<?php

use CodeIgniter\Router\RouteCollection;
use \IonAuth\Libraries\IonAuth;

/* CRON JOBS ========================================================== */
// ръчно обновяване на всички продукти от Gensoft
//$routes -> add('import_manual_gensoftData', 'Cron2::run/$1', ['as' => 'Cron-import_manual_gensoftData']);
$routes -> add('gensoft_prepareDb', 'Cron::gensoftPrepareDb', ['as' => 'Cron-gensoftPrepareDb']);

// Nodejs брояч на поръчките в реално време 
$routes -> cli('cli_order_notifications', "Cron::cli_order_notifications");
/* ===================================================================== */

$routes -> group('ajax', ['namespace' => 'App\Controllers\Ajax'], function ($r) {
    $r -> get('seo-list', 'SeoController::list');
    $r -> post('seo-save', 'SeoController::save', ['as' => 'SeoController-save']);
    $r -> post('seo-auto-generate', 'SeoController::autoGenerate', ['as' => 'SeoController-autoGenerate']);
    $r -> post('seo-auto-generate-all', 'SeoController::autoGenerateAll', ['as' => 'SeoController-autoGenerateAll']);
    $r -> post('seo-bulk-noindex', 'SeoController::bulkNoindex', ['as' => 'SeoController-bulkNoindex']);
    $r -> post('seo-bulk-index', 'SeoController::bulkIndex', ['as' => 'SeoController-bulkIndex']);
    $r -> get('seo-categories', 'SeoController::categories', ['as' => 'SeoController-categories']);
});

/** ПЛЪГИН ЗА МОДИФИЦИРАНЕ НА СНИМКИТЕ В CKFINDER ============== */
$routes -> group('MyPlugin', ['namespace' => 'CkFinder\image_modificate'], function ($r) {
    $r -> add('', 'MyPlugin::index');
});
/* =========================================================== */

/** LOGIN  ======================================================= */
$routes -> group('', ['namespace' => 'IonAuth\Controllers'], function ($r) {
    $r -> get('login', 'Auth::login');
    $r -> post('login', 'Auth::login');
    $r -> get('logout', 'Auth::logout');
});
/* =========================================================== */

// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
// === Език на интерфейса =============================================
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
$routes -> add('/lang/(:any)', 'Language::index/$1');

/** BASECONTROLLER  ======================================================= */
$routes -> group('BaseController', function ($r) {
    $c = 'BaseController';

    $r -> add('setSession', "$c::setSession", ['as' => 'BaseController-setSession']);
    $r -> add('getSession/(:any)', "$c::getSession/$1", ['as' => 'BaseController-getSession']);

    $r -> add('order_notifications', "$c::order_notifications");
    $r -> add('userPreferences?(:any)', "$c::userPreferences", ['as' => 'BaseController-userPreferences']);
    $r -> add('documents_inModul', "$c::documents_inModul", ['as' => 'BaseController-documents_inModul']); // прикачване на документи
    $r -> add('delete_documents_inModul', "$c::delete_documents_inModul", ['as' => 'BaseController-delete_documents_inModul']); // изтриване на документ
});
/* =========================================================== */

/** ПРОВЕРКА ДАЛИ ДАДЕНА ОФЕРТА Е ОТВОРЕНА ================== */
$routes -> group('Offer_isOpen', function ($r) {
    $c = 'Offer_isOpen';

    $r -> add('isOpenZenova', "$c::isOpenZenova", ['as' => 'Offer_isOpen__isOpenZenova']);
    $r -> add('check-offer-isOpen', "$c::checkAndLockOffer", ['as' => 'Offer_isOpen__check-offer-isOpen']);
    $r -> add('unlock-offer', "$c::unlockOffer", ['as' => 'Offer_isOpen__unlock-offer']);
});
/* =========================================================== */

/**  HOME PAGE ============================================== */
$routes -> group('/', function ($r) {
    $r -> get('', 'home\Home::index'); // зарежда се директно, без redirect
});

$routes -> group('Home', ['namespace' => 'App\Controllers\home'], function ($r) {
    $c = 'Home';

    $r -> add('', "$c::index", ['as' => 'home']);

    // връща пълната навигация (вкл. скритите)
    $r -> get('nav-config', "$c::navConfigFetch");
    // запис на пренареждане/скриване/нови елементи
    $r -> post('nav_save', "$c::nav_save", ['as' => 'Home_nav-save']);
    // нулиране към фабричната конфигурация    
    $r -> delete('nav_reset', "$c::nav_reset", ['as' => 'Home_nav-reset']);
});
/* =========================================================== */

/** MAINPAGE ======================================================= */
$routes -> group('MainPage', ['namespace' => 'App\Controllers\mainPage'], function ($r) {
    $c = 'MainPage';

    $model    = model('App\Models\common\MODEL__global');
    $IonAuth  = new IonAuth();
    $response = array_column($model -> get__userPreferences($IonAuth -> user() -> row()?->user_id), null, 'modul_name');

    $tabs = [
        'zenova',
        'special',
        'bizKlient',
        'baner',
        'promo',
        'dostavka',
        'order'
    ];

    foreach ($tabs as $tab) {
        $newTab  = ucwords($tab);
        $perPage = isset($response[$tab]) ? $response[$tab]['per_page'] : 10;

        if ($tab == 'order' || $tab == 'promo') {
            $r -> get("index?tab=$tab&(:any)&page=1&perPage=$perPage", "$c::index", ['as' => "tab{$newTab}"]);
        } else {
            $r -> get("index?tab=$tab&page=1&perPage=$perPage", "$c::index", ['as' => "tab{$newTab}"]);
        }
    }

    $r -> add('index', 'MainPage::index');

    $r -> add('unionOrders_byIds', "$c::unionOrders_byIds", ['as' => 'MainPage-unionOrders_byIds']);
    $r -> add('downloadFiles?(:any)', "$c::downloadFiles", ['as' => 'MainPage-downloadFiles']);
    $r -> add('copy?(:any)', "$c::copy", ['as' => 'MainPage-copy']);
    $r -> add('convert/(:num)/(:any)', "$c::convert/$1/$2", ['as' => 'MainPage-convert']);
    $r -> add('save_tovaritelnizaNo?(:any)', "$c::save_tovaritelnizaNo", ['as' => 'MainPage-save_tovaritelnizaNo']);
    $r -> add('delete/?(:any)', "$c::delete", ['as' => 'MainPage-delete']);
    $r -> add('order-delete/?(:any)', "$c::deleteOrder", ['as' => 'MainPage-orderDelete']);
    $r -> add('order-return/?(:any)', "$c::returnOrder", ['as' => 'MainPage-orderReturn']);
    $r -> add('order-complete/?(:any)', "$c::completeOrder", ['as' => 'MainPage-completeOrder']);
});
/* =========================================================== */

/** FILEMANAGER  ============================================== */
$routes -> group('FileManager', function ($r) {
    $c = 'FileManager';

    $r -> add('upload-file/(:num)/(:any)', "$c::uploadFile/$1/$2", ['as' => 'FileManager-uploadFile']);
    $r -> add('save-file/(:num)/(:any)/(:num)', "$c::saveFile/$1/$2/$3", ['as' => 'FileManager-saveFile']);
    $r -> add('delete-file/(:num)/(:any)/(:num)', "$c::deleteFile/$1/$2/$3", ['as' => 'FileManager-deleteFile']);
});
/* =========================================================== */

/** DROPDOWN  ============================================== */
$routes -> group('Dropdown', ['namespace' => 'App\Controllers\common'], function ($r) {
    $c = 'Dropdown';

    $r -> add('renderView?(:any)', "$c::renderView", ['as' => 'Dropdown-renderView']);

    $r -> add('new/(:any)', "$c::new", ['as' => 'Dropdown-new']);
    $r -> add('update', "$c::update", ['as' => 'Dropdown-edit']);
    $r -> add('delete', "$c::delete", ['as' => 'Dropdown-delete']);

    $r -> add('remove_productAttribute', "$c::remove_productAttribute", ['as' => 'Dropdown-removeProductAttr']);
    $r -> add('set_text_toProductAttribute/(:num)', "$c::set_text_toProductAttribute/$1", ['as' => 'Dropdown-setProductAttrText']);
    $r -> add('set_modelAddt', "$c::set_modelAddt", ['as' => 'Dropdown-set_modelAddt']);
});
/* =========================================================== */

// БЪРЗА ДОСТАВКА
$routes -> group('Dostavka', function ($r) {
    $c = 'Dostavka';

    $r -> get('edit/(:num)', "$c::index/$1", ['as' => 'Dostavka-edit']);
    $r -> add('new', "$c::index", ['as' => 'Dostavka-new']);
    $r -> add('delete/(:any)', "$c::delete/$1", ['as' => 'Dostavka-delete']);
    $r -> add('submit/(:any)', "$c::submit/$1", ['as' => 'Dostavka-submit']);
});

/** ПРИНТ  ============================================== */
$routes -> group('PrintPreview', ['namespace' => 'App\Controllers'], function ($r) {
    $c = 'PrintPreview';

    $r -> add("index?(:any)", "$c::index", ['as' => 'PrintPreview']);
    $r -> add('izbor_shablon?(:any)', "$c::izbor_shablon", ['as' => 'PrintPreview-izborShablon']);
    $r -> add('protocol/(:num)', "$c::protocol/$1", ['as' => 'PrintPreview-protocol']);
    $r -> add('labels/(:num)/(:any)', "$c::labels/$1/$2", ['as' => 'PrintPreview-labels']);
    $r -> add('productAttributes/(:num)/(:any)', "$c::productAttributes/$1/$2", ['as' => 'PrintPreview-productAttributes']);
    $r -> add('exportPdf', "$c::exportPdf", ['as' => 'PrintPreview-exportPdf']);
    $r -> add('exportXls?(:any)', "$c::exportXls", ['as' => 'PrintPreview-exportXls']);
});
/* =========================================================== */

/** КУРИЕР  ============================================== */
$routes -> group('ApiQurier', ['namespace' => 'App\Controllers'], function ($r) {
    $c = 'ApiQurier';

    $r -> add('get_speeedyOficeData', "$c::get_speeedyOficeData", ['as' => 'ApiQurier-get_speeedyOficeData']);
    $r -> add('api_calculateDostavka/(:any)', "$c::api_calculateDostavka/$1", ['as' => 'ApiQurier-apiCalculateDostavka']);
    $r -> add('search_cityByName', "$c::search_cityByName", ['as' => 'ApiQurier-search_cityByName']);
    $r -> add('econt_action', "$c::econt_action", ['as' => 'ApiQurier-econt_action']);
//$r -> add("speedyRequest(:any)", "$c::speedyRequest", ['as' => 'ApiQurier-speedyRequest']);
//$r -> add("speedyValidate", "$c::speedyValidate", ['as' => 'ApiQurier-speedyValidate']);
});
/* =========================================================== */


/** СПИСЪЦИ  ============================================== */
$routes -> group('spisak', ['namespace' => 'App\Controllers\spisak'], function ($routes) {

    $routes -> group('Product', function ($r) {
        $c = 'Product';

        $r -> get('index?(:any)', "$c::index", ['as' => 'Product__sp']);
        $r -> add('change-category-on-products', "$c::change_categoryOnProducts", ['as' => 'Product-change_categoryOnProducts']);
        $r -> add('save_nalich', "$c::save_nalich", ['as' => 'Product-save_nalich']);

        /////////////////////////////////////////////////
        $r -> get('get-category-tree', "$c::getCategoryTreeModal", ['as' => 'Product-getCategoryTreeModal']);
        $r -> post('apply-category', "$c::applyCategoryToSelected", ['as' => 'Product-applyCategory']);
        $r -> post('save-nalich-category', "$c::save_nalich_category", ['as' => 'Product-save_nalich_category']);
        //////////////////////////////////////////////////

        $r -> add('clone/(:num)', "$c::clone/$1", ['as' => 'Product__clone']);
        $r -> add('delete?(:any)', "$c::delete", ['as' => 'Product__delete']);
    });

    $routes -> group('Klient', function ($r) {
        $c = 'Klient';

        $r -> get('index?(:any)', "$c::index", ['as' => 'Klient__sp']);
        $r -> add('change-priceLevel', "$c::change_priceLevel", ['as' => 'Klient-change_priceLevel']);
        $r -> add('delete?(:any)', "$c::delete", ['as' => 'Klient__delete']);
    });

    $routes -> group('NashiFirmi', function ($r) {
        $c = 'NashiFirmi';

        $r -> put('?page=1&perPage=10', "$c::index", ['as' => 'NashiFirmi_sp']);
        $r -> add('', "$c::index");
        $r -> add('delete/(:num)/(:any)', "$c::delete/$1/$2", ['as' => 'NashiFirmi-delete']);
    });
});
/* =========================================================== */



/** СПОДЕЛЕНИ РЕСУРСИ  ============================================== */
$routes -> group('common', ['namespace' => 'App\Controllers\common'], function ($routes) {

    // Клиенти
    $routes -> group('Klient', function ($r) {
        $c = 'Klient';

        $r -> add('klient_autocomplete', "$c::klient_autocomplete", ['as' => 'Klient-аutocomplete']);
        $r -> add('klient_save', "$c::klient_save", ['as' => 'Klient-save']);
    });
});
/* =========================================================== */

/** ПОТРЕБИТЕЛИ  ============================================== */
$routes -> group('users', ['namespace' => 'App\Controllers\users'], function ($routes) {

    $routes -> group('Users', function ($r) {
        $c = 'Users';

        $r -> get('/', "$c::index", ['as' => 'Users_index']);
        $r -> add('save_user/(:any)', "$c::save_user/$1", ['as' => 'Users__save-user']);
        $r -> add('delete_user/(:num)/(:any)', "$c::delete_user/$1/$2", ['as' => 'Users__delete-user']);

        $r -> add('activate/(:num)', "$c::activate/$1", ['as' => 'Users__activate']);
        $r -> add('deactivate/(:num)', "$c::deactivate/$1", ['as' => 'Users__deactivate']);
    });

    // Групи - Потребители 
    $routes -> group('Groups', function ($r) {
        $c = 'Groups';

        $r -> get('/', 'Groups::index', ['as' => 'Groups_index']);
        $r -> add('save_group/(:any)', "$c::save_group/$1", ['as' => 'Groups__save-group']);
        $r -> add('delete_group/(:num)/(:any)', "$c::delete_group/$1/$2", ['as' => 'Groups__delete-group']);

        //$r -> get('edit_GroupPermisions/(:num)', 'Group_permisions::index/$1', ['as' => 'edit_GroupPermisions']);
        //$r -> post('set_groupPermisions/(:num)', 'Group_permisions::set_groupPermisions/$1', ['as' => 'set_groupPermisions']);
    });

    $routes -> group('GroupPermisions', function ($r) {
        $c = 'Group_permisions';

        $r -> get('/', "$c::index", ['as' => 'GroupPermisions_index']);
        $r -> post('save_groupPermisions/(:num)', 'Group_permisions::save_groupPermisions/$1', ['as' => 'save_groupPermisions']);
        //$r -> get('edit_GroupPermisions/(:num)', 'Group_permisions::index/$1', ['as' => 'edit_GroupPermisions']);
        // $r -> post('set_groupPermisions/(:num)', 'Group_permisions::set_groupPermisions/$1', ['as' => 'set_groupPermisions']);
    });
});
/* =========================================================== */



/* DASHBOARD
  =========================================================== */
$routes -> group('analytics', ['namespace' => 'App\Controllers\Api'], function ($routes) {
    $routes -> get('/', 'Analytics::index');
    $routes -> get('data', 'Analytics::data');
});

$routes -> get('/dashboard/stockGroups', 'Dashboard\Dashboard::stockGroups');

$routes -> get('dashboard/exportStockMovement', 'Dashboard\Dashboard::exportStockMovement');
$routes -> get('dashboard/exportBestSellers', 'Dashboard\Dashboard::exportBestSellers');
$routes -> get('dashboard/exportDeliveries', 'Dashboard\Dashboard::exportDeliveries');

$routes -> get('dashboard/loadFirmsFromDB', 'Dashboard\Dashboard::loadFirmsFromDB');
$routes -> get('dashboard/loadUsers', 'Dashboard\Dashboard::loadUsers');

// ---- ANALYTICS TRACK ----
// CORS preflight
$routes -> options('api/track', 'Api\Tracker::options');

// POST - реалните данни
$routes -> post('api/track', 'Api\Tracker::collect');

// GET - за тест в браузъра
$routes -> get('api/track', 'Api\Tracker::status');

$routes -> get('dashboard/overviewGroups', 'Dashboard\Dashboard::overviewGroups');
$routes -> get('/dashboard/debts', 'Dashboard\Dashboard::debts');
$routes -> get('dashboard/cashflow', 'Data\Cashflow::index');
$routes -> get('dashboard/cashflow/load', 'Data\Cashflow::load');

$routes -> get('dashboard/debtors', 'Dashboard\Debtors::index');   // VIEW
$routes -> get('dashboard/debtors/load', 'Dashboard\Debtors::load');    // AJAX JSON
$routes -> get('dashboard/debtors/export', 'Dashboard\Debtors::export');  // EXCEL EXPORT

$routes -> get('refillstock', 'RefillStock\RefillStock::index');
$routes -> get('refillstock/data', 'RefillStock\RefillStock::data');
$routes -> get('refillstock/export', 'RefillStock\RefillStock::export');
$routes -> post('refillstock/export', 'RefillStock\RefillStock::export');
$routes -> get('dashboard/deliveries', 'Dashboard\Deliveries::index');

$routes -> get('dashboard/bestSellers', 'Dashboard\Dashboard::bestSellers');

$routes -> get('dashboard/stockMovement', 'Dashboard\Dashboard::stockMovement');

$routes -> get('/calendar', 'Calendar::index');

$routes -> group('clients', ['namespace' => 'App\Controllers\Clients'], function ($routes) {
    $routes -> get('/', 'Clients::index');
    $routes -> get('create', 'Clients::create');
    $routes -> post('save', 'Clients::save');
    $routes -> get('preview/(:num)', 'Clients::preview/$1');
    $routes -> get('edit/(:num)', 'Clients::edit/$1');
    $routes -> post('update/(:num)', 'Clients::update/$1');
    $routes -> get('delete/(:num)', 'Clients::delete/$1');
    $routes -> post('addOption', 'Clients::addOption');
    $routes -> match(['get', 'post', 'put', 'delete'], 'products', 'Clients::products');
    $routes -> get('searchFirms', 'Clients::searchFirms');
});

$routes -> get('dashboard', 'Dashboard\Dashboard::index');
$routes -> get('dashboard/data/(:segment)', 'Dashboard\Dashboard::data/$1');
$routes -> get('dashboard/dataCustom', 'Dashboard\Dashboard::dataCustom');
$routes -> get('dashboard/firms', 'Dashboard\Dashboard::firms');
$routes -> get('dashboard/inactiveFiltered', 'Dashboard\Dashboard::inactiveFiltered');

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}


if (is_dir(APPPATH . 'Modules')) {

    $modulesDir = [APPPATH . 'Modules/'];

    foreach ($modulesDir as $dir) {
        if (!is_dir($dir)) {
            continue;
        }

        $modules = scandir($dir);
        foreach ($modules as $module) {
            if (in_array($module, ['.', '..'], true)) {
                continue;
            }

            $moduleDir = $dir . $module;
            if (is_dir($moduleDir)) {
                $routesPath = $moduleDir . '/Config/Routes.php';
                if (file_exists($routesPath)) {
                    require $routesPath;
                }
            }
        }
    }
}
