<?php

namespace Config;

use CodeIgniter\Config\BaseService;
use App\Libraries\Gensoft\LIB__FirebirdConnection;
use App\Libraries\Gensoft\LIB__FirebirdServices;
use App\Libraries\Gensoft\LIB__GensoftOrder;
use App\Libraries\gensoft\LIB__GensoftInfrastructureService;
use App\Libraries\gensoft\GensoftImportService;


/**
 * Services Configuration file.
 *
 * Services are simply other classes/libraries that the system uses
 * to do its job. This is used by CodeIgniter to allow the core of the
 * framework to be swapped out easily without affecting the usage within
 * the rest of your application.
 *
 * This file holds any application-specific services, or service overrides
 * that you might need. An example has been included with the general
 * method format you should use for your service methods. For more examples,
 * see the core Services file at system/Config/Services.php.
 */
class Services extends BaseService {

    /**
     * Gensoft Firebird connection service
     * 
     * Отговаря за:
     * - създаване и управление на връзка към Firebird (Gensoft)
     * - проверка дали Firebird сървърът е достъпен
     * - предоставяне на споделена (shared) инстанция
     *
     * Пример за използване:
     * <code>
     * $fb = service('firebirdConnection');
     * $fb->isReachable('192.168.1.10');
     * $conn = $fb->getConnection();
     * </code>
     * 

     */
    public static function firebirdConnection(bool $getShared = true) {
        if ($getShared) {
            return static::getSharedInstance('firebirdConnection');
        }

        return new LIB__FirebirdConnection();
    }

    public static function firebirdServices(bool $getShared = true) {
        if ($getShared) {
            return static::getSharedInstance('firebirdServices');
        }

        return new LIB__FirebirdServices();
    }

    public static function PrepareOrder_toGensoft(bool $getShared = true){
        if ($getShared) {
            return static::getSharedInstance('PrepareOrder_toGensoft');
        }

        return new LIB__GensoftOrder();
    }

}
