<?php

namespace App\Controllers;

/**
 * Admin abstract controller file
 *
 * @package CI-Admin
 * @license https://opensource.org/licenses/MIT	MIT License
 * @link    http://github.com/bbvrignaud/ci-admin
 */
use \CodeIgniter\Controller,
    \Config\Services;
use \IonAuth\Libraries\{
    Ion_auth_acl,
    IonAuth
};
use \stdClass;
use function \base_url,
             \helper,
             \view;
use \App\Libraries\Breadcrumb;
use \App\Models\common\MODEL__global;
use \App\Models\MODEL__offer_isOpen;

//use \IonAuth\Models\Group_permisions_model;
//abstract

class BaseController extends Controller {

    protected $show_alert = 'IonAuth\Views\Messages\list';
    protected $ionAuth;
    protected $user;

    public function __construct() {
        helper(['autoLoad_helper', 'form', 'url', 'array', 'utils']);
        $this -> ionAuth       = new IonAuth();
        $this -> acl           = new Ion_auth_acl();
        $this -> breadcrumb    = new Breadcrumb();
        $this -> MODEL__global = new MODEL__global();
        $this -> customConfig  = new \Config\ValentiConfig\CustomConfig();

        if (!$this -> ionAuth -> loggedIn()) {
            header('Location: ' . base_url() . 'login');
            exit;
        }
        // ако няма админ права 
        if (!$this -> ionAuth -> isAdmin()) {
            // d($this -> ionAuth -> isAdmin());    
        }

        $this -> validation = Services::validation();
        $this -> session    = Services::session();
        $this -> request    = Services::request();
        $this -> response   = Services::response();
        $this -> language   = Services::language();

        // date_default_timezone_set(service('settings') -> get('App.timeZone')); //timezone

        $setLocale = $this -> session -> lang;

        if ($this -> session -> lang == null) {
            $settings  = service('settings');
            $setLocale = $settings -> get('App.defaultLocale') != '' ? $settings -> get('App.defaultLocale') : 'bg';
            $this -> session -> set('lang', $setLocale);
        }

        $this -> language -> setLocale($setLocale);
        $this -> user           = $this -> ionAuth -> user() -> row();
        $this -> group          = $this -> ionAuth -> getUsersGroups($this -> user -> id) -> getRow();
        $this -> acl -> isAdmin = $this -> group -> name;
        $this -> session -> set('user', $this -> user);
    }

    // рестрикци на групата до изгледи и др.
    protected function checkgroupAccess($view = '', $is_single = 0) {
        if (!$this -> ionAuth -> isAdmin()) {

            $getTab = $this -> request -> getVar('tab') ?? '';

            $deniedMsg = match ($getTab) {
                'zenova' => 'ценова листа',
                'special' => 'специална',
                'bizKlient' => 'бизнес клиент',
                'promo' => 'промоции',
                'baner' => 'заявка за банер',
                'order' => 'поръчки',
                'spProduct' => 'списък продукти',
                'klient', 'gensoftKlient' => 'списък клиенти',
                default => ''
            };

            $viewTab = [
                'view'      => $view,
                'tab'       => $getTab,
                'is_single' => $is_single,
            ];

            if (!$this -> acl -> isAllowed($this -> group -> id, $viewTab, null)) {
                // $this -> session -> setFlashdata('message', "Достъпът е отказан до $deniedMsg!");
                return false;
                // return redirect() -> back() -> send();  // Use send() to ensure the redirect happens immediately
            }
        }
    }

    protected function render_template($page = null, $data = [], $headerMenuHide = null) {
        $data['userName_label']              = $this -> user -> first_name . ' ' . $this -> user -> last_name;
        $data['userGroup_label']             = $this -> group -> name;
        $data['userGroupId']                 = $this -> group -> id;
        $data['ionAuth']                     = $this -> ionAuth;
        $data['acl']                         = $this -> acl;
        // настройки за брой показини записи в mainPage за потребител
        $data['userPreferences']             = $this -> MODEL__global -> get__userPreferences($this -> user -> user_id);
        // общ брой на продуктите
        $data['totalProductCount']           = $this -> MODEL__global -> get__totalProductCouut();
        $data['orderNotificationsCount']     = $this -> MODEL__global -> get__orders_count_notification($this -> customConfig -> isVisible['tab_NOrders']);
        $data['orderElseNotificationsCount'] = $this -> MODEL__global -> get__orders_else_count_notification(); // брояч на другите поръчки(бърза, незавършена,клиентска)
        // извличане на броя  задачи
        // глобална навигация sidebar left nav 
        $data['nav']                         = $this -> getNavFromConfig();

        if (url_is('*MainPage') || url_is('modul*')) {
            $this -> session -> set('current_eventsCount', '');

            $response = $this -> MODEL__global -> get__count_events();

            $current_eventsCount = 0;
            if (isset($response -> events_json)) {
                foreach (json_decode($response -> events_json) as $val) {

                    if (($val -> status ?? '') != 2) {
                        $current_eventsCount++;
                    }
                }
                $this -> session -> set('current_eventsCount', $current_eventsCount);
            }
        }

        $data['headerMenuHide'] = $headerMenuHide;
        $data['content']        = $page;

        return view('layouts/VIEW__master', $data);
    }

    protected function returnResponse($request = null, $name = '', $msg = '', $msg_visible = 0, $isJson = 0) {

        if (is_array($request) && $name === 'err-in-view-product') {

            $existList = [];

            foreach (array_filter($request) as $k => $v) {
                $existList[] = match ($k) {
                    'zenovaName' => lang('LANG__global.returnResponse.err.productInList_z', [$v]),
                    'specialName' => lang('LANG__global.returnResponse.err.productInList_s', [$v]),
                    'orderName' => lang('LANG__global.returnResponse.err.productInList_o', [$v]),
                    default => null
                };
            }

            $messages = view($this -> show_alert, ['errorsInSpProduct' => ['err' => $existList, 'name' => $msg]]);

            $isJson ? '' : $this -> session -> setFlashdata('message', $messages);
            return false;
        } elseif ($request) {
            $messages = $msg_visible == 1 ? view($this -> show_alert, ['messages' => [lang('LANG__global.returnResponse.ok') . ' ' . $msg . ' ' . $name]
                    ]) : '';

            $response = [
                'success'  => true,
                'id'       => $msg,
                'messages' => $messages,
            ];
        } else {
            $messages = $msg_visible == 1 ? view($this -> show_alert, ['errors' => [$msg . ' ' . $name]]) : '';

            $response = [
                'success'  => false,
                'messages' => $messages,
            ];
        }

        $isJson ? '' : $this -> session -> setFlashdata('message', $messages);

        return $response;
    }

    public function trimFilter($request) {

        $trimmed_post = [];

        foreach ($request as $key => $item) {
            if ($item === '') {
                $trimmed_post[$key] = null;
                continue;
            }

            if ($key == 'description') {
                $trimmed_post[$key] = $item;
                continue;
            }

            if (is_array($item)) {
                $trimmed_post[$key] = $this -> trimFilter($item);
                continue;
            }

            $row = trim(preg_replace(['/[~!@$^*?]/', '/\s+/'], ' ', $item));
            $row = str_replace('&', ' and ', $row);
            $row = str_replace("'", '`', $row);
            $row = str_replace('"', '``', $row);

            $trimmed_post[$key] = $row;

//            $replace = is_string($item) ? [$item] : $item;
//
//            $replace = array_map(function ($row) {
//                $row = trim(preg_replace(['/[~!@$^*?]/', '/\s+/'], ' ', $row));
//                $row = str_replace('&', ' and ', $row);
//                $row = str_replace("'", '`', $row);
//                $row = str_replace('"', '``', $row);
//                return $row;
//            }, $replace);
//
//            $trimmed_post[$key] = is_string($item) ? $replace[0] : $replace;
        }

        return $trimmed_post;
    }

    // пормяна на елемети от масива
    public function changeArr($form = [], array $arg = [], $id = null, $isOfer = null): array {

        // Set empty values to null
        array_walk_recursive($form, fn(&$value) => $value = ($value === '') ? null : $value);

        foreach ($arg as $key => $transforms) {

            if (!(
                    ($key === 'all' && $isOfer) ||
                    ($key === 'update' && is_numeric($id)) ||
                    ($key === 'create' && !is_numeric($id))
                    )
            ) {
                continue;
            }

            foreach ($transforms as $type => $fields) {
                foreach ((array) $fields as $field) {
                    $value         = $form[$field] ?? null;
                    $filteredValue = array_filter((array) $value);

                    $form[$field] = match ($type) {
                        'json' => !empty($filteredValue) ? json_encode($filteredValue, JSON_UNESCAPED_UNICODE) : null,
                        'jsonNum' => !empty($filteredValue) ? json_encode($filteredValue, JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK) : null,
                        'imp' => !empty($filteredValue) ? implode(',', $filteredValue) : null,
                        'filterArr' => !empty($filteredValue) ? $filteredValue : null,
                        'int' => $value !== null ? (int) $value : null,
                        'user' => $this -> user -> username ?? null,
                        'date' => date("d-m-Y H:i"),
                        'format_date' => (date_create($value) -> format('d-m-Y') === $value) ? $value . ' ' . date("H:i") : $value,
                        default => $value,
                    };
                }
            }
        }

        return $form;
    }

    public function setSession($isNull = false, $name = '') {
        $sesionName = $this -> request -> getVar('sesionName');
        $dataArr    = $this -> request -> getVar('dataArr');
        $isChecked  = (bool) $this -> request -> getVar('isChecked');

        if ($isNull) {
            session() -> remove($name);
            return;
        }

        // Ако същест сесията
        $existingData = session() -> get($sesionName) ?? [];

        // Дали `$existingData` и `$dataArr` са масиви
        $existingData = is_array($existingData) ? $existingData : [];
        $dataArr      = is_array($dataArr) ? $dataArr : [];

        // Update the session data based on `$isChecked`
        if ($isChecked) {
            // Add new data (merge and filter duplicates)
            $updatedData = array_unique(array_merge($existingData, $dataArr));
        } else {

            // Remove specific values from the session data
            $updatedData = array_diff($existingData, $dataArr);
        }
        // Update the session with the new data
        session() -> set($sesionName, $updatedData);
    }

    public function getSession($sesionName = '') {
        return session() -> get($sesionName) ?? [];
    }

    public function userPreferences() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $data = [
            'user_preferences_id' => $urlParams['user_preferences_id'],
            'modul_name'          => $urlParams['tab'],
            'tip'                 => $urlParams['tip'] ?? null,
            'user_id'             => $this -> user -> user_id,
            'per_page'            => $urlParams['perPage'],
        ];

        $this -> MODEL__global -> set__userPreferences($data);

        return json_encode('');
    }

    protected function get__viewMainpageTables() {
        $m = 'mainPage/VIEW__mainPage_table';

        return [
            'zenova'    => "$m-zenova",
            'promo'     => "$m-promo",
            "bizKlient" => "$m-bizKlient",
            'baner'     => "$m-baner",
            'special'   => "$m-special",
            'order'     => "$m-order",
            'dostavka'  => "$m-dostavka"
        ];
    }

    protected function get__viewTable($arg, $data = []) {
        $m = 'Modules';

        $orderTable = in_array($data['arg'], ['site', 'L', 'K', 'N', 'F']) ? 'VIEW__order-site-table' : '';

        return match ($arg) {
            'special' => view("$m/$arg\Views\VIEW__$arg-table", $data),
            'baner' => view("$m/$arg\Views\VIEW__$arg-table", $data),
            'promo' => view("$m/$arg\Views\VIEW__$arg-table", $data),
            'bizKlient' => view("$m/$arg\Views\VIEW__$arg-table", $data),
            'zenova' => view("$m/$arg\Views\VIEW__$arg-table", $data),
            'order' => view("$m/$arg\Views/$orderTable", $data),
            'dostavka' => view('oferta/dostavka/VIEW__dostavka-table', $data),
            'spProduct' => view('spisak/product/VIEW__product-table', $data),
        };
    }

    protected function get__viewPrintTable($arg) {
        $c = 'printPreview';

        return match ($arg) {
            'order' => "$c/$arg/VIEW__printPreview-$arg",
            'bizKlient' => "$c/$arg/VIEW__printPreview-$arg",
            'promo' => "$c/$arg/VIEW__printPreview-$arg",
            'special' => "$c/$arg/VIEW__printPreview-$arg",
            'baner' => "$c/$arg/VIEW__printPreview-$arg",
            'zenova' => "$c/$arg/VIEW__printPreview-$arg",
            'zenovaLabel' => "$c/zenova/VIEW__printPreview-zenovaLabel",
            'specialLabel' => "$c/special/VIEW__printPreview-specialLabel",
            'catalog' => "$c/catalog/VIEW__printPreview-catalog",
        };
    }

    protected function get__skladTip($arg) {

        return match ($arg) {
            'site' => 1,
            'sklad' => 2,
            'magazine' => 3,
            'bravas' => 4
        };
    }

    protected function buildCategoryTree($parent_id = null, $categories = null) {
        $tree = array();

        foreach ($categories as $category) {

            if ($category['parent_id'] == $parent_id) {
                $children = $this -> buildCategoryTree($category['category_id'], $categories);
                if ($children) {
                    $category['children'] = $children;
                } else {
                    $category['children'] = [];
                }

                $tree[] = $category;
            }
        }

        return $tree;
    }

    //определяне на id до подкатегориите от последната вложена подкатегория
    public function findPathToCategory($targetId, $categories, $path = []) {
        foreach ($categories as $cat) {
            $currentPath = [...$path, $cat];

            if ($cat['category_id'] == $targetId) {
                return $currentPath;
            }

            if (!empty($cat['children'])) {
                $result = $this -> findPathToCategory($targetId, $cat['children'], $currentPath);
                if ($result !== null) {
                    return $result;
                }
            }
        }
        return null;
    }

    // прикачени файлове в модул
    public function documents_inModul() {
        $imagefile = $this -> request -> getFiles();
        $tab       = $this -> request -> getVar('tab');
        $orderTip  = $this -> request -> getVar('orderTip');
        $orderId   = $this -> request -> getVar('orderId');

        if ($imagefile) {

            $folder = dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . 'documents/' . $tab . '/' . $orderTip . '/' . $orderId;

            if (!is_dir($folder)) {
                mkdir($folder, 0777, TRUE);
            }


            foreach ($imagefile['images'] as $img) {
                if ($img -> isValid() && !$img -> hasMoved()) {
                    $newName = preg_replace('/[\s]+/', '_', $img -> getName());

                    if (!file_exists($folder . '/' . $newName)) {
                        $img -> move($folder, $newName);
                    }
                }
            }
        }
    }

    public function delete_documents_inModul() {
        $tab       = $this -> request -> getVar('tab');
        $orderTip  = $this -> request -> getVar('orderTip');
        $orderId   = $this -> request -> getVar('orderId');
        $imageName = $this -> request -> getVar('imageName');

        if ($imageName) {
            $folder = dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . 'documents/' . $tab . '/' . $orderTip . '/' . $orderId;

            foreach (glob($folder . '/*.*') as $file) {
                $folder . '/' . $imageName == $file ? unlink($file) : '';
            }

            // Ако след това ако папката е празна — изтриваме я
            if (count(glob($folder . '/*')) === 0) {
                rmdir($folder);
            }
        }
        return json_encode('');
    }

    // брой поръчки от сайт ajax авт. проверка за нови поръчки
    // ======================================================
    public function order_notifications() {
        $response = $this -> MODEL__global -> get__orders_count_notification();

        return json_encode($response);
    }

    protected function validateForm() {
        $validation = \Config\Services::validation();
        $validation -> setRules([
            'file' => [
                'rules'  => 'uploaded[file]',
                'errors' => [
                    'uploaded' => 'Липсва файл'
                ]
            ]
        ]);

        return $validation;
    }

    ////////////////////////////////////////////////////////////
    // Упралвние на навигацията в Home Page и SidebarMenu

    protected function get__jsonNavPath() {
        return WRITEPATH . 'nav_overrides.json';
    }

    protected function getNavFromConfig(bool $includeDisabled = false): array {
        helper('homePageNav');

        $src  = HELPER_defaultJsonNav() ?? [];
        $path = $this -> get__jsonNavPath();
        $ovr  = [];

        if (is_file($path)) {
            $json = file_get_contents($path);
            $data = json_decode($json, true);
            $ovr  = is_array($data) ? $data : [];
        }
        // d($src['main']['items']);
//d($ovr['main']['items'][0]['attrs']);
        return !empty($ovr) ? $ovr : $src;
    }

}

// трябва да се деактивира това за да работи норм kint в файла composer/autoload_static
//symfony/var-dumper/Resources/functions/dump.php
