<?php

namespace App\Controllers\Data;

use App\Controllers\BaseController;
use App\Controllers\Data\CashflowData;

class Cashflow extends BaseController
{
    public function index()
    {
        return view('Data/cashflow', [
            "title" => "Кешфлоу"
        ]);
    }

public function load()
{
    $from   = $this->request->getGet('from');
    $to     = $this->request->getGet('to');
    $salary = floatval($this->request->getGet('salary') ?? 0);

    $data = new CashflowData();

    // 🔹 1) ДАННИ ЗА РАЗХОДИТЕ
    $items = $data->getDataFiltered($from, $to);

    // фиксираме само редове, които имат сума
    $items = array_filter($items, fn($r) => isset($r["лв."]));
    $items = array_values($items);

    // 🔹 2) СУМА НА РАЗХОДИТЕ
    // ЗАБЕЛЕЖКА: ако "лв." са положителни — ги обръщаме в "-" !
    $totalExpenses = 0;

    foreach ($items as $r) {
        if (!isset($r["лв."])) continue;

        $val = floatval($r["лв."]);

        // ако стойността е +, правим я разход (-)
        if ($val > 0) $val = -$val;

        $totalExpenses += $val;
    }

    // 🔹 3) ПРИХОДИ (продажби — автоматично)
    $incomeTotal = $data->getSalesIncome(); // ВИНАГИ ПОЛОЖИТЕЛНО

    // 🔹 4) КРАЙНА ПЕЧАЛБА
    $profit = $incomeTotal + $totalExpenses - $salary;

    return $this->response->setJSON([
        "items"        => $items,
        "income_total" => $incomeTotal,

        "totals"       => [
            "total_expenses" => $totalExpenses,
            "salary"         => $salary,
            "income_sum"     => $incomeTotal,
            "profit"         => $profit
        ],

        "period_label" => $data->getPeriodLabel($from, $to)
    ]);
}
    public function export()
    {
        // TODO: ще ти направя Excel с PhpSpreadsheet
        echo "Excel export ще бъде генериран";
    }
}
