<?php
namespace App\Controllers\Data;

class CashflowData
{
    private function normalizeAmount($v)
    {
        $v = str_replace([" ", "лв.", "лв", "\u{00A0}"], "", $v);
        $v = str_replace(",", ".", $v);
        return floatval($v);
    }

private function normalizeDate($d)
{
    // ако форматът е 10/21/2024 → MM/DD/YYYY
    $parts = explode("/", $d);

    if (strlen($parts[0]) === 2 && intval($parts[0]) > 12) {
        // това е DD/MM/YYYY
        [$day, $month, $year] = $parts;
    } elseif (strlen($parts[1]) === 2 && intval($parts[1]) > 12) {
        // това е MM/DD/YYYY
        [$month, $day, $year] = $parts;
    } else {
        // fallback
        [$day, $month, $year] = $parts;
    }

    return "$year-$month-$day";
}

    
    public function getAllRows()
    {
        return [
    
            // ===== РАЗХОДИ (оригиналните твои) =====
            ["От дата"=>"02/01/2025", "Номер"=>"12421", "Код"=>"6", "Описание"=>"Други - куриер спиди + ароматизатор", "лв."=>"-14,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"02/01/2025", "Номер"=>"12422", "Код"=>"6", "Описание"=>"Такса приемане на карти", "лв."=>"-2,00", "През"=>"Каса РАЗХОДИ ПО БАНКА"],
            ["От дата"=>"02/01/2025", "Номер"=>"12423", "Код"=>"6", "Описание"=>"Такса пакетно обслужване ДСК", "лв."=>"-38,00", "През"=>"Каса РАЗХОДИ ПО БАНКА"],
            ["От дата"=>"02/01/2025", "Номер"=>"12424", "Код"=>"333", "Описание"=>"Васко обяд", "лв."=>"-15,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"03/01/2025", "Номер"=>"12425", "Код"=>"6", "Описание"=>"Месечна такса РС", "лв."=>"-25,00", "През"=>"Каса РАЗХОДИ ПО БАНКА"],
            ["От дата"=>"03/01/2025", "Номер"=>"12426", "Код"=>"6", "Описание"=>"Такса обслужване POS", "лв."=>"-10,00", "През"=>"Каса РАЗХОДИ ПО БАНКА"],
            ["От дата"=>"03/01/2025", "Номер"=>"12427", "Код"=>"6", "Описание"=>"Такса ангажимент — ДСК", "лв."=>"-327,50", "През"=>"Каса РАЗХОДИ ПО БАНКА"],
            ["От дата"=>"03/01/2025", "Номер"=>"12428", "Код"=>"6", "Описание"=>"Лихва по договор — ДСК", "лв."=>"-1137,50", "През"=>"Каса РАЗХОДИ ПО БАНКА"],
            ["От дата"=>"06/01/2025", "Номер"=>"12431", "Код"=>"1", "Описание"=>"Гориво — Свиленград", "лв."=>"-100,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН СВИЛЕНГРАД"],
            ["От дата"=>"06/01/2025", "Номер"=>"12439", "Код"=>"333", "Описание"=>"Васко обяд", "лв."=>"-10,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"07/01/2025", "Номер"=>"12447", "Код"=>"333", "Описание"=>"Васко обяд", "лв."=>"-7,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"09/01/2025", "Номер"=>"12474", "Код"=>"6", "Описание"=>"Климатик за Радев — Бител", "лв."=>"-3293,60", "През"=>"КАСА ДРУГИ РАЗХОДИ В БРОЙ"],
            ["От дата"=>"08/01/2025", "Номер"=>"12467", "Код"=>"333", "Описание"=>"Васко обяд", "лв."=>"-12,40", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"08/01/2025", "Номер"=>"12472", "Код"=>"6", "Описание"=>"Техническо обслужване — клиент ЕЙЧ ДЖИ", "лв."=>"-10,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН СВИЛЕНГРАД"],
            ["От дата"=>"10/01/2025", "Номер"=>"12487", "Код"=>"333", "Описание"=>"Васко обяд", "лв."=>"-11,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"13/01/2025", "Номер"=>"12492", "Код"=>"6", "Описание"=>"Плащане по заем ДСК", "лв."=>"-878,67", "През"=>"Каса РАЗХОДИ ПО БАНКА"],
            ["От дата"=>"13/01/2025", "Номер"=>"12499", "Код"=>"6", "Описание"=>"Прахосмукачка", "лв."=>"-192,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН"],
            ["От дата"=>"15/01/2025", "Номер"=>"12513", "Код"=>"40", "Описание"=>"Комисионна — Венци Сопот", "лв."=>"-120,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"17/01/2025", "Номер"=>"12534", "Код"=>"333", "Описание"=>"Васко обяд", "лв."=>"-10,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"21/01/2025", "Номер"=>"12544", "Код"=>"1", "Описание"=>"Гориво — Свиленград", "лв."=>"-100,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН СВИЛЕНГРАД"],
            ["От дата"=>"23/01/2025", "Номер"=>"12557", "Код"=>"6", "Описание"=>"Вода", "лв."=>"-27,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"27/01/2025", "Номер"=>"12568", "Код"=>"6", "Описание"=>"Ароматизатор + паркинг", "лв."=>"-33,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН (с ДДС)"],
            ["От дата"=>"29/01/2025", "Номер"=>"12575", "Код"=>"123456", "Описание"=>"Винетка X4334KB", "лв."=>"-87,00", "През"=>"КАСА ВАЛПЕРС МАГАЗИН СВИЛЕНГРАД"],
    
    
            // ===== ПРИХОДИ (10 НОВИ ЗАПИСА) =====
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91650","Фирма"=>"Клиент в брой","Склад"=>"ВАЛПЕРС СКЛАД","Главна група"=>"МРЕЖОВИ УСТРОЙСТВА","Подгрупа"=>"Мрежови устройства ДРУГИ","Стока"=>"TP-Link TL-WA855RE range extender","Количество"=>"2 бр.","Оборот"=>"62,50 лв.","Чист приход"=>"7,90 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91651","Фирма"=>"КЕЙБЪЛ НЕТ - ЕООД","Склад"=>"ВАЛПЕРС МАГАЗИН","Главна група"=>"МРЕЖОВИ УСТРОЙСТВА","Подгрупа"=>"Мрежови устройства Рутери","Стока"=>"Ubiquiti LocoM5","Количество"=>"1 бр.","Оборот"=>"116,67 лв.","Чист приход"=>"16,18 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91652","Фирма"=>"Ди Ти Кей Системс - ЕООД","Склад"=>"ВАЛПЕРС МАГАЗИН","Главна група"=>"РАЗКЛОНИТЕЛИ 220V","Подгрупа"=>"Разклонители 220V HAMA","Стока"=>"Разклонител HAMA 6 гнезда 3м","Количество"=>"1 бр.","Оборот"=>"21,67 лв.","Чист приход"=>"3,37 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91653","Фирма"=>"САТ 1977 - ООД","Склад"=>"ВАЛПЕРС СКЛАД","Главна група"=>"МОНИТОРИ","Подгрупа"=>"Монитори DELL","Стока"=>"Dell E2423HN 23.8'' FULL HD","Количество"=>"1 бр.","Оборот"=>"182,20 лв.","Чист приход"=>"20,53 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91654","Фирма"=>"ТИК КОМПЮТЪРС ЕООД","Склад"=>"ВАЛПЕРС МАГАЗИН","Главна група"=>"ПРИНТЕРИ","Подгрупа"=>"Мастилено-струйни принтери","Стока"=>"Canon Pixma MG2550S","Количество"=>"1 бр.","Оборот"=>"89,00 лв.","Чист приход"=>"12,00 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91655","Фирма"=>"Си Ейч Компютърс ЕООД","Склад"=>"ВАЛПЕРС СКЛАД","Главна група"=>"КОМПЮТРИ","Подгрупа"=>"Настолни компютри","Стока"=>"Компютър Intel i5 / 16GB / 512SSD","Количество"=>"1 бр.","Оборот"=>"950,00 лв.","Чист приход"=>"85,00 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91656","Фирма"=>"А И А КОМПЮТЪРС 2005 ЕООД","Склад"=>"ВАЛПЕРС МАГАЗИН","Главна група"=>"ПАМЕТ RAM","Подгрупа"=>"DDR4","Стока"=>"Kingston 16GB DDR4 3200MHz","Количество"=>"1 бр.","Оборот"=>"58,00 лв.","Чист приход"=>"6,50 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91657","Фирма"=>"АТЛАС СЕКЮРИТИ ЕООД","Склад"=>"ВАЛПЕРС МАГАЗИН","Главна група"=>"КАМЕРИ ЗА ВИДЕОНАБЛЮДЕНИЕ","Подгрупа"=>"Hikvision","Стока"=>"Hikvision DS-2CD2043G2-I","Количество"=>"1 бр.","Оборот"=>"145,00 лв.","Чист приход"=>"18,20 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91658","Фирма"=>"ИНВАЙТ ЕООД","Склад"=>"ВАЛПЕРС СКЛАД","Главна група"=>"СЪРВЪРИ","Подгрупа"=>"Малки сървъри","Стока"=>"HP ProLiant MicroServer Gen10","Количество"=>"1 бр.","Оборот"=>"699,00 лв.","Чист приход"=>"62,00 лв."],
            ["От дата"=>"10/21/2024","Тип"=>"продажба","Документ"=>"91659","Фирма"=>"ВИДЕОПЕРФЕКТ ООД","Склад"=>"ВАЛПЕРС МАГАЗИН","Главна група"=>"КАБЕЛИ","Подгрупа"=>"HDMI","Стока"=>"HDMI кабел 4K 5м","Количество"=>"2 бр.","Оборот"=>"34,00 лв.","Чист приход"=>"5,40 лв."],
    
        ];
    }


    public function getDataFiltered($from, $to)
    {
        $rows = $this->getAllRows();

        if (!$from || !$to) return $rows;

        $fromD = strtotime($from);
        $toD   = strtotime($to);

        return array_values(array_filter($rows, function($r) use ($fromD, $toD) {
            $d = strtotime($this->normalizeDate($r["От дата"]));
            return $d >= $fromD && $d <= $toD;
        }));
    }

    public function getTotals($items, $salary, $incomes)
    {
        $totalExpenses = 0;

        foreach ($items as $r) {
            $totalExpenses += $this->normalizeAmount($r["лв."]);
        }

        // Разходите са отрицателни -> правим ги нормални
        $totalExpensesClean = $totalExpenses;

        $incomeSum = array_sum($incomes);

        $profit = $incomeSum + $totalExpensesClean - $salary;

        return [
            "total_expenses" => $totalExpensesClean,
            "salary"         => $salary,
            "income_sum"     => $incomeSum,
            "profit"         => $profit,
            "income_months"  => $incomes,
        ];
    }

    public function getPeriodLabel($from, $to)
    {
        if (!$from || !$to) return "Без период";

        $months = [
            "01"=>"ЯНУАРИ","02"=>"ФЕВРУАРИ","03"=>"МАРТ","04"=>"АПРИЛ",
            "05"=>"МАЙ","06"=>"ЮНИ","07"=>"ЮЛИ","08"=>"АВГУСТ",
            "09"=>"СЕПТЕМВРИ","10"=>"ОКТОМВРИ","11"=>"НОЕМВРИ","12"=>"ДЕКЕМВРИ"
        ];

        $fm = $months[date("m", strtotime($from))];
        $tm = $months[date("m", strtotime($to))];

        $year = date("Y", strtotime($from));

        return "$fm — $tm $year";
    }

    public function generateMonthFields($from, $to)
    {
        if (!$from || !$to) return [];

        $months = [];

        $start = new \DateTime($from);
        $end   = new \DateTime($to);
        $end->modify('first day of next month');

        while ($start < $end) {
            $m = $start->format("m");
            $y = $start->format("Y");

            $bgNames = [
                "01"=>"Януари","02"=>"Февруари","03"=>"Март","04"=>"Април",
                "05"=>"Май","06"=>"Юни","07"=>"Юли","08"=>"Август",
                "09"=>"Септември","10"=>"Октомври","11"=>"Ноември","12"=>"Декември"
            ];

            $months[$bgNames[$m]] = 0;

            $start->modify('first day of next month');
        }

        return $months;
    }
    
    public function getExpensesOnly()
    {
        return array_filter($this->getAllRows(), fn($r) =>
            isset($r["лв."]) // разходите имат "лв."
        );
    }

    // ⚡ сума на оборота
    public function getSalesIncome()
    {
        $total = 0;

        foreach ($this->getAllRows() as $r) {
            if (isset($r["Оборот"])) {
                $total += $this->normalizeAmount($r["Оборот"]);
            }
        }
        return $total;
    }
}

