<?php

namespace App\Controllers;

use \App\Models\MODEL__fileManager;

class FileManager extends BaseController {

    public function __construct() {
        parent::__construct();

        $this -> MODEL__fileManager = new MODEL__fileManager();
    }

    private function uploadFileCommon($file, $uploadName, $id = null, $arg = '') {

        $err = false;
        $msg = '';
        $dir = '';

        if ($file -> isValid() && !$file -> hasMoved()) {
            $newName = preg_replace('/[\s]+/', '_', $uploadName . '.' . $file -> getExtension());

            $data = [
                'id'              => $id,
                'userName_create' => $this -> ionAuth -> user() -> row() -> username,
                'offersName'      => $uploadName,
                'is_file'         => 1,
                'file_dir'        => (!empty($id) ? "$arg/$id/" : '') . $newName,
                'date_create'     => date('Y-m-d')
            ];

            $lastId = $this -> MODEL__fileManager -> upload_file($data, $arg);

            if (isset($lastId['err'])) {
                return $lastId;
            }

            $targetDirectory = dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . "docAsOfer/$arg/$lastId";

            if (!empty($id)) {
                array_map('unlink', glob("$targetDirectory/*"));
            }

            // Create folder if it doesn"t exist
            if (!is_dir($targetDirectory)) {
                mkdir($targetDirectory, 0777, true);
            }

            if ($file -> move($targetDirectory, $newName)) {
                $msg = 'Файлът е качен';
            }
        }

        return ['err' => $err, 'msg' => $msg, 'dir' => $dir ?? ''];
    }

    private function saveFileCommon($name, $folder, $id = null, $arg = null, bool $is_ofer = false) {
        $err = false;
        $msg = '';
        $dir = '';

        if (!is_dir($folder)) {
            $err = "Директорията: $arg/$id не съществува. Кликнете на бутона избор на файл";
        } else {
            $files = glob($folder . '/*');

            if (empty($files) || !file_exists($files[0])) {
                $err = "Файлът $name не е наличен в директорията.";
            } else {

                $ext     = pathinfo(basename($files[0]), PATHINFO_EXTENSION);
                $newName = preg_replace('/[\s]+/', '_', $name . '.' . $ext);
                $oldFile = $files[0];
                $newFile = $folder . '/' . $newName;

                if (rename($oldFile, $newFile)) {
                    $data = [
                        'id'         => $id,
                        'offersName' => $name,
                        'file_dir'   => "$arg/$id/$newName"
                    ];

                    $responce = $this -> MODEL__fileManager -> upload_file($data, $arg);

                    if (isset($responce['err'])) {
                        return $responce;
                    }

                    $msg = 'Файлът е редактиран.';
                } else {
                    $err = 'Грешка при редакцията на файла.';
                }
            }
        }

        return ['err' => $err, 'msg' => $msg, 'dir' => $dir];
    }

    // обновяване на качения файл
    public function saveFile($id = '', $arg = '', bool $is_ofer = false) {
        $newName = $this -> request -> getVar('newName');
        $folder  = dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . "docAsOfer/$arg/$id";
        //$folder  = 'uploads/' . $arg . '/' . $id;

        $result = $this -> saveFileCommon($newName, $folder, $id, $arg, $is_ofer);

        return json_encode($result);
    }

    // качване на файл като оферта или ценова листа
    // ==============================================
    public function uploadFile($id, $arg = '') {
        $file       = $this -> request -> getFile('file');
        $uploadName = $this -> request -> getVar('uploadName');

        $result = $this -> uploadFileCommon($file, $uploadName, $id, $arg);

        return json_encode($result);
    }

    public function deleteFile($id = '', $arg = '', bool $is_ofer = false) {
        $err    = false;
        $msg    = '';
        $folder = dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . "docAsOfer/$arg/$id";

        if (is_dir($folder)) {
            if ($is_ofer) {
                // Delete files in the directory
                array_map('unlink', glob("$folder/*"));

                // Delete the directory itself
                if (rmdir($folder)) {
                    $this -> MODEL__fileManager -> delete_file($id, $arg, $is_ofer);

                    $msg = "Файлът е изтрит";
                } else {
                    $err = "Грешка при изтриването на файла!";
                }
            } else {
                helper('filesystem');
                // Delete files and directory recursively
                if (delete_files($folder, true) && rmdir($folder)) {
                    $this -> MODEL__fileManager -> delete_file($id, $arg, $is_ofer);

                    $msg = "изтрит файл в директория";
                } else {
                    $err = "Грешка при изтриването на файл в директория";
                }
            }
        } else {
            $err = "Директория в която се намира файла не е открита";
        }

        if ($is_ofer) {
            return json_encode(['err' => $err, 'msg' => $msg]);
        } else {
            $this -> returnResponse(!$err, "$arg/$id", $err ? $err : $msg, 1);

            return redirect() -> back();
        }
    }

}

////echo json_encode($arr_merged, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT);
 //
//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
