<?php

namespace App\Controllers;

use \App\Models\MODEL__offer_isOpen;
use CodeIgniter\HTTP\ResponseInterface;

class Offer_isOpen extends BaseController {

    public function isCurentUser($oferId, $urlTab, $logedUserId) {

        // Проверка за наличие на офертата по ID и заключване на офертата, ако е възможно
        $MODEL__offer_isOpen = new MODEL__offer_isOpen();
        $offer               = $MODEL__offer_isOpen -> isCurentUser($oferId, $urlTab, $logedUserId);

        if ($offer) {
            // Проверка дали офертата е вече отворена от друг потребител
            if ($offer -> is_open == 1 && $offer -> locked_by_userId !== $logedUserId) {
                $user = $this -> ionAuth -> user($offer -> locked_by_userId ?? null) -> row();

                return json_encode([
                    'error'     => true,
                    'message'   => 'Офертата вече е отворена от потребител ',
                    'opened_by' => $user ? $user -> username : 'Неизвестен потребител'
                ]);
            } else {
                return json_encode('');
            }
        } else {
            return json_encode('');
        }
    }

    public function isOpenZenova() {
        // Проверка за AJAX заявка
        $oferId      = $this -> request -> getVar('oferId');
        $logedUserId = $this -> user -> id;

        // Проверка за AJAX заявка
        if (!$this -> request -> isAJAX()) {
            return $this -> response -> setStatusCode(400) -> setJSON(['status' => 'error', 'message' => 'Invalid request type']);
        }

        // Проверка за наличие на офертата по ID и заключване на офертата, ако е възможно
        $MODEL__offer_isOpen = new MODEL__offer_isOpen();
        $offer               = $MODEL__offer_isOpen -> isOpenZenova($oferId, $logedUserId);

        if ($offer) {
            // Проверка дали офертата е вече отворена от друг потребител
            if ($offer -> is_open == 1 && $offer -> locked_by_userId !== $logedUserId) {
                $user = $this -> ionAuth -> user($offer -> locked_by_userId ?? null) -> row();

                return json_encode([
                    'error'     => true,
                    'message'   => 'Офертата вече е отворена от потребител ',
                    'opened_by' => $user ? $user -> username : 'Неизвестен потребител'
                ]);
            } else {
                return json_encode('');
            }
        } else {
            return json_encode('');
        }
    }

    public function checkAndLockOffer() {
        // Проверка за AJAX заявка
        $oferId      = $this -> request -> getVar('oferId');
        $urlTab      = $this -> request -> getVar('urlTab');
        $logedUserId = $this -> user -> id;

        // Проверка за AJAX заявка
        if (!$this -> request -> isAJAX()) {
            return $this -> response -> setStatusCode(400) -> setJSON(['status' => 'error', 'message' => 'Invalid request type']);
        }

        // Проверка за наличие на офертата по ID и заключване на офертата, ако е възможно
        $MODEL__offer_isOpen = new MODEL__offer_isOpen();
        $offer               = $MODEL__offer_isOpen -> checkAndLockOffer($oferId, $urlTab, $logedUserId);

        if ($offer) {
            // Проверка дали офертата е вече отворена от друг потребител
            if ($offer -> is_open == 1 && $offer -> locked_by_userId !== $logedUserId) {
                $user = $this -> ionAuth -> user($offer -> locked_by_userId ?? null) -> row();

                $response = [
                    'error'     => true,
                    'message'   => 'Офертата вече е отворена от потребител',
                    'opened_by' => $user ? $user -> username : 'Неизвестен потребител'
                ];
            } else {
                // Офертата е вече заключена от текущия потребител
                $response = [
                    'status'  => 'success',
                    'message' => 'Офертата е вече заключена от текущия потребител.'
                ];
            }
        } else {
            // Успешно заключване на офертата
            $response = [
                'status'  => 'success',
                'message' => 'Офертата е успешно заключена.'
            ];
        }

        return json_encode($response);
    }

    public function unlockOffer() {
        $oferId = $this -> request -> getVar('oferId');
        $urlTab = $this -> request -> getVar('urlTab');

        if (empty($urlTab) || empty($oferId)) {
            if ($this -> request -> getServer('HTTP_REFERER')) {
                return redirect() -> to($this -> request -> getServer('HTTP_REFERER'));
            } else {
                return redirect() -> back();
            }
            //return redirect() -> back();
        }

        $MODEL__offer_isOpen = new MODEL__offer_isOpen();
        $MODEL__offer_isOpen -> unlockOffer($oferId, $urlTab);
        return json_encode('');
    }

}
