<?php

namespace App\Controllers;

use \App\Models\common\MODEL__global;
use \App\Models\printPreview\MODEL__printPreview;

class PrintPreview extends BaseController {

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global       = new MODEL__global();
        $this -> MODEL__printPreview = new MODEL__printPreview();
    }

    public function index() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $list = !empty($urlParams['id']) ? $this -> MODEL__printPreview -> get__products_forOfer($urlParams) : $this -> MODEL__printPreview -> get__products_forOrder();

        $data = [
            'message'            => '',
            'addCSS'             => $this -> addCSS(),
            'addJS'              => $this -> addJS(),
            'urlParams'          => urldecode(http_build_query($urlParams)),
            'isLandscape'        => $urlParams['tab'] == 'zenova' ? true : false,
            'arg'                => $urlParams['tab'],
            'ofer'               => $this -> MODEL__printPreview -> get__ofer_byId($urlParams),
            'list'               => $list,
            'oferId'             => $urlParams['id'] ?? $urlParams['orderId'],
            'valuta'             => $this -> MODEL__global -> get__valuta(),
            'shablon'            => $this -> MODEL__global -> get__shablons(),
            'nashiFirmi_list'    => $this -> MODEL__printPreview -> get__all_nashiFirmi(),
            'category_attribute' => $this -> MODEL__global -> get__all_categoryAttributes($list),
            // VIEWS -----------------------------------------------------
            'view_chkBtn'        => 'printPreview/VIEW__printPreview-chkBtn',
            'view_actionBtn'     => 'printPreview/VIEW__printPreview-actBtn',
            'view_table'         => $this -> get__viewPrintTable($urlParams['tab']),
        ];

        return $this -> render_template('printPreview/VIEW__printPreview', $data);
    }

    // етикети за ценова листа
    public function labels($id = '', $arg = '') {

        $map = match ($arg) {
            'zenova' => 'zenovaLabel',
            'special' => 'zenovaLabel',
        };

        $data = ['id' => $id, 'tab' => $arg];
        $list = $this -> MODEL__printPreview -> get__products_forOfer($data);

        //dd(array_column($list,'category_id'));
        $data = [
            'addJS'              => ['js/_Global/ajax_config', 'js/_Global/loadPlugins'],
            'ofer'               => $this -> MODEL__printPreview -> get__ofer_byId($data),
            'list'               => $list,
            'category_attribute' => $this -> MODEL__global -> get__all_categoryAttributes($list)
        ];

        return $this -> render_template($this -> get__viewPrintTable($map), $data);
    }

    // продуктови х-ки за предпчеат каталог
    public function productAttributes($id = '', $arg = '') {

        $data = ['id' => $id, 'tab' => $arg];
        $list = $this -> MODEL__printPreview -> get__products_forOfer($data);

        //dd(array_column($list,'category_id'));
        $data = [
            'addCSS'             => ['css/printPreview/printCatalog'],
            'addJS'              => $this -> addJS(),
            'ofer'               => $this -> MODEL__printPreview -> get__ofer_byId($data),
            'arg'                => $arg,
            'list'               => $list,
            'category_attribute' => $this -> MODEL__global -> get__all_categoryAttributes($list),
        ];

        return $this -> render_template($this -> get__viewPrintTable('catalog'), $data);
    }

    // изглед бизнес оферта та с генерация на протокол предпечат
    public function protocol($id = '', $arg = 'bizKlient') {

        $userName_label = $this -> user -> first_name . ' ' . $this -> user -> last_name;
        $arr            = ['id' => $id, 'tab' => $arg];

        $data = [
            'userName_label' => $userName_label,
            'ofer'           => $this -> MODEL__printPreview -> get__ofer_byId($arr),
            'list'           => $this -> MODEL__printPreview -> get__products_forOfer($arr),
        ];

        return view('printPreview/bizKlient/VIEW__printPreview-bizKlientProtocol', $data);
    }

    public function izbor_shablon() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $shablonId = $this -> request -> getVar('shablonId');
        $oferId    = $urlParams['id'] ?? $urlParams['orderId'];

        $list = !empty($urlParams['id']) ? $this -> MODEL__printPreview -> get__products_forOfer($urlParams) : $this -> MODEL__printPreview -> get__products_forOrder();

        $valuta  = $this -> MODEL__global -> get__valuta();
        $ofer    = $this -> MODEL__printPreview -> get__ofer_byId($urlParams);
        $shablon = $this -> MODEL__global -> get__shablons($shablonId);

        $prefixString = $_ENV['app.imageDir'];
        $pattern      = '/(<img\s[^>]*?src=")([^"]*)"/i';
        $replacement  = '$1' . $prefixString . '$2"';

        $shablon -> shablon_header = preg_replace($pattern, $replacement, $shablon -> shablon_header ?? '');
        $shablon -> shablon_footer = preg_replace($pattern, $replacement, $shablon -> shablon_footer ?? '');

        $ofer -> shablon_header = $shablon -> shablon_header ?? '';
        $ofer -> shablon_footer = $shablon -> shablon_footer ?? '';
        $userName_label         = $this -> user -> first_name . ' ' . $this -> user -> last_name;

        $data = [
            'oferId'             => $oferId,
            'list'               => $list,
            'valuta'             => $valuta,
            'ofer'               => $ofer,
            'shablon'            => $shablon,
            'userName_label'     => $userName_label,
            'category_attribute' => $this -> MODEL__global -> get__all_categoryAttributes($list),
        ];

        $data['view_table'] = view($this -> get__viewPrintTable($urlParams['tab']), $data);

        return json_encode($data);
    }

    public function exportXls() {

        $htmlString       = preg_replace("/<img[^>]+\>/i", '', $this -> request -> getVar('html') ?? '');
        $htmlString       = preg_match("/<table(.*?)>(.*?)<\/table>/is", $htmlString, $matches);
        $isHaracteristika = $this -> request -> getVar('isHaracteristika');

        if (filter_var($isHaracteristika, FILTER_VALIDATE_BOOLEAN)) {
            return $this -> exportXls_withAttr();
        }

        $cleanedTableContents = preg_replace("/<(th|td|ul|div)[^>]*style\s*=\s*['\"]display\s*:\s*none;['\"][^>]*>.*?<\/\\1>/is", "", $matches[0]);

        $file_name   = 'data.xlsx';
        $reader      = new \PhpOffice\PhpSpreadsheet\Reader\Html();
        $spreadsheet = $reader -> loadFromString($cleanedTableContents);
        $sheet       = $spreadsheet -> getActiveSheet();

        $highestRow = $sheet -> getHighestRow();

        // $highestRow = $arg == 'inv' ? 'F' . $highestRow - 1 : ($arg == 'packList' ? 'M' . $highestRow : '');
        //$sheet -> getStyle("A1:M$highestRow") -> getBorders() -> getAllBorders() -> setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
        //$sheet -> getPageSetup() -> setFitToWidth(1);
        //$sheet -> getPageSetup() -> setFitToHeight(0);
        $sheet -> getStyle('B:C') -> getAlignment() -> setWrapText(false);
        $sheet -> getColumnDimension('C') -> setWidth(30);
        $sheet -> getColumnDimension('A') -> setWidth(15);
        $sheet -> getColumnDimension('B') -> setWidth(30);

        $writer  = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
        ob_start();
        $writer -> save('php://output');
        $xlsData = ob_get_contents();
        ob_end_clean();

        $response = array(
            'fileName' => $file_name,
            'file'     => "data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64," . base64_encode($xlsData)
        );

        return (json_encode($response));
    }

    public function exportXls_withAttr() {
        $htmlString = preg_replace("/<img[^>]+\>/i", '', $this -> request -> getVar('html') ?? '');

        // Extract all tables from the HTML string
        preg_match_all("/<table(.*?)>(.*?)<\/table>/is", $htmlString, $matches);

        function removeHiddenTags($html) {
            return preg_replace("/<(th|td|b)[^>]*style\s*=\s*['\"]display\s*:\s*none;['\"][^>]*>.*?<\/\\1>/is", "", $html);
        }

        $categorizedTables = [];

        function processTable($tableHTML, &$categorizedTables) {
            // Clean table HTML (remove hidden tags)
            $cleanedTableContents = removeHiddenTags($tableHTML);

            // Extract category ID from the table using regex
            preg_match_all('/data-category-name="(.*?)"/', $tableHTML, $categoryMatches);
            $categoryIDs = $categoryMatches[1];

            // Extract thead and rows from the table
            preg_match("/<thead(.*?)>(.*?)<\/thead>/is", $cleanedTableContents, $sectionMatches);
            $theadHTML = $sectionMatches[0] ?? '';

            preg_match_all("/<tr(.*?)>(.*?)<\/tr>/is", $cleanedTableContents, $rowMatches);

            if (!empty($categoryIDs)) {
                foreach (array_unique($categoryIDs) as $categoryID) {
                    if (!isset($categorizedTables[$categoryID])) {
                        $categorizedTables[$categoryID] = [];
                        if (!empty($theadHTML)) {
                            $categorizedTables[$categoryID][] = $theadHTML;
                        }
                    }
                    foreach ($rowMatches[0] as $rowHTML) {
                        if (strpos($rowHTML, "data-category-name=\"$categoryID\"") !== false) {
                            $categorizedTables[$categoryID][] = $rowHTML;
                        }
                    }
                }
            }
        }

        foreach ($matches[0] as $tableHTML) {
            processTable($tableHTML, $categorizedTables);
        }

        // Create a new Spreadsheet object
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $reader      = new \PhpOffice\PhpSpreadsheet\Reader\Html();

        // Loop through each category to create sheets and fill data
        foreach ($categorizedTables as $categoryName => $tables) {
            // Create a new worksheet and set its title
            $sheetTitle = preg_replace('/[^A-Za-zА-Яа-я0-9\s]/u', '', $categoryName);

            if (strlen(trim($sheetTitle)) >= 54) {
                $sheetTitle = substr($sheetTitle, 0, 54);
            }

            // Encode special characters to ensure the title is safe
            if (!mb_check_encoding($sheetTitle, 'UTF-8') || !mb_detect_encoding($sheetTitle, 'UTF-8', true)) {
                $sheetTitle = mb_convert_encoding($sheetTitle, 'UTF-8');
            }

            // след енкодинга се премахва ? от края на стринга
            if (substr($sheetTitle, -1) === '?') {
                $sheetTitle = substr($sheetTitle, 0, -1);
            }

            $sheet = $spreadsheet -> createSheet();
            $sheet -> setTitle(' ' . $sheetTitle);

            $currentRow = 1;
            $finalTable = '';

            $finalTable = '<table role="presentation" width="100%" cellspacing="0">' . implode('', $tables) . '</table>';

            $tempSpreadsheet = $reader -> loadFromString($finalTable);
            $tempSheet       = $tempSpreadsheet -> getActiveSheet();
            $highestRow      = $tempSheet -> getHighestRow();
            $highestColumn   = $tempSheet -> getHighestColumn();

            // Copy the data from the temporary sheet to the main sheet
            for ($row = 1; $row <= $highestRow; $row++) {
                for ($col = 'A'; $col <= $highestColumn; $col++) {
                    $cellValue = $tempSheet -> getCell("$col$row") -> getValue();
                    $sheet -> setCellValue("$col$currentRow", $cellValue);
                    $sheet -> getStyle("$col$currentRow") -> getAlignment() -> setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
                }
                $currentRow++;
            }
            // Set column widths and styles
            $sheet -> getStyle('B:C') -> getAlignment() -> setWrapText(true);
            $sheet -> getColumnDimension('C') -> setWidth(30);
            $sheet -> getColumnDimension('A') -> setWidth(15);
            $sheet -> getColumnDimension('B') -> setWidth(30);
        }

        // Remove the default sheet created by PhpSpreadsheet
        $spreadsheet -> removeSheetByIndex(0);
        $spreadsheet -> setActiveSheetIndex(0);

        // Save the spreadsheet to a file and prepare the response
        $file_name = 'data.xlsx';
        $writer    = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
        ob_start();
        $writer -> save('php://output');
        $xlsData   = ob_get_contents();
        ob_end_clean();

        $response = array(
            'fileName' => $file_name,
            'file'     => "data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64," . base64_encode($xlsData)
        );

        //dd($response);
        return json_encode($response);
    }

    public function exportPdf() {
        $this -> pdf = new \App\Libraries\Pdf();

        $body       = $this -> request -> getVar('body');
        $oferName   = $this -> request -> getVar('oferName');
        $pageFormat = $this -> request -> getVar('pageFormat');
        $chkLenght  = $this -> request -> getVar('chkLenght');
        $isZenova   = $this -> request -> getVar('isZenova');
        $isCatalog  = $this -> request -> getVar('isCatalog');

        $data = [
            'pageFormat' => $pageFormat,
            'chkLenght'  => $chkLenght,
            'isZenova'   => $isZenova,
            'isCatalog'  => $isCatalog,
        ];

        $this -> pdf -> create($body, $oferName, $data);
    }

    // преобразуване на число в текст
    public static function number2lv($number = 0) {
        if ($number == 0) {
            return 0;
        }

        list($lv, $st) = explode(".", sprintf('%0.2f', $number));
        $lv   = (int) $lv;
        if ($lv >= 2000000000)
            return lang('LANG__printPreview.numToText.toLarge');
        $text = self::num2bgtext($lv);

        $text .= $lv == 1 ? " лев" : " лева";
        if ($st <> 0)
            $text = preg_replace("/^" . lang('LANG__printPreview.numToText.one') . " /", "", $text);
        if ($st && $st != 0) {
            $sttext = self::num2bgtext($st, true);
            $text   .= " " . lang('LANG__printPreview.numToText.and') . " " . self::num2bgtext($st, true);
            $text   .= $st == 1 ? " " . lang('LANG__printPreview.numToText.cent') : " " . lang('LANG__printPreview.numToText.cents');
        }

        return $text;
    }

    public static function num2bgtext($number, $stotinki = false) {
        $_num0 = array(0  => lang('LANG__printPreview.numToText.null'), 1  => lang('LANG__printPreview.numToText.one'), 2  => lang('LANG__printPreview.numToText.two'), 3  => lang('LANG__printPreview.numToText.tri'), 4  => lang('LANG__printPreview.numToText.four'),
            5  => lang('LANG__printPreview.numToText.five'), 6  => lang('LANG__printPreview.numToText.six'), 7  => lang('LANG__printPreview.numToText.seven'), 8  => lang('LANG__printPreview.numToText.eight'), 9  => lang('LANG__printPreview.numToText.nine'),
            10 => "lang('LANG__printPreview.numToText.ten')", 11 => lang('LANG__printPreview.numToText.eleven'), 12 => lang('LANG__printPreview.numToText.twelve'));

        $_num100 = array(1 => lang('LANG__printPreview.numToText.sto'), 2 => lang('LANG__printPreview.numToText.dvesta'), 3 => lang('LANG__printPreview.numToText.trista'));

        $number = (int) $number;

        $_div10         = ($number - $number % 10) / 10;
        $_mod10         = $number % 10;
        $_div100        = ($number - $number % 100) / 100;
        $_mod100        = $number % 100;
        $_div1000       = ($number - $number % 1000) / 1000;
        $_mod1000       = $number % 1000;
        $_div1000000    = ($number - $number % 1000000) / 1000000;
        $_mod1000000    = $number % 1000000;
        $_div1000000000 = ($number - $number % 1000000000) / 1000000000;
        $_mod1000000000 = $number % 1000000000;

        if ($number == 0) {
            return $_num0[$number];
        }


        /* До двайсет */
        if ($number > 0 && $number < 20) {
            if ($stotinki && $number == 1)
                return lang('LANG__printPreview.numToText.edna');
            if ($stotinki && $number == 2)
                return lang('LANG__printPreview.numToText.dve');
            if ($number == 2)
                return lang('LANG__printPreview.numToText.dva');

            return isset($_num0[$number]) ? $_num0[$number] : $_num0[$_mod10] . lang('LANG__printPreview.numToText.nadeset');
        }

        /* До сто */
        if ($number > 19 && $number < 100) {
            //dd($_num0);
            $tmp = ($_div10 == 2) ? lang('LANG__printPreview.numToText.dvadeset') : $_num0[$_div10] . lang('LANG__printPreview.numToText.ten');
            $tmp = $_mod10 ? $tmp . " " . lang('LANG__printPreview.numToText.and') . " " . self::num2bgtext($_mod10, $stotinki) : $tmp;
            return $tmp;
        }

        /* До хиляда */
        if ($number > 99 && $number < 1000) {
            $tmp = isset($_num100[$_div100]) ? $_num100[$_div100] : $_num0[$_div100] . lang('LANG__printPreview.numToText.stotin');
            if (($_mod100 % 10 == 0 || $_mod100 < 20) && $_mod100 != 0) {
                $tmp .= " " . lang('LANG__printPreview.numToText.and');
            }
            if ($_mod100) {
                $tmp .= " " . self::num2bgtext($_mod100);
            }
            return $tmp;
        }

        /* До милион */
        if ($number > 999 && $number < 1000000) {
            /* Damn bulgarian @#$%@#$% два хиляди is wrong :) */
            $tmp      = ($_div1000 == 1) ? lang('LANG__printPreview.numToText.hilqda') :
                    (($_div1000 == 2) ? lang('LANG__printPreview.numToText.dvehilqdi') : self::num2bgtext($_div1000) . " " . lang('LANG__printPreview.numToText.hilqdi'));
            $_num0[2] = lang('LANG__printPreview.numToText.dva');
            if (($_mod1000 % 10 == 0 || $_mod1000 < 20) && $_mod1000 != 0) {
                if (!(($_mod100 % 10 == 0 || $_mod100 < 20) && $_mod100 != 0)) {
                    $tmp .= " " . lang('LANG__printPreview.numToText.and');
                }
            }
            if (($_mod1000 % 10 == 0 || $_mod1000 < 20) && $_mod1000 != 0 && $_mod1000 < 100) {
                $tmp .= " " . lang('LANG__printPreview.numToText.and');
            }
            if ($_mod1000) {
                $tmp .= " " . self::num2bgtext($_mod1000);
            }
            return $tmp;
        }

        /* Над милион */
        if ($number > 999999 && $number < 1000000000) {
            $tmp = ($_div1000000 == 1) ? lang('LANG__printPreview.numToText.onemilion') : self::num2bgtext($_div1000000) . " " . lang('LANG__printPreview.numToText.miliona');
            if (($_mod1000000 % 10 == 0 || $_mod1000000 < 20) && $_mod1000000 != 0) {
                if (!(($_mod1000 % 10 == 0 || $_mod1000 < 20) && $_mod1000 != 0)) {
                    if (!(($_mod100 % 10 == 0 || $_mod100 < 20) && $_mod100 != 0)) {
                        $tmp .= " " . lang('LANG__printPreview.numToText.and');
                    }
                }
            }
            $and = ", ";
            if (($_mod1000000 % 10 == 0 || $_mod1000000 < 20) && $_mod1000000 != 0 && $_mod1000000 < 1000) {
                if (($_mod1000 % 10 == 0 || $_mod1000 < 20) && $_mod1000 != 0 && $_mod1000 < 100) {
                    $tmp .= " " . lang('LANG__printPreview.numToText.and');
                }
            }
            if ($_mod1000000) {
                $tmp .= " " . self::num2bgtext($_mod1000000);
            }
            return $tmp;
        }

        /* Над милиард */
        if ($number > 99999999 && $number <= 2000000000) {
            $tmp = ($_div1000000000 == 1) ? lang('LANG__printPreview.numToText.onemiliard') : "";
            $tmp = ($_div1000000000 == 2) ? lang('LANG__printPreview.numToText.twomiliard') : $tmp;
            if ($_mod1000000000) {
                $tmp .= " " . self::num2bgtext($_mod1000000000);
            }
            return $tmp;
        }
        /* Bye ... */
        return "";
    }

    // ==== зареждане на css файлове в header на html странiцата ====
    // --------------------------------------------------------------
    public function addCSS() {

        return [
            'css/layouts/global',
            'css/printPreview/printPreview'
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = ['plugins/stickyTableHeaders/stickytableheaders'];

        $default = ['js/printPreview/printPreview'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
