<?php

namespace App\Controllers\home;

use App\Controllers\BaseController;

class Home extends BaseController {

    protected $viewPath = 'home/';

    /**
     * Главна страница (Home)
     * - Зарежда навигацията (merge от CustomConfig + overrides)
     * - Подаваме isAdmin флаг за да се показват контролите за редакция
     * - Ако е админ, вкарваме и JS за редактора
     */
    public function index() {
        $isRefresh = $this -> request -> getVar('isRefresh');

        $data = [
            'page_title' => '<i class="fa fa-home"></i>',
            'addCSS'     => $this -> addCSS(),
            'addJS'      => $this -> addJS(),
            'message'    => session() -> getFlashdata('message'),
            'isAdmin'    => $this -> ionAuth -> isAdmin(),
        ];

        return $this -> render_template($this -> viewPath . 'VIEW__homePage', $data);
    }

    /**
     * Връща текущата конфигурация на навигацията (вкл. скритите елементи)
     * Само за администратори. Ползва се от фронтенд редактора.
     * GET /home/nav-config
     */
    public function navConfigFetch() {
        if (!$this -> ionAuth -> isAdmin()) {
            return $this -> response -> setStatusCode(403) -> setJSON(['error' => 'forbidden']);
        }

        // includeDisabled=true -> искаме да виждаме и скритите items/groups
        $nav = $this -> getNavFromConfig(true);
        return $this -> response -> setJSON($nav);
    }

    /**
     * Записва overrides на навигацията (JSON в writable/nav_overrides.json)
     * Само за администратори. Ползва се от фронтенд редактора.
     * POST /home/nav-config
     * Body: { "groups": [ { key, title, position, enabled, items:[{id,label,icon,enabled,position,attrs:{...}}] } ] }
     */
    public function nav_save() {
        $data = $this -> request -> getJSON(true);

        if (!is_array($data)) {
            return $this -> response -> setStatusCode(400) -> setJSON(['error' => 'bad_payload']);
        }

        // Път към файла
        $path = $this -> get__jsonNavPath();

        // Уверяваме се, че директорията съществува
        if (!is_dir(dirname($path))) {
            mkdir(dirname($path), 0775, true);
        }

        file_put_contents($path, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

        return $this -> response -> setJSON(['ok' => true]);
    }

    /**
     * Нулира overrides (трие writable/nav_overrides.json)
     * Само за администратори.
     * DELETE /home/nav-config
     */
    public function nav_reset() {

        $path = $this -> get__jsonNavPath();

        if (is_file($path)) {
            @unlink($path);
        }

        return $this -> response -> setJSON(['ok' => true]);
    }

    public function addCSS() {
        return ['css/home/homePage'];
    }

    public function addJS() {
        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = [];

        $default = [
            'js/homePage/homePage_navEditor',
            'js/layouts/topMenu',
            'js/popupForm/popup_expImp'
        ];

        $modals = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}
