<?php

namespace App\Controllers\mainPage;

use \App\Controllers\BaseController as BaseController;
use \App\Models\mainPage\MODEL__mainPage;
use \App\Models\common\MODEL__all_oferta;
use \App\Libraries\Pagination;
use Config\Services;
use ZipArchive;

class MainPage extends BaseController {

    private $Pagination_lib;
    private $MODEL__mainPage;

    public function __construct() {
        parent::__construct();

        //$this -> checkgroupAccess('home', $single = 0);
//        $viewTab = ['view' => 'home', 'tab' => $this -> request -> getVar('tab') ?? ''];
//        if (!$this -> acl -> isAllowed($this -> group -> id, $viewTab, null)) {
//            $this -> session -> setFlashdata('message', 'Достъпът е отказан!');
//            echo 'Достъпът е отказан!';
//            exit();
//        }


        $this -> Pagination_lib    = new Pagination();
        $this -> MODEL__all_oferta = new MODEL__all_oferta();
        $this -> MODEL__mainPage   = new MODEL__mainPage();

        $this -> session -> remove(['oferId', 'openedTab']);
    }

    public function index() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        //$this -> breadcrumb -> add('СПИСЪК С ЛИСТИ', '/');

        $tab        = $urlParams['tab'] ?? 'zenova';
        $orderTip   = $urlParams['orderTip'] ?? '';
        $page       = max(1, (int) ($urlParams['page'] ?? 1)); // ako $perPage ==0
        $perPage    = max(1, (int) ($urlParams['perPage'] ?? 10));
        $searchName = $urlParams['searchName'] ?? '';
        $searchCol  = $urlParams['searchCol'] ?? null;

        $sortCol   = $urlParams['sort_col'] ?? null;
        $sortOrder = $urlParams['sort_order'] ?? null;
        $offset    = max(0, ($page - 1) * $perPage);

        $matchedTable       = '';
        $matchedPagnitation = '';

        $list = $this -> MODEL__mainPage -> get__list(
                $tab,
                $searchName,
                $searchCol,
                ['col' => $sortCol, 'sortOrder' => $sortOrder],
                ['offset' => $offset, 'per_page' => $perPage]);

        $countTotalRecords = $this -> MODEL__mainPage -> count_totalRecords($tab, $searchName, $searchCol, ['col' => $sortCol, 'sortOrder' => $sortOrder]);

        $totalPages = ceil($countTotalRecords / $perPage);
        $pagination = $this -> Pagination_lib -> generate(['page' => $page, 'total_pages' => $totalPages]);

        $users = in_array($orderTip, ['site', 'L', 'K']) ? $this -> MODEL__global -> get__users(['id', 'first_name', 'last_name', 'username']) : '';

        $pageTitle = [
            'zenova'    => 'ЦЕНОВИ ЛИСТИ',
            'special'   => 'ОФЕРТИ',
            'bizKlient' => 'БИЗНЕС КЛИЕНТИ ОФЕРТИ',
            'order'     => 'ПОРЪЧКИ',
            'promo'     => 'ПРОМОЦИИ',
            'baner'     => 'ЗАЯВКА ЗА БАНЕР'
        ];

        $data = [
            'page_title'           => $pageTitle[$tab] ?? '',
            //'checkgroupAccess'     => $this -> checkgroupAccess('home', $single                = 0),
            'addCSS'               => $this -> addCSS(),
            'addJS'                => $this -> addJS(),
            'acl'                  => $this -> acl,
            'userGroupId'          => $this -> group -> id,
            'session'              => $this -> session -> get('tabSesion'),
            'breadcrumbs'          => $this -> breadcrumb -> render(),
            'message'              => session() -> getFlashdata('message'),
            'providers'            => ($tab == 'providers') ? $this -> MODEL__mainPage -> get__providers() : null,
            'list'                 => $list,
            'pagination'           => $pagination,
            'sesion_unionOrderIds' => $this -> getSession('sesion_unionOrderIds') ?? [],
            'countTotalRecords'    => $countTotalRecords,
            'status'               => $this -> MODEL__global -> get__status(),
            'users'                => $users,
            // views --------------------------------------------------------
            'view__table'          => $this -> get__viewMainpageTables(),
            'view_order'           => [
                'site'   => 'mainPage/order/VIEW__mainPage-order-dilar',
                'L'      => 'mainPage/order/VIEW__mainPage-order-dilar',
                'K'      => 'mainPage/order/VIEW__mainPage-order-klient',
                'F'      => 'mainPage/order/VIEW__mainPage-order-fast',
                'N'      => 'mainPage/order/VIEW__mainPage-order-uncomplete',
                'sklad'  => 'mainPage/order/VIEW__mainPage-order-gensoftSklad1',
                'sklad2' => 'mainPage/order/VIEW__mainPage-order-gensoftSklad2',
            ]
        ];

        if (empty($searchName)) {
            $remove = true;

            // ако няма търсе по име се изтрива сесията за маркирани поръчки(за обединение)
            $this -> setSession($remove, 'sesion_unionOrderIds');
            $data['sesion_unionOrderIds'] = [];
        }

        if (isset($urlParams['isRefresh'])) {
            $htmlTable = view('mainPage/VIEW__mainPage_table-' . $tab, $data);

            if (preg_match('#<tbody>([\s\S]*)</tbody>#i', $htmlTable, $matches)) {
                $matchedTable = trim(str_replace(['<tbody>', '</tbody>'], ' ', $matches[0]));
            }

            if (preg_match('/<div id="pagination"([\s\S]*)>(.*?)<\/div>/s', $htmlTable, $matches)) {
                $matchedPagnitation = $matches[0];
            }

            return json_encode([
                'table'       => $matchedTable,
                'pagnitation' => $matchedPagnitation
            ]);
        }

        return $this -> render_template('mainPage/VIEW__mainPage', $data);
    }

    // изтриване на оферта
    // ===================
    public function delete() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);
        $name = $urlParams['name'];

        $this -> MODEL__all_oferta -> delete_oferta($urlParams);
        $this -> returnResponse(true, $name, 'изтрит запис: ', 1);

        return redirect() -> back();
    }

    // връщане на поръчка
    // =============================
    public function returnOrder() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);
        $name = $urlParams['name'];

        $this -> MODEL__mainPage -> return_order($urlParams);
        $this -> returnResponse(true, $name, 'върната поръчка', 1);

        return redirect() -> back();
    }

    // завършване на поръчка
    // =============================
    public function completeOrder() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);
        $name = $urlParams['name'];

        $this -> MODEL__mainPage -> completeOrder($urlParams);
        $this -> returnResponse(true, $name, 'завършена поръчка', 1);

        return redirect() -> back();
    }

    // изтриване на на поръчка от ел магазин
    // ====================================
    public function deleteOrder() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);
        $name = $urlParams['name'];

        $this -> MODEL__mainPage -> delete_order($urlParams);
        $this -> returnResponse(true, $name, 'изтритa поръчка: ', 1);

        return redirect() -> back();
    }

    // копиране на оферта
    // ===================
    public function copy() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $data = [
            'id'       => $urlParams['id'] ?? '',
            'oferName' => $urlParams['name'],
            'userName' => $this -> ionAuth -> user() -> row() -> username
        ];

        if ($urlParams['tab'] == 'order') {
            $response = $this -> MODEL__mainPage -> clone_order($data['userName'], $urlParams['orderId']);
        } else {
            $response = $this -> MODEL__mainPage -> copy_ofer($data, $urlParams['tab']);
        }


        if (isset($response['err'])) {
            $this -> returnResponse(false, null, $response['err'], 1);
        }

        return redirect() -> back();
    }

    // превръщане  на оферта в поръчка
    // ==============================
    public function convert($id, $name = '') {

        $response = $this -> MODEL__all_oferta -> convert_ofer($id, $name);

        if ($response == true) {
            $this -> returnResponse(true, $name, lang('LANG__mainPage.returnResponse.ok.convertOfer'), 1);
        }

        return redirect() -> back();
    }

    // обединяване на поруъчки дъ=илърски по id на поръчките
    public function unionOrders_byIds() {
        $sesionName = $this -> request -> getVar('sesionName');
        $orderIds   = $this -> getSession($sesionName) ?? [];

        if (!empty($orderIds)) {
            $this -> MODEL__mainPage -> unionOrders($orderIds);
            $this -> setSession(true, 'sesion_unionOrderIds'); //изчиства сесията с обединените поръчки
        }

        $this -> returnResponse(true, '', 'извършена операцията обединение.', 1);

        return json_encode('');
    }

    public function save_tovaritelnizaNo() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $urlParams['tavaritelniza_no'] = $this -> request -> getVar('tovaritelnizaNo');
        $response                      = $this -> MODEL__mainPage -> save_tovaritelnizaNo($urlParams);

        return json_encode($response);
    }

    // сваляне на прикачени файлове като zip файл
    public function downloadFiles() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $dir = dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . "documents/{$urlParams['tab']}/{$urlParams['id']}";

        if (!is_dir($dir)) {
            return $this -> response -> setStatusCode(404) -> setBody('Директорията не съществува.');
        }

        $zipFilename = "archive_{$urlParams['tab']}";

        $zip     = new ZipArchive();
        $tempZip = tempnam(sys_get_temp_dir(), 'zip');

        if ($zip -> open($tempZip, ZipArchive::CREATE) !== TRUE) {
            return $this -> response -> setStatusCode(500) -> setBody('Неуспешно създаване на ZIP файла.');
        }

        foreach (scandir($dir) as $file) {
            if ($file !== '.' && $file !== '..') {
                $filePath = $dir . '/' . $file;
                if (is_file($filePath)) {
                    $zip -> addFile($filePath, $file);
                }
            }
        }

        $zip -> close();

        // Изчистване на буфера (ако има нещо)
        if (ob_get_level()) {
            ob_end_clean();
        }
        // Задаване на хедъри за сваляне
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="' . $zipFilename . '"');
        header('Content-Length: ' . filesize($tempZip));
        header('Pragma: public');
        header('Cache-Control: must-revalidate');
        header('Expires: 0');

        // Изпращане на файла към браузъра
        readfile($tempZip);
        unlink($tempZip);
        exit;
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'css/layouts/global',
            'css/layouts/tables',
            'css/mainPage/mainPage'   
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/remove_special_chars'
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/tblColumnToggle/jquery.columntoggle',
            'plugins/tblColumnToggle/jquery.pageLength'
        ];
        $default = [
            'js/mainPage/mainPage',
            'js/mainPage/mainPage_fileAction'
        ];

        $modals = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
