<?php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class OfferLockFilter implements FilterInterface {

    // филтър за изритване на потребител ако нов се логне
    public function before(RequestInterface $request, $arguments = null) {
        $session = session();
        $offerId = $session -> get('oferId');
        $tab     = $session -> get('openedTab');
        $user    = $session -> get('user');

        if (!$offerId || !$user) {
            return; // няма нужните данни – пускаме заявката
        }

        $MODEL__offer_isOpen = new \App\Models\MODEL__offer_isOpen();

        $logedUserId = $user -> id;
        $offer       = $MODEL__offer_isOpen -> isCurentUser($offerId, $tab, $logedUserId);

        if ($offer && $offer -> is_open == 1 && $offer -> locked_by_userId != $logedUserId) {
            $ionAuth    = new \IonAuth\Libraries\IonAuth();
            $lockedUser = $ionAuth -> user($offer -> locked_by_userId ?? null) -> row();

            if ($request -> isAJAX()) {
                return service('response') -> setStatusCode(410) ;
            }

            return redirect() -> to(base_url()) -> with('error', 'Офертата е заключена от потребител: ' . ($lockedUser -> username ?? 'неизвестен'));
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null) {
        
    }

}
