<?php

if (!function_exists('generate_category_li')) {

    function generate_category_li($data = []) {

        $routeCreate = route_to('POPup_category-save', 'null', $data['categoryId']);
        $routeDelete = route_to('POPup_category-delete', $data['categoryId']);
        $routeSave   = route_to('POPup_category-save', $data['categoryId'], 'null');

        $enterName   = lang('LANG__category.placeholder.enterName');
        $deleteTitle = lang('LANG__global.btn.delete');
        $editTitle   = lang('LANG__global.btn.edit');
        $saveTitle   = lang('LANG__global.btn.save');

        $placeholder = lang('LANG__category.label.subCat');

        $li = <<<HTML
                       <li class="clearfix" data-id="{$data['categoryId']}">
                            <span class="node-plus"></span>
                            <i class="fa fa-battery-empty"></i>

                            <div class="btnGroup btn-group">
                                <i class="edit btn-outline-primary p-1 border-0 fa fa-edit" data-route="{$routeSave}" title="{$editTitle}"></i>
                                <i class="delete btn-outline-danger p-1 border-0 fa fa-trash" data-route="{$routeDelete}" title="{$deleteTitle}"></i>
                            </div>

                            <label class="categoryName">{$data['name']}</label>

                            <ul class="child" style="display:none">
                                <li class="label m-1" data-id="{$data['categoryId']}">
                                    <div class="row">
                                        <div class="col">
                                            <!-- Подкатегория -->
                                            <span class="ml-1">{$placeholder}</span>
                                        </div>

                                        <div class="col-6">
                                            <!--  Въвеведете имe -->
                                            <input class="categoryName" type="text" style="width: 90%;" placeholder="{$enterName}">
                                            <i class="create btn-outline-primary p-1 border-0 fa fa-save float-right clearfix mr-1" data-route="{$routeCreate}" title="{$saveTitle}"></i>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </li>
                HTML;

        return $li;
    }

}

if (!function_exists('generate_subCategory_li')) {

    function generate_subCategory_li($data = []) {

        $routeDelete = route_to('POPup_category-delete', $data['categoryId']);
        $routeSave   = route_to('POPup_category-save', $data['categoryId'], $data['parentId']);

        $deleteTitle = lang('LANG__global.btn.delete');
        $editTitle   = lang('LANG__global.btn.edit');

        $li = <<<HTML
                        <li data-id="{$data['parentId']}" data-sub-id="{$data['categoryId']}">

                          <div class="btnGroup btn-group">
                              <i class="edit btn-outline-primary p-1 border-0 fa fa-edit" data-route="{$routeSave}" title="{$editTitle}"></i><!-- редакция -->

                              <i class="delete btn-outline-danger p-1 border-0 fa fa-trash" data-route="{$routeDelete}" title="{$deleteTitle}"></i><!-- изтриване -->
                          </div>

                          <span class="categoryName akrobatSemiBold">{$data['name']}</span> 
                       </li>
                HTML;

        return $li;
    }

}

// app/Helpers/CustomHelper.php
if (!function_exists('generate_attribute_li')) {

    function generate_attribute_li($data = []) {

        $routeDelete = route_to('POPup_categoryAttr-delete', $data['attrId']);
        $routeSave   = route_to('POPup_categoryAttr-save', $data['attrId'], $data['categoryId']);
        $deleteTitle = lang('LANG__global.btn.delete');
        $editTitle   = lang('LANG__global.btn.edit');

        $li = <<<HTML
                        <li data-id="{$data['attrId']}" data-sub-id="{$data['categoryId']}">
                          <div class="btnGroup btn-group btn-group-sm">
                              <i class="edit btn-outline-primary p-1 border-0 fa fa-edit" data-route="{$routeSave}" title="{$editTitle}"></i><!-- редакция -->

                              <i class="delete btn-outline-danger p-1 border-0 fa fa-trash" data-route="{$routeDelete}" title="{$deleteTitle}"></i><!-- изтриване -->
                          </div>

                          <span class="categoryName">{$data['name']}</span>
                       </li>
                HTML;

        return $li;
    }

}

// генериране на атрибути за х-ки в м. ф. редакция на продукт
if (!function_exists('generate_categoryAttribute')) {

    function generate_categoryAttribute($data = []) {
        $routeDelete = route_to('POPup_categoryAttr-delete', $data['attrId']);
        $routeSave   = route_to('POPup_categoryAttr-save', $data['attrId'], $data['categoryId']);
        
        $deleteTitle = lang('LANG__global.btn.delete');
        $editTitle   = lang('LANG__global.btn.edit');

        $attr = <<<HTML
                    <div class="rootBlock input-group input-group-sm mb-1">
                          <div class="input-group-prepend input-group-text col justify-content-end text-right bg-transparent border-top-0 border-left-0 border-right-0 ">
                
                            <label class="categoryAttrName akrobatSemiBold w-100" data-id="{$data['attrId']}">{$data['name']}</label>
                                
                            <div class="btnGroup btn-group">
                                <!-- редакция -->
                                <i class="editCatAttr btn-outline-primary p-1 border-0 fa fa-edit" data-route="{$routeSave}" title="{$editTitle}"></i>

                                <!-- изтриване -->
                                <i class="deleteCatAttr btn-outline-danger p-1 border-0 fa fa-trash" data-route="{$routeDelete}" title="{$deleteTitle}"></i>
                            </div> 
                         
                          </div>
                                 
                        <div class="input-group-prepend col">
                            <textarea class="txtProdAttr w-100" name="product_characteristic[{$data['attrId']}',]" rows="1"></textarea>
                        </div>  
                    </div>
                HTML;

        return $attr;
    }

}




    