<?php

if (!function_exists('h_getValuta')) {

    function h_getValuta() {

        $settings = service('settings') -> get('App.general') ?? [];

        /* --- Основни настройки ------------------------------------ */
        $preval   = $settings['preval'] ?? [];
        $currency = $preval['base_currency'] ?? 'BGN';

        /* --- Валута ---------------------------------------------- */
        return match ($currency) {
            'EUR' => '€',
            'USD' => '$',
            default => 'лв',
        };
    }

}

/**
  Извлича IP адрес от стринг във формат:
  "IP:път_към_GDB"
  Пример:
  109.199.253.21:c:/Gensoft2/SKLAD.GDB
  ------------------------------------------------------ */
if (!function_exists('h_extractIp')) {

    function h_extractIp(string $input): ?string {

        if (preg_match('/^(\d{1,3}(?:\.\d{1,3}){3})/', $input, $m)) {
            if (filter_var($m[1], FILTER_VALIDATE_IP)) {
                return $m[1];
            }
        }
        return null;
    }

}

/**
  Конвертира текст от Gensoft (CP1251) към UTF-8
  извличане от gensoft с бг
  Използва се при четене на текстови полета от Firebird / Gensoft.
  ------------------------------------------------------ */
if (!function_exists('h_UTF8')) {

    function h_UTF8($str): string {
        return iconv("CP1251", "UTF-8", trim($str));
    }

}

// извличане от gensoft с бг
if (!function_exists('h_UTF8N')) {

    function h_UTF8N($str): string {

        $converted = iconv("CP1251", "UTF-8", (
                $str == '' || empty($str) ? 'NULL' :
                (is_numeric($str) ? $str : "'" . (trim($str)) . "'")
        ));

        return $converted == "''" ? 'NULL' : $converted;
    }

}

/**
  Конвертира текст от UTF-8 към CP1251
  Използва се при запис на текстови данни към Gensoft / Firebird.
  ------------------------------------------------------ */
if (!function_exists('h_CP1251')) {

    function h_CP1251($str): string {
        return iconv("UTF-8", "CP1251", $str);
    }

}

/** извличане от gensoft с бг
 *   ------------------------------------------------------ */
if (!function_exists('CP1251N')) {

    function h_CP1251N($str): string {
        return iconv("UTF-8", "CP1251", ($str == '' || empty($str) ? 'NULL' : "'" . ($str) . "'"));
    }

}

/** Премахва апострофи
 *   ------------------------------------------------------ */
if (!function_exists('h_replace')) {

    function h_replace($str): string {
        $str = str_replace("'", '', $str);
        return trim($str);
    }

}
/** Нормализация на мерната единица
 *   ------------------------------------------------------ */
if (!function_exists('h_normalizeUnit')) {

    function h_normalizeUnit(string $v): string {
        $v = trim(mb_strtolower($v));
        $v = rtrim($v, '.');
        return $v;
    }

}

/** Форматиране на мерната единица
 *   ------------------------------------------------------ */
if (!function_exists('h_formatUnit')) {

    function h_formatUnit(string $v): string {
        $v = trim(mb_strtolower($v));

        // ако вече завършва на точка → готово
        if (mb_substr($v, -1) === '.') {
            return $v;
        }

        // ако последният символ е буква → добавяме точка
        if (preg_match('/\p{L}$/u', $v)) {
            return $v . '.';
        }

        return $v;
    }

}

/** Форматиране на мерната единица
 *   ------------------------------------------------------ */
if (!function_exists('h_toFixed')) {

    function h_toFixed($v, bool $isRoundedToFirst = false) {
        $settingsGeneral = service('settings') -> get('App.general') ?? [];
        $priceAccuracy   = $isRoundedToFirst ? 1 : (int) $settingsGeneral['priceAccuracy'] ?? 2;

        return is_numeric($v) ? sprintf('%0.' . $priceAccuracy . 'f', (float) $v) : null;
    }

}

/**
  Преобразува DateTime към Gensoft / Firebird GenDT формат
  GenDT представлява:
  - брой дни (OLE Automation Date)
  - от 1990-01-01
  - умножено по 100000
  Добавя +3 часа за корекция на времевата зона.
  ------------------------------------------------------ */
if (!function_exists('h_dateToGenDT')) {

    function h_dateToGenDT(DateTime $dt): int {
        // Set base date (1990-01-01)
        $baseDate = new DateTime('1990-01-01', new DateTimeZone('UTC'));

        $dt -> modify('+3 hours');

        // Convert both dates to OLE Automation Date (number of days since 1899-12-30)
        $dtOADate = $dt -> format('U') / 86400 + 25569; // UNIX timestamp to OLE Automation Date

        $baseDateOADate = $baseDate -> format('U') / 86400 + 25569; // Base date to OLE Automation Date
        // Calculate GenDT (multiply by 100000)
        return intval(($dtOADate - $baseDateOADate) * 100000);
    }

}

if (!function_exists('h_dateToGenDT2')) {

    function h_dateToGenDT2(DateTime $dt): int {
        // базова дата (Gensoft)
        $baseDate = new DateTime('1990-01-01 00:00:00', new DateTimeZone('UTC'));

        // работим с копие, за да не пипаме оригиналния обект
        $dt = clone $dt;

        // нормализираме към 00:00:00 (махаме часа напълно)
        $dt -> setTime(0, 0, 0);

        // OLE Automation Date
        $dtOADate       = $dt -> format('U') / 86400 + 25569;
        $baseDateOADate = $baseDate -> format('U') / 86400 + 25569;

        // GenDT (дни * 100000)
        return (int) (($dtOADate - $baseDateOADate) * 100000);
    }

}
