<?php

namespace App\Libraries\Gensoft;

/*
 * ------------------------------------------------------------
 * FIREBIRD (GENSOFT) CONNECTION HANDLER
 * ------------------------------------------------------------

  Отговаря за:
  - проверка на достъпност до Firebird сървъра
  - управление на връзка (persistent / non-persistent)
  - кеширане на активната връзка
 */

class LIB__FirebirdConnection {

    /** @var resource|null */
    protected $conn        = null;
    protected ?string $currentHost = null;

    /* Проверява дали Firebird сървърът е достъпен по мрежа
      ------------------------------------------------------ */

    public function isReachable(string $ip, int $port = 3050, int $timeout = 2): bool {
        $fp = @fsockopen($ip, $port, $errno, $errstr, $timeout);

        if ($fp) {
            fclose($fp);
            return true;
        }

//        echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
//                <fieldset class="p-2 pt-3"><strong class="fa fa-exclamation-triangle"></strong>  Връзката с Gensoft сървър не може да се осъществи!</fieldset>
//                    <button type="button" class="close text-light p-1" data-dismiss="alert">
//                        <span>×</span>
//                    </button>
//              </div>';

        return false;
    }

    /* Създава връзка към Firebird база данни
      ------------------------------------------------------ */

    public function connect(string $host, string $user = 'SYSDBA', string $password = 'masterkey') {

        // Ако имаме връзка и не искаме форсиран reconnect
        if ($this -> conn && $this -> currentHost === $host) {
            return $this -> conn;
        }

        // ако сменяме host → просто забравяме старата връзка
        // НЕ я затваряме!
        if ($this -> conn && $this -> currentHost !== $host) {
            $this -> conn        = null;
            $this -> currentHost = null;
        }

        // Избор на тип връзка:
        // - persistent при нормална работа без ibase_close()
        // - non-persistent при принудителен reconnect
        $conn = @ibase_pconnect($host, $user, $password);

        if (!$conn) {
            throw new \RuntimeException('Firebird connection failed: ' . ibase_errmsg());
        }

        // Кешираме връзката за повторна употреба
        // кешираме
        $this -> conn        = $conn;
        $this -> currentHost = $host;
        return $conn;
    }

    /* Връща текущата активна Firebird връзка
      ------------------------------------------------------ */

    public function getConnection() {
        if (!$this -> conn) {
            throw new \RuntimeException('Firebird connection not initialized. Call connect() first.');
        }

        return $this -> conn;
    }

}
