<?php

namespace App\Libraries\Gensoft\Local;

use \App\Models\BaseModel;

class LIB__GensoftGroups {

    protected $settings;

    // основна функция 
    public function renderSklad() {
        return $this -> renderWrapper();
    }

    public function renderGroups($skladId = '') {
        $db = db_connect();

        $groups = $db -> table(BaseModel::TBL_CATEGORY_GENSOFT)
                        -> where('sklad_id', $skladId)
                        -> get() -> getResultArray();

        if (empty($groups)) {
            return [];
        }

        $tree = $this -> buildTree(null, $groups);

        return $this -> renderTree($tree, true);
    }

    /** Изграждане на дървото
      ========================================== */
    protected function buildTree($parent, array $categories): array {
        $tree = [];

        foreach ($categories as $category) {
            if ($category['parent'] == $parent) {

                $children = $this -> buildTree($category['grupa'], $categories);

                $category['children'] = $children ?: [];
                $tree[]               = $category;
            }
        }

        return $tree;
    }

    /** Рендиране на филтъра (избор на склад,  дата)
      ========================================== */
    protected function renderWrapper(): string {
        // CSS assets, които тази библиотека изисква
        $route_gensoftGroups_by_sklad = route_to('Popup_izboProduct-getGensoftGroups_bySklad');
        $cssHtml                      = '';
        $jsHtml                       = '';

        foreach ($this -> addCSS() as $css) {
            $cssHtml .= sprintf(
                    '<link rel="stylesheet" type="text/css" href="%s">',
                    auto('assets/' . $css . '.css')
            );
        }

        foreach ($this -> addJS() as $js) {
            $jsHtml .= sprintf(
                    '<script src="%s"></script>',
                    auto('assets/' . $js . '.js')
            );
        }

        $optionsHtml = '';
        foreach ([$_ENV['app.baseSklad'], $_ENV['app.sklad4']] as $i => $value) {
            if (!empty($value)) {
                $optionsHtml .= sprintf(
                        '<option value="%s">%s</option>',
                        $i,
                        $value
                );
            }
        }


        return <<<HTML
                       $cssHtml

                        <label> Избор на Gensoft склад</label>
                        <select id="gensoftSklad" class="css-dropdown-p css-focus-strong my-1" data-route="$route_gensoftGroups_by_sklad">
                            <option value="">-- Избери склад --</option>
                            $optionsHtml
                        </select>
                
                       <!-- Филтър по дата -->
                       <div class="my-1">
                            <div class="css-date-range">
                                <div>
                                    <span class="css-date-label">Период От</span>
                                    <input id="dateFrom" 
                                           type="date"
                                           class="css-input-p css-focus-strong css-border-none  w-90">
                                </div>

                                <div>
                                    <span class="css-date-label">До</span>
                                    <input id="dateTo"
                                           type="date"
                                           class="css-input-p css-focus-strong css-border-none  w-90">
                                </div>
                            </div>
                        </div>
                
                        <div id="renderTree"></div>

                      $jsHtml
                HTML;
    }

    /**  Рендиране на списъка с групи ul
      ========================================== */
    protected function renderTree(array $tree, bool $isRoot = false): string {
        if (!$tree) {
            return '';
        }

        $route_filter = route_to('Popup_izboProduct-refreshTable');
        $list         = '<ul' . ($isRoot ? ' class="root overflow-auto" style="max-height: calc(100vh - 330px);"' : '') . '>';

        foreach ($tree as $item) {

            $children     = $item['children'] ?? [];
            $hasChildren  = !empty($children);
            $label        = htmlspecialchars($item['grupa'], ENT_QUOTES, 'UTF-8');
            $toggleStyle  = $hasChildren ? '' : 'style="display:none"';
            $liClass      = $hasChildren ? 'has-children' : '';
            $isLastParent = !empty($children) && !array_filter($children, fn($c) => !empty($c['children']));

            $chk = $hasChildren ? '<input type="checkbox" class="chk-gens-root">' : '<input type="checkbox" value="' . $label . '">';

            $list .= <<<HTML
                        <li class="$liClass">
                            <div class="js-node css-node" data-value="$label">
                                <span class="toggle" $toggleStyle></span>
                                $chk
                                <span class="js-label css-label">$label</span>
                            </div>
                     HTML;

            if ($hasChildren) {
                $list .= $this -> renderTree($children);
            }

            $list .= '</li>';
        }

        $list .= '</ul>';

        //  Само ако е ROOT – добавяме search + actions
        if (!$isRoot) {
            return $list;
        }

        return <<<HTML
                    <div class="mb-2">
                        <input id="treeSearch" class="css-input-p css-focus-strong css-border-none" type="text" placeholder="Търси по gensoft група…">
                    </div>
        
                    $list

                    <div class="actions mb-2 w-20 text-center row justify-content-center">
                        <button id="getSelected" class="round-10 bg-primary" data-route="$route_filter" type="button">Филтрирай</button>
                        <button id="reset" class="round-10" data-route="$route_filter" type="button">Reset</button>
                    </div>
                HTML;
    }

    public function addCSS() {
        return [
            'css/lib/gensoft/gensoftGroups'
        ];
    }

    public function addJS() {
        return [
            'js/lib/Lib__treeCore'
        ];
    }

}
