<?php

namespace App\Libraries;

ini_set('max_execution_time', 0);
ini_set('memory_limit', '900M');

require_once APPPATH . 'ThirdParty/dompdf/autoload.inc.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class Pdf extends DOMPDF {

    // генериране на PDF
    // =================
    public function create($view, $oferName = 'pdf', $data = []) {

        $options = new Options();

        $options -> set('defaultMediaType', 'all');
        $options -> set('isFontSubsettingEnabled', true);
        $options -> set('isRemoteEnabled', TRUE);
        //$options -> set('debugKeepTemp', TRUE);
        //$options -> set('debugLayoutInline', TRUE);
        //$options -> set('debugLayout', TRUE);
        $options -> set('isHtml5ParserEnabled', true);
        $options -> set('isJavascriptEnabled', TRUE);
        $options -> set('isPhpEnabled', TRUE);
        $options -> set('fontHeightRatio', 1);
        $options -> set('defaultFont', 'OpenSans');
        $options -> set('dpi', 100);

        $dompdf = new Dompdf($options);

        $dompdf -> set_protocol(isset($_SERVER["HTTPS"]) ? "https://" : "http://");
        $dompdf -> set_host($_SERVER["SERVER_NAME"]);

        //$orientation = $data['chkLenght'] == 0 && $data['isZenova'] == 1 ? 'portrait' : 'portrait';

        if ($data['pageFormat']) {
            $dompdf -> setPaper('A4', $data['pageFormat']);
        } else {
            $dompdf -> setPaper('A4', 'portrait');
        }

        if (isset($data['isCatalog']) && $data['isCatalog'] ==1) {
            $css = '<style>' . file_get_contents(base_url() . '/assets/css/printPreview/printCatalog_dompdf.css') . '</style>';
        } else {
            $css = '<style>' . file_get_contents(base_url() . '/assets/css/printPreview/dompdf.css') . '</style>';
            // $css .= '<style>' . file_get_contents('https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css') . '</style>';
        }


        $js = '	<script type="text/php">
                if ( isset($pdf) ) {
                        $x = 500;
                        $y = 810;
                        $text = "Page {PAGE_NUM} - {PAGE_COUNT}";
                        $font = $fontMetrics->get_font("Arial", "bold");
                        $size = 10;
                        $color = array(0,0,0);
                        $word_space = 0.0;  //  default
                        $char_space = 0.0;  //  default
                        $angle = 0.0;   //  default
                        $pdf->page_text($x, $y, $text, $font, $size, $color, $word_space, $char_space, $angle);
                }
  
	</script>';

        //~<body[^>]*>(.*?)</body>~si'
        //'{<div\s+id="wrapper"\s*>((?:(?:(?!<div[^>]*>|</div>).)++|<div[^>]*>(?1)</div>)*)</div>}si' 
        // започване от този div таг
        if (preg_match('{<div\s+id="printArea"\s*>((?:(?:(?!<div[^>]*>|</div>).)++|<div[^>]*>(?1)</div>)*)</div>}si', $view, $body)) {
            // $body[1] = str_replace("trShow_dostavchik no-print", "", $body[1]);
            //$dompdf -> loadHtml($css . $body[1] . $js);
        }

        $dompdf -> loadHtml($css . $view . $js, 'UTF-8');
        $dompdf -> render();
        $dompdf -> stream($oferName, array("Attachment" => false));

        exit(0);

        //header('Content-Type: application/octet-stream; charset=utf-8');
    }

    // изпращане на PDF до групата emails
    // ======================================
    public function sendPdf_toMail($dompdf, $oferName, $mesage, $arr_mails = [], $single_mail = '') {
        $output = $dompdf -> output();

        $file_to_save = $_SERVER['DOCUMENT_ROOT'] . '/' . $oferName . '_' . rand(0, 999) . '.pdf';
        file_put_contents($file_to_save, $output);
        $file         = $file_to_save;
        $filename     = $oferName . '.pdf';

        $from_name = 'bravas.bg';
        $from_mail = 'sales@bravas.bg';
        $replyto   = 'Reply-To: dimitrova@bravas.bg,n.nikovski@bravas.bg,r.radev@bravas.bg,vasil_atanasov@abv.bg,sales@bravas.bg,s.dimitrov@bravas.bg,r_radev@bravas.bg' . '\r\n';
        $uid       = md5(uniqid(time()));

        $header = "MIME-Version: 1.0\r\n";
        $header .= "Content-Type: multipart/mixed; boundary=\"" . $uid . "\"\r\n";
        $header .= "From: " . $from_name . " <" . $from_mail . ">\r\n";
        $header .= "Reply-To: " . $replyto . "\r\n";
        $header .= "X-Priority: 3\r\n";
        $header .= "X-Mailer: PHP" . phpversion() . "\r\n";

        $file_size       = filesize($file);
        $filetype        = filetype($file);
        $handle          = fopen($file, "r");
        $content         = fread($handle, $file_size);
        fclose($handle);
        //Clear cache and check filesize again
        clearstatcache();
        $encoded_content = chunk_split(base64_encode($content));

        $o = "--" . $uid . "\r\n";
        $o .= "Content-Type: {$filetype}; " . " name=\"{$filename}\"\r\n";
        $o .= "Content-Transfer-Encoding: base64\r\n";
        $o .= "Content-Disposition: attachment;" . " filename=\"" . $this -> filename_to_UTF8($filename) . "\";\r\n";
        $o .= "X-Attachment-Id: " . rand(1000, 99999) . "\r\n\r\n";
        $o .= $encoded_content;
        $o .= "--" . $uid . "\r\n";
        $o .= "Content-type: text/html; charset=\"utf-8\"\r\n";
        $o .= "Content-Transfer-Encoding: 8bit\r\n\r\n";

        // проверка дали полето или група за майл от .alertable са празни или пълни
        if ($single_mail != '' && $arr_mails != []) {
            $to = implode(',', array_merge($arr_mails, explode(",", $single_mail)));
        } elseif ($single_mail != '') {
            $to = implode(',', explode(",", $single_mail));
        } elseif ($arr_mails != []) {
            $to = implode(',', $arr_mails);
        }

        $to = preg_replace('/,,/', ',', $to);

        $oferName = '=?UTF-8?B?' . base64_encode($oferName) . '?=';
        $process  = explode(",", $to);
        foreach ($process as $to1) {
            mail($to1, $oferName, $o . $mesage, $header);
        }

        unlink($file_to_save);
        return json_encode(['sended' => $to, 'sucses' => 1]);
    }

    // преобразува български имена в латиница
    // ======================================
    function filename_to_UTF8($filename) {
        $table = array(
            'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ж' => 'ZH', 'З' => 'Z', 'И' => 'I', 'Й' => 'J', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O', 'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'H', 'Ц' => 'C', 'Ч' => 'CH', 'Ш' => 'SH', 'Щ' => 'SHT', 'Ь' => '-', 'Ъ' => 'A', 'Ю' => 'IU', 'Я' => 'IA', 'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ж' => 'zh', 'з' => 'z', 'и' => 'i', 'й' => 'j', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o', 'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'c', 'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sht', 'ь' => '-', 'ъ' => 'a', 'ю' => 'iu', 'я' => 'ia', '<' => '', '>' => '', '?' => '', '/' => '', '!' => '', '@' => '', '№' => '', '$' => '', '%' => '', '€' => '', '§' => '', '*' => '', '(' => '', ')' => '', '+' => '', '~' => '', '[' => '', ']' => '', ',' => '', '/' => ''
        );

        $filename = strtr($filename, $table);
        $filename = strtolower(preg_replace('/[\s]+/', '_', $filename));

        return $filename;
    }

}
