<?php

namespace App\Models;

use DateTime;
use DateTimeZone;
use Config\Services;
use \App\Models\BaseModel as BaseModel;

class MODEL__gensoft extends BaseModel {

    /** @var \App\Libraries\Gensoft\LIB__FirebirdConnection $fb */
    protected static $fb;
    protected static $settings;

    public function __construct() {
        parent::__construct();
        helper('utils');

        // Инициализираме service веднъж (глобално за модела)
        if (!self::$fb) {
            self::$fb = service('firebirdConnection');
        }

        // Зареждаме настройките (readonly)
        if (!self::$settings) {
            self::$settings = (object) (service('settings') -> get('App.gensoft') ?? []);
        }
    }

    // последна продажна цена от gensoft за клиент
    function get_lastPrice($data = []) {
        $settings = self::$settings; // настройки
        $fb       = self::$fb; // Firebird service

        $host  = $settings -> gensoftSrv ?? ''; // път до базата данни SKLAD.GDB
        $host2 = $settings -> gensoftSrv2 ?? '';

        $ip = h_extractIp($host);

        $isBravas = $data['isBravas'];

        // проверка дали Gensoft сървъра е достъпен
        if (!$fb -> isReachable($ip) || empty($host)) {
            return;
        }
        $dbh         = $fb -> connect($isBravas ? $host2 : $host);
        $productName = h_CP1251($data['stoka']);
        $firmaName   = h_CP1251(trim($data['firmaName']));

        $stmt = "SELECT  
                    IIF( P.VALUTA = 'L', 
                        (IIF(P.DDS > 0, P.CENA / 1.20, P.CENA) / NULLIF(P.kolich, 0) ) / 1.95583,
                        (IIF(P.DDS > 0, P.CENA / 1.20, P.CENA) / NULLIF(P.kolich, 0))
                    ) AS POSLEDNA_CENA, 
                    P.STOKA, 
                    R.FIRMA,
                    R.DT_CHANGED
                  FROM PRODAWA R
                  JOIN PRODAWA_ITEMS P ON P.DATETIME = R.DATETIME
                  
                  WHERE 
                    R.FIRMA = '$firmaName'
                    AND P.STOKA = '$productName'
                    AND P.kolich > 0
                ORDER BY  R.DT_CHANGED DESC ROWS 1;";
        $sth  = ibase_query($dbh, $stmt);
        $row  = ibase_fetch_object($sth);

        if (!empty($row -> POSLEDNA_CENA)) {
            return sprintf('%0.2f', $row -> POSLEDNA_CENA);
        }

        $skladName = $isBravas ? $_ENV['app.sklad4'] : $_ENV['app.baseSklad'];
        return ['err' => "Липсва последна продажна цена от Gensoft $skladName!"];
    }

    function get__kasiBanki() {
        $settings = self::$settings; // настройки
        $fb       = self::$fb; // Firebird service

        $host  = $settings -> gensoftSrv ?? ''; // път до базата данни SKLAD.GDB
        $host2 = $settings -> gensoftSrv2 ?? '';
        $a     = [];

        $ip = h_extractIp($host);

        // проверка дали Gensoft сървъра е достъпен
        if (!$fb -> isReachable($ip) || empty($host)) {
            return;
        }

        foreach ([$host, $host2] as $k => $host) {
            if (!empty($host)) {
                $dbh = $fb -> connect($host);

                $stmt = "SELECT KB_ID,KB_TIP, KB_NAME FROM KASI_BANKI where IS_ACTIVE = 'Y'";
                $sth  = ibase_query($dbh, $stmt);

                while ($row = ibase_fetch_object($sth)) {

                    $a[$k][] = [
                        'kb_id'   => $row -> KB_ID,
                        'kb_tip'  => $row -> KB_TIP,
                        'kb_name' => h_UTF8($row -> KB_NAME),
                    ];
                }
            }
        }

        return $a;
    }

    function get__kontragents() {
        $settings = self::$settings; // настройки
        $fb       = self::$fb; // Firebird service

        $host = $settings -> gensoftSrv ?? ''; // път до базата данни SKLAD.GDB

        $ip = h_extractIp($host);

        // проверка дали Gensoft сървъра е достъпен
        if (!$fb -> isReachable($ip) || empty($host)) {
            return;
        }

        $dbh = $fb -> connect($host);

        $query = "SELECT 1 FROM RDB\$RELATION_FIELDS WHERE RDB\$RELATION_NAME = UPPER('FIRMI')  AND RDB\$FIELD_NAME = UPPER('ID_FIRMA')";

        $result = ibase_query($dbh, $query);
        $row0   = ibase_fetch_row($result);

        if (!$row0) {
            return;
        }

        $stmt = "SELECT AGENT, TIP, ID_FIRMA, FIRMA, MOL, TEL, CITY, ADDR, EMAIL, F_GRUPA, BULSTAT FROM FIRMI where TIP = 'P' or TIP = 'A'";

        $sth = ibase_query($dbh, $stmt);

        while ($row = ibase_fetch_object($sth)) {

            $a[] = [
                'tip'         => $row -> TIP,
                'klient_name' => h_UTF8($row -> FIRMA),
                'klient_id'   => $row -> ID_FIRMA
            ];
        }
        //dd($a);
        return $a ?? [];

//        return $this -> db -> table(self::TBL_KLIENT)
//                        -> select('klient_id, klient_name')
//                        -> where('tip', 'A')
//                        -> get() -> getResultArray();
    }

    // изв на складовете в които го има продукта в поръчка таблицата
    function get__info_products($products = []) {
        $settings = self::$settings; // настройки
        $fb       = self::$fb; // Firebird service

        $ip = h_extractIp($settings -> gensoftSrv);

        // проверка дали Gensoft сървъра е достъпен
        if (!$fb -> isReachable($ip)) {
            return $products;
        }

//        $sklad1 = $_ENV['app.baseSklad'];
//        $sklad2 = $_ENV['app.sklad2'];
//        $sklad3 = $_ENV['app.sklad3'];
//        $sklad4 = $_ENV['app.sklad4'];

        $primarySklad = array_filter([
            $_ENV['app.baseSklad'] ?? null,
            $_ENV['app.sklad2'] ?? null,
            $_ENV['app.sklad3'] ?? null
                ]
        );

        $secondSklad = array_filter([
            $_ENV['app.sklad4'] ?? null
                ]
        );

        $valuesToCheck = array_merge($primarySklad, $secondSklad);
        $json          = [];

        for ($i = 0; $i <= 1; $i++) {
            $currentHost  = ($i === 0) ? ($settings -> gensoftSrv ?? '') : ($settings -> gensoftSrv2 ?? '');
            $currentSklad = ($i === 0) ? $primarySklad : $secondSklad;

            if (empty($currentHost)) {
                continue;
            }

            $dbh = $fb -> connect($currentHost);

            $productArr = array_column($products, null, 'gensoft_item_id');

            $searchSklad_arr = [];
            foreach ($currentSklad as $sklad) {
                $searchSklad_arr[] = h_CP1251N($sklad);
            }

            $skladInClause = implode(',', $searchSklad_arr);

            $stokaInClause = implode(',', array_map(function ($value) {
                        return h_CP1251N($value);
                    }, array_filter(array_column($products, 'gensoft_productName'))));

            if (empty($stokaInClause)) {
                return $products;
            }

            //$skladInClause = implode(',', $searchSklad_arr);

            $stmt = "SELECT d.ITEM_ID, d.RAZFAS1, s.STOKA, s.SKLAD, s.KOLICH, CASE WHEN s.KOLICH_LOCKED <> '0' THEN s.KOLICH_LOCKED END AS KOLICH_LOCKED FROM STOKI s
LEFT JOIN STOKI_DEF d ON (d.STOKA = s.STOKA AND d.GRUPA = s.GRUPA)
where s.STOKA IN($stokaInClause) AND s.SKLAD IN ($skladInClause)";

            $sth = ibase_query($dbh, $stmt);

            while ($row = ibase_fetch_object($sth)) {
                $json[] = [
                    'ITEM_ID'       => $row -> ITEM_ID,
                    'RAZFAS1'       => h_UTF8($row -> RAZFAS1),
                    'STOKA'         => h_UTF8($row -> STOKA),
                    'SKLAD'         => h_UTF8($row -> SKLAD),
                    'KOLICH_LOCKED' => h_UTF8($row -> KOLICH_LOCKED ?? 0),
                    'KOLICH'        => $row -> KOLICH ?? 0
                ];
            }
            ibase_free_result($sth);
            ibase_close($dbh);
        }

        foreach ($productArr as &$row) {
            $itemId              = $row['gensoft_item_id'];
            $gensoft_productName = $row['gensoft_productName'];

            $jsonEncoded = [];
            foreach ($json as $row2) {
                if ($row2['ITEM_ID'] == $itemId || $row2['STOKA'] == $gensoft_productName) {
                    $jsonEncoded[] = $row2;
                }
            }

            // проверка дали склада присъства, ако не се добавя липсващият без данни за него
            foreach ($valuesToCheck as $val) {
                if (!isset(array_column($jsonEncoded, null, 'SKLAD')[$val])) {
                    // Add missing item to jsonEncoded array
                    $jsonEncoded[] = [
                        'KOLICH_LOCKED' => 0,
                        'KOLICH'        => 0,
                        'RAZFAS1'       => '',
                        'SKLAD'         => $val,
                    ];
                }
            }

            // Sort jsonEncoded array by SKLAD
            usort($jsonEncoded, function ($a, $b) {
                return strcmp($b['SKLAD'], $a['SKLAD']);
            });

            // показва в Gensoft кои в складове, колко бройки има
            $row['gensoft_inSkladJson'] = json_encode($jsonEncoded, JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK);
        }

        return $productArr;
    }

    // изв на складовете само за един продукт кого кликнем на бутона info
    function get__info_forSingleProduct($productName = '') {
        $settings = self::$settings; // настройки
        $fb       = self::$fb; // Firebird service

        $ip = h_extractIp($settings -> gensoftSrv);

        $sklad1 = $_ENV['app.baseSklad'];
        $sklad2 = $_ENV['app.sklad2'];
        $sklad3 = $_ENV['app.sklad3'];
        $sklad4 = $_ENV['app.sklad4'];

        $sklads = [$sklad1, $sklad2, $sklad3, $sklad4];

        $a            = [];
        $kolich_total = 0;

        // проверка дали Gensoft сървъра е достъпен
        if (!$fb -> isReachable($ip)) {
            http_response_code(500);

            echo json_encode([
                'message' => 'Връзката с Gensoft сървър неможе да се осъществи!',
            ]);
        }

        foreach ($sklads as $sklad) {
            if (!empty($sklad)) {
                $valuesToCheck[] = $sklad;
            }
        }

        $productData = $this -> db -> table(self::TBL_PRODUCT)
                        -> where('gensoft_productName', $productName)
                        -> get() -> getRowArray();

        $gensoft_json = json_decode($productData['gensoft_json'], true) ?? [];
        $barcod       = $productData['gensoft_item_id'] ?? '';

        for ($i = 0; $i <= 1; $i++) {
            $host = $i === 1 ? $settings -> gensoftSrv2 : $settings -> gensoftSrv;

            // връзка с fb
            $dbh = $fb -> connect($host);

            $searchSklad_arr = [];
            foreach (($i == 1 ? [$sklad4] : [$sklad1, $sklad2, $sklad3]) as $sklad) {
                if (!empty($sklad)) {
                    $searchSklad_arr[] = h_CP1251N($sklad);
                    //$searchSklad_arr[] = $sklad;
                }
            }

            $skladInClause = implode(',', $searchSklad_arr);

            $r = h_CP1251N($productName);
            //$r = $productName;

            $stmt = "SELECT d.ITEM_ID, d.RAZFAS1, s.STOKA, s.SKLAD, s.KOLICH, CASE WHEN s.KOLICH_LOCKED <> '0' THEN s.KOLICH_LOCKED END AS KOLICH_LOCKED FROM STOKI s
LEFT JOIN STOKI_DEF d ON (d.STOKA = s.STOKA AND d.GRUPA = s.GRUPA)
where d.BARCODE = '" . $barcod . "' AND s.SKLAD IN ($skladInClause)";

            $sth = ibase_query($dbh, $stmt) or die(ibase_errmsg());
            //$a   = [];

            while ($row = ibase_fetch_object($sth)) {

                $kolich_total = $row -> KOLICH;

                $a[] = [
                    'ITEM_ID'       => $row -> ITEM_ID,
                    'RAZFAS1'       => h_UTF8($row -> RAZFAS1),
                    'STOKA'         => h_UTF8($row -> STOKA),
                    'SKLAD'         => h_UTF8($row -> SKLAD),
                    'KOLICH_LOCKED' => h_UTF8($row -> KOLICH_LOCKED ?? 0),
                    'KOLICH'        => $row -> KOLICH ?? 0,
                    'KOLICH_TOTAL'  => $kolich_total
                ];
            }


            ibase_free_result($sth);
            ibase_close($dbh);
        }


        // проверка дали склада присъства ако не се добавя липсващият без данни за него
        foreach ($valuesToCheck as $val) {
            if (!isset(array_column($a, null, 'SKLAD')[$val])) {
                // Add missing item to jsonEncoded array
                $a[] = [
                    'KOLICH_LOCKED' => 0,
                    'KOLICH'        => 0,
                    'RAZFAS1'       => '',
                    'SKLAD'         => $val,
                ];
            }
        }

        // Sort jsonEncoded array by SKLAD
        usort($a, function ($a, $b) {
            return strcmp($b['SKLAD'], $a['SKLAD']);
        });

        return $a;
    }

    // преобразуване на поръчка в gensoft поръчка
    function convert_in_order($data = [], $order = []) {
        $settings = self::$settings; // настройки
        $fb       = self::$fb; // Firebird service

        if (!$order) {
            return ['err' => 'Липсва обект поръчка ($order).'];
        }

        $host  = $settings -> gensoftSrv ?? ''; // път до базата данни SKLAD.GDB
        $host2 = $settings -> gensoftSrv2 ?? '';

        if ($host === '') {
            return ['err' => 'Липсва настройка Gensoft път до главната база данни.'];
        }

        $ip = h_extractIp($host);

        // проверка дали Gensoft сървъра е достъпен
        if (!$fb -> isReachable($ip)) {
            return ['err' => '❌ Връзката с Gensoft сървър неможе да се осъществи!'];
        }

        $sklad1 = $_ENV['app.baseSklad'] ?? '';
        $sklad4 = $_ENV['app.sklad4'] ?? '';

        if ($sklad1 === '') {
            return ['err' => 'Липсва app.baseSklad в ENV.'];
        }

        // каса - банки
        $kasaB1 = $settings -> kasaBanki[1] ?? null; // за валперс
        $kasaB2 = $settings -> kasaBanki[2] ?? null; // за бравас

        if (!is_array($kasaB1) || !is_array($kasaB2)) {
            return ['err' => 'Няма валидна настройка за Gensoft каси и банки.'];
        }

        $skladName   = $data['isSingleProduct'] ?? false ? $data['skladName'] : $_ENV['app.baseSklad'];
        $konsignacia = $data['order']['payment_method'] ?? ''; // Метод на плащане: по банка

        $konsignacia = match ($konsignacia) {
            'B', 'D' => 'D',
            'N', 'E' => 'E',
            default => 'NULL'
        };

        $baseSklad     = '';
        $bravasSklad   = '';
        $casheProdData = [];
        $i             = 1;

        $order_product_json = json_decode($order -> product_json ?? '[]', true);

        // проверявва дали присъства даденият продукт в избрания склад(ръчно)
        if (!empty($data['isSingleProduct'])) {

            $db = $fb -> connect($skladName == $sklad4 ? $host2 : $host);

            $itemName        = $data['order']['products'][0]['gensoft_productName'] ?? null;
            $skladNameEncode = h_CP1251N($skladName);

            if (!$itemName) {
                return ['err' => 'Не е предоставен валиден ID на продукт'];
            }

            $itemName = h_CP1251N($itemName);

            $sql   = "select STOKA from STOKI WHERE STOKA = $itemName AND SKLAD = $skladNameEncode";
            $query = ibase_query($db, $sql);
            ibase_close($db);

            if (empty(ibase_fetch_row($query))) {
                return ['err' => 'Този продукт не присъства в избраният склад'];
            }
        }

        // обработка за всеки продукт
        foreach ($data['order']['products'] as $row) {
            $gensoft_json     = json_decode($row['gensoft_json'] ?? '[]', true);
            $orderProductData = $order_product_json[$row['product_id']] ?? [];
            $qty              = $orderProductData['qty'] ?? 0;
            $price            = $orderProductData['price'] ?? 0;

            if (empty($row['gensoft_item_id'])) {
                continue;
            }

            if (empty($gensoft_json)) {
                return ['err' => "Този продукт {$row['gensoft_productName']} няма валидна gensoft информация в базата данни."];
            }

            if (empty($gensoft_json['grupa'])) {
                return ['err' => "Този продукт {$row['gensoft_productName']} няма gensoft група."];
            }

            // Добавя в склад ако има само номенклатура
            if (isset($gensoft_json['noData'])) {
                $db = $fb -> connect($host);

                // Подготвяне и екраниране на входните стойности
                $grupa = h_CP1251($gensoft_json['grupa']);
                $sklad = h_CP1251($gensoft_json['sklad']);
                $stoka = h_CP1251($row['gensoft_productName']);

                $trans = ibase_trans($db, IBASE_DEFAULT);
                $sql   = "INSERT INTO STOKI(GRUPA, STOKA, SKLAD) VALUES ('$grupa', '$stoka', '$sklad')";
                $query = ibase_query($trans, $sql);
                ibase_commit($trans);
                ibase_close($db);
            }

            // Проверка дали продукта е в базовия склад
            $db            = $fb -> connect($host);
            $stoka         = h_CP1251($row['gensoft_productName']);
            $baseSkladName = h_CP1251($sklad1);
            $grupa         = h_CP1251($gensoft_json['grupa']);

            $sql   = "select STOKA from STOKI WHERE STOKA = '$stoka' AND SKLAD = '$baseSkladName'";
            $query = ibase_query($db, $sql);

            if (empty(ibase_fetch_row($query))) {
                $trans = ibase_trans($db, IBASE_DEFAULT);
                $sql   = "INSERT INTO STOKI(GRUPA, STOKA, SKLAD) VALUES ('$grupa', '$stoka', '$baseSkladName')";

                ibase_query($trans, $sql);
                ibase_commit($trans);
            }
            ibase_close($db);
            //////////////////////////////////////////////////////
            // Прилага ДДС
            if ($price > 0) {
                // Add 20% to the price
                $price += $price * ($data['order']['dds'] / 100);
            }
            // ако е създ авт поръчка се проверява дали е bravas и дали е авт режим
            $skladNameEncode = (empty($data['isSingleProduct']) && isset($gensoft_json['isBravas']) ) ? $_ENV['app.sklad4'] : $skladName;

            //(kbId=2) D - разсрочено, B - банков път // кешово (kbId=3) Е - разсрочено, N - в брой
            $kbId = match ($konsignacia) {
                'B', 'D' => $skladNameEncode == $sklad4 ? $kasaB2['B'] : $kasaB1['B'],
                'N', 'E' => $skladNameEncode == $sklad4 ? $kasaB2['K'] : $kasaB1['K'],
                default => 'NULL'
            };

            // ако няма каси и банйки настроени
            if (empty($kbId)) {
                return ['err' => "Няма валидна gensoft информация каси и банки."];
            }

            // Структурира запис за Gensoft
            $a = [
                'DATETIME'    => 'replace',
                'STOKA'       => h_CP1251N($row['gensoft_productName']),
                'GRUPA'       => h_CP1251N($gensoft_json['grupa'] ?? ' '),
                'SKLAD'       => h_CP1251N($skladNameEncode),
                'KOLICH'      => $qty,
                'CENA'        => $price * $qty,
                'NUM'         => $i . '_num',
                'DDS'         => $data['order']['dds'],
                'KONSIGNACIA' => h_CP1251N($konsignacia),
                //'KONSIGNACIA' => $konsignacia,
                'VALUTA'      => "'M'",
                'KB_ID'       => $kbId,
                'SER_NO'      => h_CP1251N(' '),
                'CENA_LIST'   => h_CP1251N('Цени на едро'),
                'ENDDATE'     => "'" . date('m-d-Y H:i', strtotime('+7 days')) . "'",
            ];

            $keys         = implode(', ', array_keys($a));
            $placeholders = implode(', ', array_values($a));

            // Assign the record to the appropriate array
            if ((empty($data['isSingleProduct']) && isset($gensoft_json['isBravas']) ) || $skladName == $sklad4) {
                $bravasSklad .= "INSERT INTO S_ORDER_ITEMS($keys) VALUES ($placeholders);
";

                $casheProdData[$row['product_id']] = ['inGensoftSklad' => $skladNameEncode, 'gensoftSmetka' => 'r2'];
            } else {
                $baseSklad .= "INSERT INTO S_ORDER_ITEMS($keys) VALUES ($placeholders);
";

                $casheProdData[$row['product_id']] = ['inGensoftSklad' => $skladNameEncode, 'gensoftSmetka' => 'r'];
            }

            $i++;
        }

        // Execute inserts for base and bravas
        if (!empty($baseSklad)) {
            $dbh = $fb -> connect($host);

            //$isTrigerExist = $this -> triggerExists($dbh, ['firmi' => 'FIRMI_BI0']);
            $response = $this -> executeBulkInsert($dbh, $baseSklad, $order, $data, $settings, $skladName, $isBase   = true);

            if (empty($data['isSingleProduct'])) {
                foreach ($casheProdData as &$item) {
                    if ($item['gensoftSmetka'] == 'r') {
                        $item['gensoftSmetka'] = $response['smetka'];
                    }
                }
            }
            ibase_close($dbh);
        }

        if (!empty($bravasSklad)) {
            $dbh = $fb -> connect($host2);

            $response = $this -> executeBulkInsert($dbh, $bravasSklad, $order, $data, $settings, $skladName, $isBase   = false);

            if (empty($data['isSingleProduct'])) {
                foreach ($casheProdData as &$item) {
                    if ($item['gensoftSmetka'] == 'r2') {
                        $item['gensoftSmetka'] = $response['smetka'];
                    }
                }
            }
            ibase_close($dbh);
        }

        return empty($data['isSingleProduct']) ? ['casheProdData' => $casheProdData, 'newOrder' => 1] : ($response ?? []);
    }

    // Function to execute bulk insert if data exists.
    private function executeBulkInsert($dbh, $skladData, $order = [], $data = [], $settings = [], $skladName = '', $isBase = false) {
        //date_default_timezone_set('Europe/Sofia');

        if (!$dbh) {
            die("Failed to connect to the database: " . ibase_errmsg());
        }

        //// S_ORDER    /////////////////////////////////////////
        $query_maxSmetka   = ibase_query($dbh, 'select MAX(SMETKA) as MAXSMETKA from S_ORDER');
        $query_maxDateTime = ibase_query($dbh, 'select MAX(DATETIME)+1 as MAXDATETIME from S_ORDER');

        $maxDateTime = ibase_fetch_object($query_maxDateTime) -> MAXDATETIME;
        $maxSmetka   = str_pad(ibase_fetch_object($query_maxSmetka) -> MAXSMETKA + 1, 10, '0', STR_PAD_LEFT);

        // Декодиране на JSON стойности и избор на метод за доставка
        $delivery_json      = json_decode($order -> delivery_json ?? '[]', true);
        $tovaritelniza_json = json_decode($order -> tovaritelniza_json ?? '[]', true);
        $gensoftOrder_json  = json_decode($order -> gensoftOrder_json ?? '[]', true);
        $deliveryMetod      = $order -> delivery_method;
        $orderDatetime      = $isBase ? $gensoftOrder_json['datetime'] ?? null : $gensoftOrder_json['datetime2'] ?? null;
        $orderSmetka        = $isBase ? ($gensoftOrder_json['smetka'] ?? null) : ($gensoftOrder_json['smetka2'] ?? null);
        $whoPayBill         = $order -> whoPayBill ?? '';
        $prevozvach         = $order -> prevozvach ?? ''; // от локална поръчка
        $tavaritelnizaNo    = $order -> tavaritelniza_no ?? '';

        // Съставяне на бележка за контакт
        $belezka = ' ';

        // бележка
        if (!empty($order -> belezka_private)) {
            $belezka .= mb_strtoupper('Бележка: ' . $order -> belezka_private);
        }

        if (!empty($order -> invoice_tip)) {
            $belezka .= mb_strtoupper(' Док.: ' . $order -> invoice_tip);
        }

        // коментар от сайт
        if (!empty($order -> belezka)) {
            $belezka .= ' Коментар: ' . $order -> belezka;
        }

        if (!empty($tovaritelniza_json)) {
            $belezka .= ' Плащане: ';

            $belezka .= match ($tovaritelniza_json['payment']) {
                'za_smetkaPoluchatel' => 'За сметка на клиент.',
                'za_smetkaMe' => 'За сметка на продавач.',
                'za_smetkaShare' => 'Споделени разходи за доставка.',
                'za_smetkaCustom' => 'Споделени разходи м/у продавач и клиент.',
                default => ''
            };
        } elseif ($deliveryMetod == 'curier') {
            $belezka .= " За чия сметка: $whoPayBill";
        }

        if (!empty($delivery_json)) {
            $isEkont  = str_contains($delivery_json['izborKurier'] ?? '', 'econt');
            $isSpeedy = str_contains($delivery_json['izborKurier'] ?? '', 'speedy');

            //$belezka .= ' Данни за доставка: ';

            foreach ($delivery_json as $k => $row) {
                $belezka .= match ($k) {
                    'lice_zaKont' => ', лице за контакт:' . $row,
                    'tel' => ', тел.:' . $row,
                    'izborKurier' => $delivery_json['deliveryMetod'] == 'curier' ? (', Доставка с ' . ($isEkont ? 'Еконт' : ($isSpeedy ? 'Speedy' : ''))) : '',
                    'grad' => ', ' . $row,
                    'ofis' => ', офис:' . $row,
                    //'street' => ', улица:' . $row,
                    //'street_num' => ', №:' . $row,
                    default => ''
                };
            }
        }

        if (!empty($tavaritelnizaNo)) {
            $belezka .= " ТВ: $tavaritelnizaNo";
        }

        // Избор на превозвач
        $prevozName = match (true) {
            $deliveryMetod == 'curier' && str_contains($delivery_json['izborKurier'] ?? '', 'econt') => $settings -> prevoz['E'] ?? '',
            $deliveryMetod == 'curier' && str_contains($delivery_json['izborKurier'] ?? '', 'speedy') => $settings -> prevoz['S'] ?? '',
            $deliveryMetod == 'firmCar' => $settings -> prevoz['F'] ?? '',
            $deliveryMetod == 'selfCar' => $settings -> prevoz['ST'] ?? '',
            default => ' '
        };

        // ако е локална поръчка взимаме избрания превозвач
        if (!empty($prevozvach)) {
            $prevozName = $prevozvach;
        }

        // Подготовка на данни
        // надолу strtotime означ. увеличаване на текущата дата
        // $dtDoc    = strtotime("now", strtotime("+2 hours")) - strtotime('1984-06-16 -11 hours');

        $dtDoc    = h_dateToGenDT(new DateTime('now', new DateTimeZone('UTC')));
//$dtDoc = time() - 456328800;
        $firma    = h_CP1251($data['order']['klient'] ?? ' '); // клиент от оферта
        $propsKey = $isBase ? $settings -> props['key'] ?? '' : $settings -> props['key2'] ?? '';
        $propsVal = $isBase ? $settings -> props['val'] ?? '' : $settings -> props['val2'] ?? '';
        $props    = h_CP1251("|{$propsKey}—{$propsVal}|"); // default  |102--400|
        $agent    = h_CP1251($order -> agent ?? ' ');
        $prevoz   = h_CP1251($prevozName); // prevozva4
        $owner    = h_CP1251($data['order']['owner'] ?? ' '); // first_name  last_name текущ потребител от оферта
        $shipDate = !empty($order -> date_shipping) ? date('Y-m-d', strtotime($order -> date_shipping)) . ' ' . date('H:i') : ''; // дата на експедиция
// Съставяне на масив за S_ORDER

        $arr = [
            'DATETIME'  => $maxDateTime,
            'DT_DOC'    => $dtDoc,
            'SMETKA'    => $maxSmetka,
            'FIRMA'     => $firma,
            'PREWOZ'    => trim(substr($prevoz, 0, 48)),
            'AGENT'     => trim(substr($agent, 0, 48)),
            'OWNER'     => trim(substr($owner, 0, 48)),
            'PROPS'     => $props,
            'KASA'      => 'I',
            'SHIP_DATE' => $shipDate,
            'NOTE'      => !empty(trim($belezka)) ? trim(substr(h_CP1251N($belezka), 0, 254)) : ' ',
        ];

        $orderKeys   = implode(', ', array_keys($arr));
        $orderValues = array_values($arr);
        $orderPlace  = implode(', ', array_fill(0, count($arr), '?'));

// Стартираме транзакцията
        $trans = ibase_trans($dbh, IBASE_DEFAULT);

        if (!$trans) {
            return ['err' => 'Грешка: неможе да се инициализира транзакция'];
        }

        $sql = "INSERT INTO S_ORDER($orderKeys) VALUES($orderPlace)";

        $orderPrepare = ibase_prepare($trans, $sql);

// ако не съществува gensot поръчка
        if (empty($orderDatetime)) {
            ibase_execute($orderPrepare, ...$orderValues);
        }

        //=============================================================
        //// S_ORDER_ITEMS    /////////////////////////////////////////
        $datetime  = $orderDatetime ?? $maxDateTime ?? 1;
        $smetka    = $orderSmetka ?? $maxSmetka ?? 1;
        $skladData = str_replace('replace', $datetime, $skladData);

        // ако ръчно сме създали преди това продукт в gensoft поръчка
        if ($orderDatetime) {
            $sql_countProducts = "select count(DATETIME) as DATETIME from S_ORDER_ITEMS WHERE DATETIME={$datetime}";

            $query_countProducts = ibase_query($dbh, $sql_countProducts);
            $countProducts       = ibase_fetch_object($query_countProducts) -> DATETIME;
            $skladData           = preg_replace('/\d_num/', $countProducts + 1, $skladData);
            ibase_free_result($query_countProducts);
        }

        $skladData = str_replace('_num', '', $skladData);
        $sql2      = "EXECUTE BLOCK AS BEGIN $skladData END;";
        print_r($skladData);
        dd(1);
        ibase_query($trans, $sql2);
        ibase_commit($trans);

        if ($data['isSingleProduct']) {
            return [
                $isBase ? 'datetime' : 'datetime2'   => $datetime,
                $isBase ? 'skladName' : 'skladName2' => $skladName,
                $isBase ? 'smetka' : 'smetka2'       => $smetka,
            ];
        }

        return ['newOrder' => 1, 'smetka' => $smetka];
    }

}
