<?php

namespace App\Models;

use \App\Models\BaseModel as BaseModel;

class MODEL__offer_isOpen extends BaseModel {

    public function isCurentUser($oferId = null, $urlTab = null) {

        if (!$urlTab || !$oferId) {
            return;
        }

        $builder = $this -> db -> table(self::TABLES[$urlTab]);

        $idField = $this -> db -> fieldExists('order_id', self::TABLES[$urlTab]) ? 'order_id' : 'id';
        $offer   = $builder -> select("$idField, is_open, locked_by_userId")
                        -> where($idField, $oferId)
                        -> get() -> getRow();

        if ($offer && $offer -> is_open) {
            return $offer;
        }
    }

    // проверка за статуса на ценова листа дали се използва от потребител
    public function isOpenZenova($oferId = null) {
        $builder = $this -> db -> table(self::TABLES['zenova']);

        $offer = $builder -> select('id, is_open, locked_by_userId')
                        -> where('id', $oferId)
                        -> get() -> getRow();

        if ($offer && $offer -> is_open) {
            return $offer;
        }
    }

    // отключване на оферта
    public function unlockOffer($oferId = null, $urlTab = null) {
        $data = [
            'is_open'          => null,
            'locked_by_userId' => null,
            'last_activity'    => null
        ];

        $this -> db -> table(self::TABLES[$urlTab])
                -> where($urlTab == 'order' ? 'order_id' : 'id', $oferId)
                -> update($data);
    }

    // проверка за статуса на оферта дали се използва от потребител
    public function checkAndLockOffer($oferId = null, $urlTab = null, $logedUserId = null) {
        $builder = $this -> db -> table(self::TABLES[$urlTab]);

        $idField = $this -> db -> fieldExists('order_id', self::TABLES[$urlTab]) ? 'order_id' : 'id';
        $offer   = $builder -> select("$idField, is_open, locked_by_userId")
                        -> where($idField, $oferId)
                        -> get() -> getRow();

        if ($offer && $offer -> is_open) {
            return $offer;
        }

        // Lock the offer for the current user
        $data = [
            'is_open'          => 1,
            'locked_by_userId' => $logedUserId,
        ];

        $this -> db -> table(self::TABLES[$urlTab])
                -> where($idField, $oferId)
                -> update($data);

        return false;
    }

}
