<?php

namespace App\Models\common;

use \App\Models\BaseModel as BaseModel;

class MODEL__all_oferta extends BaseModel {

    // извл на офертата само
    function get__ofer_by_id($id = '', $arg = '') {

        $r = $this -> db -> table(self::TABLES[$arg] . ' o')
                        -> join(self::TBL_KLIENT . ' k', 'klient_id', 'left')
                        -> where('o.id', $id)
                        -> get() -> getRow();
        return $r;
    }

    // ИЗВЛИЧАНЕ НА продуктите в според офертата по ид
    function get__products_forOfer($id = '', $arg = '') {

        $sql = $this -> db -> table(self::TABLES[$arg] . ' as o')
                -> join(self::TBL_PRODUCT . ' p', ' FIND_IN_SET(p.product_id, o.productsID) > 0', 'inner')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' sp', 'product_id', 'left')
                -> join('(SELECT model_id,model FROM ' . self::TBL_MODEL . ' ) as pm', 'pm.model_id=p.model_id', 'left')
                -> join(self::TBL_BRAND . ' b', 'brand_id', 'left');

        if ($this -> db -> fieldExists('valuta_id', self::TABLES[$arg])) {
            $sql -> join(self::TBL_VALUTA . ' v', 'valuta_id', 'left');
        }

        $sql -> where('o.id', $id)
                -> groupBy('p.product_id')
                -> orderBy('FIND_IN_SET(p.product_id, o.productsID)');

        //dd();
        return $sql -> get() -> getResultArray();
    }

    // конвертиране на оферта в поръчка
    function convert_ofer($id, $oferName = '') {
        $cloneRow = $this -> db -> table(self::TBL_SPECIAL)
                        -> where('id', $id)
                        -> get() -> getRowArray();

        unset($cloneRow['id']);
        unset($cloneRow['colorRows']);
        unset($cloneRow['userName_modify']);
        unset($cloneRow['date_update']);
        unset($cloneRow['is_open']);
        unset($cloneRow['locked_by']);
        unset($cloneRow['shablon_id']);
        unset($cloneRow['label_price']);

        // автомат. генериране на фактура номер с префикс + дата + маx id
        $maxId         = $this -> db -> table(self::TBL_ORDER) -> select('id') -> countAllResults();
        $invoicePrefix = (object) service('settings') -> get('App.general');

        $cloneRow['order_invoice'] = $invoicePrefix -> invoice['pref'] . (date("dmy")) . ($maxId + 1);
        // ------------------------------------------------------------
        $cloneRow['offersName']    = $oferName;
        $cloneRow['date_create']   = date("d-m-Y H:i");

        $sql = $this -> db -> table(self::TBL_ORDER) -> insert($cloneRow);

        return ($sql == true) ? true : false;
    }

    // конвертиране на оферта в поръчка
    function clone_ofer($data = []) {
        if (!$data['id'] || !$data['tab'] || !array_key_exists($data['tab'], self::TABLES)) {
            return []; // Return empty array or default data when tab is not provided
        }

        try {
            $this -> db -> transBegin();

            $cloneRow = $this -> db -> table(self::TABLES[$data['tab']])
                            -> where('id', $data['id'])
                            -> get() -> getRow();

            // max custom id за принт офертата otdolu
            // проверка дали колона CustomNo съществува
            if ($this -> db -> fieldExists('customNo', self::TABLES[$data['tab']])) {
                $CustomNo = $this -> db -> table(self::TABLES[$data['tab']]) -> select('max(CustomNo) as customNo') -> get() -> getRow();

                $cloneRow -> customNo = $CustomNo -> customNo != '' ? $CustomNo -> customNo + 1 : '21501';
            }

            // Unset unnecessary fields
            $fieldsToUnset = ['id', 'userName_modify', 'date_update', 'is_open', 'locked_by'];
            foreach ($fieldsToUnset as $field) {
                unset($cloneRow -> $field);
            }

            $cloneRow -> userName_create = $data['userCreate'];
            $cloneRow -> offersName      = $data['oferName'];
            $cloneRow -> date_create     = date("d-m-Y");

            $sql = $this -> db -> table(self::TABLES[$data['tab']]) -> insert((array) $cloneRow);

            if (!$this -> db -> transStatus()) {
                $error     = $this -> db -> error();  // Get the error details
                $errorCode = $error['code'];

                if ($errorCode === 1062) {
                    $errorMessage = "Това име {$data['oferName']} вече съществува. Въведете друго име за клонирането.";
                } else {
                    $errorMessage = $error['message'];
                }

                $this -> db -> transRollback();
                return ['err' => $errorMessage];
            }
            $this -> db -> transComplete();
            return true;
        } catch (DatabaseException $e) {
            $this -> db -> transRollback();
            return $e -> getMessage();
        }
    }

    // запис на поръчка
    function save_order($id = null, $data = [], $arg = '') {

        if (!$id || !$arg || !array_key_exists($arg, self::TABLES)) {
            return []; // Return empty array or default data when tab is not provided
        }

        try {
            $this -> db -> transBegin();

            // обновяване/или нов запис на оферта
            $upsertData = $data[$arg] + ($data['autocomplete'] ?? []);

            if ($arg == 'bizKlient' && empty($upsertData['id'])) {

                // извл на max CustomNo за принт офертата 
                $CustomNo = $this -> db -> table(self::TABLES[$arg])
                                -> select('max(CustomNo) as CustomNo')
                                -> get() -> getRow() -> CustomNo;

                $upsertData['CustomNo'] = $CustomNo == '' ? '' : $CustomNo + 1;
            }


            $zavishenaZena_arr     = $upsertData['zavishena_zena'] ?? [];
            $deletedProductIds_arr = $upsertData['deletedProductArrId'] ?? [];

            unset($upsertData['zavishena_zena'], $upsertData['deletedProductArrId']);

            // Check for duplicate offersName
            $existingOffer = $this -> db -> table(self::TABLES[$arg])
                    -> select('id')
                    -> where('offersName', $upsertData['offersName'])
                    -> get()
                    -> getRow();

            if ($existingOffer && (!$id || $existingOffer -> id != $id)) {
                $this -> db -> transRollback();
                return ['err' => "Това име {$upsertData['offersName']} вече съществува. Въведете друго име."];
            }

            $oferta = $this -> db -> table(self::TABLES[$arg]) -> upsert($upsertData);

            // 1- ако е нов ред, 2- update, 0 -ако данните са същите
            $last_id = ($oferta === 1) ? $this -> db -> insertID() : null;

            if (!$this -> db -> transStatus()) {
                $errorMessage = $this -> db -> error()['message'];
                $this -> db -> transRollback();
                return ['err' => $errorMessage];
            }

            $this -> db -> transComplete();
            return $last_id ?? $id; // презарежда с нова или същест оферта
        } catch (DatabaseException $e) {
            $this -> db -> transRollback();
            return $e -> getMessage();
        }
    }

    // delete from mainPage
    function delete_oferta($urlParams = []) {
        $id       = $urlParams['id'] ?? null;
        $tab      = $urlParams['tab'] ?? null;
        $promoTip = $urlParams['promoTip'] ?? '';

        if (!$id || !$tab || !array_key_exists($tab, self::TABLES)) {
            return []; // Return empty array or default data when tab is not provided
        }

        try {
            $this -> db -> transBegin();

            $table = match ($tab) {
                'promo' => $promoTip == 'D' ? self::TBL_PROMO : self::TBL_PROMOKL,
                default => self::TABLES[$tab],
            };

            // Извличане на `productIds` за таб `promo`
            $productIds = ($tab === 'promo') ?
                    $this -> db -> table($table)
                            -> select('productsID')
                            -> where('id', $id)
                            -> get() -> getRow() -> productsID ?? null : null;

            $this -> db -> table($table)
                    -> where('id', $id)
                    -> delete();

            if ($tab === 'promo' && !empty($productIds)) {
                $productIdsArr = explode(',', $productIds);

                // когато продуктите не съществуват нито в една от таблиците
                $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL)
                        -> set($promoTip == 'D' ? 'is_promo' : 'is_promoKl', NULL)
                        -> whereIn('product_id', $productIdsArr)
                        -> update();
            }

            if (!$this -> db -> transComplete()) { // Commit or rollback automatically
                $errorMessage = $this -> db -> error()['message'];
                return ['err' => $errorMessage];
            }
        } catch (\Exception $e) {
            $this -> db -> transRollback();
            log_message('error', 'Transaction failed: ' . $e -> getMessage());
            return $e -> getMessage();
        }
    }

}
