<?php

namespace App\Models\common;

use \App\Models\BaseModel as BaseModel;

class MODEL__dropdown extends BaseModel {

    protected function __map($tip = '', $data = []) {
        $primaryId     = $data['primaryId'] ?? null;
        $modelId       = $data['firstModelId'] ?? null;
        $brandId       = $data['brandId'] ?? null;
        $name          = $data['name'] ?? null;
        $productId     = $data['productId'] ?? null;
        $productCharId = $data['var']['productCharId'] ?? null;
        $catCharId     = $data['var']['catCharId'] ?? null;

        $map = [
            'brand'          => [
                'tbl'           => self::TBL_BRAND,
                'col'           => 'brandTxt',
                'isGrouped'     => true,
                'prepareInsert' => ['brandTxt' => $name],
                'prepareUpdate' => [
                    'where' => ['brand_id' => $primaryId],
                    'set'   => ['brandTxt' => $name],
                ],
            ],
            'model'          => [
                'tbl'           => self::TBL_MODEL,
                'col'           => 'model',
                'filterBy'      => "brand_id = $brandId", // зависи от марката
                'isGrouped'     => true,
                'disableFK'     => true,
                'prepareInsert' => [
                    'brand_id'   => $brandId,
                    'product_id' => $productId,
                    'model'      => $name
                ],
                'prepareUpdate' => [
                    'where' => ['model_id' => $primaryId],
                    'set'   => ['model' => $name],
                ],
            ],
            'modelAddt'      => [
                'tbl'       => self::TBL_MODEL,
                'col'       => 'model',
                'filterBy'  => "brand_id = $brandId", // зависи от марката
                'isGrouped' => true,
                'notIn'     => "model_id <>$modelId",
                'link'      => true,
            ],
            'modelYear'      => [
                'tbl'           => self::TBL_MODEL_PROPERTY,
                'col'           => 'm_property_text',
                'filterBy'      => "model_id = $modelId AND m_property_key=1", // зависи от модела
                'isGrouped'     => true,
                'prepareInsert' => [
                    'model_id'        => $modelId,
                    'm_property_key'  => 1,
                    'm_property_text' => $name,
                ],
                'prepareUpdate' => [
                    'where' => ['model_property_id' => $primaryId],
                    'set'   => ['m_property_text' => $name],
                ],
            ],
            'modelKupe'      => [
                'tbl'           => self::TBL_MODEL_PROPERTY,
                'col'           => 'm_property_text',
                'filterBy'      => "model_id = $modelId AND m_property_key=2", // зависи от модела
                'isGrouped'     => true,
                'prepareInsert' => [
                    'model_id'        => $modelId,
                    'm_property_key'  => 2,
                    'm_property_text' => $name,
                ],
                'prepareUpdate' => [
                    'where' => ['model_property_id' => $primaryId],
                    'set'   => ['m_property_text' => $name],
                ],
            ],
            'prodCharValues' => [
                'tbl'               => self::TBL_PRODUCT_CHAR_VALUE,
                'col'               => 'product_characteristic_text',
                'isGrouped'         => true,
                'prepareInsert'     => [
                    'product_characteristic_value_id' => '',
                    'product_characteristic_text'     => $name,
                ],
                'prepareInsertLink' => [
                    'product_characteristic_id'  => $productCharId,
                    'product_id'                 => $productId,
                    'category_characteristic_id' => $catCharId
                ],
                'prepareUpdate'     => [
                    'where' => ['product_characteristic_value_id' => $primaryId],
                    'set'   => [' product_characteristic_text' => $name],
                ],
            ],
        ];

        return $map[$tip] ?? null;
    }

    public function loadDropdown(array $p): array {
        $tip    = $p['tip'] ?? '';
        $search = $p['search'] ?? '';

        $cfg = $this -> __map($tip, $p) ?? null;

        if (!$cfg || empty($cfg['tbl']) || empty($cfg['col'])) {
            return [];
        }

        $results = $this -> db -> table($cfg['tbl'])
                        -> when(!empty($cfg['filterBy']), fn($q) => $q
                                -> where($cfg['filterBy'])
                                -> where("{$cfg['col']} is not null")
                        )
                        -> when(!empty($cfg['notIn']), fn($q) => $q
                                -> where($cfg['notIn'])
                        )
                        -> when(!empty($search), fn($q) => $q -> like($cfg['col'], $search, 'both'))
                        -> when(!empty($cfg['isGrouped']), fn($q) => $q
                                -> groupBy($cfg['col'])
                                -> orderBy($cfg['col'], 'asc')
                        ) -> get() -> getResultArray();

        // ако има свързваща таблица за доп модели
        if (!empty($cfg['link'])) {
            $selectedIds = $this -> db -> table(self::TBL_PRODUCT_MODEL_ADDIT_LINK)
                            -> select('model_addit_id')
                            -> where('product_id', $p['productId'])
                            -> where('model_main_id', $p['firstModelId'])
                            -> get() -> getResultArray();

            $selectedIds = array_column($selectedIds, 'model_addit_id');

            foreach ($results as &$row) {
                $row['isChecked'] = in_array($row['model_id'], $selectedIds);
            }
        }

        return $results;
    }

    function insert_new($data = []) {
        $tip = $data['tip'] ?? null;

        $cfg               = $this -> __map($tip, $data) ?? null;
        $table             = $cfg['tbl'] ?? null;
        $col               = $cfg['col'] ?? null;
        $isDisableFk       = $cfg['disableFk'] ?? null;
        $prepareInsert     = $cfg['prepareInsert'] ?? [];
        $prepareInsertLink = $cfg['prepareInsertLink'] ?? [];

        if ($isDisableFk) {
            $this -> db -> query('SET FOREIGN_KEY_CHECKS=0;');
        }

        $this -> db -> transBegin();

        $this -> db -> table($table) -> upsert($prepareInsert);
        $lastId = $this -> db -> insertID();

        // Включване на проверката за чужди ключове
        if ($isDisableFk) {
            $this -> db -> query('SET FOREIGN_KEY_CHECKS=1;');
        }

        if ($tip == 'prodCharValues' && $lastId > 0) {
            $prepareInsertLink['product_characteristic_value_id'] = $lastId;

            $this -> db -> table(self::TBL_PRODUCT_CHARACTERISTIC) -> upsert($prepareInsertLink);
        }

        if (!$this -> db -> transStatus()) {
            $this -> db -> transRollback();
            return $this -> dbError();
        }

        $this -> db -> transComplete();
        return $lastId;
    }

    function update_item($post = []) {
        $cfg = $this -> __map($post['tip'], $post) ?? null;

        if (empty($cfg)) {
            return $this -> fail('Invalid configuration.');
        }

        $table = $cfg['tbl'] ?? null;
        $where = $cfg['prepareUpdate']['where'] ?? '';
        $set   = $cfg['prepareUpdate']['set'] ?? '';

        $this -> db -> transBegin();

        $query = $this -> db -> table($table)
                -> set($set)
                -> where($where)
                -> update();

        if (!$this -> db -> transStatus()) {
            $this -> db -> transRollback();
            return $this -> dbError();
        }

        $this -> db -> transComplete();
        return $query;
    }

    // мулти модели към главния модел
    function set_multipleModels($data = []) {
        $modelAdditIds = (array) ($data['modelAdditId'] ?? []);
        $productId     = (int) ($data['productId'] ?? 0);
        $mainModelId   = (int) ($data['firstModelId'] ?? 0);
        $isChecked     = (bool) ($data['isChecked'] ?? false);

        //$modelAdditIds = is_array($modelAdditIds) ? $modelAdditIds : [$modelAdditIds];
        $table = $this -> db -> table(self::TBL_PRODUCT_MODEL_ADDIT_LINK);
        $this -> db -> transStart();

        if ($isChecked) {
            // ✅ BULK INSERT IF NOT EXISTS

            $existing = $table -> select('model_addit_id')
                            -> where('product_id', $productId)
                            -> where('model_main_id', $mainModelId)
                            -> whereIn('model_addit_id', $modelAdditIds)
                            -> get() -> getResultArray();

            $existingIds = array_column($existing, 'model_addit_id');
            $newIds      = array_diff($modelAdditIds, $existingIds);

            if (!empty($newIds)) {
                $insertData = [];

                foreach ($newIds as $id) {
                    $insertData[] = [
                        'product_id'     => $productId,
                        'model_main_id'  => $mainModelId,
                        'model_addit_id' => $id,
                    ];
                }

                $table -> insertBatch($insertData);
            }
        } else {

            $table -> where('product_id', $productId)
                    -> where('model_main_id', $mainModelId)
                    -> whereIn('model_addit_id', $modelAdditIds)
                    -> delete();
        }

        return $this -> db -> transComplete();
    }

    function set_text_toProductAttribute($prodCharId = null, $params = []) {

        $productCharacteristic = [
            'product_characteristic_id'  => $params['productCharId'],
            'product_id'                 => $params['productId'],
            'category_characteristic_id' => $params['catCharId'],
        ];

        $builder = $this -> db -> table(self::TBL_PRODUCT_CHARACTERISTIC);

        $this -> db -> transStart();

        $existingValue = $builder -> select('product_characteristic_value_id')
                        -> where($productCharacteristic)
                        -> get() -> getRow('product_characteristic_value_id');

        if ($existingValue === null) {
            $builder -> insert($productCharacteristic + ['product_characteristic_value_id' => $prodCharId]);
        } elseif ($existingValue !== $prodCharId) {
            $builder -> where($productCharacteristic) -> update(['product_characteristic_value_id' => $prodCharId]);
        }

        $lastId = $this -> db -> insertID();

        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            return ['err' => 'Грешка при изпълнение на sql заявката.' . $this -> db -> error()['message']];
        }

        return $lastId;
    }

    function remove_productAttribute($prodCharId = null) {

        return $this -> db -> table(self::TBL_PRODUCT_CHARACTERISTIC)
                        -> where('product_characteristic_id', $prodCharId)
                        -> delete();
    }

    function delete_item($post = []) {
        $cfg = $this -> __map($post['tip'], $post) ?? null;

        if (empty($cfg)) {
            return $this -> fail('Invalid configuration.');
        }

        $table = $cfg['tbl'] ?? null;
        $where = $cfg['prepareUpdate']['where'] ?? '';

        $primaryId = $post['primaryId'];
        $tip       = $post['tip'];
        $name      = $post['name'];

        if (!$primaryId) {
            return ['err' => 'Липсва първичен ключ за този тип.'];
        }

        // --- зависимостите дали марката или модела имат деца ---
        $constraints = [
            'brand' => [self::TBL_MODEL, 'brand_id',
                'Преди да изтриете марката %s трябва да изтриете всички модели асоциирани към нея!'],
            'model' => [self::TBL_MODEL_PROPERTY, 'model_id',
                'Преди да изтриете модел %s трябва да изтриете всички атрибути асоциирани към него!'],
        ];

        // --- проверка за наследници ---
        if (isset($constraints[$tip])) {
            [$childTbl, $pK, $msg] = $constraints[$tip];

            $hasChildren = $this -> db -> table($childTbl)
                            -> select('1', false)
                            -> where($pK, $primaryId)
                            -> limit(1) -> countAllResults() > 0;

            if ($hasChildren) {
                return ['err' => sprintf($msg, $name)];
            }
        }

        $this -> db -> transBegin();

        $ok = $this -> db -> table($table)
                -> where($where)
                -> delete();

        if (!$this -> db -> transStatus()) {
            $this -> db -> transRollback();
            return $this -> dbError();
        }

        $this -> db -> transComplete();
        return (bool) $ok;
    }

}
