<?php

namespace App\Models\common;

use \App\Models\BaseModel as BaseModel;

class MODEL__klient extends BaseModel {

    function klient_autocomplete($text = '') {
        $gensoftCondition = $_ENV['app.gensoftEnable'] ? 'IS NOT NULL' : 'IS NULL';

        return $this -> db -> table(self::TBL_KLIENT)
                        -> like('klient_name', $text, 'both')
                        -> where('isActive', 'Y')
                        -> where("gensoft_firm_id $gensoftCondition")
                        -> get() -> getResultArray();
    }

    function klient_save($data = '') {
        $table = self::TBL_KLIENT;

        if (is_numeric($data['user']['klient_id'])) {

            $this -> db -> table($table)
                    -> set($data['user'])
                    -> where('klient_id', $data['user']['klient_id'])
                    -> update();
        } else {
            $found = $this -> db -> table($table)
                    -> where('klient_name', $data['user']['klient_name'])
                    -> countAllResults();

            if ($found == 0) {
                $data['user']['isActive'] = 'Y';

                $this -> db -> table($table) -> insert($data['user']);
                $lastId = $this -> db -> insertID();
            }
        }

        return $lastId ?? null;
    }

}
