<?php

namespace App\Models\printPreview;

use CodeIgniter\Model;
use \App\Models\BaseModel as BaseModel;

class MODEL__printPreview extends BaseModel {

    // извикване само на шаблон и листа
    public function get__ofer_byId($urlParams = []) {
        $id       = $urlParams['id'] ?? $urlParams['orderId'] ?? null;
        $ctrl     = $urlParams['tab'] ?? '';
        $promoTip = $urlParams['promoTip'] ?? '';

        if (!$id) {
            return [];
        }

        $table = match ($ctrl) {
            'promo' => $promoTip === 'D' ? self::TBL_PROMO : self::TBL_PROMOKL,
            'order' => isset($_REQUEST['orderTip']) && in_array($_REQUEST['orderTip'], ['site','L', 'K', 'F', 'N']) ? self::TBL_ORDER : self::TBL_ORDER_GENSOFT,
            default => self::TABLES[$ctrl]
        };

        $sql = $this -> db -> table($table . ' o');

        if ($this -> db -> fieldExists('shablon_id', $table)) {
            $sql -> join(self::TBL_SHABLON . ' sha', 'shablon_id', 'left');
        }

        if ($this -> db -> fieldExists('klient_id', $table)) {
            $sql -> join(self::TBL_KLIENT . ' k', 'klient_id', 'left');
        }

        $field = $this -> db -> fieldExists('order_id', $table) ? 'o.order_id' : 'o.id';
        $sql -> where($field, $id);

        return $sql -> get() -> getRow();
    }

    public function get__products_forOfer($urlParams = []) {

        $id       = $urlParams['id'] ?? '';
        $ctrl     = $urlParams['tab'] ?? '';
        $promoTip = $urlParams['promoTip'] ?? '';

        $table = match ($ctrl) {
            'promo' => $promoTip === 'D' ? self::TBL_PROMO : self::TBL_PROMOKL,
            default => self::TABLES[$ctrl]
        };

        //dd($urlParams);
        $sql = $this -> db -> table($table . ' o')
                -> join(self::TBL_PRODUCT . ' p', 'FIND_IN_SET(p.product_id, o.productsID) > 0', 'inner')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' sp', 'product_id', 'left')
                -> join(self::TBL_SP_MQRKA . ' m', 'sp_mqrka_id', 'left')
                -> join('(SELECT model_id,model FROM ' . self::TBL_MODEL . ' ) as pm', 'pm.model_id=p.model_id', 'left')
                -> join(self::TBL_BRAND . ' b', 'brand_id', 'left')
                -> join(self::TBL_CATEGORY . ' c', 'category_id', 'left');

        if ($this -> db -> fieldExists('shablon_id', $table)) {
            $sql -> join(self::TBL_SHABLON . ' sha', 'shablon_id', 'left');
        }

        if ($this -> db -> fieldExists('klient_id', $table)) {
            $sql -> join(self::TBL_KLIENT . ' k', 'klient_id', 'left');
        }

        $field = $this -> db -> fieldExists('order_id', $table) ? 'o.order_id' : 'o.id';
        $sql -> where($field, $id)
                -> orderBy('FIND_IN_SET(p.product_id, o.productsID)');

        //dd($sql -> get() -> getResultArray());
        return $sql -> get() -> getResultArray();
    }

    // изв на продуктите за поръчката
    function get__products_forOrder() {

        $table         = isset($_REQUEST['orderTip']) && in_array($_REQUEST['orderTip'], ['site','L', 'K', 'F', 'N']) ? self::TBL_ORDER : self::TBL_ORDER_GENSOFT;
//dd($table);
        $extractedKeys = $this -> db -> table($table)
                        -> select('JSON_KEYS(JSON_UNQUOTE(JSON_EXTRACT(product_json, "$"))) AS product_keys')
                        -> where('order_id', $_REQUEST['orderId'])
                        -> get() -> getFirstRow();

        $query2 = $this -> db -> table($table . ' as o');

        // извл на поръчката за клониране
        if (isset($_REQUEST['toSklad'])) {
            $query2 -> select('o.*,p.product_id, p.gensoft_json');
        }

        $productKeys = json_decode($extractedKeys -> product_keys ?? '[]', true);
        $productIds  = $productKeys ? implode(',', $productKeys) : '';

        $query2 -> join(self::TBL_PRODUCT . ' p', "FIND_IN_SET(p.product_id, '$productIds')", 'left')
                -> where('o.order_id', $_REQUEST['orderId']);

        return $query2 -> get() -> getResultArray();
    }

    public function get__all_nashiFirmi() {

        return $this -> db -> table(self::TBL_NASHIFIRMI)
                        -> get() -> getResultArray();
    }

}
