<?php
$request = \Config\Services::request();
$general = service('settings') -> get('App.general') ?? [];

/* --- Основни настройки ------------------------------------ */
$preval    = $general['preval'] ?? [];
$priceType = $general['zenoobr']['price_type'] ?? 'discount';
$currency  = $preval['base_currency'] ?? 'BGN';

/* --- Точност ------------------------------------------------- */
$_isRoundedToFirst = $ofer -> isRoundedToFirst ?? false;
$_priceAccuracy    = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

/* --- Цени -------------------------------------------------- */
$_pricesWithDds     = !empty($general['prices_with_dds']);
$_dealerPricesLabel = 'ДИЛЪРСКИ ЦЕНИ ' . ($_pricesWithDds ? '(С ДДС)' : '(БЕЗ ДДС)');

/* --- Валута ---------------------------------------------- */
$_default_valutaCode   = $currency;
$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

/* --- Ценови нива --------------------------------------------- */
$_priceLevels = [
    'cenaB'    => 'B',
    'cenaA'    => 'А',
    'cenaSpec' => 'Спец.',
    'cenaKKC'  => 'ККЦ',
];

// само когато НЕ е discount / gensoft
if (!in_array($priceType, ['discount', 'gensoft'], true)) {
    $_priceLevels['cenaKl'] = 'Кл.клиент';
}

$_labelValuta = "<div class='w-50 m-auto' style='background-color:#C61111;color:#fff!important;padding:1px 6px;border-radius:4px;font-size:0.85em;'> $_default_valutaCode </div>";

/* --- Мярка -------------------------------------------------- */
$_mqrka = isset($mqrka) ? array_column($mqrka, null, 'sp_mqrka_id') : [];
?>

<table id="tbl_products" class="table table-striped table-sm mt-3" cellspacing="0" width="100%">
    <thead  class="css-background">
        <tr style="background: #C61111;color: white;">
            <th class="p-1 fw-600" colspan="13">
                <span style="background: #C61111;"><?= $_dealerPricesLabel ?></span>
            </th>
        </tr>

        <tr class="css-bg-purple">
            <th colspan="2"></th> 

            <th>
                <input id="filter" class="pr-4 css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__global.placeholder.filter') ?>">
            </th>

            <th colspan="2"></th>   

            <th>
        <!--                <input id="allQty" type="text" maxlength="4" data-isNumeric>
                <i id="allQtyOk" class="cursor-pointer hide ml-n4 text-success fa fa-check"></i>-->
            </th>

            <th colspan="2"></th>

            <?php if ($priceType !== 'gensoft'): ?>
                <th>
                    <?php
                    $_route     = route_to('Promo-getPriceLevel');
                    $_priceNivo = "<div id='priceLevelAll' class='text-center' data-all='1'>
                                    <span>Ценово ниво за всички продукти</span>
                                    <br><br>";

                    foreach ($_priceLevels as $level => $label) {
                        $_priceNivo .= "<button class='css-btn-wp' type='button'
                                        data-level='{$level}'
                                        data-route='{$_route}'>
                                        {$label}
                                    </button>";
                    }
                    $_priceNivo .= "</div>";
                    ?>
                    <button class="css-btn-purple border-w-1 round-10 text-white btn btn-sm" type="button" data-toggle="tooltip" title="<?= $_priceNivo ?>">Ц. ниво</button>
                </th>  
            <?php endif; ?>

            <th colspan="4"></th>   
        </tr>

        <tr>
            <th class="w-2"></th> 
            <th class="w-6"></th>
            <th class="w-15"><?= lang('LANG__special.tbl.th.product') ?></th>
            <th class="w-10"><?= lang('LANG__special.tbl.th.model') ?></th>
            <th class="w-15"><?= lang('LANG__special.tbl.th.description') ?></th>

            <th class="w-5">Налич.</th>

            <?php if ($priceType != 'gensoft') : ?>
                <th class="w-5"><?= lang('LANG__special.tbl.th.qty') ?></th>

                <th class="w-5"><?= lang('LANG__special.tbl.th.nadz') ?></th>

                <th class="w-6">ККЦ
                    <?= $_labelValuta ?>
                </th>

                <th class="w-5"><?= lang('LANG__special.tbl.th.zenaDostavna') ?>
                    <?= $_labelValuta ?>
                </th>

                <th class="w-5"><?= lang('LANG__special.tbl.th.zenaTotal') ?>
                    <?= $_labelValuta ?>
                </th>

                <th class="w-4"><?= lang('LANG__special.tbl.th.img') ?></th>

            <?php else: ?>
                <th class="w-15"><?= lang('LANG__special.tbl.th.qty') ?></th>

                <th class="w-15"><?= lang('LANG__special.tbl.th.nadz') ?></th>

                <th class="w-15">ККЦ
                    <?= $_labelValuta ?>
                </th>

                <th class="w-15"><?= lang('LANG__special.tbl.th.img') ?></th>
            <?php endif ?>
        </tr>
    </thead>

    <tbody> 
        <?php
        if (!isset($list)) {
            return;
        }

        foreach ($list as $key => $row) {
            $_gensoftJson   = json_decode((string) $row['gensoft_json']);
            $_qtyPrice_json = json_decode($row['qtyPrice_json'] ?? '');
            $_mqrka_unit    = $_mqrka[$row['sp_mqrka_id']]['mqrka_unit'] ?? '&nbsp;';
            ?> 

            <tr data-id="<?= $row['product_id'] ?>"> 

                <td class="align-middle text-center">
                    <input type="hidden" name="bizKlient[productsID][]" value="<?= $row['product_id'] ?>">           
                </td> 

                <td class="action text-center align-middle"> 
                    <div>
                        <i class="delete_product btn-outline-danger p-1 border-0 fa fa-trash" data-totalInFooter title="<?= lang('LANG__global.tbl.btn.title.delete') ?>"></i>

                        <?php
                        $urlParams      = array(
                            'ctrl'       => 'bizKlient',
                            'product_id' => $row['product_id'],
                            'arg'        => '',
                        );
                        ?>

                        <i class="edit_product btn-outline-primary p-1 border-0 fa fa-edit" data-route="<?= route_to('Popup_editProduct-open', urldecode(http_build_query($urlParams))) ?>" title="<?= lang('LANG__global.tbl.btn.title.edit') ?>"></i> 
                    </div>

                    <div>
                        <i class="btn-outline-dark p-1 border-0 fa fa-arrows" title="<?= lang('LANG__global.tbl.btn.title.move') ?>"></i>
                        <i class="rowPosition btn-outline-dark p-1 border-0 fa fa-list"></i>
                    </div> 

                    <div>
                        <button id="clone-product" class="btn btn-outline-success border-0" data-route="<?= route_to('Popup_editProduct-clone', urldecode(http_build_query($urlParams))) ?>" data-product-name="<?= $row['product_name'] ?>" type="button" title="клониране на продукт">
                            <i class="fa fa-copy"></i>
                        </button>
                    </div> 
                </td> 

                <td class="productName align-middle text-break fw-400">
                    <?= empty($row['product_name']) ? '<b class="bg-danger">Липсва продуктово име</b><br>' . $row['gensoft_productName'] : $row['product_name'] ?>
                    <div>
                        <?php
                        if ($row['gensoft_item_id']) {
                            echo '<img class="w-20" src="' . $_ENV['app.imageDataDir'] . 'logos/genSoft.jpg" alt="">';
                        }

                        // echo $_gensoftJson -> qty_safe ?? '' ? '<p class="bg-secondary m-2">' . $_ENV['app.sklad4'] . '</p>' : '';
                        ?>  
                    </div>
                </td> 

                <td class="productModel align-middle text-break fw-400 text-center"><?= $row['model'] ?></td> 

                <td class="productDesk align-middle fw-400">
                    <div class="maxHeight">
                        <?= $row['description'] ?>
                    </div>

                    <?php if (!empty($row['description'])) { ?>
                        <i class="fa fa-info-circle text-primary text-center d-block cursor-pointer" data-toggle="tooltip" title="<?= htmlentities($row['description']) ?>"></i> 
                    <?php } ?>
                </td> 

                <!--  наличност -->
                <td class="productNalichnost position-relative align-middle text-center fw-400">
                    <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);"><?= ($row['nalichnost'] ?? 0 ) . ' ' . $_mqrka_unit ?>
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">
                        <?php
                        if ($_gensoftJson -> kol_lock ?? null) {
                            echo '<small>запаз. - ' . $_gensoftJson -> kol_lock . $_mqrka_unit . '</small>';
                        }
                        ?>

                        <?php if ($_ENV['app.gensoftEnable'] && !empty($row['gensoft_item_id'])): ?>
                            <button class="getGensoftInfo col btn text-primary " data-route="<?= route_to('Popup_izboProduct-getGensoftInfo') ?>" data-name="<?= $row['gensoft_productName'] ?? 'null' ?>" type="button">
                                <i class="fa fa-info-circle"></i>
                            </button>
                        <?php endif ?>
                    </div>
                </td> 

                <!--  брой -->
                <td class="qty text-center align-middle fw-400">
                    <br>

                    <input class="qty css-input-p css-focus-strong css-border-none css-max-input-width text-center" 
                           name="bizKlient[qtyPrice_json][<?= $row['product_id'] ?>][qty]" 
                           data-isNumeric  
                           type="text"  
                           value="<?= $_qtyPrice_json -> {$row['product_id']} -> qty ?? '' ?>">

                    <?= $_mqrka_unit ?>
                </td> 

                <td class="nadz text-center align-middle fw-400"><br><br><br></td> 

                <td class="zenaProdava position-relative align-middle text-center fw-400">
                    <?php
                    $_zenaProdava = null;
                    $_promoPrice  = null;
                    $_gsKKC       = h_toFixed($_gensoftJson -> KKC ?? null, $_isRoundedToFirst); // gensoft KKC 

                    if (isset($row['nivo'])) {
                        $_zenaProdava = h_toFixed($row['nivo'], $_isRoundedToFirst);
                    } elseif (isset($_qtyPrice_json -> {$row['product_id']} -> price)) {
                        $_zenaProdava = h_toFixed($_qtyPrice_json -> {$row['product_id']} -> price, $_isRoundedToFirst);
                    }

                    $_gPromoPercent = is_numeric($_gensoftJson -> promoPercent ?? null) ? (float) $_gensoftJson -> promoPercent : null; // gensoft промо % 

                    if ($_gPromoPercent && is_numeric($_gsKKC)) {
                        $_promoPrice = h_toFixed($_gsKKC * (1 + ($_gPromoPercent / 100)), $_isRoundedToFirst);
                    }
                    ?>

                    <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);" >
                        <input class="zenaProdava css-input-p css-focus-strong css-border-none css-max-input-width text-center" 
                               name="bizKlient[qtyPrice_json][<?= $row['product_id'] ?>][price]" 
                               data-isNumeric
                               type="text" 
                               value="<?= $priceType === 'gensoft' ? $_gsKKC : ($_zenaProdava ?? '') ?>"
                               <?= $priceType === 'gensoft' && !empty($row['gensoft_item_id']) ? 'disabled' : '' ?>>
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">
                        <?php if ($_promoPrice !== null && !empty($_gsKKC)): ?>
                            <small class="<?= $_gPromoPercent < 0 ? 'text-danger' : 'text-success' ?>">
                                <?= ($_gPromoPercent > 0 ? '+' : '') . $_promoPrice . '&nbsp;&nbsp;(' . $_gPromoPercent . '%)' ?>
                            </small>
                        <?php endif; ?>

                        <?php
                        $_route           = route_to('Promo-getPriceLevel');
                        $_btnPriceLvl     = '';
                        $_isEmptyPriceLvl = true; // Предполагаме, че всички нива са празни;
                        $_btn             = '';
                        foreach ($_priceLevels as $level => $label) {
                            if (!empty($row[$level])) {
                                $_btn .= "<button class='css-btn-wp' data-level='$level'
                                          data-product-id='{$row['product_id']}'
                                          data-route='$_route' type='button'>$label</button>";
                            }
                        }


                        if ($priceType !== 'gensoft' && $_btn) {
                            echo "<button class='css-btn-purple round-10 w-100'
                                  type='button' data-toggle='tooltip'
                                  title=\"<div id='priceLevel' class='d-flex gap-3'><span>Ценово ниво</span>$_btn</div>\">
                                  Ц. ниво
                                </button>";
                        }
                        ?>
                    </div>
                </td> 
                <?php if ($priceType != 'gensoft') : ?>
                    <td class="zenaDostavna css-background text-center align-middle fw-400" data-base-price=" <?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) ?>">
                        <?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) . ' ' . ($_default_valuta['valuta_symbol'] ?? '') ?>
                    </td> 
                <?php endif ?>

                <?php if ($priceType != 'gensoft') : ?>
                    <td class="total text-center align-middle fw-400"></td>
                <?php endif ?>

                <td class="productImage align-middle fw-400">
                    <?php
                    echo match ($row['badge_index']) {
                        '1' => '<div class="mb-1 text-center"><img class="w-50" src="' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></div>',
                        '2' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                        '3' => '<div class="mb-1 text-center"><img class="w-50" src="' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></div>',
                        '4' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></div>',
                        default => ''
                    };
                    ?>
                    <div class="d-flex">
                        <span class="<?= empty($row['image']) ? '' : 'fa fa-search-plus' ?> position-absolute"></span>
                        <?php $_imgSrc = empty($row['image']) ? '' : $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION) ?>
                        <img class="zoomImg mw-100 m-auto" src="<?= $_imgSrc ?>" data-full-image="<?= $_ENV['app.imageDir'] . $row['image'] ?>" onerror="this.onerror=null;this.src='';" alt=" ">  
                    </div>
                </td>         
            </tr> 
        <?php } ?> 
    </tbody> 

    <tfoot>

        <tr id="total_bez_dds">
            <th colspan="10">Сума без вкл. ДДС:</th>
            <th class="suma" colspan="2"></th>
        </tr>

        <tr id="dds" class="hide">
            <th colspan="10">ДДС <?= service('settings') -> get('App.general')['dds'] ?? '' ?>%</th>
            <th class="suma" colspan="2"></th>
        </tr>

        <tr id="total_s_dds" class="hide">
            <th colspan="10">Сума тотал с вкл. ДДС:</th>
            <th class="suma" colspan="2"></th>
        </tr>


        <tr id="razhod" style='background:#C61111; color: #fff;'>
            <th colspan="7">Разход</th> 
            <th></th> 
            <th colspan="2"></th> 
            <th class="suma" colspan="2"></th>
        </tr>

        <tr id="prihod" style='background:rgba(99, 102, 241, 0.4);'>
            <th colspan="7">Очакван приход без ДДС</th> 
            <th class="nadz" style="padding: 3px;text-align: center"></th> 
            <th colspan="2"></th> 
            <th class="suma" colspan="2"></th>
        </tr>

        <tr id="pechalba" class="css-bg-purple">
            <th colspan="7">Печалба</th> 
            <th class="percent" style="padding: 3px;text-align: center"></th> 
            <th colspan="2"></th> 
            <th class="suma" colspan="2"></th>
        </tr>

    </tfoot>
</table>
