<?php

namespace App\Modules\events\Models;

use \App\Models\BaseModel as BaseModel;

class MODEL__events extends BaseModel {

    
    function get__events($date = null, $tip = '') {

        $q = $this -> db -> table(self::TBL_EVENTS)
                        -> where('events_date', $date ?? date('d-m-Y'))
                        -> where('tip', $tip)
                        -> get() -> getRow();

        return $q;
    }

    function get__autocomplete($text = '') {

//        return $this -> db -> table(self::TBL_PROVIDER)
//                        -> select('provider_id, provider_name')
//                        -> like('provider_name', $text, 'both')
//                        -> get() -> getResultArray();

        return $this -> db -> table(self::TBL_KLIENT)
                        -> like('klient_name', $text, 'both')
                        -> where('isActive', 'Y')
                        -> get() -> getResultArray();
    }

    function save($data = []): bool {
        $this -> db -> transBegin();

        try {
            $builder = $this -> db -> table(self::TBL_EVENTS);

            // Check if a record with the given date exists
            $existingRecord = $builder
                            -> where('events_date', $data['events_date'])
                            -> where('tip', $data['tip'])
                            -> get() -> getRow();

            if ($existingRecord) {
                // Update the existing record
                $builder -> where('events_date', $data['events_date'])
                        -> where('tip', $data['tip'])
                        -> set($data) -> update();
            } else {
                // Insert a new record
                $builder -> insert($data);
            }

            $this -> db -> transCommit();
            return true;
        } catch (\Exception $e) {
            $this -> db -> transRollback();
            log_message('error', 'Transaction failed: ' . $e -> getMessage());
            return $e -> getMessage();
        }
    }

    function delete($date = null, $tip = null) {
        $this -> db -> transBegin();

        try {
            $query = $this -> db -> table(self::TBL_EVENTS)
                    -> where('events_date', $date)
                    -> where('tip', $tip)
                    -> delete();

            $this -> db -> transCommit();
            return $query;
        } catch (\Exception $e) {
            $this -> db -> transRollback();
            log_message('error', 'Transaction failed: ' . $e -> getMessage());
            return 'Database transaction failed: ' . $e -> getMessage();
        }
    }

}
