<?php

namespace App\Modules\order\Models;

use \App\Models\BaseModel as BaseModel;

class MODEL__order extends BaseModel {

    public function __construct() {
        parent::__construct();
    }

    function get__order_byId($orderId = null) {

        $orderTip = $_REQUEST['orderTip'] ?? null;

        $table = match ($orderTip) {
            'site', 'L', 'K', 'F' => self::TBL_ORDER,
            'N' => self::TBL_ORDERCART,
            default => self::TBL_ORDER_GENSOFT,
        };

        $t = $this -> db -> table($table . ' o')
                -> join(self::TBL_KLIENT . ' k', 'klient_id', 'left')
                -> join(self::TBL_SP_STATUS . ' st', 'sp_status_id', 'left')
                -> where('o.order_id', $orderId)
                -> orderBy('o.order_id', 'DESC')
                -> groupBy('o.order_id');
        return $t -> get() -> getRow();
    }

    function get__products_inOrder($orderId = null) {
        $orderTip = $_REQUEST['orderTip'] ?? null;

        $table = match ($orderTip) {
            'site', 'L', 'K', 'F' => self::TBL_ORDER,
            'N' => self::TBL_ORDERCART,
            default => self::TBL_ORDER_GENSOFT,
        };

        $extractedKeys = $this -> db -> table($table)
                        -> select('JSON_KEYS(JSON_UNQUOTE(JSON_EXTRACT(product_json, "$"))) AS product_keys')
                        -> where('order_id', $orderId)
                        -> get() -> getFirstRow();

        $productIds = implode(',', json_decode($extractedKeys -> product_keys ?? '[]', true));

        $sql = $this -> db -> table($table . ' as o')
                -> join(self::TBL_PRODUCT . ' p', "FIND_IN_SET(p.product_id, '$productIds')", 'left')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' sp', 'product_id', 'left')
                -> where('o.order_id', $orderId);

        if (($_REQUEST['orderTip'] ?? '') == 'N') {
            $sql -> join(self::TBL_PRODUCT_SITES . ' ps', 'product_id', 'inner')
                    -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' pl', 'product_id', 'left');
        }

        return $sql -> get() -> getResultArray();
    }

    function get_products_byId($productId = '') {

        $sql = $this -> db -> table(self::TBL_PRODUCT)
                -> select('product_id, gensoft_json, gensoft_item_id, gensoft_productName')
                -> whereIn('product_id', $productId);

        return $sql -> get() -> getResultArray();
    }

    function deleteLTovaritelniza($urlParams = []) {
        $table = in_array($urlParams['orderTip'], ['site', 'L', 'K']) ? self::TBL_ORDER : self::TBL_ORDER_GENSOFT;

        $this -> db -> table($table)
                -> set('tavaritelniza_no', null)
                -> set('tovaritelniza_key', null)
                -> set('tovaritelniza_json', null)
                -> where('tavaritelniza_no', $urlParams['tovaritelnizaNo'])
                -> update();
    }

    function delete_order($data = []) {

        $orderTip = $data['orderTip'] ?? null;

        $table = match ($orderTip) {
            'site', 'L', 'K', 'F' => self::TBL_ORDER,
            'N' => self::TBL_ORDERCART,
            default => self::TBL_ORDER_GENSOFT,
        };

        $this -> db -> table($table)
                -> where('order_id', $data['orderId'])
                -> delete();
    }

    function save_order($data = []) {
        $orderTip = $_REQUEST['orderTip'] ?? null;

        $table = match ($orderTip) {
            'site', 'L', 'K', 'F', 'N' => self::TBL_ORDER,
            default => self::TBL_ORDER_GENSOFT,
        };

        if ($orderTip == 'N') {
            $this -> db -> table(self::TBL_ORDERCART)
                    -> where('order_id', $data['order_id'])
                    -> delete();

            unset($data['order_id']);
            $data['orderTip'] = null;
        }

        // когато статуса е завършен или авансово се намаля наличността на продуктите
        if (in_array($data['sp_status_id'], [4, 6]) && in_array($orderTip, ['site', 'L', 'K'])) {
            $product_json = json_decode($data['product_json'] ?? '[]', true);

            if (empty($product_json)) {
                return ['err' => "Грешка: Няма предоставени продукти за обработка."];
            }

            $productIds = array_keys($product_json);

            $builder       = $this -> db -> table(self::TBL_PRODUCT . ' o');
            $currentStocks = $builder -> select('o.product_id,o.gensoft_item_id, o.product_name, o.nalichnost,m.mqrka_unit')
                            -> join(self::TBL_SP_MQRKA . ' m', 'sp_mqrka_id', 'left')
                            -> whereIn('o.product_id', $productIds)
                            -> get() -> getResultArray();

            // Map current stock by product_id for quick access
            $stockMap = array_column($currentStocks, null, 'product_id');
            $errors   = [];

            // Валидация за наличности
            if ($_ENV['app.gensoftEnable']) {
                foreach ($product_json as $productId => $v) {
                    if (!isset($stockMap[$productId])) {
                        $productName = $stockMap[$productId]['product_name'] ?? 'неизвестен продукт';
                        $errors[]    = [
                            'err' => "Грешка: Продуктът ({$productName}) с ID {$productId} не е намерен."
                        ];
                        continue;
                    }

                    $currentStock = $stockMap[$productId]['nalichnost'];

                    if ($currentStock - $v['qty'] < 0 && empty($stockMap[$productId]['gensoft_item_id'])) {
                        $productName = $stockMap[$productId]['product_name'];
                        $mqrka       = $stockMap[$productId]['mqrka_unit'];

                        $errors[] = [
                            'err' => "Внимание: Недостатъчна наличност за {$productName}- {$currentStock}, текущо кол.:{$mqrka}"
                        ];
                    }
                }
            }

            if (!empty($errors)) {
                return ['errors' => $errors];
            }

            foreach ($product_json as $k => $v) {
                if (!empty($v['qty'])) {
                    $builder -> set('nalichnost', "nalichnost - {$v['qty']}", false)
                            -> where('product_id', $k)
                            -> where('gensoft_item_id is null')
                            -> update();
                }
            }
        }

        $upsert = $this -> db -> table($table) -> upsertBatch($data);

        // 1- ако е нов ред, 2- update, 0 -ако данните са същите
        // last id на оферта ако е нова оферта
        $last_id = ($upsert === 1) ? $this -> db -> insertID() : null;

        return ['orderId' => $last_id ?? $data['order_id']]; // презарежда с нова или същест оферта
    }

    // записва datetime за създ поръчки в Gensoft
    function is_newGensoftOrder($data = []) {

        $builder    = $this -> db -> table(self::TBL_ORDER);
        $updateData = [];

        $gensoftQuery = $builder -> select('gensoftOrder_json')
                        -> where('order_id', $data['orderId'])
                        -> get() -> getRowArray();

        $productJson = json_decode($data['productJson'] ?? '[]', true);
        $productId   = $data['productId'][0] ?? null;

        if ($data['isSingleProduct'] && isset($productJson[$productId])) {

            $productJson[$productId] = array_merge(
                    $productJson[$productId],
                    [
                        'inGensoftOrd'   => 1,
                        'inGensoftSklad' => $data['gensoftOrder']['skladName'] ?? $data['gensoftOrder']['skladName2'],
                        'gensoftSmetka'  => $data['gensoftOrder']['smetka'] ?? $data['gensoftOrder']['smetka2']
                    ]
            );

            $gensoftOrderData = json_decode($gensoftQuery['gensoftOrder_json'], true);

            // Актуализиране на основните полета
            if (!empty($gensoftOrderData)) {
                foreach (['skladName', 'datetime', 'smetka', 'skladName2', 'datetime2', 'smetka2'] as $field) {
                    if (isset($data['gensoftOrder'][$field])) {
                        $gensoftOrderData[$field] = $data['gensoftOrder'][$field];
                    }
                }

                $updateData['gensoftOrder_json'] = json_encode($gensoftOrderData + $data['gensoftOrder'], JSON_UNESCAPED_UNICODE);
            } else {
                $updateData['gensoftOrder_json'] = json_encode($data['gensoftOrder'], JSON_UNESCAPED_UNICODE);
            }

            $updateData['sp_status_id'] = 3;
        }

        // ако е авт. създ поръчка в Gensoft
        if ($data['newOrder']) {
            $updateData['gensoftOrder_json'] = $data['newOrder'];

            foreach ($data['casheProdData'] as $k => $row) {
                if (isset($productJson[$k])) {
                    $productJson[$k] = array_merge($productJson[$k], [
                        'inGensoftOrd'   => 1,
                        'inGensoftSklad' => $row['inGensoftSklad'],
                        'gensoftSmetka'  => $row['gensoftSmetka']
                    ]);
                }
            }

            $updateData['sp_status_id'] = 4;
        }


        $updateData['product_json'] = json_encode($productJson, JSON_UNESCAPED_UNICODE);

        $builder -> set($updateData)
                -> where('order_id', $data['orderId'])
                -> update();
    }

    // връщане на поръчката
    function return_order($orderId = null) {
        if (empty($orderId)) {
            return;
        }

        $this -> db -> transBegin();

        $builder = $this -> db -> table(self::TBL_ORDER);
        $clone   = $builder -> where('order_id', $orderId)
                        -> get() -> getRowArray();

        $newProductData = [
            'order_id'     => $clone['order_id'],
            'klient_id'    => $clone['klient_id'],
            'product_json' => $clone['product_json'],
        ];

        $jsonProduct = json_decode($clone['product_json'], true);
        foreach ($jsonProduct as $k => &$v) {
            $this -> db -> table(self::TBL_PRODUCT)
                    -> set('nalichnost', "nalichnost + {$v['qty']}", false)
                    -> where('product_id', $k)
                    -> where('gensoft_item_id is null')
                    -> update();
        }

        $builder -> set('sp_status_id', 5)
                -> where('order_id', $orderId)
                -> update();

        $this -> db -> table(self::TBL_ORDERRETURN) -> upsert($newProductData);

        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            $errorMessage = $this -> db -> error()['message'];
            return ['err' => $errorMessage];
        }
    }

    //    function get__all_orders($data = []) {
//        $table = $_GET['orderTip'] == 'site' ? self::TBL_ORDER : self::TBL_ORDER_GENSOFT;
//
//        $t = $this -> db -> table($table . ' o')
//                -> select('o.*,st.status_name')
//                -> select('k.klient_name, k.klient_adres')
//                -> join(self::TBL_KLIENT . ' k', 'klient_id', 'left')
//                -> join(self::TBL_SP_STATUS . ' st', 'sp_status_id', 'left')
//                -> orderBy('o.order_id', 'DESC')
//                -> groupBy('o.order_id')
//                -> limit($data['per_page'], $data['offset']);
//
//        if ($data['searchName']) {
//            $t -> like('o.order_id', $data['searchName']);
//        }
//
//        match ($_GET['orderTip']) {
//            'sklad' => $t -> where('o.gensoft_sklad', 'sklad'),
//            'magazine' => $t -> where('o.gensoft_sklad', 'magazine'),
//            'bravas' => $t -> where('o.gensoft_sklad', 'bravas'),
//            default => null
//        };
//
//        return $t -> get() -> getResultArray();
//    }
}
