<?php
$settings = service('settings') -> get('App.general') ?? [];

define('ORDER_TIP', $_GET['orderTip'] ?? '');
define('ORDER_ID', $_GET['orderId'] ?? '');
define('TAB', $_GET['tab'] ?? '');

/* --- Основни настройки ------------------------------------ */
$preval    = $settings['preval'] ?? [];
$priceType = $settings['zenoobr']['price_type'] ?? 'discount';

function isDisableTovaritelhniza($order): bool {
    return (($order -> delivery_method ?? '') != 'curier' && $order -> orderTip === null) || empty($order -> delivery_json);
}

function getOrderTypeUrlLink($order): string {
    $_siteName = $order -> site_name ?? '';
    $_urlLink  = '<a class="text-primary" href="https://' . $_siteName . '" target="_blank" style="font-size: 15px;">https://' . $_siteName . '</a>';

    return match (ORDER_TIP) {
        'site' => "дилърска от сайт {$_urlLink}",
        'L' => "дилърска локална",
        'K' => "клиентска от сайт {$_urlLink}",
        'F' => "бърза от сайт {$_urlLink}",
        'N' => "незавършена от сайт {$_urlLink}",
        default => 'Няма информация',
    };
}

function renderButtons($acl, $userGroupId, $order, array $deliveryObekt): void {
    $urlParams = urldecode(http_build_query([
        'ctrl'       => 'order',
        'ofer_id'    => $order -> order_id ?? '',
        'product_id' => '',
        'arg'        => ORDER_TIP,
    ]));

    // Бутон избор продукт
    echo '<div class="btn-group d-flex gap-11">';

    if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'prodIzbor')) {
        echo '<a id="izbor-product" class="btn btn-default" data-route="' . route_to('Popup_izboProduct-open', $urlParams) . '" style="min-width: 150px;">
                <i class="d-flex justify-content-center fa fa-book mr-1"></i>' . lang('LANG__global.btn.izborProduct') . '
            </a>';
    }

    '<button type="button" class="btn btn-default dropdown-toggle dropdown-toggle-split" data-toggle="dropdown"></button>
            
            <!--  Бутон нов продукт (Dropdown) -->
            <div class="dropdown-menu">
                <a id="new_product" class="btn" data-route="' . route_to('Popup_editProduct-open', $urlParams) . '">
                    <i class="fa fa-plus mr-1"></i>' . lang('LANG__global.btn.newProduct') . '
                </a>
            </div>
        </div>';

    // Бутон Товарителница (logic)
    if (!in_array($order?->orderTip, ['F', 'N'])) {
        $_route = match ($deliveryObekt['izborKurier'] ?? '') {
            'speedy_machina', 'speedy_office', 'speedy_door' => 'POPup_tavaritelniza-openSpeedy',
            'econt_office', 'econt_machina', 'econt_door' => 'POPup_tavaritelniza-openEcont',
            default => null,
        };

        if (is_numeric($order -> tavaritelniza_no ?? '')) {
            $_disableIftavaritelniza = 1;

            $deleteUrlParams = urldecode(http_build_query([
                'orderTip'        => ORDER_TIP,
                'orderId'         => ORDER_ID,
                'tovaritelnizaNo' => $order -> tavaritelniza_no,
            ]));

            //--- бутон генериране товарителнница
            echo function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'tovaritelniza') ? '<a id="generate-tovaritelniza" class="btn btn-success text-white px-1 py-0" data-route="' . ($_route ? route_to($_route, $order -> order_id) : '') . '" ' .
                    (isDisableTovaritelhniza($order) ? 'disabled' : '') . '>Товарителница
                   <div id="tavaritelnizaNo">' . $order -> tavaritelniza_no . '</div>
                 </a>' : null;

            //--- бутон delete товарителнница
            echo '<a id="delete-tovaritelniza" class="d-flex align-items-center p-1 btn btn-danger text-white" data-route="' . route_to('Order-delete_tovaritelniza', $deleteUrlParams) . '" title="изтриване на товатирелница">
                    <i class="fa fa-trash"></i>
                  </a>';

            //--- преглед товарителнница
            $_settingsService = service('settings') -> get('App.general');
            $_isEcont         = str_contains($deliveryObekt['izborKurier'] ?? '', 'econt');
            $_isSpeedy        = str_contains($deliveryObekt['izborKurier'] ?? '', 'speedy');

            $_speedyUser       = $_settingsService['speedyUser'] ?? '';
            $_speedyPass       = $_settingsService['speedyPass'] ?? '';
            $_speedyFormat     = $_settingsService['speedyFormat'] ?? '';
            $_speedySenderCopy = $_settingsService['speedySenderCopy'] ?? 'none';

            $_printLabelUrl = match (true) {
                $_isEcont => "https://ee.econt.com/api_export.php?exportMethod=printLoading&loading_num={$order -> tavaritelniza_no}&_key={$order -> tovaritelniza_key}&label=10x9",
                $_isSpeedy => "https://api.speedy.bg/v1/print?userName={$_speedyUser}&password={$_speedyPass}&paperSize={$_speedyFormat}&parcels={$order -> tovaritelniza_key}&additionalWaybillSenderCopy={$_speedySenderCopy}",
                default => '',
            };

            // преглед на товарителница
            echo '<a class="d-flex align-items-center btn-info p-1 btn" href="' . $_printLabelUrl . '" title="предпечат на товатирелница" target="_blank"> 
                    <i class="fa fa-print"></i>
                  </a>';

            // заявка за куриер
            $_tovaritelniza_json = json_decode($order -> tovaritelniza_json ?? [], true);

            if (($_tovaritelniza_json['sendFrom'] ?? '') == 'fromDoor') {
                echo '<a id="request-curier" class="d-flex align-items-center btn-primary p-1 btn" data-route="' . ( route_to('POPup_tavaritelniza-openRequestCurier', $order -> order_id, $deliveryObekt['izborKurier'] ?? '' ) ) . '" title="заявка за куриер"> 
                    <i class="text-white fa fa-truck"></i>
                  </a>';
            }
        } elseif ($order) {

            //--- бутон генериране товарителнница
            echo function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'tovaritelniza') ? '<a id="generate-tovaritelniza" class="btn btn-success px-2" data-route="' . ($_route ? route_to($_route, $order -> order_id) : '') . '" ' .
                    (isDisableTovaritelhniza($order) ? 'disabled' : '') . '>Товарителница</a>' : null;
        }
    }
}

function renderAdditionalButtons($acl, $userGroupId, $order, $priceType): void {

    // дали цялата поръчка е превърната в Gensoft поръчка
    $_gensoftOrder = $order -> gensoftOrder_json ?? null;

    //--- Gensoft бутони 
    if (in_array(ORDER_TIP, ['site', 'L']) && $priceType === 'gensoft' && isset($order -> order_id)) {
        //--- Бутон превърни в Gensoft поръчка
        echo function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'gensoftOrder') ? '<button id="create_gensoftOrder" class="btn btn-sm btn-warning px-2" 
                data-route="' . route_to('Order-sendTo_gensoftOrder', $order -> order_id ?? '') . '" ' . (!empty($_gensoftOrder) ? 'disabled' : '') . ' type="button" style="width:120px">Gensoft поръчка</button>' : null;
    }

    // текст за бутона save
    $_buttonText = match ($order -> orderTip ?? '') {
        'F' => 'Превърни в клиентска поръчка',
        'N' => 'Превърни в дилърска поръчка',
        default => 'Запис',
    };

    if (in_array(ORDER_TIP, ['site', 'L']) && $order?->sp_status_id != 5) {
        //--- Бутон Върни поръчката	
        $disabledReturn = !in_array($order?->sp_status_id, [4, 6]) ? 'disabled' : '';

        echo function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'return') ? '<div class="dropdown">
                  <a class="btn h-100 px-2 dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" ' . $disabledReturn . '>
                   <i class="d-flex justify-content-center fa fa-refresh"></i>
                    Връщане
                  </a>

            <div class="dropdown-menu"> 
               <!--  връща цялата поръчка -->
               <a id="returnOrder" class="dropdown-item btn btn-default px-2" data-route="' . route_to('Order-returnOrder', $order -> order_id ?? '') . '" title="Връщане на поръчката" ' . $disabledReturn . '>на цялата поръчка</a>
        
                <!--  връща част от продуктите -->
                <a id="returnProductsFromOrder" class="dropdown-item btn btn-default px-2" data-route="' . route_to('POPup_returnOrder-open', $order -> order_id ?? '') . '" title="Връщане на поръчката" ' . $disabledReturn . '>на избрани продукти</a>
            </div>
        </div>' : null;
    }

    //--- Бутон Save	
    $disabledSave = (in_array($order?->sp_status_id, [4, 5, 6])) ? 'disabled' : '';
    if (!in_array($order?->sp_status_id, [4, 5, 6])) {
        echo function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'save') ? <<<HTML
            <button id="save-ofer" class="btn btn-primary px-2" type="submit" >
                <i class="d-flex justify-content-center fa fa-save" $disabledSave></i>$_buttonText
            </button>
          HTML : null;
    }

    $urlParams = urldecode(http_build_query([
        'orderTip' => ORDER_TIP,
        'orderId'  => ORDER_ID,
    ]));

    $_deleteConfirm = lang('LANG__global.js.confirm.deleteOferta', ['поръчка - ' . ($order -> order_id ?? '')]);

    //--- Бутон Delete	
    echo function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'trash') ? '<a id="delete-ofer" class="btn btn-danger text-white px-2" 
           href="' . route_to('Order-delete', $urlParams) . '"  
           ' . (empty($order -> order_id) || !empty($_disableIftavaritelniza) ? 'disabled' : 'onclick="return confirm(\'' . $_deleteConfirm . '\')"') . '
           data-name="' . ($order -> order_id ?? '') . '" 
           data-action="delete">
           
           <i class="d-flex justify-content-center fa fa-trash"></i>' . lang('LANG__global.btn.delete') . '</a>' : null;

    if (!in_array($order?->orderTip, ['F', 'N'])) {
        $printUrlParams = urldecode(http_build_query([
            'tab'      => TAB,
            'orderTip' => ORDER_TIP,
            'orderId'  => ORDER_ID,
            'name'     => ORDER_ID,
        ]));

        //--- Бутон Print Preview
        echo function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'print') ? '<a id="prinPreview" class="btn btn-warning text-dark px-2" href="' . route_to('PrintPreview', $printUrlParams) . '" target="_blank" data-action="print">
			   
               <i class="d-flex justify-content-center fa fa-print"></i>' . lang('LANG__global.btn.printPreview') . '</a>' : null;
    }

    //--- Бутон Cansel	
    echo '<a id="exitOfer" class="btn btn-default px-2" href="' . route_to('tabOrder', 'orderTip=' . ORDER_TIP) . '">
        <i class="d-flex justify-content-center fa fa-reply-all"></i>' . lang('LANG__global.btn.cansel') . '</a>';
}
?>

<!--  БУТОНИ В ОФЕРТАТА ЗА ЗАПИС, ИЗТРИВАНЕ, ПРЕДПЕЧАТ и др.-->

<!-- информация от дясно -->
<section class="col-auto">
    <h5 class="m-0"><?= lang('LANG__order.breadcrumbs.info') ?></h5>

    <div><?= getOrderTypeUrlLink($order) ?></div>

    <div class="d-flex justify-content-between" style="font-size: 13px;">
        <small class="text-sm">№: <?= ($order -> order_id ?? '') . ' от ' . ($order -> date_added ?? '') ?></small>
    </div>
</section>

<!--  бутони от ляво -->
<div class="col d-flex justify-content-end gap-3 h-45px">
    <div class="btn-group d-flex gap-28">
        <?php renderButtons($acl, $userGroupId, $order, $deliveryObekt); ?>
    </div>

    <div class="btn-group d-flex gap-11">
        <?php renderAdditionalButtons($acl, $userGroupId, $order, $priceType); ?>
    </div>
</div>

