<div class="px-1">
    <div class="d-flex justify-content-between align-items-center">
        <label><i class="fa fa-taxi"></i>&nbsp;Метод на доставка</label>

        <?php
        $_optionsArr     = ['selfCar', 'firmCar', 'curier'];
        $_selectedMethod = $order -> delivery_method ?? $deliveryObekt['deliveryMetod'] ?? '';
        $_whoPayBill     = $order -> whoPayBill ?? '';

        $_mapKurier = match ($deliveryObekt['izborKurier'] ?? '') {
            'speedy_machina' => 'до автомат на Speedy',
            'speedy_office' => 'до офис с Speedy',
            'speedy_door' => 'до адрес с Speedy',
            'econt_machina' => 'до еконтомат с Еконт',
            'econt_office' => 'до офис с Еконт',
            'econt_door' => 'до адрес с Еконт',
            default => ''
        };

        // Проверяваме типа на куриерите
        $_isEcont  = str_contains($deliveryObekt['izborKurier'] ?? '', 'econt');
        $_isSpeedy = str_contains($deliveryObekt['izborKurier'] ?? '', 'speedy');

        // Избираме логото на куриера
        $_logoPath = $_isEcont ? 'EcontLogo.png' : ($_isSpeedy ? 'SpeedyLogo.png' : '');

        if ($_logoPath && $_selectedMethod == 'curier') {
            $_logoPath = '/assets/images/curier/' . $_logoPath;
        }
        echo '<img id="curierLogo" class="w-30 float-right" src="' . $_logoPath . '" alt="...">';
        ?> 
    </div>

    <select id="deliveryMetod" class="css-dropdown-p css-focus-strong css-border-none w-100 mb-1" name="order[delivery_method]">
        <option data-value="selfCar" value="selfCar" <?= $_selectedMethod == 'selfCar' ? 'selected' : '' ?>>с собствен транспорт</option>
        <option data-value="firmCar" value="firmCar" <?= $_selectedMethod == 'firmCar' ? 'selected' : '' ?>>с транспорт на <?= htmlspecialchars($customConfig -> firma) ?></option>
        <option data-value="curier" value="curier" <?= $_selectedMethod == 'curier' ? 'selected' : '' ?>>с куриер</option>
    </select>

    <!-- Превозвач само за локална поръчка -->
    <?php
    $_prevozName = '';

    if ($_GET['orderTip'] != 'L') {
        $prevoz = service('settings') -> get('App.gensoft')['prevoz'] ?? [];

        $_prevozName = match ($_selectedMethod) {
            'selfCar' => $prevoz['ST'] ?? '',
            'firmCar' => $prevoz['F'] ?? '',
            default => '',
        };
    }

    $_deliveryMethod = $order -> delivery_method ?? '';
    $_isHidden       = $_deliveryMethod === 'curier' ? 'hide' : '';
    ?>
    <div id="prevozvach" class="py-2 <?= $_isHidden ?>">
        <label class="m-0"><i class="fa fa-truck"></i>&nbsp;Превозвач
            <b class="text-danger">*</b>
        </label> 

        <select class="validate text-sm w-100" name="order[prevozvach]">
            <option value=""></option>
            <?php foreach ($kontragents ?? [] as $row) { ?>
                <?php
                if ($row['tip'] == 'P') {
                    $isSelected = $row['klient_name'] == ($order?->prevozvach ?? $_prevozName);
                    ?>
                    <option value="<?= $row['klient_name'] ?>" <?= $isSelected ? 'selected' : '' ?>><?= $row['klient_name'] ?></option>
                <?php } ?>
            <?php } ?>
        </select>    
    </div>
</div>

<!-- Метод на плащане -->
<div class="my-2 px-1">
    <label class="mt-1"><?= lang('LANG__order.leftSidebar.label.metodPay') ?></label>
    <b>*</b>

    <select id="paymentMethod" class="validate css-dropdown-p css-focus-strong css-border-none w-100 mb-1" name="order[payment_method]">
        <option value=""></option>
        <!--            <option value="B"<? // $order && $order?->payment_method == 'B' ? 'selected' : ''                            ?>>по банков път</option>-->
        <option value="D" <?= in_array($order?->payment_method, ['B', 'D']) ? 'selected' : '' ?>>на разсрочено по банков път</option>

    <!--            <option value="N" <? // $order && $order?->payment_method == 'N' ? 'selected' : ''                           ?>>в брой</option>-->
        <option value="E" <?= in_array($order?->payment_method, ['N', 'E']) ? 'selected' : '' ?>>в брой на разсрочено</option>

    </select>
</div>

<div id="deliveryData" class="<?= $_selectedMethod != 'curier' ? 'hide' : '' ?> css-background-transparent col card text-dark "> 

    <input id="deliveryObekt" type="hidden" name="delivery_json" value='<?= $order -> delivery_json ?? '' ?>'> 

    <div class="text-center"><label>Данни за доставка</label></div>

    <button id="izbor-klientObekt" class="btn bg-primary my-1 mt-3 w-100" data-route="<?= route_to('POPup_klient-open', $order -> klient_id ?? 'null') ?>" type="button">Избор на обект</button>

    <div class="my-2 px-1">
        <label>За чия сметка е куриерската услуга *</label>

        <select id="whoPayBill" class="css-dropdown-p css-focus-strong css-border-none col mb-1" name="order[whoPayBill]">
            <option value=""></option>
            <option value="За сметка на клиент" <?= $_whoPayBill == 'За сметка на клиент' ? 'selected' : '' ?>>За сметка на клиент</option>
            <option value="За сметка на продавач" <?= $_whoPayBill == 'За сметка на продавач' ? 'selected' : '' ?>>За сметка на продавач</option>
        </select>
    </div>

    <!-- Лице за контакти -->  
    <div>
        <label>
            <i class="fa fa-user"></i>&nbsp;Лице за контакти
            <b class="text-danger">*</b></label>

        <input id="lice_zaKont"
               class="css-input-p css-focus-strong css-border-none css-max-input-width mb-1" 
               type="text" 
               value="<?= $deliveryObekt['liceKont'] ?? '' ?>">
    </div>

    <!-- Тел на клиент -->     
    <div>
        <label class="mt-1">
            <i class="fa fa-phone"></i>&nbsp;<?= lang('LANG__global.leftSidebar.label.customer_tel') ?>
            <b class="text-danger">*</b></label> 

        <input id="tel" 
               class="css-input-p css-focus-strong css-border-none css-max-input-width"
               type="text" 
               value="<?= $deliveryObekt['tel'] ?? '' ?>">
    </div>

    <!-- Метод на доставка -->
    <fieldset>
        <div class="notAllowed my-2">
            <label class="mt-1">
                <i class="fa fa-truck"></i>&nbsp;Доставка чрез куриер
                <b class="text-danger">*</b></label>

            <input id="izborKurier"    
                   class="<?= $deliveryObekt['isAllowed'] ?? '' ?> css-input-p css-focus-strong css-border-none css-max-input-width" 
                   type="text" 
                   value="<?= $_mapKurier ?>">
        </div>

        <div id="toCity" class="notAllowed">
            <label> 
                <i class="fa fa-map-marker"></i>&nbsp;Населено място
                <b class="text-danger">*</b></label>

            <p class="w-100 mb-1">
                <!-- град на клиент -->   
                <input id="grad"
                       class="<?= $deliveryObekt['isAllowed'] ?? '' ?> css-input-p css-focus-strong css-border-none css-max-input-width" 
                       type="text" 
                       name="calc[city]"
                       data-autocomplete_city
                       value="<?= $deliveryObekt['grad'] ?? '' ?>">
            </p> 

            <!-- Пощенски код -->  
            <label>
                <i class="fa fa-map-marker"></i>&nbsp;<?= lang('LANG__global.leftSidebar.label.customer_postCode') ?>
                <b class="text-danger">*</b> </label>

            <p class="w-100 mb-1">
                <input id="postCode"
                       class="<?= $deliveryObekt['isAllowed'] ?? '' ?> css-input-p css-focus-strong css-border-none css-max-input-width"
                       name="calc[postCode]"
                       type="text" 
                       value="<?= $deliveryObekt['postCode'] ?? '' ?>">
            </p>
        </div>

        <!-- до офис -->
        <div id="toOfice" class="notAllowed <?= $deliveryObekt['showOfficeBlock'] ?? '' ?>">
            <label> 
                <i class="fa fa-address-card"></i>&nbsp;Офис
                <b class="text-danger">*</b></label>

            <p class="w-100 mb-1">
                <input id="ofis" class=" <?= $deliveryObekt['isAllowed'] ?? '' ?> css-input-p css-focus-strong css-border-none css-max-input-width w-100" data-curier="<?= $deliveryObekt['izborKurier'] ?? '' ?>"  type="text" value="<?= $deliveryObekt['ofis'] ?? '' ?>">  
            </p>  
        </div>

        <!-- до адрес -->
        <div id="toAdres" class="<?= $deliveryObekt['showAdresBlock'] ?? '' ?>" >
            <label class="mt-1">
                <i class="fa fa-tag"></i>&nbsp;Квартал</label>

                <input id="quarter" class="css-input-p css-focus-strong css-border-none css-max-input-width" type="text" value="<?= $deliveryObekt['kvartal'] ?? '' ?>">

            <label class="mt-1">
                <i class="fa fa-tag"></i>&nbsp;Улица</label>

            <div class="input-group-sm">
                <div class="input-group-prepend">
                    <input id="street" class="css-input-p css-focus-strong css-border-none css-max-input-width mr-1" type="text" value="<?= $deliveryObekt['ulica'] ?? '' ?>">

                    <label>№&nbsp;</label>

                    <input id="street_num" class="css-input-p css-focus-strong css-border-none css-max-input-width w-20" type="text" value="<?= $deliveryObekt['ulicaNo'] ?? '' ?>">
                </div>
            </div>

            <div id="blokContainer" class="input-group-prepend mt-2">
                <label>Блок</label>
                <input id="block_no" class="css-input-p css-focus-strong css-border-none css-max-input-width w-15 mx-1" type="text" value="<?= $deliveryObekt['blockNo'] ?? '' ?>">

                <label>вх.</label>
                <input id="entrance_no" class="css-input-p css-focus-strong css-border-none css-max-input-width w-10 mx-1" type="text" value="<?= $deliveryObekt['entranceNo'] ?? '' ?>">

                <label>ет.</label>
                <input id="floor_no" class="css-input-p css-focus-strong css-border-none css-max-input-width w-10 mx-1" type="text" value="<?= $deliveryObekt['floorNo'] ?? '' ?>">

                <label>ап.</label>
                <input id="apartment_no" class="css-input-p css-focus-strong css-border-none css-max-input-width w-10 mx-1" type="text" value="<?= $deliveryObekt['apartmentNo'] ?? '' ?>">
            </div>

            <label class="mt-1">
                <i class="fa fa-comment"></i>&nbsp;Друго</label>

                <input id="other" class="css-input-p css-focus-strong css-border-none css-max-input-width" type="text" value="<?= $deliveryObekt['other'] ?? '' ?>">
        </div>
    </fieldset>
</div>
