<?php
$request = \Config\Services::request();
// Проверяваме дали заявката е AJAX
$_isAjax = $request -> getVar('no_ajax') === 'true' ? false : $request -> isAJAX();

// закръгляне
$_isRoundedToFirst = is_object($ofer) && isset($ofer -> isRoundedToFirst) ? (bool) $ofer -> isRoundedToFirst : false;

// точност на цена
$_priceAccuracy = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

$preval              = service('settings') -> get('App.general')['preval'] ?? [];
$_default_valutaCode = strtoupper($preval['base_currency'] ?? 'BGN');

$generalSettings = service('settings') -> get('App.general') ?? [];

$priceType = $generalSettings['zenoobr']['price_type'] ?? 'discount';

/* --- Цени -------------------------------------------------- */
$_pricesWithDds     = !empty($general['prices_with_dds']);
$_dealerPricesLabel = 'ДИЛЪРСКИ ЦЕНИ ' . ($_pricesWithDds ? '(С ДДС)' : '(БЕЗ ДДС)');

$_priceLevels = [
    'cenaB'    => 'B',
    'cenaA'    => 'А',
    'cenaSpec' => 'Спец.',
    'cenaKKC'  => 'ККЦ',
];

if ($priceType !== 'discount') {
    $_priceLevels['cenaKl'] = 'Кл.клиент';
}

$_labelValuta = "<div class='w-50 m-auto' style='background-color:#C61111;color:#fff!important;padding:1px 6px;border-radius:4px;font-size:0.85em;'> $_default_valutaCode </div>";

$_mqrka = isset($mqrka) ? array_column($mqrka, null, 'sp_mqrka_id') : [];
?>

<table id="tbl_products" class="table table-striped table-sm mt-3" cellspacing="0" width="100%">
    <thead  class="css-background">
        <tr style="background: #C61111;color: white;">
            <th class="p-1 fw-600" colspan="13">
                <span style="background: #C61111;"><?= $_dealerPricesLabel ?></span>
            </th>
        </tr>

        <tr class="css-bg-purple">
            <th colspan="2"></th> 

            <th>
                <input id="filter" class="css-input-p css-focus-strong pr-4" type="search" placeholder="<?= lang('LANG__global.placeholder.filter') ?>">
            </th>

            <th colspan="2"></th>

            <th>
                <?php
                if ($priceType !== 'gensoft'):
                    $_route     = route_to('Promo-getPriceLevel');
                    $_priceNivo = "<div id='priceLevelAll' class='text-center' data-all='1'>
                                    <span>Ценово ниво за всички продукти</span>
                                    <br><br>";

                    foreach ($_priceLevels as $level => $label) {
                        $_priceNivo .= "<button class='css-btn-wp' type='button'
                                        data-level='{$level}'
                                        data-route='{$_route}'>
                                        {$label}
                                    </button>";
                    }

                    $_priceNivo .= "</div>";
                    ?>
                    <button class="css-btn-purple border-w-1 round-10 text-white btn btn-sm" type="button" data-toggle="tooltip" title="<?= $_priceNivo ?>">Ц. ниво</button>
                <?php endif ?>
            </th>  

            <th colspan="3"></th> 
        </tr>

        <tr>
            <th class="w-01"></th> 
            <th class="w-2"></th>
            <th class="w-8">Продукт </th>

            <?php if ($customConfig -> isVisible['col_kod']): ?>
                <th class="w-6">Код</th>
            <?php endif ?> 

            <?php if ($_ENV['app.gensoftEnable']): ?>
                <th class="w-3">Gensoft поръчка</th>
                <th class="w-7">Наличност по складове в Gensoft</th>
            <?php else: ?> 
                <th class="w-3">Наличност</th>
            <?php endif ?>

            <th class="w-1">Кoл.</th>
            <th class="w-1">KKC
                <?= $_labelValuta ?>
            </th>

            <th class="w-1">Общо
                <?= $_labelValuta ?>
            </th> 

            <?php if ($priceType != "gensoft") { ?>
                <th class="w-01">Доставна цена
                    <?= $_labelValuta ?>
                </th>
            <?php } ?>

            <th class="w-2">Снимка</th> 
        </tr>
    </thead>

    <tbody> 
        <?php
        if (!isset($list)) {
            return;
        }

        $_weight = 0;
        foreach ($list as $row) {
            $_gensoftJson       = json_decode((string) $row['gensoft_json']);
            $_order_productJson = json_decode($order -> product_json ?? '');
            $_weight            += (float) $row['teglo'];
            ?> 

            <tr class="text-center" data-id="<?= $row['product_id'] ?>"> 
                <td class="align-middle text-center fw-400">
                    <input type="hidden" name="order[total_weight]" value="<?= $_weight ?? 0 ?>">
                </td>

                <td class="action align-middle text-center fw-400">
                    <i class="delete_product btn-outline-danger p-1 border-0 fa fa-trash" data-totalInFooter title="<?= lang('LANG__global.tbl.btn.title.delete') ?>"></i>

                    <?php
                    $urlParams          = urldecode(http_build_query(array(
                        'ctrl'       => 'order',
                        'ofer_id'    => $order -> order_id ?? '',
                        'product_id' => $row['product_id'],
                        'arg'        => isset($_GET['orderTip']) ? $_GET['orderTip'] : ($_isAjax ? $arg : ''), // $arg от POPup_editProduct
                    )));
                    ?>

                    <i class="edit_product btn-outline-primary p-1 border-0 fa fa-edit" data-route="<?= route_to('Popup_editProduct-open', $urlParams) ?>" title="<?= lang('LANG__global.tbl.btn.title.edit') ?>"></i>

                    <?php
                    if ($_ENV['app.gensoftEnable']) {
                        $_routeSendToGensoft = route_to('Order-sendTo_gensoftOrder', $row['order_id'] ?? '');

                        $_gensoftOrder_json = json_decode($order -> gensoftOrder_json ?? '[]', true);
                        $_sklads            = [
                            $_ENV['app.baseSklad'],
                            $_ENV['app.sklad2'],
                            $_ENV['app.sklad3'],
                            $_ENV['app.sklad4']
                        ];

                        $_selectedSklad = mb_strtoupper($_gensoftOrder_json['skladName'] ?? '');
                        $_defaultSklad  = mb_strtoupper($_ENV['app.sklad4']);
                        $_optionsHtml   = '<option value="">-- Изберете Gensoft склад --</option>';

                        foreach ($_sklads as $sklad) {
                            $_sklad = mb_strtoupper($sklad);

                            $disabled = $_selectedSklad && $_selectedSklad !== $_sklad && $_selectedSklad !== '' && $_sklad !== $_defaultSklad ? 'disabled' : '';

                            $_optionsHtml .= "<option value='$_sklad' $disabled>{$_sklad}</option>\n";
                        }

                        $_tooltipContent = <<<HTML
                                            <div>
                                                  <p>Определяне към кой склад в Gensoft<br> да бъде насочена избраната стока за създаване на поръчка в Gensoft.</p>
                               <p><span class="text-danger">Забележка:</span>  след като веднъж се избере склад<br> другите се деактивират като избираеми с изключение на $_defaultSklad</p>

                                                  <select id="izbor_sklad" class="css-dropdown-p css-focus-strong css-border-none" data-productid="{$row['product_id']}" data-route="$_routeSendToGensoft">$_optionsHtml</select>
                                            </div>
                     HTML;

                        if ($row['gensoft_item_id']) {
                            $_productId     = $row['product_id'];
                            // Ако има продукти ръчно прехвърлени в Gensoft поръчка
                            $_inGensoft     = isset($_order_productJson -> {$_productId} -> inGensoftOrd);
                            $_gensoftSmetka = $_order_productJson -> {$_productId} -> gensoftSmetka ?? '';
                            $_gensoftSklad  = $_order_productJson -> {$_productId} -> inGensoftSklad ?? '';

                            $_isDisabledBtnSklad = ($_isAjax || $_inGensoft) ? 'disabled' : '';
                            $_tooltipIsEnabled   = $_isDisabledBtnSklad ? '' : 'tooltip';
                            $_title              = $_isDisabledBtnSklad ? '' : htmlspecialchars($_tooltipContent);
                            $_bgClass            = ($_isAjax || $_isDisabledBtnSklad) ? 'bg-danger' : '';
                            $_action             = $_isAjax ? 'moveToSklad' : '';
                            $_blockedClass       = $_inGensoft ? 'notAllowed' : '';

                            echo <<<HTML
                                        <div class="{$_blockedClass}">
                                            <i class="{$_bgClass} tooltipGensoftSklad btn-outline-dark p-1 fa fa-home" 
                                               data-toggle="{$_tooltipIsEnabled}" 
                                               title="{$_title}" 
                                               {$_isDisabledBtnSklad} 
                                               data-action="{$_action}">
                                            </i>
                                        </div>
                                  HTML;
                        }
                    }
                    ?>
                </td>

                <td class="productName align-middle text-left fw-400">
                    <span>  <?= empty($row['product_name']) ? '<b class="bg-danger">Липсва продуктово име</b><br>' . $row['gensoft_productName'] : $row['product_name'] ?></span>

                    <div class="d-flex flex-column">
                        <?php
                        if ($row['gensoft_item_id']) {
                            echo '<img class="w-15" src="' . $_ENV['app.imageDataDir'] . 'logos/genSoft.jpg" alt="">';
                        }
                        ?>  
                    </div>
                </td>

                <?php if ($customConfig -> isVisible['col_kod']): ?>
                    <td class="align-middle text-left fw-400"><?= $row['kod'] ?></td>
                <?php endif ?> 


                <?php
                $_mqrka_unit = empty($row['sp_mqrka_id']) ? '' : $_mqrka[$row['sp_mqrka_id']]['mqrka_unit'];

                if ($_ENV['app.gensoftEnable']):
                    ?>
                    <td class="align-middle text-left fw-400">
                        <?php
                        // дали има съдадена ръчна gensoft поръчка 
                        echo '<input name="product_json[' . $row['product_id'] . '][inGensoftOrd]" type="hidden" value="' . ($_inGensoft ?? '') . '">';
                        echo '<input name="product_json[' . $row['product_id'] . '][gensoftSmetka]" type="hidden" value="' . ($_gensoftSmetka ?? '') . '">';
                        echo '<input name="product_json[' . $row['product_id'] . '][inGensoftSklad]" type="hidden" value="' . ( $_gensoftSklad ?? '') . '">';

                        if (!empty($_gensoftSmetka)) {
                            echo '<div class="bg-info p-1">';
                            echo '<div>Склад: ' . $_gensoftSklad . '</div><div>Сметка: ' . $_gensoftSmetka . '</div></div> </div></div>';
                        }
                        ?>
                    </td>

                    <td class="totalKolich align-middle text-left fw-400">
                        <?php
                        // показва в Gensoft кои в складове, колко бройки има
                        $_gensoft_inSkladJson = json_decode($row['gensoft_inSkladJson'] ?? null);

                        foreach ($_gensoft_inSkladJson ?? [] as $json) {
                            $SKLAD         = $json -> SKLAD;
                            $KOLICH        = $json -> KOLICH;
                            $RAZFAS1       = $json -> RAZFAS1;
                            $KOLICH_LOCKED = $json -> KOLICH_LOCKED;

                            $text = '<div class="d-flex">';
                            // if ($SKLAD != '') {
                            $text .= '<div class="col-5">' . $json -> SKLAD . '</div> ';
                            // }
                            // if ($KOLICH != '') {
                            $text .= '<div class="col"><b class="' . (!empty($KOLICH) ? 'text-blue' : '') . '">кол.: ' . $json -> KOLICH . ' ' . $RAZFAS1 . '</b> ';
                            // }
                            // if (!empty($KOLICH_LOCKED)) {
                            $text .= '<b class="' . (!empty($KOLICH_LOCKED) ? 'text-danger' : '') . '">запаз.: ' . ($json -> KOLICH_LOCKED) . ' ' . $RAZFAS1 . '</b></div>';
                            //  }

                            echo '<small class="text-sm">' . $text . '</div></small>';
                        }
                        echo '<br><div class="col">Обща наличност: <span class="totalKolich">' . (!empty($row['nalichnost']) ? $row['nalichnost'] . ' ' . $_mqrka_unit : '<span class="text-danger">няма наличност</span>') . '</span></div>';
                        ?>
                    </td>
                <?php else: ?>
                    <td class="align-middle text-center fw-400">
                        <div class="col"><?= !empty($row['nalichnost']) ? $row['nalichnost'] . ' ' . $_mqrka_unit : 0 ?></div>
                    </td>
                <?php endIf ?>

                <td class="qty position-relative  align-middle text-center fw-400">
                    <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);">
                        <?php renderProductQuantity($row, $_order_productJson) ?>
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);" >
                        <?= $_mqrka_unit ?>
                    </div>
                </td>

                <td class="zenaProdava position-relative align-middle text-center fw-400">
                    <?php
                    $_priceLevelMapping = [
                        'Цена В'    => 'cenaB',
                        'Цена А'    => 'cenaA',
                        'Цена С'    => 'cenaKl',
                        'Цена Кл'   => 'cenaKl',
                        'cenaKKC'   => 'cenaKKC',
                        'cenaPromo' => 'cenaPromo',
                        'Специална' => 'cenaSpec',
                    ];

                    $_klientPriceLevel = $_priceLevelMapping[$order?->zenaNivo] ?? null;
                    $_priceProdava     = $_order_productJson -> {$row['product_id']} -> price ?? '';

                    if (($_GET['orderTip'] ?? null) === 'N' && $_klientPriceLevel) {
                        $_priceProdava = $row[$_klientPriceLevel] ?? $_priceProdava;
                    }
                    ?>

                    <!-- btn посл прод цена от gensoft-->
                    <?php if ($_ENV['app.gensoftEnable']): ?>
                        <div class="position-absolute" style="top: 10px; ">
                            <button class="lastPrice css-bg-purple css-border-none round-10" data-route="<?= route_to('Order-gensoft_lastPrice', 'stoka=' . $row['gensoft_productName'] . '&isBravas=' . ($_gensoftJson -> isBravas ?? 0)) ?>" type="button" title="последна продажна цена от Gensoft за клиент">Посл. цена</button>
                        </div>
                    <?php endif ?>

                    <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);" >
                        <input class="zenaProdava validate css-input-p css-focus-strong css-border-none css-max-input-width text-center" name="product_json[<?= $row['product_id'] ?>][price]" data-isNumeric type="text" value="<?= $_priceProdava ?>">
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">
                        <?php
                        $_route           = route_to('Promo-getPriceLevel');
                        $_btnPriceLvl     = '';
                        $_isEmptyPriceLvl = true; // Предполагаме, че всички нива са празни;
                        $_btn             = '';
                        foreach ($_priceLevels as $level => $label) {
                            if (!empty($row[$level])) {
                                $_btn .= "<button class='css-btn-wp' data-level='$level'
                                          data-product-id='{$row['product_id']}'
                                          data-route='$_route' type='button'>$label</button>";
                            }
                        }


                        if ($priceType !== 'gensoft' && $_btn) {
                            echo "<button class='css-btn-purple round-10 w-100'
                                  type='button' data-toggle='tooltip'
                                  title=\"<div id='priceLevel' class='d-flex gap-3'><span>Ценово ниво</span>$_btn</div>\">
                                  Ц. ниво
                                </button>";
                        }
                        ?>
                    </div>
                </td>

                <td class="total align-middle text-right fw-400"></td>

                <?php if ($priceType != "gensoft") { ?>
                    <td class="zenaDostavna css-background fw-400 text-center align-middle" data-base-price="<?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) ?>">
                        <?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']);
                        ?>
                        <input class="zenaDostavna" type="hidden" value="<?= $row['price_dostavna'] ?? '' ?>">
                    </td> 
                <? } ?>

                <td class="align-middle fw-400">
                    <?php renderProductImage($row); ?>
                </td>
            </tr> 
        <?php } ?> 
    </tbody> 

    <tfoot>
        <?php
        $_isKurier = match ($deliveryObekt['izborKurier'] ?? '') {
            'econt_office', 'econt_door', 'econt_machina' => 'Еконт',
            'speedy_office', 'speedy_door', 'speedy_machina' => 'Speedy',
            default => '',
        };

        // ако е клиентска или бърза поръчка се скриват редовете с ДДС
        if (!in_array(($_GET['orderTip'] ?? null), ['K', 'F'])) :
            ?>
            <tr id="grandQtyRow" class="notAutoNum">
                <th class="text-right align-middle fw-500" colspan="<?= $customConfig -> isVisible['col_kod'] ? 5 : 5 ?>">
                    <label>Общо количество</label>
                </th>

                <th id="grandQtyVal" class="text-center align-middle fw-500">
                    <div class="text-center"></div>
                </th>

                <th colspan="3"></th>
            </tr>

            <tr id="total_bez_dds" class="notAutoNum">
                <th class="text-right" colspan="<?= $customConfig -> isVisible['col_kod'] ? 5 : 5 ?>"></th>

                <th class="text-right" colspan="2">Сума без ДДС</th>
                <th class="suma text-right"></th>
            </tr>

            <tr id="dds" class="<?= !$request -> isAJAX() && empty($order -> is_dds) ? 'hide' : '' ?>">
                <th colspan="<?= $customConfig -> isVisible['col_kod'] ? 5 : 5 ?>"></th>
                <th class="text-right" colspan="2">ДДС <?= service('settings') -> get('App.general')['dds'] ?? '' ?>%</th>
                <th class="suma text-right"></th>
            </tr>
        <?php endif ?>

        <tr id="total_s_dds" class="<?= (!$request -> isAJAX() && is_null($order?->is_dds)) || empty($order) ? 'hide' : '' ?>">
            <th colspan="<?= $customConfig -> isVisible['col_kod'] ? 5 : 5 ?>"></th>
            <th class="text-right" colspan="2">Сума тотал с ДДС:</th>
            <th class="suma text-right"></th>
        </tr>

        <tr id="dostavka" class="notAutoNum <?= empty($_isKurier) ? 'hide' : '' ?>">
            <th class="text-right" colspan="<?= $customConfig -> isVisible['col_kod'] ? 5 : 5 ?>">  
                <button id="calculateDostavka" class="css-bg-purple btn" data-route="<?= route_to('ApiQurier-apiCalculateDostavka', $deliveryObekt['izborKurier'] ?? '') ?>" type="button">Куриерска цена с ДДС за доставка </button>
            </th>

            <th class="align-middle text-right" colspan="2">
                <label>тегло кг. </label>
                <input id="totalWeight" class="css-input-p css-focus-strong css-border-none css-max-input-width w-40" type="text" name="calc[totalWeight]" data-isnumeric value="">
            </th>

            <th class="text-right text-danger">
                <div id="dostavkaVal"></div>
                <div id="totalAndDostavkaVal"></div>
            </th>
        </tr>

        <tr id="prihod" class="notAutoNum css-bg-purple">
            <th colspan="3"><?= lang('LANG__order.tbl.tfoot.prihod') ?></th> 
            <th class="nadz" style="padding: 3px;text-align: center"></th> 
            <th class="suma text-right" colspan="1"></th> 
            <th colspan="2"></th> 
        </tr>

            <!--        <tr id="pechalba" class="notAutoNum" style='background: #aef893;'>
                        <td colspan="3">Печалба</td> 
                        <td class="percent" style="padding: 3px;text-align: center"></td> 
                        <td></td>
                        <td class="suma"></td>
                        <td colspan="3"></td> 
                    </tr>-->
    </tfoot>
</table>

<?php

//  ------- ФУНКЦИИ  --------------------------------------------------
// колона количество
function renderProductQuantity($row, $order_productJson) {

    $grandTotalQty = $order_productJson -> {$row['product_id']} -> qty ?? '';

    echo <<<HTML
            <input class="qty validate css-input-p css-focus-strong css-border-none text-center" 
                   name="product_json[{$row['product_id']}][qty]" 
                   type="text" 
                   data-isbroj 
                   value="$grandTotalQty">
          HTML;
}

// колона снимка
function renderProductImage($row) {
    $_imgSrc = empty($row['image']) ? '' : $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION);

    $_imgZoom = empty($row['image']) ? '' : $_ENV['app.imageDir'] . $row['image'];
    ?> 
    <div class="d-flex">
        <span class="<?= $row['image'] != '' ? 'fa fa-search-plus' : '' ?> position-absolute"></span>
        <img class="zoomImg mw-100 m-auto" src="<?= $_imgSrc ?>" data-full-image="<?= $_imgZoom ?>" onerror="this.onerror=null;this.src='';" alt=" ">
    </div>
<?php } ?>

<script>
    // Are product prices entered WITH VAT
    window.PRICES_WITH_DDS = <?= !empty($generalSettings['prices_with_dds']) ? 'true' : 'false' ?>;

    // VAT percent (example: 20)
    window.SETTINGS_DDS = <?= (int) ($generalSettings['dds'] ?? 20) ?>;
</script>
