<?php

namespace App\Modules\popupForm\Controllers\product;

use \App\Models\common\MODEL__global;
use \App\Libraries\Pagination_ajax;
use App\Libraries\Gensoft\Local\LIB__GensoftGroups;
use App\Libraries\LIB__CategoryTree;
use \App\Models\MODEL__gensoft;
use \App\Modules\zenova\Models\MODEL__zenova_oferta;
use \App\Modules\popupForm\Models\product\MODELpop__izborProduct;

class POPup_izborProduct extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/product\\';

    public function __construct() {
        parent::__construct();

        $this -> LIB__GensoftGroups     = new LIB__GensoftGroups();
        $this -> LIB__CategoryTree      = new LIB__CategoryTree();
        $this -> MODEL__global          = new MODEL__global();
        $this -> Pagination_ajax_lib    = new Pagination_ajax();
        $this -> MODELpop__izborProduct = new MODELpop__izborProduct();
        $this -> MODEL__gensoft         = new MODEL__gensoft();
        $this -> MODEL__zenova_oferta   = new MODEL__zenova_oferta();

        helper('array');
    }

    ////////////////////////////////////////////////////////////
    //--- МОДАЛ ФОРМА ИЗБОР НА ПРОДУКТ ---
    // /////////////////////////////////////////////////////////
    // 
    // отваряне на модал ф. 
    // --------------------------------------
    public function open($urlParams = null) {
        parse_str($urlParams, $urlParams);
        $perPage = (int) ($this -> request -> getVar('perPage') ?? 10);
        $page    = (int) ($this -> request -> getVar('page') ?? 1);

        if (empty($urlParams['arg'])) {
            $referer = $this -> request -> getServer('HTTP_REFERER');

            if ($referer) {
                $path        = parse_url($referer, PHP_URL_PATH);
                $segments    = explode('/', trim($path, '/'));
                $lastSegment = end($segments);

                if (is_numeric($lastSegment)) {
                    $urlParams['arg'] = (int) $lastSegment;
                }
            }
        }

        $urlParams['ctrl'] = $urlParams['ctrl'] ?? 'zenova';

        // Извличане на продуктите
        $searchParams = [
            'ctrl' => $urlParams['ctrl'],
            'arg'  => $urlParams['arg'] ?? null,
        ];

        // gensoft групи
        if ($_ENV['app.gensoftEnable']) {
            $gensoftGroups = $this -> LIB__GensoftGroups -> renderSklad();
        }

        $productData = $this -> prepareProductData($searchParams, $page, $perPage);
        $categories  = $this -> LIB__CategoryTree -> render();

        // Данни за изгледа
        $data = [
            'modal_Title'        => 'Избор на продукт',
            'addCSS'             => $this -> addCSS(),
            'addJS'              => $this -> addJS(),
            'urlParams'          => $urlParams,
            'perPage'            => $perPage,
            'mqrka'              => $this -> MODEL__global -> get__mqrka(),
            'categories'         => $categories,
            'gensoftGroups'      => $gensoftGroups ?? [],
            'list'               => $productData['listData'],
            'pagination'         => $productData['pagination'],
            'countTotalProducts' => $productData['totalProducts'],
            // --- VIEW -----------------------------------------------
            'view_table'         => $this -> viewPath . 'izborProdukt/VIEWpop__izborProduct-table',
        ];

        return json_encode(view($this -> viewPath . 'izborProdukt/VIEWpop__izborProduct', $data));
    }

    // при търсе по име, код или категория или кликване на страница 
    // се опреснява таблицата с продукти 
    public function refreshTable() {// ajax
        $perPage = (int) ($this -> request -> getVar('perPage') ?? 10);
        $page    = (int) ($this -> request -> getVar('page') ?? 1);

        // Подготовка на параметрите за търсене
        $searchParams = array_filter([
            'ctrl'             => $this -> request -> getVar('ctrl'),
            'arg'              => $this -> request -> getVar('arg'),
            'selectedCatIds'   => $this -> request -> getVar('selectedCatIds'),
            //'searchCategoryRootId' => $this -> request -> getVar('searchCategoryRootId'),
            'name'             => trim($this -> request -> getVar('searchName')),
            'sqlCol'           => $this -> request -> getVar('sqlCol'),
            'inStock'          => $this -> request -> getVar('inStock'),
            'hasGensoftPromo'  => $this -> request -> getVar('hasGensoftPromo'),
            'gensoftGroups'    => $this -> request -> getVar('gensoftGroups'),
            'gensoftSkladName' => $this -> request -> getVar('gensoftSkladName'),
            'gensoftDateFrom'  => $this -> request -> getVar('gensoftDateFrom'),
            'gensoftDateTo'    => $this -> request -> getVar('gensoftDateTo'),
        ]);

        // Извличане на продуктите
        $productData = $this -> prepareProductData($searchParams, $page, $perPage);
        $categories  = $this -> LIB__CategoryTree -> render();

        // Подготовка на резултатите
        $data = [
            'perPage'            => $perPage,
            'search'             => $searchParams,
            'ctrl'               => $searchParams['ctrl'] ?? '',
            'arg'                => $searchParams['arg'] ?? '',
            'categories'         => $categories,
            'list'               => $productData['listData'],
            'searchResult'       => $productData['groupedProducts'],
            'pagination'         => $productData['pagination'],
            'countTotalProducts' => $productData['totalProducts'],
            'mqrka'              => $this -> MODEL__global -> get__mqrka(),
        ];

        // Извеждане на HTML таблицата
        $data['htmlTable'] = view($this -> viewPath . 'izborProdukt/VIEWpop__izborProduct-table', $data);

        $matchedTable       = '';
        $matchedPagnitation = '';

        if (preg_match('#<tbody>([\s\S]*)</tbody>#i', $data['htmlTable'], $matches)) {
            $matchedTable = $matches[0];
        }

        if (preg_match('/<div id="pagination"([\s\S]*)>(.*?)<\/div>/s', $data['htmlTable'], $matches)) {
            $matchedPagnitation = $matches[0];
        }

        return json_encode([
            'table'         => trim(preg_replace('#</?tbody[^>]*>#i', ' ', $matchedTable)),
            'pagnitation'   => $matchedPagnitation,
            'totalProducts' => $productData['totalProducts']
        ]);
    }

    // обща функция обединяваща open() и refreshTable()
    private function prepareProductData(array $search, int $page, int $perPage): array {
        $ctrl = $search['ctrl'] ?? null;
        $arg  = $search['arg'] ?? null;

        // Добавяне на лимити към търсенето
        $offset          = ($page > 1) ? ($perPage * ($page - 1)) : 0;
        $search['limit'] = ['offset' => $offset, 'per_page' => $perPage];

        $r                  = [];
        $groupedProducts    = [];
        $excludedProductIds = [];

        // Проверка за продукти в Zenova или Promo
        if (isset($search['name']) && in_array($ctrl, ['zenova', 'promo'])) {
            $r = $this -> MODELpop__izborProduct -> is__product_in_zenovaOrPromo($ctrl, $arg, $search);
        }

        if (is_array($r) && !empty($r)) {
            // Групиране на продукти по ценови листи или промоции
            foreach ($r as $offer) {
                $offerName = $offer['offer_name'];

                foreach ($offer['products'] as $product) {
                    $groupedProducts[$offerName][] = $product['product_name'];
                    $excludedProductIds[]          = $product['product_id'];
                }
            }

            // Извличане на продукти, които не са в списъци
            $search['notInProductIds'] = $excludedProductIds;
            $listData                  = $this -> MODELpop__izborProduct -> get__products($search);
        } else {
            if ($r == 'notInZenovaLista') {
                $listData = $r;
            } else {
                // Ако няма резултати или е текстов резултат
                $listData = (is_string($r) && !empty($r) ) ? [] : $this -> MODELpop__izborProduct -> get__products($search);
            }
        }

        // Общо продукти и страници
        $totalProducts = $this -> MODELpop__izborProduct -> count_productAll($search);
        $totalPages    = ceil($totalProducts / max(1, $perPage)); // ako $perPage ==0
//dd($totalPages);
        $route         = route_to('Popup_izboProduct-refreshTable');
        // Генериране на странициране
        $pagination    = $this -> Pagination_ajax_lib -> generate([
            'page'        => $page,
            'perPage'     => $perPage,
            'total_pages' => $totalPages,
            'route'       => $route,
            'ctrl'        => $ctrl,
            'arg'         => $arg,
        ]);

        $groupedProducts = is_string($r) ? ['oferName' => $r, 'productName' => $search['name'] ?? ''] : $groupedProducts;

        return [
            'listData'        => $listData,
            'groupedProducts' => $groupedProducts,
            'totalProducts'   => $totalProducts,
            'totalPages'      => $totalPages,
            'pagination'      => $pagination,
        ];
    }

    // ajax генериране на таблица от м.ф. избор на продукти, която 
    // ще добавим към офертата.
    public function generateTable($urlParams = null) {
        parse_str($urlParams, $urlParams);
        $productIds = $this -> request -> getVar('productIds') ?? [];

        // 1. Ако сме избрали всички резултати 
        // -------------------------------------------------
        if ((bool) $this -> request -> getVar('selectAllResults')) {

            // Get search filters sent from JS
            $search = $this -> request -> getVar('searchParams');

            // Safety check
            if (!is_array($search)) {
                return json_encode('');
            }

            // Remove limit → fetch ALL matching results
            unset($search['limit']);

            // Get all product IDs that match the search filters
            $productIds = $this -> MODELpop__izborProduct -> get__all_product_ids_by_search($search);
        }

        if (empty($productIds)) {
            return json_encode('');
        }

        // 3. Изливличане на избрнаите продукти
        // -------------------------------------------------
        $listData = $this -> MODELpop__izborProduct -> generateTable($productIds);

        $data = [
            'mqrka' => $this -> MODEL__global -> get__mqrka(),
            'arg'   => $urlParams['arg'],
            'ofer'  => null,
            'order' => null,
            'list'  => $listData,
        ];

        // return view from baseControler
        $data['htmlTable'] = $this -> get__viewTable($urlParams['ctrl'], $data);

        if (preg_match('#<tbody([\s\S]*)</tbody>#i', $data['htmlTable'], $matches)) {
            $modifiedTbody = preg_replace_callback('#<tr([^>]*)(>)#i', function ($matches) {
                // Check if the <tr> already has other attributes
                $attributes = isset($matches[1]) ? $matches[1] : '';
                return '<tr' . $attributes . ' data-fromizborproduct="true" >';
            }, $matches[0]);

            $finalResults = trim(preg_replace('#</?tbody[^>]*>#i', ' ', $modifiedTbody));

            return json_encode(['table' => $finalResults]);
        }

        return json_encode(true);
    }

    // автоматично добавяне и записване на избраните продукти само за ценова листа
    public function addProductsAndSave($urlParams = null) {
        parse_str($urlParams, $urlParams);
        $zenovaId   = (int) $this -> request -> getPost('oferId');
        $productIds = $this -> request -> getPost('productIds');
        $currentIds = [];

        // 1. Ако сме избрали всички резултати 
        // -------------------------------------------------
        if ((bool) $this -> request -> getVar('selectAllResults')) {

            // Get search filters sent from JS
            $search = $this -> request -> getVar('searchParams');

            // Safety check
            if (!is_array($search)) {
                return json_encode('');
            }

            // Remove limit → fetch ALL matching results
            unset($search['limit']);

            // Get all product IDs that match the search filters
            $productIds = $this -> MODELpop__izborProduct -> get__all_product_ids_by_search($search);
        }

        if (empty($productIds)) {
            return json_encode('');
        }

        if (!$zenovaId || empty($productIds) || !is_array($productIds)) {
            return $this -> response -> setJSON(['err' => 'Невалидни данни']);
        }

        $zenova = $this -> MODEL__zenova_oferta -> get_zenova_by_id($zenovaId);

        if (!$zenova || empty($zenova -> offersName)) {
            return $this -> response -> setJSON(['err' => 'Ценовата листа няма име']);
        }

        $zProduct = array_map(function ($pid) {
            return ['product_id' => (int) $pid];
        }, $productIds);

        $data = [
            'zenova'   => [
                'id'         => $zenovaId,
                'offersName' => $zenova -> offersName,
            ],
            'zProduct' => $zProduct
        ];

        $result = $this -> MODEL__zenova_oferta -> save_oferta($zenovaId, $data, []);

        if (is_array($result) && isset($result['err'])) {
            return $this -> response -> setJSON($result);
        }

        if (!empty($zenova -> productsID)) {
            $currentIds = array_map('intval', explode(',', $zenova -> productsID));
        }

        $newIds   = array_map('intval', $productIds);
        $finalIds = array_unique(array_merge($currentIds, $newIds));

        $this -> MODEL__zenova_oferta -> db -> table('_ofer_zenovaLista')
                -> where('id', $zenovaId)
                -> update(['productsID' => implode(',', $finalIds)]);

        // 3. Generate the product table data
        // -------------------------------------------------
        $listData = $this -> MODELpop__izborProduct -> generateTable($productIds);

        $data = [
            'mqrka'  => $this -> MODEL__global -> get__mqrka(),
            'arg'    => $urlParams['arg'],
            'oferId' => $urlParams['arg'],
            'ofer'   => null,
            'order'  => null,
            'list'   => $listData,
        ];

        // return view from baseControler
        $data['htmlTable'] = $this -> get__viewTable($urlParams['ctrl'], $data);

        if (preg_match('#<tbody([\s\S]*)</tbody>#i', $data['htmlTable'], $matches)) {
            $modifiedTbody = preg_replace_callback('#<tr([^>]*)(>)#i', function ($matches) {
                // Check if the <tr> already has other attributes
                $attributes = isset($matches[1]) ? $matches[1] : '';
                return '<tr' . $attributes . '>';
            }, $matches[0]);

            $productIds   = implode(',', array_column($listData, 'product_id'));
            $finalResults = trim(preg_replace('#</?tbody[^>]*>#i', ' ', $modifiedTbody));

            return json_encode(['table' => $finalResults, 'productIds' => $productIds]);
        }

        return json_encode(true);
    }

    public function get__gensoftInfo() {
        $productName = $this -> request -> getVar('productName');

        $response = $this -> MODEL__gensoft -> get__info_forSingleProduct($productName);

        return json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT);
    }

    public function get__gensoftGroups_bySklad() {
        $skladId = $this -> request -> getVar('skladId');

        $gensoftGroups = $this -> LIB__GensoftGroups -> renderGroups($skladId);

        return json_encode($gensoftGroups);
    }

    public function addCSS() {
        return [
            'css/popupForm/popup_izborProduct',
            'plugins/jTippy_popupTitle/jTippy.min'
        ];
    }

    // зареждане на js файлове в footer на html страницата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/inOfer/tableActions'
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
        ];

        $default = ['js/popupForm/izborProduct/popup_izborProduct'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
