<?php

namespace App\Modules\popupForm\Controllers\product;

use \App\Controllers\BaseController as BaseController;
use \App\Controllers\ApiQurier;
use \App\Models\MODEL__apiQurier;
use \App\Modules\order\Models\MODEL__order;
use \App\Modules\popupForm\Models\product\MODELpop__tovaritelniza;

class POPup_tavaritelniza extends BaseController {

    protected $viewPath = 'Modules/popupForm/Views/curier\\';

    public function __construct() {
        parent::__construct();

        $this -> ApiQurier = new ApiQurier();

        $this -> MODEL__apiQurier        = new MODEL__apiQurier();
        $this -> MODELpop__tovaritelniza = new MODELpop__tovaritelniza();
        $this -> MODEL__order            = new MODEL__order();
    }

    // ajax отваряне на модал ф. packList
    public function openSpeedy($orderId) {
        $form = $this -> request -> getVar();

        $order    = $this -> MODEL__order -> get__order_byId($orderId);
        $products = $this -> MODEL__order -> get__products_inOrder($orderId);

        if (!empty($order -> delivery_json)) {
            $ko = json_decode($order -> delivery_json);
        }

        $shippingCode = $ko -> izborKurier ?? '';
        $deliveryJson = [
            'isDefault'   => $ko -> default ?? '',
            'liceKont'    => $ko -> lice_zaKont ?? '',
            'tel'         => $ko -> tel ?? '',
            'grad'        => $ko -> grad ?? '',
            'postCode'    => $ko -> postCode ?? '',
            'ofis'        => $ko -> ofis ?? '',
            'kvartal'     => $ko -> quarter ?? '',
            'ulica'       => $ko -> street ?? '',
            'ulicaNo'     => $ko -> street_num ?? '',
            'blockNo'     => $ko -> block_no ?? '',
            'floorNo'     => $ko -> floor_no ?? '',
            'entranceNo'  => $ko -> entrance_no ?? '',
            'apartmentNo' => $ko -> apartment_no ?? '',
            'other'       => $ko -> other ?? '',
            'izborKurier' => $shippingCode,
            'isOfice'     => in_array($shippingCode, ['econt_office', 'econt_machina', 'speedy_office', 'speedy_machina']),
        ];

        $data = [
            'addJS'        => $this -> addSpeedyJS(),
            'addCSS'       => $this -> addCSS(),
            'form'         => route_to('POPup_tavaritelniza-speedy_createLabel', $orderId),
            'order'        => $order,
            'orderTip'     => $form['orderTip'],
            'products'     => $products,
            'deliveryJson' => $deliveryJson,
            'profilSender' => json_decode($this -> ApiQurier -> speedy_profilSender()) -> clients
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__speedy', $data));
    }

    // ajax отваряне на модал ф. packList
    public function openEcont($orderId) {

        $form = $this -> request -> getVar();

        $order    = $this -> MODEL__order -> get__order_byId($orderId);
        $products = $this -> MODEL__order -> get__products_inOrder($orderId);

        if (!empty($order -> delivery_json)) {
            $ko = json_decode($order -> delivery_json);
        }

        $shippingCode  = $ko -> izborKurier ?? '';
        $deliveryObekt = [
            'isDefault'   => $ko -> default ?? '',
            'liceKont'    => $ko -> lice_zaKont ?? '',
            'tel'         => $ko -> tel ?? '',
            'grad'        => $ko -> grad ?? '',
            'postCode'    => $ko -> postCode ?? '',
            'ofis'        => $ko -> ofis ?? '',
            'kvartal'     => $ko -> quarter ?? '',
            'ulica'       => $ko -> street ?? '',
            'ulicaNo'     => $ko -> street_num ?? '',
            'blockNo'     => $ko -> block_no ?? '',
            'floorNo'     => $ko -> floor_no ?? '',
            'entranceNo'  => $ko -> entrance_no ?? '',
            'apartmentNo' => $ko -> apartment_no ?? '',
            'other'       => $ko -> other ?? '',
            'izborKurier' => $shippingCode,
            'isOfice'     => in_array($shippingCode, ['econt_office', 'econt_machina', 'speedy_office', 'speedy_machina']),
        ];

        $profilSender = $this -> ApiQurier -> EcontRequest('Profile/ProfileService.getClientProfiles.json', [0])['profiles'];

        $data = [
            'addJS'         => $this -> addEcontJS(),
            'addCSS'        => $this -> addCSS(),
            'form'          => route_to('POPup_tavaritelniza-ekont_createLabel', $orderId),
            'order'         => $order,
            'orderTip'      => $form['orderTip'],
            'products'      => $products,
            'deliveryObekt' => $deliveryObekt,
            'profilSender'  => $profilSender,
            'profilAgents'  => $this -> ApiQurier -> EcontRequest(null, null, 'https://ee.econt.com/suggest_autocorrect.php?method=GetEeReadyParcelAgent&id_client=' . $profilSender[0]['client']['id'])['data'],
        ];

        //dd($data['profilSender'][0]);
        //dd(array_column($profilSender[0]['addresses'],['city'=>'name']));
        return json_encode(view($this -> viewPath . 'VIEWpop__econt', $data));
    }

    // ajax отваряне на модал ф. заявка за куриер
    public function openRequestCurier($orderId = null, $tip = '') {
        $_isEcont  = str_contains($tip, 'econt');
        $_isSpeedy = str_contains($tip, 'speedy');
        $order     = $this -> MODEL__order -> get__order_byId($orderId);

        $profilSender = $_isSpeedy ? json_decode($this -> ApiQurier -> speedy_profilSender()) -> clients : $this -> ApiQurier -> EcontRequest('Profile/ProfileService.getClientProfiles.json', [0])['profiles'];

        $data = [
            'addJS'        => $_isEcont ? $this -> addEcontJS() : $this -> addSpeedyJS(),
            'addCSS'       => $this -> addCSS(),
            'form'         => route_to('POPup_tavaritelniza-submitRequestCurier', $orderId),
            'order'        => $order,
            'isEcont'      => $_isEcont,
            'isSpeedy'     => $_isSpeedy,
            'profilSender' => $profilSender,
                //'profilAgents' => $this -> ApiQurier -> EcontRequest(null, null, 'https://ee.econt.com/suggest_autocorrect.php?method=GetEeReadyParcelAgent&id_client=' . $profilSender[0]['client']['id'])['data'],
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__requestCurier', $data));
    }

    public function submitRequestCurier($orderId = null) {
        $form = $this -> request -> getVar('form');

        $response = $this -> ApiQurier -> econt_requestCurier($form);

        return json_encode($response);
    }

    // ajax генериране на товарителница еконт
    // ==================================================
    public function ekont_createLabel($orderId = null) {
        $form = $this -> request -> getVar('form');

        $formKeys = [
            'profilSender', 'profilAgents', 'sendFrom', 'opakovka', 'packCount',
            'grandWeight', 'shipmentDescription', 'returnParcelPaymentSide', 'isEmailToMe',
            'emailOnDelivery', 'check', 'test', 'isCdAmount', 'isNplatez', 'invoiceBeforePay',
            'sms', 'obrRazpiska', 'obrStRazpiska', 'signature', 'payment', 'paymentOptions',
            'paymentReceiverValue', 'za_smetkaCustom', 'sizeUnder60cm', 'delivery_date'
        ];

        $tovaritelniza_json = array_reduce($formKeys, fn($arr, $key) =>
                isset($form[$key]) && $form[$key] !== '' ? array_merge($arr, [$key => $form[$key]]) : $arr, []);

        $tovaritelniza_json = array_merge($tovaritelniza_json,
                                          array_filter(
                        [
                            'declaredValueAmount' => $form['services']['declaredValueAmount'] ?? null,
                            'cdAmount'            => $form['services']['cdAmount'] ?? null,
                        ], fn($value) => $value !== null && $value !== ''));

        $data = [
            'orderTip' => $form['orderTip'],
            'orderId'  => $form['orderId']
        ];

        // dd($form);
        $response = $this -> ApiQurier -> econt_createLabel($form);

        if (empty($response['error'])) {
            parse_str(parse_url($response['label']['pdfURL'], PHP_URL_QUERY), $pdfUrl);

            $data['tovaritelnizaNo']  = $response['label']['shipmentNumber'];
            $data['tovaritelnizaKey'] = $pdfUrl['_key'];

            $tovaritelniza_json = empty($tovaritelniza_json) ? null : json_encode($tovaritelniza_json);
            $this -> MODELpop__tovaritelniza -> save_tovaritelniza($data, $tovaritelniza_json);
        }

        return json_encode($response ?? '');
    }

    // ajax генериране на товарителница speedy
    // ==================================================
    public function speedy_createLabel($orderId = null) {
        $form = $this -> request -> getVar('form');

        $speedy_jsonKeys = [
            'senderId'          => $form['senderId'] ?? '',
            'parcelsCount'      => $form['content']['parcelsCount'] ?? '',
            'totalWeight'       => $form['content']['totalWeight'] ?? '',
            'npPrice'           => $form['service']['additionalServices']['cod']['amount'] ?? '',
            'declaredPrice'     => $form['service']['additionalServices']['declaredValue']['amount'] ?? '',
            'returnDocComent'   => $form['service']['additionalServices']['returns']['rod']['comment'] ?? '',
            'returnParcelCount' => $form['service']['additionalServices']['returns']['swap']['parcelsCount'] ?? '',
            'returnDeclaredVal' => $form['service']['additionalServices']['returns']['swap']['declaredValue'] ?? '',
            ///////////////////////////
            'palet'             => array_map(function ($paletRow) {
                return [
            'paletOsnova'     => $paletRow['paletOsnova'] ?? '',
            'paletDimensions' => $paletRow['paletDimensions'] ?? '',
            'paletTeglo'      => $paletRow['paletTeglo'] ?? ''
                ];
            }, $form['palet'] ?? []),
            /////////////////////////////////
            'select'         => [
                'pickupDate'         => $form['service']['pickupDate'] ?? '',
                'serviceId'          => $form['service']['serviceId'] ?? '',
                'contents'           => $form['content']['contents'] ?? '',
                'package'            => $form['content']['package'] ?? '',
                'beforePay'          => $form['service']['additionalServices']['obpd']['option'] ?? '',
                'returnParcel'       => $form['service']['additionalServices']['obpd']['returnShipmentPayer'] ?? '',
                'servicePayer'       => $form['payment']['courierServicePayer'] ?? '',
                'packagePayer'       => $form['payment']['packagePayer'] ?? '',
                'declaredValuePayer' => $form['payment']['declaredValuePayer'] ?? '',
            ],
            ///////////////////////////////
            'checkbox'       => [
                'saturdayDelivery'     => empty($form['service']['saturdayDelivery']) ? 0 : 1,
                'returnFragile'        => empty($form['service']['additionalServices']['returns']['swap']['fragile']) ? 0 : 1,
                'returnReceipt'        => empty($form['service']['additionalServices']['returns']['returnReceipt']['enabled']) ? 0 : 1,
                'returnDoc'            => empty($form['service']['additionalServices']['returns']['rod']['enabled']) ? 0 : 1,
                'isDocs'               => empty($form['isDocs']) ? 0 : 1,
                'moneyTransfer'        => empty($form['service']['additionalServices']['cod']['processingType']) ? 0 : 1,
                'incShipPrice'         => empty($form['service']['additionalServices']['cod']['includeShippingPrice']) ? 0 : 1,
                'cardPaymentForbidden' => empty($form['service']['additionalServices']['cod']['cardPaymentForbidden']) ? 0 : 1,
                'fragile'              => empty($form['service']['additionalServices']['declaredValue']['fragile']) ? 0 : 1,
            ]
        ];

        foreach ($speedy_jsonKeys as $key => $value) {
            if (empty($value)) {
                unset($speedy_jsonKeys[$key]);
            } elseif (is_array($value)) {
                foreach ($value as $subKey => $subValue) {
                    if (empty($subValue)) {
                        unset($speedy_jsonKeys[$key][$subKey]);
                    }
                }
            }
        }

        $data = [
            'orderTip' => $form['orderTip'],
            'orderId'  => $form['orderId']
        ];

        $response = json_decode($this -> ApiQurier -> speedy_createLabel($form));

        if (empty($response -> error)) {
            $parcelIds = array_map(function ($parcel) {
                return $parcel -> id;
            }, $response -> parcels);

            $data['tovaritelnizaNo']  = $response -> id;
            $data['tovaritelnizaKey'] = implode('|', $parcelIds);

            $this -> MODELpop__tovaritelniza -> save_tovaritelniza($data, json_encode($speedy_jsonKeys, JSON_UNESCAPED_UNICODE));
        }

        return json_encode($response ?? '');
    }

    public function addCSS() {
        return [
            'css/curier/speedy/speedyAddressForm'
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addSpeedyJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = ['plugins/jTippy_popupTitle/jTippy.min'];

        $default = [];

        $modals = [
            'js/popupForm/tavaritelniza/popup_speedyTovar',
            'js/popupForm/tavaritelniza/popup_econtRequestCurier'
        ];

        return array_merge($plugins, $global, $default, $modals);
    }

    public function addEcontJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/curierLocator',
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
        ];

        $default = [];
        $modals  = [
            'js/popupForm/tavaritelniza/popup_econtTovar',
            'js/popupForm/tavaritelniza/popup_econtRequestCurier'
        ];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
