<?php

namespace App\Modules\popupForm\Controllers\spisak;

use \App\Models\common\MODEL__global;
use \App\Modules\popupForm\Models\spisak\MODELpop__mqrka;

class POPup_mqrka extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/spisak\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global   = new MODEL__global();
        $this -> MODELpop__mqrka = new MODELpop__mqrka();
    }

    // отваряне на модал ф мярка 
    // =======================
    public function open() {// ajax
        $isRefresh = $this -> request -> getVar('isRefresh');

        $data = [
            'addCSS' => $this -> addCSS(),
            'addJS'  => $this -> addJS(),
            'mqrka'  => $this -> MODEL__global -> get__mqrka(),
        ];

        $view = view($this -> viewPath . 'VIEWpop__mqrka', $data);

        return $isRefresh ? $view : json_encode($view);
    }

    public function changeTip($id) {

        $tip = $this -> request -> getVar('tip');
        $this -> MODELpop__mqrka -> changeTip($id, $tip);
    }

    public function save() {

        $form = $this -> request -> getVar('form');
        $this -> MODELpop__mqrka -> save_mqrka($form);

        echo json_encode('');
    }

    // ==== зареждане на css файлове в header на html странiцата =====
    // ---------------------------------------------------------------
    public function delete($id, $name) {

        $response = $this -> MODELpop__mqrka -> delete_mqrka($id);
        $json     = '';

        if ($response == true) {
            $json = lang('popup/LANGpop__mqrka.returnResponse.ok.deleted', [$name]);
        } else {
            // $json = lang('popup/LANGpop__mqrka.returnResponse.err.deleted', [$name]);
        }

        return json_encode($json);
    }

    public function addCSS() {
        return [
            'css/popupForm/popup_category'
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
        ];

        $plugins = ['plugins/stickyTableHeaders/stickytableheaders'];

        $default = [];
        $modals  = ['js/popupForm/popup_mqrka'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
