<?php

namespace App\Modules\popupForm\Models\product;

use \App\Models\BaseModel as BaseModel;

class MODELpop__izborProduct extends BaseModel {

    public function get__all_product_ids_by_search(array $search): array {
        $rows = $this -> get__products($search);

        if (!is_array($rows)) {
            return [];
        }

        return array_column($rows, 'product_id');
    }

    // всички продукти
    public function get__products($data = []) {

        $sql = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> join(self::TBL_CATEGORY . ' c', 'c.category_id = p.category_id', 'left');

        // ако gensoft is active търсим само тези продукти които са от gensoft
        if ($_ENV['app.gensoftEnable']) {
            $sql -> where('p.gensoft_item_id is not null');
        }

        // Филтър за поръчки 
        if (!empty($data['ctrl']) && in_array($data['ctrl'], ['order'])) {
            // Условия за аргументи като  -D дилър промо, К-клиент промо или поръчка
            match ($data['arg']) {
                'site', 'L', 'K', 'F', 'N' => $sql
                        -> join(self::TBL_PRODUCT_SITES . ' ps', 'product_id', 'left')
                        -> groupBy('p.product_id'),
                //-> where('ps.sp_site_id', $_ENV['app.localSite'])
//                'sklad' => $sql
//                        -> where(sprintf("(JSON_UNQUOTE(JSON_EXTRACT(`gensoft_json`, '$.sklad')) IN (%s, %s))", $_ENV['app.baseSklad'], $_ENV['app.sklad2'])),
//                'bravas' => $sql
//                        -> where("JSON_UNQUOTE(JSON_EXTRACT(`gensoft_json`, '$.bravas'))", 1),
                default => null
            };
        }

        // филтър по колони
        if (!empty($data['sqlCol']) && !empty($data['name'])) {
            $sql -> groupStart();

            if ($data['sqlCol'] === 'product_name') {
                $productName = explode(' ', $data['name']);

                foreach ($productName as $pName) {
                    $sql -> groupStart();
                    $sql -> like($data['sqlCol'], $pName, 'both')
                            -> orLike('gensoft_productName', $pName, 'both');
                    $sql -> groupEnd();
                }
            } else {
                $sql -> like($data['sqlCol'], $data['name'], 'both');
            }

            $sql -> groupEnd();
        }

        // филтър по мулти категории
        if (!empty($data['selectedCatIds'])) {
            $rootCatIds = $data['selectedCatIds']['rootCat_ids'] ?? [];
            $subCatIds  = $data['selectedCatIds']['subCat_ids'] ?? [];

            if (!empty($subCatIds)) {
                $sql -> whereIn('p.category_id', $subCatIds);
            } elseif (!empty($rootCatIds)) {
                $sql -> whereIn('p.categoryRoot_id', $rootCatIds);
            }
        }

        // Пропускане на продукти за 'zenova' и 'promo' които са в ценови или промо
        if (in_array($data['ctrl'], ['zenova', 'promo'])) {

            match ($data['ctrl']) {
                'promo' => $sql
                        -> join(self::TBL_PRODUCT_IN_ZENOVALISTA . ' z', 'product_id', 'inner')
                        -> join(($data['arg'] === 'D' ? self::TBL_PRODUCT_IN_PROMOLISTA : self::TBL_PRODUCT_IN_PROMOKL) . ' pz', 'product_id', 'left')
                        -> where('pz.product_id IS NULL'),
                'zenova' => $sql
                        -> join(self::TBL_PRODUCT_IN_ZENOVALISTA . ' pz', 'product_id', 'left')
                        -> where('pz.product_id IS NULL'),
                default => null
            };
        }

        // Филтър за наличност
        if (!empty($data['inStock'])) {
            $sql -> where('p.nalichnost > 0');
        }

        // Филтър за акo има gensoft промоции
        if (!empty($data['hasGensoftPromo'])) {
            $sql -> where("JSON_EXTRACT(p.gensoft_json, '$.promoPercent') IS NOT NULL")
                    -> where("JSON_EXTRACT(p.gensoft_json, '$.KKC') IS NOT NULL");
        }

        // Филтър по gensoft групи
        if (!empty($data['gensoftGroups'])) {
            $sql -> whereIn("JSON_UNQUOTE(JSON_EXTRACT(p.gensoft_json, '$.grupa'))", $data['gensoftGroups'])
                    -> where("JSON_UNQUOTE(JSON_EXTRACT(p.gensoft_json, '$.sklad'))", $data['gensoftSkladName']);

            // Филтър по дата ОТ
            if (!empty($data['gensoftDateFrom'])) {
                $dateFrom = date('d-m-Y', strtotime($data['gensoftDateFrom']));
                $sql -> where("JSON_UNQUOTE(JSON_EXTRACT(p.gensoft_json, '$.dateStokaChanged')) >=", $dateFrom);
            }

            // Филтър по дата ДО
            if (!empty($data['gensoftDateTo'])) {
                $dateTo = date('d-m-Y', strtotime($data['gensoftDateTo']));
                $sql -> where("JSON_UNQUOTE(JSON_EXTRACT(p.gensoft_json, '$.dateStokaChanged')) <=", $dateTo);
            }
        }

        // Изключване на определени продукти
        if (!empty($data['notInProductIds'])) {
            $sql -> whereNotIn('p.product_id', $data['notInProductIds']);
        }

        if (!empty($data['limit'])) {
            $sql -> limit($data['limit']['per_page'], $data['limit']['offset']);
        }
//dd($sql -> get() -> getResultArray());
        // d($data);
        // dd($sql -> getCompiledSelect());
        return $sql -> get() -> getResultArray();
    }

    public function get_category() {
        return $this -> db -> table(self::TBL_CATEGORY)
                        -> where('parent_id', null)
                        -> get() -> getResultArray();
    }

    // ако търсим продукт показва в коя ценова листа или промоция се намира само
    public function is__product_in_zenovaOrPromo($ctrl = '', $arg = '', $search = []) {

        $mapping = [
            'zenova' => [
                'joinTable'  => self::TBL_PRODUCT_IN_ZENOVALISTA,
                'offerTable' => self::TBL_ZENOVA_LISTA,
                'offerColId' => 'zenovaLista_id',
            ],
            'promo'  => [
                'joinTable'  => $arg === 'D' ? self::TBL_PRODUCT_IN_PROMOLISTA : self::TBL_PRODUCT_IN_PROMOKL,
                'offerTable' => $arg === 'D' ? self::TBL_PROMO : self::TBL_PROMOKL,
                'offerColId' => 'promoLista_id',
            ],
        ];

        if (!isset($mapping[$ctrl])) {
            return [];
        }

        $config = $mapping[$ctrl];

        // ако е промо проверяваме дали продукта го има в някоя ценова листа
        if ($ctrl == 'promo') {
            $existProduct = $this -> db -> table(self::TBL_PRODUCT . ' p')
                            -> select('p.product_name,z.zenovaLista_id')
                            -> join(self::TBL_PRODUCT_IN_ZENOVALISTA . ' z', 'product_id', 'left')
                            -> groupStart()
                            -> where($search['sqlCol'], $search['name'])
                            -> orWhere('gensoft_productName', $search['name'])
                            -> groupEnd()
                            -> limit(1)
                            -> get() -> getRow();

            if (!$existProduct || !$existProduct -> zenovaLista_id) {
                return $existProduct ? 'notInZenovaLista' : [];
            }
        }

        $query = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> select('p.gensoft_productName,p.product_name, o.*')
                -> join($config['joinTable'] . ' o', 'product_id', 'left');
        //-> join(self::TBL_CATEGORY . ' c', 'c.category_id = p.categoryRoot_id', 'left');

        if (isset($search['sqlCol'], $search['name'])) {
            $query -> groupStart()
                    -> like($search['sqlCol'], $search['name'], 'both')
                    -> orLike('gensoft_productName', $search['name'], 'both')
                    -> groupEnd();
        } elseif (isset($search['category_id'])) {
            $query -> where('p.category_id', $search['category_id']);
        }

        // Execute the query and get the results
        $results = $query -> get() -> getResultArray();

        // Check for exact match first
        foreach ($results as $result) {
            if (strcasecmp($result['gensoft_productName'], $search['name']) === 0 || strcasecmp($result['product_name'], $search['name']) === 0) {
                $offerId = $result[$config['offerColId']] ?? null;

                if ($offerId) {
                    $offer = $this -> db -> table($config['offerTable'])
                                    -> where('id', $offerId)
                                    -> get() -> getRow();

                    return $offer -> offersName ?? '';
                }

                return '';
            }
        }

        // Group results
        $groupedResults = [];
        foreach ($results as $result) {
            $offerId = $result[$config['offerColId']] ?? null;

            if ($offerId) {
                if (!isset($groupedResults[$offerId])) {
                    $offer = $this -> db -> table($config['offerTable'])
                                    -> where('id', $offerId)
                                    -> get() -> getRow();

                    $groupedResults[$offerId] = [
                        'offer_name' => $offer -> offersName ?? '',
                        'products'   => [],
                    ];
                }
                $groupedResults[$offerId]['products'][] = $result;
            }
        }

        return $groupedResults;
    }

    // след като сме избрали продуктите се добавят към офетата
    function generateTable($productId_arr) {

        $sql = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> select('*,cenaKKC as nivo')
                -> join(self::TBL_BRAND . ' b', 'brand_id', 'left')
                -> join('(SELECT model_id,model FROM ' . self::TBL_MODEL . ' ) as pm', 'pm.model_id=p.model_id', 'left')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' sp', 'product_id', 'left')
                -> whereIn('p.product_id', $productId_arr);

        if ($_ENV['app.gensoftEnable']) {
            $sql -> where('p.gensoft_item_id is not null');
        }

        return $sql -> get() -> getResultArray();
    }

    // общ брой на продуктите
    public function count_productAll($data = null) {
        $sql = $this -> db -> table(self::TBL_PRODUCT . ' p');

        // Филтър за 'zenova' и 'promo' с условен JOIN
        if (!empty($data['ctrl']) && in_array($data['ctrl'], ['zenova', 'promo'])) {
            match ($data['ctrl']) {
                'promo' => $sql
                        -> join(self::TBL_PRODUCT_IN_ZENOVALISTA . ' z', 'product_id', 'inner')
                        -> join(($data['arg'] === 'D' ? self::TBL_PRODUCT_IN_PROMOLISTA : self::TBL_PRODUCT_IN_PROMOKL) . ' pz', 'product_id', 'left')
                        -> where('pz.product_id IS NULL'),
                'zenova' => $sql
                        -> join(self::TBL_PRODUCT_IN_ZENOVALISTA . ' pz', 'product_id', 'left')
                        -> where('pz.product_id IS NULL'),
                default => null
            };
        }

        // Филтър за 'gensoft_item_id', ако е разрешено
        if ($_ENV['app.gensoftEnable']) {
            $sql -> where('p.gensoft_item_id is not null');
        }

        // Филтър по име или колона
        if (!empty($data['sqlCol']) && !empty($data['name'])) {
            $sql -> groupStart();

            if ($data['sqlCol'] === 'product_name') {
                $productName = explode(' ', $data['name']);

                foreach ($productName as $pName) {
                    $sql -> groupStart();
                    $sql -> like($data['sqlCol'], $pName, 'both')
                            -> orLike('gensoft_productName', $pName, 'both');
                    $sql -> groupEnd();
                }
            } else {
                $sql -> like($data['sqlCol'], $data['name'], 'both');
            }

            $sql -> groupEnd();
        }

        // филтър по мулти категории
        if (!empty($data['selectedCatIds'])) {
            $rootCatIds = $data['selectedCatIds']['rootCat_ids'] ?? [];
            $subCatIds  = $data['selectedCatIds']['subCat_ids'] ?? [];

            if (!empty($subCatIds)) {
                $sql -> whereIn('p.category_id', $subCatIds);
            } elseif (!empty($rootCatIds)) {
                $sql -> whereIn('p.categoryRoot_id', $rootCatIds);
            }
        }

        // Филтър по наличност
        if (!empty($data['inStock'])) {
            $sql -> where('p.nalichnost > 0');
        }

        // Филтър за промоции
        if (!empty($data['hasGensoftPromo'])) {
            $sql -> where("JSON_EXTRACT(p.gensoft_json, '$.promoPercent') IS NOT NULL")
                    -> where("JSON_EXTRACT(p.gensoft_json, '$.KKC') IS NOT NULL");
        }

        // Филтър по gensoft групи
        if (!empty($data['gensoftGroups'])) {
            $sql -> whereIn("JSON_UNQUOTE(JSON_EXTRACT(p.gensoft_json, '$.grupa'))", $data['gensoftGroups'])
                    -> where("JSON_UNQUOTE(JSON_EXTRACT(p.gensoft_json, '$.sklad'))", $data['gensoftSkladName']);

            // Филтър по дата ОТ
            if (!empty($data['gensoftDateFrom'])) {
                $sql -> where("JSON_UNQUOTE(JSON_EXTRACT(p.gensoft_json, '$.dateCreate')) >=", $data['gensoftDateFrom']);
            }

            // Филтър по дата ДО
            if (!empty($data['gensoftDateTo'])) {
                $sql -> where("JSON_UNQUOTE(JSON_EXTRACT(p.gensoft_json, '$.dateCreate')) <=", $data['gensoftDateTo']);
            }
        }

        // Специфични условия за поръчка
        if (!empty($data['ctrl']) && $data['ctrl'] == 'order') {

            match ($data['arg']) {
                'site', 'L', 'K', 'F', 'N' =>
                        $sql -> join(self::TBL_PRODUCT_SITES . ' ps', 'product_id', 'left')
                        -> groupBy('p.product_id'),
            //-> where('ps.sp_site_id', $_ENV['app.localSite'])
//                'sklad' => $sql -> groupStart()
//                        -> where(sprintf("(JSON_UNQUOTE(JSON_EXTRACT(`gensoft_json`, '$.sklad')) IN (%s, %s))", $_ENV['app.baseSklad'], $_ENV['app.sklad2'])),
//                'bravas' =>
//                $sql -> where("JSON_UNQUOTE(JSON_EXTRACT(`gensoft_json`, '$.bravas'))", 1)
            };
        }

        if (!empty($data['notInProductIds'])) {
            $sql -> whereNotIn('p.product_id', $data['notInProductIds']);
        }

        //dd($sql -> getCompiledSelect());
        return $sql -> countAllResults();
    }

    public function save_products_to_ofers($id = null, $arr = []) {

        if (is_numeric($id)) {

            $table = match ($arr['ctrl']) {
                'zenova' => self::TBL_ZENOVA_LISTA,
                'promo' => self::TBL_PROMO,
                default => null
            };

            $old = $this -> db -> table(self::TABLES[$table])
                            -> select('productsID')
                            -> get() -> getRow('productsID');

            // обединяване
            $ids = array_unique(array_merge(
                            $old ? explode(',', $old) : [],
                            $arr['productIds']));

            $this -> db -> transStart();

            $this -> db -> table(self::TABLES[$table])
                    -> where('id', $id)
                    -> update(['productsID' => implode(',', $ids)]);

            $this -> db -> transComplete();
        }
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));

    
