<?php

namespace App\Modules\popupForm\Models\product;

use \App\Models\BaseModel as BaseModel;

class MODELpop__returnOrder extends BaseModel {

    public function get__products_fromOrder($orderId = null) {

        $extractedKeys = $this -> db -> table(self::TBL_ORDER)
                        -> select('JSON_KEYS(JSON_UNQUOTE(JSON_EXTRACT(product_json, "$"))) AS product_keys')
                        -> where('order_id', $orderId)
                        -> get() -> getFirstRow();

        $productIds = implode(',', json_decode($extractedKeys -> product_keys ?? '[]', true));

        $sql = $this -> db -> table(self::TBL_ORDER . ' as o')
                        -> join(self::TBL_PRODUCT . ' p', "FIND_IN_SET(p.product_id, '$productIds')", 'left')
                        -> where('o.order_id', $orderId)
                        -> get() -> getResultArray();

        return $sql;
    }

    public function save_return($data = []) {

        if (empty($data)) {
            return;
        }

        $filteredProduct = array_filter($data['product_json'], function ($item) {
            return !empty($item['returnQty']);
        });

        if (empty($filteredProduct)) {
            return;
        }

        foreach ($data['product_json'] as $k => &$v) {
            if (!empty($v['returnQty'])) {
                $v['qty'] -= $v['returnQty'];
            }

            // Remove item if qty is 0 or below
            if ($v['qty'] <= 0) {
                unset($data['product_json'][$k]);
            }

            unset($data['product_json'][$k]['returnQty']);
        }

        $builder = $this -> db -> table(self::TBL_PRODUCT);

        $product_json = json_encode($data['product_json']);

        $data['product_json'] = json_encode($filteredProduct);
        $this -> db -> table(self::TBL_ORDERRETURN) -> upsert($data);

        $this -> db -> table(self::TBL_ORDER)
                -> set('product_json', $product_json)
                -> where('order_id', $data['order_id'])
                -> update();

        // връщаме колич. което е поръчано
        foreach ($filteredProduct as $k => $v) {
            $builder -> set('nalichnost', "nalichnost + {$v['qty']}", false)
                    -> where('product_id', $k)
                    -> where('gensoft_item_id is null')
                    -> update();
        }
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
