<?php

namespace App\Modules\popupForm\Models\product;

use \App\Models\BaseModel as BaseModel;

class MODELpop__toSite extends BaseModel {

    public function get__productList_by_ids($productIds = []) {
        $query = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> select('p.product_id, p.product_name, p.image')
                -> whereIn('p.product_id', $productIds);

        return $query -> get() -> getResultArray();
    }

    public function get__product_to_siteData($productIds = []) {
        $query = $this -> db -> table(self::TBL_PRODUCT_SITES . ' ps')
                -> whereIn('ps.product_id', $productIds);

        return $query -> get() -> getResultArray();
    }

    public function save_data($addToSite = [], $removeFromSite = []) {

        $this -> db -> transStart();

        // когато премахване от сайт
        if (!empty($removeFromSite)) {
            $this -> db -> table(self::TBL_PRODUCT_SITES)
                    -> setData($removeFromSite, true, 'del')
                    -> onConstraint('product_id, sp_site_id')
                    -> deleteBatch();

            // премахване на продуктите от незапазените поръчки
            $removedPrId = array_column($removeFromSite, 'product_id');
            $json_paths  = array_map(function ($key) {
                return "'" . '$.' . $key . "'";
            }, $removedPrId);
    
            $this -> db -> query("UPDATE " . self::TBL_ORDERCART . " 
        SET product_json = JSON_REMOVE(product_json, " . implode(', ', $json_paths) . ") 
        WHERE " . implode(' OR ', array_map(function ($key) {
                                return "JSON_CONTAINS_PATH(product_json, 'one', '$." . $key . "')";
                            }, $removedPrId)));
        }

        // когато добавяме към сайт
        if (!empty($addToSite)) {
            $this -> db -> table(self::TBL_PRODUCT_SITES) -> upsertBatch($addToSite);
        }

        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            $response['message'] = 'Грешка при изпълнение на sql заявката';
        } else {
            $response['message'] = 'Продуктите към сайт са обновени';
        }


        return $response;
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
