<?php

namespace App\Modules\popupForm\Models\product;

use \App\Models\BaseModel as BaseModel;

class MODELpop__zenoobr extends BaseModel {

    public function get_ofer_by_id($id = null) {
        return $this -> db -> table(self::TBL_ZENOVA_LISTA)
                        -> where('id', $id)
                        -> get() -> getRow();
    }

    // изв на продуктите които са в заявката в модал ф. ценообразуване
    public function get_products($productId_arr = []) {

        $t = $this -> db -> table(self::TBL_PRODUCT . ' p')
                        -> select("*, IF(o.klientIds_to_cenaIndiv IS NOT NULL, 
                CONCAT('[', GROUP_CONCAT(JSON_OBJECT('id', k.klient_id, 'name', k.klient_name)), ']'), NULL) AS klient_names")
                        -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' o', 'product_id', 'left')
                        -> join("(SELECT klient_id, klient_name FROM " . self::TBL_KLIENT . ' ) as k', 'FIND_IN_SET(k.klient_id, o.klientIds_to_cenaIndiv)', 'left')
                        -> whereIn('p.product_id', $productId_arr)
                        -> groupBy('p.product_id')
                        -> orderBy('FIELD(p.product_id,' . implode(',', $productId_arr) . ')')
                        -> get() -> getResultArray();

        return $t;
    }

    // обновяване на продукт от модал ф. ценообр.
    public function save_zenoobr($urlParams = [], $data = []) {
        $this -> db -> table(self::TBL_ZENOVA_LISTA)
                -> set('zonoobrPercent_json', $data['zonoobrPercent_json'])
                -> set('chk_zonoobr', $data['chk_zonoobr'])
                -> set('isRoundedToFirst', $data['isRoundedToFirst'] ?? NULL)
                -> where('id', $urlParams['id'])
                -> update();

        // обновяване/или нов запис на цени
        $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL) -> upsertBatch($data['product']);
    }

    // индивидуално ценообр.
    public function save_zenoobrIndiv($urlParams = [], $data = []) {


        $existingPercent_json = json_decode(
                        $this -> db -> table(self::TBL_ZENOVA_LISTA)
                                -> select('zonoobrPercent_json')
                                -> where('id', $urlParams['id'])
                                -> get() -> getRowArray()['zonoobrPercent_json'] ?? '[]',
                                         true
                ) ?: [];

        $zonoobrPercent_json = json_decode($data['zonoobrPercent_json'] ?? '[]', true) ?: [];

        unset($existingPercent_json['indiv']);

        $updatedPercent = empty($zonoobrPercent_json['indiv']['p']) ? $existingPercent_json : array_merge($existingPercent_json, $zonoobrPercent_json);

        $this -> db -> table(self::TBL_ZENOVA_LISTA)
                -> set('zonoobrPercent_json', json_encode($updatedPercent))
                -> where('id', $urlParams['id'])
                -> update();

        $klientIds = !empty($data['klientIds']) ? implode(',', $data['klientIds']) : NULL;
        foreach ($data['product'] as &$val) {
            $val['klientIds_to_cenaIndiv'] = $klientIds;
        }

        // обновяване/или нов запис на цени
        $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL) -> upsertBatch($data['product']);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
