<?php

namespace App\Modules\popupForm\Models\product;

use \App\Models\BaseModel as BaseModel;

class MODELpop__zenovaLista extends BaseModel {

    public function moveProduct($productId = null, $curentZenovaId = null, $zenovaId = null) {

        $this -> db -> transStart();

        // 1. Прехвърляне на продукта към новата Zenova листа
        $this -> db -> table(self::TBL_PRODUCT_IN_ZENOVALISTA)
                -> set('zenovaLista_id', $zenovaId)
                -> where('product_id', $productId)
                -> update();

        // 2. Премахване на продукта от старата Zenova листа
        $this -> db -> table(self::TBL_ZENOVA_LISTA)
                -> set('productsID', "TRIM(BOTH ',' FROM REPLACE(CONCAT(',', productsID, ','), ',$productId,', ','))", false)
                -> where('id', $curentZenovaId)
                -> update();

        // 3. Добавяне на продукта към новата Zenova листа (само ако не съществува)
        $this -> db -> table(self::TBL_ZENOVA_LISTA)
                -> set('productsID',
                       "CASE WHEN FIND_IN_SET($productId, productsID) = 0 OR productsID = '' THEN TRIM(BOTH ',' FROM CONCAT(productsID, ',', $productId)) ELSE productsID END", false)
                -> where('id', $zenovaId)
                -> update();

        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            return ['err' => 'Грешка: при изпълнение на sql заявката'];
        }

        return true;
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
