<?php

namespace App\Modules\popupForm\Models\spisak;

use \App\Models\BaseModel as BaseModel;

class MODELpop__category extends BaseModel {

    public function get__categoryById(int $id): ?array {
        if (empty($id)) {
            return null;
        }

        $row = $this -> db -> table(self::TBL_CATEGORY)
                        -> where('category_id', $id)
                        -> get() -> getRowArray();

        return $row ?: null;
    }

    public function get__category() {
        $categories = $this -> db -> table(self::TBL_CATEGORY)
                        -> where('parent_id', null)
                        -> orderBy('category_position', 'ASC')
                        -> get() -> getResultArray();

        foreach ($categories as &$category) {
            // дали главната категория има подкатегории
            $hasChild = $this -> db
                    -> table(self::TBL_CATEGORY)
                    -> where('parent_id', $category['category_id'])
                    -> limit(1)
                    -> countAllResults();

            if ($hasChild) {
                $category['isChildren'] = 1;
            }
        }

        return $categories;
    }

    // извл на продуктите спрямо подкатегорията за подредба в сайт
    // ----------------------------------------------------------
    public function get__subCategory($id = null, $column = null) {

        $query = $this -> db -> table(self::TBL_CATEGORY)
                        -> where('parent_id IS NOT NULL')
                        -> orderBy('ISNULL(category_position)')
                        -> orderBy('category_position', 'ASC')
                        -> get() -> getResultArray();

        return $query;
    }

    /**
     * Change category parent and place it at the end of the new parent's order
     */
    public function changeParent($id, $parentId) {
        // Get max position under the new parent
        $maxPos = $this -> db -> table(self::TBL_CATEGORY)
                        -> where('parent_id', $parentId)
                        -> selectMax('category_position')
                        -> get() -> getRow() -> category_position ?? 0;

    
        return $this -> db -> table(self::TBL_CATEGORY)
                        -> where('category_id', $id)
                        -> update([
                            'parent_id'         => $parentId,
                            'category_position' => $maxPos + 1,
        ]);
    }

    public function set__position($positionArr = null) {
        if (empty($positionArr)) {
            return;
        }
        $data = [];


        foreach ($positionArr as $row) {
            $data[] = [
                'category_id'       => (int) $row['id'],
                'category_position' => (int) $row['position'],
            ];
        }

        $this -> db -> table(self::TBL_CATEGORY)
                //-> onConstraint('category_id')
                -> updateBatch($data, 'category_id');
    }

    public function set__image($data = []) {

        if (empty($data['category_id'])) {
            return ['err' => 'Липсва id на категорията.']; // или хвърли грешка
        }

        return $this -> db -> table(self::TBL_CATEGORY)
                        -> where('category_id', $data['category_id'])
                        -> set('image_cat', $data['image_cat'])
                        -> update();
    }

    public function save_category($data = [], $isRoot = 0) {
        $msg = $isRoot ? "Главната категория с име: {$data['category_name']} вече съществува." : "Категорията с име {$data['category_name']} вече съществува.";

        $this -> db -> transStart();

        $existing = $this -> db
                -> table(self::TBL_CATEGORY)
                -> where('LOWER(category_name)', mb_strtolower($data['category_name']))
                -> countAllResults();

        if ($existing > 0) {
            $this -> db -> transRollback();
            return $this -> dbError($msg);
        }

        $this -> db -> table(self::TBL_CATEGORY) -> upsert($data);

        if (!$this -> db -> transStatus()) {
            return $this -> dbError($msg);
        }

        $this -> db -> transComplete();
        return true;
    }

    public function remove($id = null) {
        $conditions = $id ? ['category_id' => $id, 'parent_id' => $id] : null;

        return $this -> deleteFromTable(self::TBL_CATEGORY, $conditions);
    }

    public function removeCatAttr($id = null) {
        $conditions = $id ? ['category_characteristic_id' => $id] : null;
        return $this -> deleteFromTable(self::TBL_CATEGORY_ATTRIBUTE, $conditions);
    }

    private function deleteFromTable($table, $conditions) {
        if (!$conditions) {
            return false;
        }

        // Проверка за всички наследници (деца, внуци, ...)
        $sql = " WITH RECURSIVE descendants AS (
                          SELECT category_id FROM _category WHERE parent_id = ?
                          UNION ALL
                          SELECT c.category_id FROM _category c
                          INNER JOIN descendants d ON c.parent_id = d.category_id
                        )
                        SELECT COUNT(*) as totalDescendants FROM descendants
                      ";

        $result = $this -> db -> query($sql, [$conditions['category_id']]) -> getRow();

        // Ако има подкатегории 
        if ($result -> totalDescendants > 0) {
            return ['err' => 'Категорията има вложени подкатегории и не може да бъде изтрита. Изтрий първо всички вътрешни подкатегории!'];
        }

        $this -> db -> transStart();

        $affectedRows = $this -> db -> table($table)
                -> orWhere($conditions)
                -> delete();

        if (!$this -> db -> transStatus()) {
            $msg = "SQL Грешка при изтриване от таблица $table: ";
            return $this -> dbError($msg);
        }
        $this -> db -> transComplete();
        return $affectedRows > 0;
        ;
    }

}
