<?php

namespace App\Modules\popupForm\Models\spisak;

use \App\Models\BaseModel as BaseModel;

class MODELpop__klient extends BaseModel {

    public function get__klient($id = '') {

        if (is_numeric($id)) {
            return $this -> db -> table(self::TBL_KLIENT . ' k')
                    ->select('k.*,us.is_password_changed,us.password')
                            -> join(self::TBL_USERSITE . ' us', 'us.id=k.klient_id', 'left')
                            -> where('klient_id', $id)
                            -> get() -> getRow();
        }
    }

    // обновяване или нулиране на парола на клиент в портал сайт
    public function reset_update_password($klientId = null, $action = null, $password = null) {
        if (empty($klientId) || !in_array($action, ['reset', 'new'])) {
            return false;
        }
        $data = [];
        if ($action === 'reset') {
            $data = [
                'is_password_changed' => NULL,
                'password'            => '$2y$10$5LgEvBI3y66/uPJgG8Zw8.Eul0Wpw2nQ4rZCzOk455SxHOvJmc8sW',
            ];
        } elseif ($action === 'new') {

            $data = [
                'is_password_changed' => 1,
                'password'            => password_hash($password, PASSWORD_DEFAULT),
            ];
        }

        if (!empty($data)) {
            return $this -> db -> table(self::TBL_USERSITE)
                            -> where('id', $klientId)
                            -> update($data);
        }

        return false; // Return false if nothing was updated
    }

    public function save_klient($data = []) {
        return $this -> db -> table(self::TBL_KLIENT) -> upsert($data);
    }

//    public function remove_klient($id) {
//        if ($id) {
//            $delete = $this -> db -> table($this -> tbl_category)
//                    -> where('category_id', $id)
//                    -> delete();
//
//            // изтриване на подкатегориите към дадена категория
//            $this -> db -> table($this -> tbl_category)
//                    -> where('parent_id', $id)
//                    -> delete();
//
//            return ($delete == true) ? true : false;
//        }
//    }
}
