<?php

namespace App\Modules\popupForm\Models\spisak;

use \App\Models\BaseModel as BaseModel;

class MODELpop__shablon extends BaseModel {

    // извл на имената на шаблoни в модал ф. select box
    // -------------------------------------------------
    function get__shablonName() {
        return $this -> db -> table(self::TBL_SHABLON)
                        -> select('shablon_id,shablon_name')
                        -> orderBy('shablon_name', 'ASC')
                        -> get() -> getResultArray();
    }

    // get шаблoн по id
    // -------------------------------------------------
    function get__shablon_by_id($id) {
        return $this -> db -> table(self::TBL_SHABLON)
                        -> select('*')
                        -> where('shablon_id', $id)
                        -> get() -> getRow();
    }

    // save шаблoн
    // -------------------------------------------------
    function save_shablon($data = []) {

        $sql = $this -> db -> table(self::TBL_SHABLON) -> upsert($data);

        if ($sql == 1) {
            return $this -> db -> insertID();
        }
    }

    function update_shablonName($data = []) {
        return $this -> db -> table(self::TBL_SHABLON) -> upsert($data);
    }

    // delete шаблoн
    // -------------------------------------------------
    function copy_shablon($data = []) {
        $clone_row = $this -> db -> table(self::TBL_SHABLON)
                        -> select('*')
                        -> where('shablon_id', $data['id'])
                        -> get() -> getRow();

        unset($clone_row -> shablon_id);

        $clone_row -> shablon_name = $data['shablonName'];
        $this -> db -> table(self::TBL_SHABLON) -> insert((array) $clone_row);

        return $this -> db -> insertID();
    }

    // delete шаблoн
    function delete_shablon($id) {
        $this -> db -> table(self::TBL_SHABLON) -> delete(['shablon_id' => $id]);
    }

}
