<?php
$settingsService = (object) service('settings') -> get('App.general');

$preval   = $settingsService -> preval ?? [];
$currency = $preval['base_currency'] ?? 'BGN';


$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв',
};

$_json_tavaritelniza = json_decode($order -> tovaritelniza_json ?? '[]', true);
$_tovaritelnizaNo    = $order -> tavaritelniza_no ?? '';

$_title = empty($_tovaritelnizaNo) ? "Генериране на товарителница" : "Редакция на товарителница № $_tovaritelnizaNo";
?>

<div class="modal fade" id="modal_generateTovaritelniza" tabindex="-1"  data-backdrop="static" data-keyboard="false" role="dialog" aria-hidden="true" style="z-index: 1111111">

    <!-- --- ЗАРЕЖДАНЕ НА CSS ОТ CONTROLLER --- -->
    <?php if (isset($addCSS) && is_array($addCSS)) { ?>
        <?php foreach ($addCSS as $css) { ?>
            <link rel="stylesheet" type="text/css" href="<?= auto('assets/' . $css . '.css'); ?>">
        <?php } ?>
    <?php } ?>

    <div class="modal-dialog modal-dialog-centered w-50 mw-100 m-auto" role="document">
        <div class="css-background css-box-shadow modal-content">
            <div class="css-background py-1 css-rounded-16 modal-header py-1">
                <a class="mr-5 pr-4" href="http://www.econt.bg" style="position: relative;top: -5px;">
                    <img src="/assets/images/curier/EcontLogo.png" alt="econt">
                </a>

                <?= "<h4 class='col modal-title'>$_title</h4>" ?>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body overflow-auto" style="height: calc(100vh - 200px);">
                <form id="form-curier" name="form-curier" method="post" role="form" spellcheck="false" action="<?= $form ?>">
                    <input type="hidden" name="tovaritelnizaNo" value="<?= $_tovaritelnizaNo ?>">
                    <input type="hidden" name="orderTip" value="<?= $orderTip ?>">
                    <input type="hidden" name="orderId" value="<?= $order -> order_id ?>">

                    <input type="hidden" name="client[liceKont]" value="<?= !empty($order -> klient_name) ? $deliveryObekt['liceKont'] : '' ?>">
                    <input type="hidden" name="client[name]" value="<?= $order -> klient_name ?? $deliveryObekt['liceKont'] ?>">
                    <input type="hidden" name="client[phone][]" value="<?= $deliveryObekt['tel'] ?>">
                    <input type="hidden" name="adres[quarter][name]" value="<?= $deliveryObekt['kvartal'] ?>">
                    <input type="hidden" name="adres[street][name]" value="<?= $deliveryObekt['ulica'] ?>">
                    <input type="hidden" name="adres[street][num]" value="<?= $deliveryObekt['ulicaNo'] ?>">
                    <input type="hidden" name="adres[other]" value="<?= $deliveryObekt['other'] ?>">
                    <input type="hidden" name="receiverOfficeCode" value="<?php
                    if (preg_match('/\d+(\.\d+)?/', $deliveryObekt['ofis'], $matches)) {
                        echo $matches[0];
                    }
                    ?>">

                    <input type="hidden" name="ofisName" value="<?= preg_replace('/^\d+(\.\d+)?\s*/', '', $deliveryObekt['ofis']) ?>">

                    <input type="hidden" name="shipping_code" value="<?= $deliveryObekt['izborKurier'] ?>">

                    <input id="isOfice" type="hidden" name="isOfice" value="<?= $deliveryObekt['isOfice'] ? 1 : 0 ?>">
                    <div class="col">
                        <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #4238ca;" >
                            <legend class="akrobatExtraBold">Данни за подател</legend>

                            <div class="row">
                                <span class="col-3">Име/фирма<b class="text-danger" style="font-size: 20px">*</b></span>

                                <p class="col akrobatBold mb-1">
                                    <select class="css-dropdown-p css-focus-strong css-border-none fw-600 w-100" name="profilSender">
                                        <?php
                                        foreach ($profilSender as $k => $name):
                                            $_selectedS = ($_json_tavaritelniza['profilSender'] ?? $settingsService -> econtSender ?? '') == $k ? 'selected' : '';
                                            ?>
                                            <option value="<?= $k ?>" <?= $_selectedS ?>><?= $name['client']['name'] ?></option>
                                        <?php endforeach ?>
                                    </select>
                                </p> 

                                <p class="col akrobatBold mb-1"> 
                                    <?php
                                    $_clientNumber = $profilSender[0]['client']['clientNumber'];
                                    echo $_clientNumber ? 'Клиентски номер:' . $_clientNumber : ''
                                    ?>
                                </p> 
                            </div>

                            <div class="row">
                                <span class="col-3">Упълномощено лице</span>

                                <p class="col akrobatBold mb-1">
                                    <select class="css-dropdown-p css-focus-strong css-border-none fw-600 w-100" name="profilAgents">
                                        <?php
                                        foreach ($profilAgents as $k => $val):
                                            if ($val['value'] != ''):
                                                $_selectedA = ($_json_tavaritelniza['profilAgents'] ?? $settingsService -> econtAgent ?? '') == $k ? 'selected' : '';
                                                ?>
                                                <option value="<?= $k ?>" <?= $_selectedA ?>><?= $val['value'] ?></option>
                                            <?php endif ?>
                                        <?php endforeach ?>
                                    </select>
                                </p> 
                            </div>

                            <div class="row">
                                <span class="col-3">Пращане на пратка</span>

                                <div class="col mb-1">
                                    <select id="sendFrom" class="css-dropdown-p css-focus-strong css-border-none fw-600 w-100" name="sendFrom">
                                        <option value="fromDoor" <?= ($_json_tavaritelniza['sendFrom'] ?? '') === 'fromDoor' ? 'selected' : '' ?>>от врата</option>
                                        <option value="" <?= empty($_json_tavaritelniza['sendFrom']) ? 'selected' : '' ?>>от офис на куриер</option>
                                    </select>
                                </div>
                            </div>

                            <div id="officeLocatorRow" class="row <?= ($_json_tavaritelniza['sendFrom'] ?? '') == 'fromDoor' ? 'hide' : '' ?>">
                                <span class="col-3">Адрес офис на куриер<b class="text-danger" style="font-size: 20px">*</b></span>

                                <div class="col mb-1">
                                    <input class="izborOfice validate fw-600 pointer-events-none" name="senderOfficeCode" data-name="Изберете бутона Еконт офис локатор от данни за подадтел" value="<?= $settingsService -> econtOfis ?? '' ?>">
                                </div>
                            </div>

                            <div class="row p-2">
                                <button id="econtLocator" class="btn round-10 bg-secondary fa fa-map-marker" type="button">&nbsp;Еконт офис локатор</button>
                            </div>

                            <div id="senderAdresRow" class="row <?= ($_json_tavaritelniza['sendFrom'] ?? '') == 'fromDoor' ? '' : 'hide' ?>">
                                <span class="col-3">Адрес на пратката</span>
                                <div class="col mb-1">
                                    <select class="css-dropdown-p css-focus-strong css-border-none fw-600 w-100" name="senderAdres">
                                        <?php foreach ($profilSender as $client): ?>
                                            <?php
                                            foreach ($client['addresses'] as $k => $adr):
                                                $adrName  = $adr['city']['name'];
                                                $_ul      = $adr['street'];
                                                $_ulN     = $adr['num'];
                                                $_kv      = $adr['quarter'];
                                                $_fullAdr = '';

                                                if (empty($_ul)) {
                                                    $_fullAdr = $adrName . ' ' . $_kv;
                                                } else {
                                                    $_fullAdr = $adrName . ' ' . $_ul . ' ' . $_ulN;
                                                }
                                                ?>
                                                <option value="<?= $k ?>"><?= $_fullAdr ?></option>
                                            <?php endforeach ?>
                                        <?php endforeach ?>
                                    </select>
                                </div>
                            </div>
                        </fieldset>   

                        <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #4238ca;" >
                            <legend class="akrobatExtraBold">Данни за получател</legend>

                            <div class="row">
                                <span class="col-3">Име /Фирма<b class="text-red">*</b></span>
                                <p class="col akrobatBold mb-1">
                                    <?= $order -> klient_name ?? $deliveryObekt['liceKont'] ?>
                                </p>  
                            </div>

                            <div class="row">
                                <span class="col-3">Упълномощено лице<b class="text-red">*</b></span>
                                <p class="col akrobatBold mb-1">
                                    <?= !empty($order -> klient_name) ? $deliveryObekt['liceKont'] : '---' ?>
                                </p>  
                            </div>

                            <div class="row">
                                <span class="col-3">Телефон<b class="text-red">*</b></span>

                                <p class="col akrobatBold mb-1">
                                    <?= $deliveryObekt['tel'] ?>
                                </p>  
                            </div>

                            <div class="row">
                                <span class="col-3">E-mail</span>
                                <p class="col akrobatBold mb-1"><?= $deliveryObekt['email'] ?? '' ?></p>  
                            </div>

                            <div class="row">
                                <span class="col-3">Населено място</span>

                                <div class="col akrobatBold mb-1">
                                    <input id="city_name" class="w-25 px-0 pointer-events-none" name="adres[city][name]" type="text" value="<?= $deliveryObekt['grad'] ?>" required>
                                </div>  
                            </div>

                            <div class="row">
                                <span class="col-3">Пощенски код</span>
                                <div class="col akrobatBold mb-1">
                                    <input  class="w-25 px-0 pointer-events-none" name="adres[city][postCode]" type="text" value="<?= $deliveryObekt['postCode'] ?>" required>
                                </div>  
                            </div>

                            <div class="toOficeContainer row">
                                <span class="col-3">Доставка до <?=
                                    match ($deliveryObekt['izborKurier']) {
                                        'econt_door' => 'врата:',
                                        'econt_office' => 'офис:',
                                        'econt_machina' => 'автомат (без опция Тествай)'
                                    }
                                    ?>
                                    <b class="text-danger" style="font-size: 20px">*</b>    
                                </span>

                                <p class="col akrobatBold mb-1">
                                    <?php
                                    if ($deliveryObekt['isOfice']) {
                                        echo $deliveryObekt['ofis'];
                                    } else {
                                        echo 'ул.: ' . $deliveryObekt['ulica'] . ' №: ' . $deliveryObekt['ulicaNo'] . ', квартал: ' . $deliveryObekt['kvartal'] . ', блок: ' . $deliveryObekt['blockNo'] . ', вх.: ' . $deliveryObekt['entranceNo'] . ', ет.: ' . $deliveryObekt['floorNo'] . ', ап.: ' . $deliveryObekt['apartmentNo'];
                                    }
                                    ?>
                                </p>  
                            </div>

                            <?php if (empty($deliveryObekt['isOfice'])) { ?>
                                <div class="row">
                                    <span class="col-3">Забележка към адреса:</span>

                                    <div class="col akrobatBold mb-1">
                                        <?= $deliveryObekt['other'] ?>
                                    </div>  
                                </div>
                            <?php } ?>
                        </fieldset>

                        <br>

                        <?php
                        $_pArr        = [];
                        $_totalWeight = 0;
                        $_totalPrice  = 0;

                        foreach ($products as $row) {
                            $_totalWeight += $row['teglo'];
                            $_totalPrice  = $row['total_price'];

                            if (isset($row['product_name']) && $row['product_name'] != '') {
                                $_pArr[] = $row['product_name'];
                            }
                        }
                        ?>

                        <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #4238ca;" >
                            <legend class="akrobatExtraBold">Данни за пратката</legend>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row justify-content-between">
                                        <span class="col-5">Тип на пратката <b class="text-red">*</b></span>
                                        <div class="col-6">
                                            <?php
                                            $_statusOpakovka = $_json_tavaritelniza['opakovka'] ?? 'pack';
                                            ?>

                                            <select id="opakovka" name="opakovka" class="w-100 css-dropdown-p css-focus-strong css-border-none fw-600">
                                                <option value="document" <?= $_statusOpakovka == 'document' ? 'selected' : '' ?>>документ</option>
                                                <option value="pack" <?= $_statusOpakovka == 'pack' ? 'selected' : '' ?>>колет</option>
                                                <option value="post_pack" <?= $_statusOpakovka == 'post_pack' ? 'selected' : '' ?>>пощенска пратка</option>
                                                <option value="pallet" <?= $_statusOpakovka == 'pallet' ? 'selected' : '' ?>>карго палет</option>
                                                <option value="cargo" <?= $_statusOpakovka == 'cargo' ? 'selected' : '' ?>>карго експрес</option>
                                                <option value="documentpallet" <?= $_statusOpakovka == 'documentpallet' ? 'selected' : '' ?>>карго палет + документи</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="row">
                                        <span class="col">Брой пакети <b class="text-red">*</b></span>
                                        <div class="col-4">
                                            <input id="count" class="css-input-p css-focus-strong css-border-none notClear" name="packCount" type="number" data-isbroj value="<?= $_json_tavaritelniza['packCount'] ?? 1 ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="row">
                                        <span class="col">Тегло кг. <b class="text-red">*</b></span>
                                        <div class="col">
                                            <input id="grandWeight" type="text" class="css-input-p css-focus-strong css-border-none" name="grandWeight" data-isnumeric value="<?= sprintf('%0.2f', $_json_tavaritelniza['grandWeight'] ?? ($_totalWeight ?? 1)) ?>" required>
                                        </div>  
                                    </div>
                                </div>
                            </div>

                            <div id="razmerPratkaRow" class="row mt-1 hide">
                                <span class="col-3">Размери на пратка<b class="text-danger" style="font-size: 20px">*</b></span>
                                <div class="col">
                                    <div class="razmerPratkaBlock row">
                                        <div class="mx-2 w-15">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="px-2 py-0 input-group-text">Д</span>
                                                    <input type="text" class="css-input-p css-focus-strong css-border-none" name="totalWeight" data-isnumeric value="120" >
                                                </div>
                                            </div>
                                        </div>

                                        <div class="w-15">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="px-2 py-0 input-group-text">Ш</span>
                                                    <input type="text" class="css-input-p css-focus-strong css-border-none" name="totalWeight" data-isnumeric value="80" >
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mx-2 w-15">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="px-2 py-0 input-group-text">В</span>
                                                    <input type="text" class="css-input-p css-focus-strong css-border-none" name="totalWeight" data-isnumeric value="180" >
                                                </div>
                                            </div>
                                        </div>
                                        см.
                                        <div class="mx-2 col-4">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="px-2 py-0 input-group-text">тегло кг.</span>
                                                    <input type="text" class="cargoWeight css-input-p css-focus-strong css-border-none" name="totalWeight" data-isnumeric value="" >
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-1">
                                <span class="col-3">Описание на съдържанието<b class="text-danger" style="font-size: 20px">*</b></span>

                                <p class="col mb-1">
                                    <textarea class="validate css-input-p css-focus-strong css-border-none fw-600" name="shipmentDescription" data-name="Описание на съдържанието"><?= $_json_tavaritelniza['shipmentDescription'] ?? '' ?></textarea>
                                </p>  
                            </div>

                            <div class="row">
                                <span class="col-3">Пратката е под 60см.</span>
                                <p class="col mb-1">
                                    <input id="sizeUnder60" type="checkbox" class="akrobatBold" name="sizeUnder60cm" <?= empty($_json_tavaritelniza['sizeUnder60cm']) ? '' : 'checked' ?> value="1" disabled><b class="akrobatBold">&nbsp;да</b>
                                </p>  
                            </div>

                            <div class="row">
                                <span class="col-3">Чуплива пратка.</span>
                                <p class="col mb-1">
                                    <input type="checkbox" class="akrobatBold" name="keepUpright" value="1"><b class="akrobatBold">&nbsp;да</b>
                                </p>  
                            </div>
                        </fieldset>

                        <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #4238ca;">
                            <legend class="akrobatExtraBold">Указания</legend>

                            <div class="row mb-1">
                                <span class="col-4">При отказ на пратка</span>

                                <div>
                                    <select id="id2" class="css-dropdown-p css-focus-strong css-border-none fw-600" name="returnParcelPaymentSide">
                                        <option value="Receiver" <?= ($_json_tavaritelniza['returnParcelPaymentSide'] ?? null) == 'Receiver' ? 'selected' : '' ?>>Връщането да за сметка на получателя</option>
                                        <option value="sender" <?= ($_json_tavaritelniza['returnParcelPaymentSide'] ?? null) == 'sender' ? 'selected' : '' ?>>Връщането да е за моя сметка</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row mb-1">
                                <div class="col akrobatBold">

                                    <input type="checkbox" name="isEmailToMe" <?= ($_json_tavaritelniza['isEmailToMe'] ?? null) == '0' ? '' : 'checked' ?> value="1">&nbsp;Имейл към подател при доставка
                                    <input id="email" class="w-40 ml-2 css-input-p css-focus-strong css-border-none" name="emailOnDelivery" type="text" value="<?= $settingsService -> econtAgentEmail ?? ($profilSender[0]['client']['email'] ?? '') ?>">
                                </div>    
                            </div>

                            <div class="row mt-1">
                                <div class="col akrobatBold">
                                    <input class="isCheckTest" type="checkbox" name="check" <?= ($_json_tavaritelniza['check'] ?? null) == '0' ? '' : 'checked' ?> value="1">&nbsp;Преглед
                                    <input class="isCheckTest" type="checkbox" name="test" value="1" <?= ($_json_tavaritelniza['test'] ?? null) == 1 ? 'checked' : '' ?>>&nbsp;Тест
                                </div>  
                            </div>
                        </fieldset>   

                        <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #4238ca;">
                            <legend class="akrobatExtraBold">Допълнителни услуги</legend>

                            <div class="row rowBlock">
                                <span class="col-3">
                                    <input class="isPlatez akrobatBold" name="isCdAmount"  data-name="Обявена стойност" type="checkbox"  <?= ($_json_tavaritelniza['isCdAmount'] ?? null) == 1 ? 'checked' : '' ?> value="1">&nbsp;Обявена стойност <?= $_default_valutaSymbol ?>.
                                </span>

                                <p class="col-2 mb-1">
                                    <input class="css-input-p css-focus-strong css-border-none" name="services[declaredValueAmount]" type="text" data-isnumeric value="<?= $_json_tavaritelniza['declaredValueAmount'] ?? '' ?>">
                                </p>  
                            </div>

                            <div class="row rowBlock">
                                <span class="col-3">
                                    <input id="isNplatez" type="checkbox" class="isPlatez akrobatBold" name="isNplatez" data-name="Наложен платеж" <?= ($_json_tavaritelniza['isNplatez'] ?? null) == 1 ? 'checked' : '' ?> value="1">&nbsp;Наложен платеж  <?= $_default_valutaSymbol ?>.
                                </span>

                                <p class="col-2 mb-1">
                                    <input class="css-input-p css-focus-strong css-border-none" name="services[cdAmount]" type="text" data-isnumeric value="<?= $_json_tavaritelniza['cdAmount'] ?? '' ?>">
                                </p>  

                                <p class="col mb-1">
                                    Начин на изплащане
                                    <?php $_clientCdNumber = $profilSender[0]['cdPayOptions'][0]['num'] ?? '' ?>
                                    <select id="id22" class="css-dropdown-p css-focus-strong css-border-none fw-600" name="cdPayOptions">
                                        <option value="">в брой</option>
                                        <?php
                                        if (!empty($_clientCdNumber)) {
                                            echo "<option value='{$_clientCdNumber}'>{$_clientCdNumber}</option>";
                                        }
                                        ?>
                                    </select>
                                </p>  
                            </div>

                            <div class="row justify-content-end">
                                <button id="calculateDostavka" class="btn round-10 btn-info" data-route="<?= route_to('ApiQurier-apiCalculateDostavka', $deliveryObekt['izborKurier'] ?? '') ?>" type="button">Изчисли стойността на доставката</button>

                                <!--  попълване на данните от калкулация на доставката -->
                                <span class="my-auto mx-2"></span>
                            </div>

                            <br>

                            <div>
                                <input id="invoiceBeforePay" type="checkbox" class="akrobatBold" name="invoiceBeforePay" value="1" <?= ($_json_tavaritelniza['invoiceBeforePay'] ?? null) == 1 ? 'checked' : '' ?> disabled> 
                                <b class="akrobatBold">Предай ф-ра преди плащане на наложен платеж</b>
                            </div>

                            <div class="row">
                                <div class="col akrobatBold">
                                    <input type="checkbox" name="sms" <?= ($_json_tavaritelniza['sms'] ?? null) == 1 ? 'checked' : '' ?> value="1" >&nbsp;SMS известяване
                                    <input type="checkbox" name="obrRazpiska" <?= ($_json_tavaritelniza['obrRazpiska'] ?? null) == 1 ? 'checked' : '' ?> value="1">&nbsp;Обратна разписка
                                    <input type="checkbox" name="obrStRazpiska" <?= ($_json_tavaritelniza['obrStRazpiska'] ?? null) == 1 ? 'checked' : '' ?> value="1">&nbsp;Обратна и стокова разписка
                                </div>  
                            </div>

                            <div class="row">
                                <div class="col akrobatBold">
                                    <input type="checkbox" name="signature" <?= ($_json_tavaritelniza['signature'] ?? null) == 1 ? 'checked' : '' ?> value="1">&nbsp;Верни данни и подпис върху документ
                                </div>  
                            </div>

                        </fieldset>

                        <?php if ($deliveryObekt['izborKurier'] == 'econt_door'):
                            ?>
                            <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #4238ca;">
                                <legend class="akrobatExtraBold">Доставка</legend>

                                <div class="row mb-1">
                                    <span class="col-4">Дата на изпращане</span>

                                    <div class="col-3">
                                        <input id="ship_date" type="date" value="<?= date('Y-m-d') ?>">
                                    </div>
                                </div>

                                <div class="row mb-1">
                                    <span class="col-4">Доставка на</span>

                                    <div class="col-3">
                                        <select id="delivery_date" class="w-100" name="delivery_date" data-date="<?= $_json_tavaritelniza['delivery_date'] ?? '' ?>">
                                            <option value="">Изберете дата</option>
                                        </select>
                                    </div>
                                </div>
                            </fieldset>
                        <?php endif ?>

                        <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #4238ca;">
                            <legend class="akrobatExtraBold">Данни за плащане</legend>

                            <div class="row mb-1">
                                <span class="col-5">Плащане <b class="text-red">*</b></span>

                                <div class="col">
                                    <?php
                                    $_whoPay = $settingsService -> econtWhoPay ?? '';

                                    $_whoPayOptions = [
                                        ''                    => '',
                                        'za_smetkaPoluchatel' => 'За сметка на клиент',
                                        'za_smetkaMe'         => 'За сметка на продавач',
                                        'za_smetkaShare'      => 'Споделени разходи за доставка (50% от сумата м/у продавач и клиент)',
                                        'za_smetkaCustom'     => 'Сума на доставка за клиент (споделени разходи м/у продавач и клиент)',
                                    ];

                                    $_selectedPayment = $_json_tavaritelniza['payment'] ?? $settingsService -> econtWhoPay ?? array_key_first($_whoPayOptions);
                                    ?>

                                    <select id="payment" class="validate css-dropdown-p css-focus-strong css-border-none fw-600 w-100" name="payment" data-name="Плащане">

                                        <?php foreach ($_whoPayOptions as $value => $label): ?>
                                            <option value="<?= $value ?>" <?= $_selectedPayment === $value ? 'selected' : '' ?>>
                                                <?= $label ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div id="paymentReceiverRow" class="row <?= $_json_tavaritelniza['payment'] ?? ($_whoPay ?? '') != 'za_smetkaCustom' ? 'hide' : '' ?> mt-1">
                                <span class="col-5">Получател сума  <?= $_default_valutaSymbol ?>.</span>

                                <div class="col-2">
                                    <input class="css-input-p css-focus-strong css-border-none" type="text" name="paymentReceiverValue" value="<?= $_json_tavaritelniza['paymentReceiverValue'] ?? '' ?>">
                                </div>
                            </div>

                            <div id="paymentOptionsRow" class="row my-1  <?= $_json_tavaritelniza['payment'] ?? ($_whoPay ?? '') == 'za_smetkaMe' ? 'hide' : '' ?>">
                                <span class="col-5">Метод на плащане за продавач</span>

                                <select class="css-dropdown-p css-focus-strong css-border-none ml-2 fw-600" name="paymentOptions">
                                    <option value="cash" <?= ($_json_tavaritelniza['paymentOptions'] ?? '') == 'cash' ? 'selected' : '' ?>>в брой</option>
                                    <option value="credit"  <?= ($_json_tavaritelniza['paymentOptions'] ?? '') == 'credit' ? 'selected' : '' ?>>на кредит</option>
                                </select>
                            </div>
                        </fieldset>

                        <!-- Заявка за куриер-->
                        <fieldset id="block_zaqvkaCurier" class="col mb-2" style="background: #f6f8ff; border: 2px solid #4238ca;">
                            <legend class="akrobatExtraBold">Заявка за куриер</legend>

                            <div class="row mb-1">
                                <span class="col-2">Дата на вземане</span>

                                <div class="col-3">
                                    <input id="requestDate" name="requestDate" type="date"  value="<?= date('Y-m-d') ?>">
                                </div>

                                <!-- Часови интервал -->
                                <span>Между:</span>
                                <div class="col">
                                    <!-- От час -->
                                    <?php
                                    date_default_timezone_set('Europe/Sofia');
                                    $now           = new DateTime();
                                    $currentHour   = (int) $now -> format('G');
                                    $currentMinute = (int) $now -> format('i');

                                    echo '<select id="requestHourFrom" name="requestHourFrom" >';
                                    echo('<option value="">Час</option>');

                                    for ($h = 9; $h <= 18; $h++) {
                                        // Ако е днешна дата и часът е в миналото - пропускаме
                                        $_hide = now() && ($h < $currentHour || ($h == $currentHour )) ? 'hide' : '';
                                        printf('<option class="' . ($_hide) . '" value="%02d">%02d</option>', $h, $h);
                                    }
                                    echo '</select>';
                                    ?>

                                    <!-- От минути -->
                                    <select name="requestMinFrom">
                                        <option value="">Минути</option>
                                        <option value="00">00</option>
                                        <option value="15">15</option>
                                        <option value="30">30</option>
                                        <option value="45">45</option>
                                    </select>

                                    <label class="mx-2">и</label>

                                    <!-- До час -->

                                    <?php
                                    date_default_timezone_set('Europe/Sofia');

                                    echo '<select id="requestHourTo" name="requestHourTo" >';
                                    echo('<option value="">Час</option>');

                                    for ($h = 9; $h <= 18; $h++) {
                                        // Ако е днешна дата и часът е в миналото - пропускаме
                                        $_hide = now() && ($h < $currentHour || ($h == $currentHour )) ? 'hide' : '';
                                        printf('<option class="' . ($_hide) . '" value="%02d">%02d</option>', $h, $h);
                                    }
                                    echo '</select>';
                                    ?>

                                    <!-- До минути -->
                                    <select name="requestMinTo">
                                        <option value="">Минути</option>
                                        <option value="00">00</option>
                                        <option value="15">15</option>
                                        <option value="30">30</option>
                                        <option value="45">45</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row col mb-1">     
                                <button id="zaqviCurier" class="btn round-10 btn-primary" type="button"><i class="fa fa-truck"></i>&nbsp;Заяви куриер</button>
                            </div>
                        </fieldset>
                    </div>
                </form>
            </div>

            <div class="modal-footer">
                <div class="btn-group">
                    <button type="button" id="save" class="btn round-10 btn-primary">
                        <i class="fa fa-save"></i>&nbsp;<?= empty($_tovaritelnizaNo) ? 'Генериране' : 'Запис' ?>
                    </button>

                    <button class="btn btn-outline-secondary p-1 round-10" type="button" data-dismiss="modal"><?= lang('LANG__global.btn.cansel') ?></button>
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->

    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <script>
            var SETTINGS_NUM_FIXED = SETTINGS.priceAccuracy;
        </script>

        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>  
</div>
