<?php
$settingsService = (object) service('settings') -> get('App.general');

$_json_tavaritelniza = json_decode($order -> tovaritelniza_json ?? '[]', true);
$_tovaritelnizaNo    = $order -> tavaritelniza_no ?? '';

$_title = empty($_tovaritelnizaNo) ? "Генериране на товарителница" : "Редакция на товарителница № $_tovaritelnizaNo";

$_classHidePalet = !empty($_json_tavaritelniza['select']['serviceId']) && in_array($_json_tavaritelniza['select']['serviceId'], [412, 413]) ? '' : 'hide'; // ако е палет 
?>

<div class="modal fade" id="modal_generateTovaritelnizaSpeedy" role="dialog" data-backdrop="static" data-keyboard="false" style="z-index: 1111111">

    <!-- --- ЗАРЕЖДАНЕ НА CSS ОТ CONTROLLER --- -->
    <?php if (isset($addCSS) && is_array($addCSS)) { ?>
        <?php foreach ($addCSS as $css) { ?>
            <link rel="stylesheet" type="text/css" href="<?= auto('assets/' . $css . '.css'); ?>">
        <?php } ?>
    <?php } ?>

    <div class="modal-dialog modal-dialog-centered w-50 mw-100 m-auto ui-draggable">
        <div class="ss-background css-box-shadow modal-content">
            <div class="modal-header">
                <a href="http://www.speedy.bg" style="position: relative;top: -5px;">
                    <img src="/assets/images/curier/SpeedyLogo.png" alt="Speedy">
                </a>

                <h4 class="col text-center modal-title"><?= $_title ?></h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body overflow-auto" style="height: calc(100vh - 180px);">
                <form id="form-curier" name="form-curier" method="post" role="form" spellcheck="false" action="<?= $form ?>">

                    <input type="hidden" name="tovaritelnizaNo" value="<?= $_tovaritelnizaNo ?>">
                    <input type="hidden" name="orderTip" value="<?= $orderTip ?>">
                    <input type="hidden" name="orderId" value="<?= $order -> order_id ?>">
                    <input type="hidden" name="grad" value="<?= preg_match('/^\d*\s*([^\s]+)/u', $deliveryJson['ofis'], $matches) ? $matches[1] : ''; ?>">
                    <input type="hidden" name="ofisName" value="<?= preg_replace('/^\d+\s*/', '', $deliveryJson['ofis']) ?>">

                    <?php
                    $_recipient_phoneNumber = $deliveryJson['tel'] ?? '';

                    if (preg_match('/^\d{9}$/', $_recipient_phoneNumber)) {
                        $_recipient_phoneNumber = '0' . $_recipient_phoneNumber;
                    }
                    ?>

                    <input type="hidden" name="recipient[phone1][number]" value="<?= $_recipient_phoneNumber ?>">
                    <input type="hidden" name="recipient[clientName]" value="<?= $order -> klient_name ?? '' ?>">
                    <input type="hidden" name="recipient[contactName]" value="<?= $deliveryJson['liceKont'] ?>">
                    <input type="hidden" name="recipient[email]" value="<?= $deliveryJson['email'] ?? '' ?>">
                    <input type="hidden" name="recipient[privatePerson]" value="<?= in_array($orderTip, ['site', 'L']) ? 'false' : 'true' ?>">

                    <?php if (in_array($orderTip, ['site', 'L'])): ?>
                        <input type="hidden" name="recipient[name]" value="<?= $deliveryJson['liceKont'] ?>">    
                    <?php endif ?>

                    <input type="hidden" name="recipient[address][siteName]" value="<?= $deliveryJson['grad'] ?>">
                    <input type="hidden" name="recipient[address][complexName]" value="<?= $deliveryJson['kvartal'] ?>">
                    <input type="hidden" name="recipient[address][streetName]" value="<?= $deliveryJson['ulica'] ?>">
                    <input type="hidden" name="recipient[address][streetNo]" value="<?= $deliveryJson['ulicaNo'] ?>">
                    <input type="hidden" name="recipient[address][blockNo]" value="<?= $deliveryJson['blockNo'] ?>">
                    <input type="hidden" name="recipient[address][entranceNo]" value="<?= $deliveryJson['entranceNo'] ?>">
                    <input type="hidden" name="recipient[address][floorNo]" value="<?= $deliveryJson['floorNo'] ?>">
                    <input type="hidden" name="recipient[address][apartmentNo]" value="<?= $deliveryJson['apartmentNo'] ?>">

                    <input type="hidden" name="recipient[pickupOfficeId]" value="<?php
                    if (preg_match('/\d+(\.\d+)?/', $deliveryJson['ofis'], $matches)) {
                        echo $matches[0];
                    }
                    ?>">

                    <input type="hidden" name="shipping_code" value="<?= $deliveryJson['izborKurier'] ?>">
                    <input id="isOfice" type="hidden" name="isOfice" value="<?= $deliveryJson['isOfice'] ? 1 : 0 ?>">
                    <input class="o bg-white akrobatBold" type="hidden" name="ref1" value="Поръчка: <?= $order -> order_id ?>">

                    <div class="row hide">
                        <label class="col-3"><?= 'Поръчка: ' . $order -> order_id ?></label>
                    </div>

                    <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #ff3405;" >
                        <legend class="akrobatExtraBold">Данни за подател</legend>

                        <section class="row mb-1">
                            <span class="col-3">Обект, от който тръгват пратките</span>
                            <div class="col">
                                <select id="sender" class="w-100 bg-white akrobatBold">
                                    <?php
                                    foreach ($profilSender as $row) {
                                        $_senderId    = $row -> clientId;
                                        $_senderTel   = $row -> phones[0] -> number;
                                        $_senderName  = $row -> contactName;
                                        $_senderEmail = $row -> email;
                                        $_fullAdr     = $row -> address -> fullAddressString;

                                        $_selected = ($_senderId == ($_json_tavaritelniza['senderId'] ?? $settingsService -> speedySender ?? '')) ? 'selected' : '';
                                        ?>
                                        <option 
                                            data-info='{"phone":"<?= $_senderTel ?>","name":"<?= $_senderName ?>","email":"<?= $_senderEmail ?>","id":"<?= $_senderId ?>"}' 
                                            value="<?= $_senderId ?>" 
                                            <?= $_selected ?>>
                                            Име: <?= $row -> clientName ?>, Адрес: <?= $row -> address -> fullAddressString ?>
                                        </option>
                                    <?php } ?>
                                </select>

                                <input id="sender_adres" type="hidden" name="sender[adress]" value="<?= $_fullAdr ?? '' ?>">
                                <input id="sender_phone" type="hidden" name="sender[phone1][number]" value="<?= $_senderTel ?? '' ?>">
                                <input id="sender_name" type="hidden" name="sender[contactName]" value="<?= $_senderName ?? '' ?>">
                                <input id="sender_email" type="hidden" name="sender[email]" value="<?= $_senderEmail ?? '' ?>">
                            </div>  
                        </section>

                        <section class="row mb-1 float-right">Клиентски номер:
                            <div class="col akrobatBold">
                                <input id="senderId" class="pointer-events-none" name="senderId" value="<?= $_json_tavaritelniza['senderId'] ?? $_senderId ?>">           
                            </div> 
                        </section>

                        <section class="row clearfix">
                            <span class="col-3">Пращане на пратка</span>

                            <div class="col mb-1">
                                <select id="sendFrom" class="bg-white akrobatBold" name="sendFrom">
                                    <option value="fromDoor" <?= ($_json_tavaritelniza['sendFrom'] ?? '') === 'fromDoor' ? 'selected' : '' ?>>от врата</option>
                                    <option value="" <?= empty($_json_tavaritelniza['sendFrom']) ? 'selected' : '' ?>>от офис на куриер</option>
                                </select>
                            </div>
                        </section>

                        <section id="officeLocatorRow" class="row mb-1">
                            <span class="col-3">Адрес офис на куриер<b class="text-danger" style="font-size: 20px">*</b></span>

                            <button id="speedyLocator" class="btn bg-secondary fa fa-map-marker" type="button">&nbsp;Speedy офис локатор</button>

                            <div class="col ">
                                <input class="izborOfice validate pointer-events-none" name="senderOfficeCode" data-name="Изберете бутона Speedy офис локатор от данни за подадтел" value="<?= $settingsService -> speedyOfis ?? '' ?>">
                            </div>
                        </section>
                    </fieldset>   

                    <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #ff3405;" >
                        <legend class="akrobatExtraBold">Данни за получател</legend>

                        <section class="row mb-1">
                            <span class="col-3">Лице за контакт <b class="text-red">*</b></span>
                            <div class="col akrobatBold"><?= $deliveryJson['liceKont'] ?></div>  
                        </section>

                        <section class="row mb-1">
                            <span class="col-sm-3">Телефон<b class="text-red">*</b></span>
                            <div class="col akrobatBold"><?= $deliveryJson['tel'] ?></div>  
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">E-mail</span>
                            <div class="col akrobatBold"></div>  
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">Населено място</span>
                            <div class="col akrobatBold ">
                                <input id="city_name" class="w-25 px-0 pointer-events-none pr-3" name="adres[city][name]" type="text" value="<?= $deliveryJson['grad'] ?>">
                            </div>  
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">Пощенски код</span>
                            <div class="col akrobatBold">
                                <input class="w-25 px-0 pointer-events-none" name="adres[city][postCode]" type="text" value="<?= $deliveryJson['postCode'] ?>" required>
                            </div>  
                        </section>

                        <section class="toOficeContainer row mb-1">
                            <span class="col-3">Доставка до <?=
                                match ($deliveryJson['izborKurier']) {
                                    'speedy_door' => 'врата:',
                                    'speedy_office' => 'офис:',
                                    'speedy_machina' => 'автомат (без опция Тествай)'
                                }
                                ?>
                            </span>

                            <div class="col akrobatBold"><?php
                                if ($deliveryJson['isOfice']) {
                                    echo $deliveryJson['ofis'];
                                } else {
                                    echo 'квартал ' . $deliveryJson['kvartal'] . ', ул.' . $deliveryJson['ulica'] . ' № ' . $deliveryJson['ulicaNo'] . ', блок ' . $deliveryJson['blockNo'] . ', вх. ' . $deliveryJson['entranceNo'] . ', ет. ' . $deliveryJson['floorNo'] . ', ап. ' . $deliveryJson['apartmentNo'];
                                }
                                ?>
                            </div>  
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">Допълнение към адреса:</span>
                            <div class="col akrobatBold">
                                <?= $deliveryJson['other'] ?>
                            </div>  
                        </section>
                    </fieldset>     

                    <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #ff3405;" >
                        <legend class="akrobatExtraBold">Данни за пратката</legend> 

                        <section class="row mb-1">
                            <span class="col-3">Услуга <b class="text-red">*</b></span>
                            <div class="col">
                                <?php
                                $_optionsService = [
                                    ['value' => '505', 'label' => '505-СТАНДАРТ 24 ЧАСА'],
                                    ['value' => '515', 'label' => '515-СТАНДАРТ 24 ЧАСА ПАКЕТ'],
                                    ['value' => '412', 'label' => '412-PALLET ONE BG - PREMIUM'],
                                    ['value' => '413', 'label' => '413-PALLET ONE BG - ECONOMY'],
                                    ['value' => '704', 'label' => '704-ГУМИ']
                                ];

                                $_selectedServiceId = $_json_tavaritelniza['select']['serviceId'] ?? '505'
                                ?>
                                <select id="service-select" class="bg-white akrobatBold" name="service[serviceId]">
                                    <?php foreach ($_optionsService as $o): ?>
                                        <option value="<?= $o['value'] ?>" <?= $o['value'] === $_selectedServiceId ? 'selected' : '' ?>>
                                            <?= $o['label'] ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                        </section>

                        <section class="row mb-1">
                            <span class="col-3"></span>
                            <div class="col">
                                <input id="chk_isDocs" name="isDocs" type="checkbox" value="1" <?= !empty($_json_tavaritelniza['checkbox']['isDocs']) ? 'checked' : '' ?> <?= empty($_classHidePalet) ? 'disabled' : '' ?>>&nbsp;Документи
                            </div>
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">Съдържание <b class="text-red">*</b></span>
                            <div class="col">

                                <?php
                                $_optionsContent = [
                                    "ТЕХНИКА",
                                    "АВТОЧАСТИ",
                                    "ДОКУМЕНТИ",
                                    "КАНЦ. МАТЕР.",
                                    "КОЗМЕТИКА",
                                    "ЛЕКАРСТВА (МЕДИКАМ.)",
                                    "МЕБЕЛИ",
                                    "ТЕКСТИЛ (ДРЕХИ)",
                                    "ОПТИКА",
                                    "ПРЕПАРАТИ"
                                ];

                                $_selectedContent = $_json_tavaritelniza['select']['contents'] ?? "ТЕХНИКА"
                                ?>
                                <select id="sadarzanie" class="bg-white akrobatBold" name="content[contents]">
                                    <?php foreach ($_optionsContent as $opt): ?>
                                        <option value="<?= $opt ?>" <?= ($opt === $_selectedContent) ? 'selected' : '' ?>><?= $opt ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>  
                        </section> 

                        <section class="row mb-1">
                            <span class="col-3">Опаковка <b class="text-red">*</b></span>
                            <div class="row col justify-content-between">
                                <div class="col-2">
                                    <?php
                                    $_optionsPack  = ["КАШОН", "ЧУВАЛ", "ПЛИК", "КУТИЯ", "СТРЕЧ", "ФОЛИО"];
                                    $_selectedPack = $_json_tavaritelniza['select']['package'] ?? "КАШОН"
                                    ?>
                                    <select id="opakovka" class="bg-white akrobatBold" name="content[package]">
                                        <?php foreach ($_optionsPack as $op): ?>
                                            <option value="<?= $op ?>" <?= ($op === $_selectedPack) ? 'selected' : '' ?>>
                                                <?= $op ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div> 

                                <div class="row col-5">
                                    <span class="col-6">Брой пакети <b class="text-red">*</b></span>
                                    <div class="col-4">
                                        <input id="broiPaketi" class="bg-white akrobatBold notClear <?= empty($_classHidePalet) ? 'pointer-events-none' : '' ?>" name="content[parcelsCount]" type="number" data-isbroj value="<?= $_json_tavaritelniza['parcelsCount'] ?? 1 ?>">
                                    </div>
                                </div>

                                <div class="row col-4">
                                    <span class="col-6">Тегло кг. <b class="text-red">*</b></span>
                                    <div class="col">
                                        <input id="totalWeight" class="bg-white akrobatBold  <?= empty($_classHidePalet) ? 'pointer-events-none' : '' ?>" name="content[totalWeight]" type="text" value="<?= $_json_tavaritelniza['totalWeight'] ?? 1 ?>">
                                    </div>  
                                </div>
                            </div>
                        </section>

                        <section id="block_sizePack" class="row mb-1 <?= $_classHidePalet ?>">
                            <span class="col-3">Размери на пакети <b class="text-danger" style="font-size: 20px">*</b></span>
                            <div class="row col justify-content-between">
                                <div class="col-2">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <input id="w" class="bg-white akrobatBold" type="text" data-isnumeric>
                                            <span class="px-2 py-0 input-group-text">Ш</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-2">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <input id="d" class="bg-white akrobatBold" type="text" data-isnumeric>
                                            <span class="px-2 py-0 input-group-text">Д</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-2">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <input id="h" class="bg-white akrobatBold" type="text" data-isnumeric>
                                            <span class="px-2 py-0 input-group-text">В</span>

                                        </div>
                                    </div>
                                </div>
                                <span class="px-2 py-0 input-group-text">см.</span>
                                <div class="col-3">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <input id="ww" class="bg-white akrobatBold" type="text" data-isnumeric>
                                            <span class="px-2 py-0 input-group-text">тегло кг.</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col">
                                    <button id="add_sizePack" class="btn bg-secondary border-1" type="button">Добави</button>
                                </div>
                            </div>
                        </section>

                        <section id="block_paletTable" class="row mb-1 <?= $_classHidePalet ?>">
                            <span class="col-3"></span>
                            <div class="col"> 

                                <table class="table table-sm" style="box-shadow: 1px 1px 3px 0 #000">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>Палетна основа</th>
                                            <th>Размери</th>
                                            <th>Тегло</th>
                                            <th></th>
                                        </tr>
                                        <tr>
                                            <th></th>
                                            <th colspan="3">
                                                <select id="pallet-type-select" class="bg-white akrobatBold">
                                                    <option data-value="0,0" value="">--- избери основа ---</option>
                                                    <option data-value="80,60" value="150">150-Mини палет (EUR6) (80 x 60)</option>
                                                    <option data-value="80,120" value="250">250-Евро палет (80 x 120)</option>
                                                    <option data-value="100,120" value="350">350-Индустриален палет 100 (EUR3) (100 x 120)</option>
                                                    <option data-value="120,120" value="450">450-Индустриален палет 120 (120 x 120)</option>
                                                    <option data-value="150,120" value="510">510-Нестандартен палет S1 (150 x 120)</option>
                                                    <option data-value="175,120" value="520">520-Нестандартен палет S2 (175 x 120)</option>
                                                    <option data-value="200,120" value="530">530-Нестандартен палет S3 (200 x 120)</option></select>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if (!empty($_json_tavaritelniza['palet'])) :
                                            foreach ($_json_tavaritelniza['palet'] as $k => $row) :
                                                $dim = explode('x', $row['paletDimensions']);
                                                ?>
                                                <tr>
                                                    <td>
                                                        <input type="hidden" name="palet[][paletOsnova]" value="<?= $row['paletOsnova'] ?>">
                                                        <input type="hidden" name="palet[][paletDimensions]" value="<?= $row['paletOsnova'] ?>">
                                                        <input type="hidden" name="palet[][paletTeglo]" value="<?= $row['paletTeglo'] ?>">


                                                        <input type="hidden" name="content[parcels][][seqNo]" value="<?= $k + 1 ?>">
                                                        <input type="hidden" name="content[parcels][][size][width]" value="<?= $dim[0] ?? '' ?>">
                                                        <input type="hidden" name="content[parcels][][size][height]" value="<?= $dim[1] ?? '' ?>">
                                                        <input type="hidden" name="content[parcels][][size][depth]" value="<?= $dim[2] ?? '' ?>">
                                                        <input type="hidden" name="content[parcels][][weight]" value="<?= $row['paletTeglo'] ?>">
                                                    </td>
                                                    <td><?= $row['paletOsnova'] ?></td>
                                                    <td><?= $row['paletDimensions'] ?></td>
                                                    <td><?= $row['paletTeglo'] ?></td>
                                                    <td><button class="remove_paletRow btn px-1 py-0 bg-danger">x</button></td>
                                                </tr>
                                                <?php
                                            endforeach;
                                        endif
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </section>
                    </fieldset> 

                    <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #ff3405;">
                        <legend class="akrobatExtraBold">Допълнителни услуги</legend> 

                        <section class="row mb-1">
                            <span class="col-3">Дата на изпращане</span>

                            <div class="col-2">
                                <select id="delivery_date" class="w-100 bg-white akrobatBold" name="service[pickupDate]" data-date="<?= $_json_tavaritelniza['select']['pickupDate'] ?? '' ?>">
                                    <option value="">Изберете дата</option>
                                </select>
                            </div>

                            <!-- доставка в събота -->
                            <div class="col">
                                <input id="chk_saturdayDelivery" type="checkbox" name="service[saturdayDelivery]" value="true" <?= !empty($_json_tavaritelniza['checkbox']['saturdayDelivery']) ? 'checked' : '' ?> <?= $deliveryJson['isOfice'] ? 'disabled' : '' ?>>&nbsp;Дост. в събота/празник (само ако е до врата)
                            </div>

                            <div class="col-3 hide">
                                <input id="ship_date" class="bg-white akrobatBold" type="date" value="<?= date('Y-m-d') ?>">
                            </div>
                        </section>

                        <section class="row mb-2">
                            <span class="col-3">Наложен платеж лв.</span>
                            <div class="col-2">
                                <input id="npPrice" class="bg-white akrobatBold" name="service[additionalServices[cod[amount]]]" type="text" data-isnumeric value="<?= $_json_tavaritelniza['npPrice'] ?? '' ?>">
                            </div> 

                            <div class="col">
                                <input id="chk_moneyTransfer" name="service[additionalServices[cod[processingType]]]" type="checkbox" value="POSTAL_MONEY_TRANSFER" <?= !empty($_json_tavaritelniza['checkbox']['moneyTransfer']) ? 'checked' : '' ?> <?= empty($_json_tavaritelniza['npPrice']) ? 'disabled' : '' ?>>&nbsp;Като паричен превод

                                <br>

                                <input id="chk_includePriceInNP" name="service[additionalServices[cod[includeShippingPrice]]]" type="checkbox" value="true" <?= !empty($_json_tavaritelniza['checkbox']['incShipPrice']) ? 'checked' : '' ?> <?= empty($_json_tavaritelniza['npPrice']) ? 'disabled' : '' ?>>&nbsp;Вкл. цената на к.у. в НП 
                                <br>

                                <input id="chk_allowPayWithCard" name="service[additionalServices[cod[cardPaymentForbidden]]]" type="checkbox" checked="" value="true" <?= !empty($_json_tavaritelniza['checkbox']['cardPaymentForbidden']) ? 'checked' : '' ?>  <?= empty($_json_tavaritelniza['npPrice']) ? 'disabled' : '' ?>>&nbsp;Плащане с карта 
                            </div>
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">Обявена стойност лв.</span>

                            <div class="col-2">
                                <input id="declaredValue" class="bg-white akrobatBold" name="service[additionalServices[declaredValue[amount]]]" type="text" data-isnumeric value="<?= $_json_tavaritelniza['declaredPrice'] ?? '' ?>">
                            </div>  

                            <div class="col-2">
                                <input id="chk_isFragile" type="checkbox" name="service[additionalServices[declaredValue[fragile]]]" value="true" <?= !empty($_json_tavaritelniza['checkbox']['fragile']) ? 'checked' : '' ?>  <?= empty($_json_tavaritelniza['declaredPrice']) ? 'disabled' : '' ?>>&nbsp;Чупливост
                            </div>  
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">Опции преди плащане/получаване</span>
                            <div class="col">
                                <?php
                                $_optionsBeforePay = [
                                    'TEST' => 'Тествай преди плащане/получаване',
                                    'OPEN' => 'Отвори преди плащане/получаване',
                                ];

                                $_selectedBeforePay = $_json_tavaritelniza['select']['beforePay'] ?? 'OPEN';
                                ?>
                                <select id="option_before_payment" class="bg-white" name="service[additionalServices[obpd[option]]]" <?= empty($_classHidePalet) ? 'disabled' : '' ?>>
                                    <?php foreach ($_optionsBeforePay as $value => $label): ?>
                                        <option value="<?= $value ?>" <?= $value === $_selectedBeforePay ? 'selected' : '' ?>>
                                            <?= $label ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>  
                        </section>
                    </fieldset>

                    <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #ff3405;">
                        <legend class="akrobatExtraBold">Заявки за връщане</legend> 

                        <section class="row mb-1">
                            <div class="col">
                                <input name="service[additionalServices[returns[returnReceipt[enabled]]]]" type="checkbox" value="true" <?= !empty($_json_tavaritelniza['checkbox']['returnReceipt']) ? 'checked' : '' ?>>&nbsp;Обратна разписка
                            </div>  
                        </section>

                        <section class="row mb-1">
                            <div class="col-3">
                                <input name="service[additionalServices[returns[rod[enabled]]]]" type="checkbox" value="true" <?= !empty($_json_tavaritelniza['checkbox']['returnDoc']) ? 'checked' : '' ?>>&nbsp;Обратни документи
                            </div>

                            <div class="col">
                                <textarea class="bg-white akrobatBold" name="service[additionalServices[returns[rod[comment]]]]" placeholder="Забележка към обратните документи"><?= $_json_tavaritelniza['returnDocComent'] ?? '' ?></textarea>  
                            </div>
                        </section>

                        <section class="row mb-1">
                            <span class="col-3 d-flex align-items-center">Обратна пратка</span>

                            <div class="col">
                                <table class="table-sm mb-1">
                                    <thead>
                                        <tr>
                                            <th>Услуга</th>
                                            <th class="w-15">Бр. пакети</th>
                                            <th class="w-30">Обявена стойност</th>
                                            <th>Чупливо</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <tr>
                                            <td> 
                                                <select class="bg-white akrobatBold" name="service[additionalServices[returns[swap[serviceId]]]]">
                                                    <?php
                                                    foreach ($_optionsService as $o):
                                                        if (!in_array($o['value'], [412, 413])):
                                                            ?>
                                                            <option value="<?= $o['value'] ?>" <?= $o['value'] === $_selectedServiceId ? 'selected' : '' ?>>
                                                                <?= $o['label'] ?>
                                                            </option>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </select>
                                            </td>

                                            <td>
                                                <input class="bg-white akrobatBold" name="service[additionalServices[returns[swap[parcelsCount]]]]" type="text" value="<?= $_json_tavaritelniza['returnParcelCount'] ?? '' ?>" data-isnumeric>
                                            </td>

                                            <td>
                                                <input class="bg-white akrobatBold" name="service[additionalServices[returns[swap[declaredValue]]]]" type="text" value="<?= $_json_tavaritelniza['returnDeclaredVal'] ?? '' ?>" data-isnumeric>
                                            </td>

                                            <td class="text-center">
                                                <input type="checkbox" name="service[additionalServices[returns[swap[fragile]]]]" value="true" <?= !empty($_json_tavaritelniza['checkbox']['returnFragile']) ? 'checked' : '' ?>>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </section>
                    </fieldset> 

                    <fieldset class="col mb-2" style="background: #f6f8ff; border: 2px solid #ff3405;">
                        <legend class="akrobatExtraBold">Данни за плащане</legend> 

                        <section class="row mb-1">
                            <span class="col-3">Платец <b class="text-red">*</b></span>
                            <div class="col">
                                <?php
                                $_whoPay = $settingsService -> speedyWhoPay ?? '';

                                $_whoPayOptions = [
                                    ''          => '',
                                    'RECIPIENT' => 'Получател',
                                    'SENDER'    => 'Подател',
                                ];

                                $_selectedServicePayer = $_json_tavaritelniza['select']['servicePayer'] ?? $settingsService -> speedyWhoPay ?? array_key_first($_whoPayOptions);
                                ?>

                                <select class="validate bg-white akrobatBold" name="payment[courierServicePayer]" data-name="Платец">
                                    <?php foreach ($_whoPayOptions as $value => $label): ?>
                                        <option value="<?= $value ?>" <?= $value === $_selectedServicePayer ? 'selected' : '' ?>>
                                            <?= $label ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>  
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">Платец опаковка<b class="text-red">*</b></span>
                            <div class="col">
                                <?php
                                $_optionsPackagePayer        = [
                                    'SAME'      => 'както к.у.',
                                    'RECIPIENT' => 'Получател',
                                    'SENDER'    => 'Подател',
                                ];
                                $_selectedPackagePayer       = $_json_tavaritelniza['select']['packagePayer'] ?? 'SAME';
                                $_selectedDeclaredValuePayer = $_json_tavaritelniza['select']['declaredValuePayer'] ?? 'SAME';
                                ?>
                                <select class="bg-white akrobatBold" name="payment[packagePayer]">
                                    <?php foreach ($_optionsPackagePayer as $value => $label): ?>
                                        <option value="<?= $value ?>" <?= $value === $_selectedPackagePayer ? 'selected' : '' ?>>
                                            <?= $label ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div> 

                            <div class="col">к.у. - куриерска услуга</div>
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">Платец обявена ст.</span>
                            <div class="col">
                                <select id="declaredValuePayer" class="bg-white akrobatBold" name="payment[declaredValuePayer]" <?= empty($_json_tavaritelniza['declaredPrice']) ? 'disabled' : '' ?>>
                                    <?php foreach ($_optionsPackagePayer as $value => $label): ?>
                                        <option value="<?= $value ?>" <?= $value === $_selectedDeclaredValuePayer ? 'selected' : '' ?>>
                                            <?= $label ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </section>

                        <section class="row mb-1">
                            <span class="col-3">При отказ на пратка</span>
                            <div class="col">

                                <select class="bg-white akrobatBold" name="service[additionalServices[obpd[returnShipmentPayer]]]">
                                    <option value="RECIPIENT" <?= ($_json_tavaritelniza['returnParcel'] ?? '') == 'RECIPIENT' ? 'selected' : '' ?>>Връщането да за сметка на получателя</option>
                                    <option value="SENDER" <?= ($_json_tavaritelniza['returnParcel'] ?? '') == 'SENDER' ? 'selected' : '' ?>>Връщането да е за моя сметка</option>
                                </select>
                            </div>
                        </section>
                    </fieldset> 

                    <!-- Заявка за куриер-->
                    <fieldset id="block_zaqvkaCurier" class="col mb-2" style="background: #f6f8ff; border: 2px solid #ff3405;">
                        <legend class="akrobatExtraBold">Заявка за куриер</legend>

                        <div class="row mb-1">
                            <span class="col-3">Желан час за посещение:</span>

                            <!-- Часови интервал -->
                            <div class="col">
                                <!-- От час -->
                                <?php
                                date_default_timezone_set('Europe/Sofia');
                                $now           = new DateTime();
                                $currentHour   = (int) $now -> format('G');
                                $currentMinute = (int) $now -> format('i');

                                echo '<select id="requestHourFrom" class="w-13" name="requestHourFrom" >';
                                echo('<option value="">час</option>');

                                for ($h = 9; $h <= 18; $h++) {
                                    // Ако е днешна дата и часът е в миналото - пропускаме
                                    $_hide = now() && ($h < $currentHour || ($h == $currentHour )) ? 'hide' : '';
                                    printf('<option class="' . ($_hide) . '" value="%02d">%02d</option>', $h, $h);
                                }
                                echo '</select>';
                                ?>

                                <!-- От минути -->
                                : <select class="w-13" name="requestMinFrom">
                                    <option value="">минути</option>
                                    <option value="00">00</option>
                                    <option value="15">15</option>
                                    <option value="30">30</option>
                                    <option value="45">45</option>
                                </select>
                            </div>
                        </div>

                        <div class="row mb-1">
                            <span class="col-3">Работно време от:</span>

                            <div class="col">
                                <input id="working-from-time-hour" class="w-13" type="text"  size="1" tabindex="0" maxlength="2" placeholder="час">

                                :
                                <input id="working-from-time-min" class="w-13" type="text"  size="1" tabindex="0" maxlength="2" placeholder="минути">
                                до

                                <input id="working-to-time-hour" class="w-13" type="text"  size="1" tabindex="0" maxlength="2" placeholder="час">

                                :
                                <input id="working-to-time-min" class="w-13" type="text"  size="1" tabindex="0" maxlength="2" placeholder="минути">

                            </div>
                        </div>

                        <div class="row col mb-1">     
                            <button class="btn btn-primary" type="button"><i class="fa fa-truck"></i>&nbsp;Заяви куриер</button>
                        </div>
                    </fieldset>
                </form>     
            </div> 

            <div class="modal-footer">
                <div class="btn-group">
                    <button type="button" id="save" class="btn btn-primary">
                        <i class="fa fa-save"></i>&nbsp;<?= empty($_tovaritelnizaNo) ? 'Генериране' : 'Запис' ?>
                    </button>

                    <button class="btn btn-outline-secondary p-1 border-0" type="button" data-dismiss="modal"><?= lang('LANG__global.btn.cansel') ?></button>
                </div>
            </div>    
        </div>  
    </div><!-- /.modal-dialog -->

    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <script> var SETTINGS_NUM_FIXED = SETTINGS.priceAccuracy</script>

        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>  
</div>
