<!-- dir [View/common] tooltip  избор на ценова листа-->

<div id="modal_popupZenovaLista" class="modal fade p-0" tabindex="-1"  role="dialog" data-backdrop="static" data-keyboard="false" style="z-index: 1111111">

    <div class="modal-dialog modal-dialog-centered mw-50">
        <div class="modal-content">

            <div class="modal-header modal-drag-handle p-1">
                <h3 class="d-flex col modal-title">Избор на ценова листа</h3>

                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>

            <div class="modal-body p-1">
                <form id="form">
                    <div class="overflow-auto" style=" max-height: calc(100vh - 220px);">

                        <table id="popupZenovaLista" class="table-sm w-100" data-route="<?= route_to('POPup_zenovaLista-import', $tip) ?>" width="100" cellspacing="0">
                            <thead class='bg-primary'>
                                <tr>
                                    <th class="p-1" colspan="2">
                                        <input id="zenova_filter" type="search" placeholder="Филтър">
                                    </th>

                                    <th></th>
                                </tr>

                                <tr>
                                    <th class="col-0-5"></th>
                                    <th class="col-7"><?= lang('LANG__order.tbl.th.zenList') ?></th>
                                    <th class="col">Ценово ниво</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php foreach ($zenovaLista ?? [] as $k => $v) { ?>
                                    <tr data-id="<?php echo $v['id']; ?>">
                                        <td></td>
                                        <td class="offersName" style="border-bottom: 1px dashed;"><?= $v['offersName']; ?></td>

                                        <td>
                                            <button data-nivo="cenaB" type="button"><?= lang('LANG__zenovaOferta.tbl.th.zenaB'); ?></button>
                                            <button data-nivo="cenaA" type="button"><?= lang('LANG__zenovaOferta.tbl.th.zenaA'); ?></button>
                                            <button data-nivo="cenaSpec" type="button"><?= lang('LANG__zenovaOferta.tbl.th.zenaSpec'); ?></button>
                                            <button data-nivo="cenaKl" type="button"><?= lang('LANG__zenovaOferta.tbl.th.zenaKlKl'); ?></button>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </form>
            </div>

            <div class="modal-footer p-0">
                <div class="btn-group">
                    <button class="btn btn-default" type="button" data-dismiss="modal"><?= lang('popup/LANGpop__izborProduct.footer.btn.close') ?></button>
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->

    <!-- --- ЗАРЕЖДАНЕ НА JS ОТ CONTROLLER --- -->
    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>

    <script>
        Lp.table_freezeHeader({'table': '.modal #popupZenovaLista', 'scroll': '.overflow-auto', 'margin': 0}); // thead frezze

        // филтър по ценова листа
        $('.modal').on('keyup', 'thead #zenova_filter', function (e) {
            e.stopImmediatePropagation();

            let _this = $(this);

            let labels = _this.closest('table').find('tbody td.offersName');
            let valThis = _this.val().trim().toLowerCase();

            if (valThis === '') {
                labels.parent().show();
            }
            else {
                labels.each(function () {
                    let label = $(this);
                    let text = label.text().toLowerCase();
                    let parent = label.parent();

                    parent.toggle(text.includes(valThis));
                });
            }
        });

        //добавяне на избраната ценова листа по избрано ниво 
        $('.modal').on('click', '#popupZenovaLista tbody button', function (e) {
            e.stopImmediatePropagation();
            const _this = $(this);
            const tr = _this.closest('tr');
            const table = '#tbl_products';
            const tbody = $(table).find('tbody');
            let productIdArr = [ ];

            tbody.find('tr').not('.colorRows').each(function () {
                productIdArr.push($(this).data('id'));
            });

            $.ajax({
                url: _this.closest('table').data('route'),
                type: 'POST',
                data: {'zenovaLista_id': tr.data('id'), 'nivo': _this.data('nivo'), 'productIdArr': productIdArr},
                dataType: 'json',
                success: function (response) {
                    tbody.append(response);

                    // промяна на позицията на цветния ред
                    tbody.find('tr.colorRows').each(function (row, tr) {
                        $(this).find('td.colorRows-data input.colorRows-pos').attr('value', $(this).index( ) - row);
                    });

                    $root.plugins();

                    alert('Ценовата листа е добавена');
                }
            });
        });
    </script>           
</div>


