<!-- dir [View/common] tooltip  избор на ценова листа-->

<div id="modal_popupZenovaLista" class="modal fade p-0" tabindex="-1"  role="dialog" data-backdrop="static" data-keyboard="false" style="z-index: 1111111">

    <div class="modal-dialog modal-dialog-centered mw-50">
        <div class="modal-content">

            <div class="modal-header modal-drag-handle p-1">
                <h3 class="w-100 text-center modal-title">Преместване на продукт в ценова листа
                    <br>
                    <span class="font-size-14"><?= $productData['product_name'] ?? $productData['gensoft_productName'] ?? '' ?></span>
                </h3>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
                <br>

            </div>

            <div class="modal-body p-1">
                <form id="form">
                    <div class="overflow-auto" style=" max-height: calc(100vh - 220px);">

                        <?php
                        $url = array(
                            'curentZenovaId' => $curentZenovaId,
                            'productId'      => $productData['product_id'],
                        );
                        ?>
                        <table id="popupZenovaLista" class="table-sm w-100" data-route="<?= route_to('POPup_moveProductToZenova-open', urldecode(http_build_query($url))) ?>" width="100" cellspacing="0">
                            <thead class='bg-primary'>
                                <tr>
                                    <th class="p-1" colspan="2">
                                        <input id="zenova_filter" type="search" placeholder="Филтър">
                                    </th>

                                    <th></th>
                                </tr>

                                <tr>
                                    <th class="col-0-5"></th>
                                    <th class="col-7"><?= lang('LANG__order.tbl.th.zenList') ?></th>
                                    <th class="col-1"></th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php foreach ($zenovaLista ?? [] as $k => $v) { ?>
                                    <tr data-id="<?php echo $v['id']; ?>">
                                        <td></td>
                                        <td class="offersName" style="border-bottom: 1px dashed;"><?= $v['offersName']; ?></td>

                                        <td>
                                            <button class="move" data-productId="<?= $productData['product_id'] ?? '' ?>" type="button"><i class="fa fa-refresh"></i>Прехвърли</button>

                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </form>
            </div>

            <div class="modal-footer p-0">
                <div class="btn-group">
                    <button class="btn btn-default" type="button" data-dismiss="modal"><?= lang('popup/LANGpop__izborProduct.footer.btn.close') ?></button>
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->

    <!-- --- ЗАРЕЖДАНЕ НА JS ОТ CONTROLLER --- -->
    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>

    <script>
        Lp.table_freezeHeader({'table': '.modal #popupZenovaLista', 'scroll': '.overflow-auto', 'margin': 0}); // thead frezze

        // филтър по ценова листа
        $('.modal').on('keyup', 'thead #zenova_filter', function (e) {
            e.stopImmediatePropagation();

            let _this = $(this);

            let labels = _this.closest('table').find('tbody td.offersName');
            let valThis = _this.val().trim().toLowerCase();

            if (valThis === '') {
                labels.parent().show();
            }
            else {
                labels.each(function () {
                    let label = $(this);
                    let text = label.text().toLowerCase();
                    let parent = label.parent();

                    parent.toggle(text.includes(valThis));
                });
            }
        });

        //добавяне на избраната ценова листа по избрано ниво 
        $('.modal').on('click', 'tbody button', function (e) {
            e.stopImmediatePropagation();
            const _this = $(this);
            const tr = _this.closest('tr');
            const route = _this.closest('table').data('route');

            if (!confirm('Сигурни ли сте, че искате да преместите избрания продукт')) {
                return false;
            }

            $.ajax({
                url: GLOBVAR.isOpenZenovaUrl, // var in VIEW__footer
                type: 'POST',
                //global: false,

                dataType: 'json',
                data: {'oferId': tr.data('id'), 'urlTab': 'zenova'},
                success: function (response)
                {

                    if (response.error) {
                        if (!confirm(response.message + ' ' + response.opened_by + '.\nВнимание: това може да предизвика грешка ако наистина тази ценова листа е отворена за редакция.\n\nИскате ли да продължите въпреки това?')) {
                            return false;
                        }
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'zenovaId': tr.data('id'), 'productId': _this.data('productid')},
                        dataType: 'json',
                        success: function (response) {
                            //$root.plugins();
                            if (response.err) {
                                alert(response.err);
                                return false;
                            }

                            $("#tableProduct").load(window.location + ' #tableProduct>*', function (response, status, xhr) {
                                if (status == 'success') {
                                    $root.plugins();

                                    alert('Продуктът е прехвърлен');
                                    $('.modal').modal('toggle');
                                }
                            });
                        }
                    });
                }
            });



        });
    </script>           
</div>


