<div class="form-group">
    <label class="fw-500 css-text-dark">Свързани продукти</label>

    <div class="border mt-1">
        <!-- Поле за търсене -->
        <input id="relatedSearch" class="css-input-p css-focus-strong css-border-none form-control round-10"
               data-product-id="<?= $list?->product_id ?? '' ?>"
               data-hx-get="<?= route_to('POPup_editProduct-search_relatedProducts') ?>"
               data-hx-target="next .hx-box"
               data-hx-trigger="input delay:400ms"
               data-hx-vals='js:{searchName: this.value,curentProductId :this.dataset.productId }'
               type="text"  
               placeholder="Търси продукт по име или по (код, код на доставчик, OEM, UPC, EAN)..." >

        <!-- Резултати от търсенето -->
        <div id="relatedSearchResults" class="hx-box mb-3" style="max-height: 300px;overflow-y: auto;"></div>

        <!-- Избрани продукти със снимка -->
        <div>
            <h6 class="d-flex justify-content-between align-items-center fw-500 mb-2">
                <span class="w-50">
                    <input id="chk_AllRelatedItems" class="w-10 ml-2" type="checkbox">
                    Избрани продукти:
                </span>

                <button id="removeAllRelatedItems" class="btn btn-outline-danger btn-sm round-10 p-2" type="button">
                    Премахни избраните продукти
                </button>
            </h6>

            <ul id="relatedBlock" class="list-group">

                <?php
                foreach ($related_products ?? [] as $row):
                    $image       = $row['image'] ?? '';
                    $productId   = (int) $row['product_id'];
                    $productName = $row['product_name'];
                    $desc        = htmlentities($row['description']);

                    $imagePath    = $_ENV['app.imageDir'] . $image;
                    $_imgCasheSrc = $image ? $_ENV['app.imageCasheDir'] . $image . '/' . pathinfo($image, PATHINFO_FILENAME) . '__150x150.' . pathinfo($image, PATHINFO_EXTENSION) : '';
                    ?>

                    <li class="auto-count p-1 d-flex align-items-center border-bottom" data-id="<?= $productId ?>">
                        <input class="w-3" type="checkbox">
                        <input name="form[related_products][]" type="hidden" value="<?= $productId ?>">
                        <img class="zoomImg mr-2 rounded border" src="<?= $_imgCasheSrc ?>" data-zoom-image="<?= $imagePath ?>" alt=" " width="40" height="40">
                        <span class="name"><?= $productName ?></span>

                        <div class="btnGroup ml-auto d-flex align-items-center">
                            <i class="fa fa-info-circle btn py-0 px-1" data-toggle="tooltip" title="<?= $desc ?>" ></i>

                            <i class="fa fa-arrows btn py-0 px-1"></i>

                            <i class="removeItem fa fa-close btn py-0 px-1 text-danger"></i>
                        </div>
                    </li>
                <?php endforeach ?>
            </ul>
        </div>
    </div>
</div>
