<?php
$mainImage        = trim($list -> image ?? '');
$additionalImages = !empty($list -> image_aditional) ? array_filter(array_map('trim', explode(',', $list -> image_aditional))) : [];
?>

<div class="form-group px-4 pt-4 pb-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <label class="font-weight-bold h5 mb-0">SEO настройки</label>

        <!-- Dynamic SEO score indicator -->
        <div id="seoScoreWrap" class="d-flex align-items-center">
            <div id="seoScoreCircle" class="seo-score-circle mr-3">
                <span id="seoScoreValue">0%</span>
            </div>
            <div>
                <div id="seoScoreLabel" class="font-weight-bold">Няма данни</div>
                <small id="seoScoreTips" class="text-muted">Попълни SEO полетата, за да получиш оценка.</small>
            </div>
        </div>
    </div>

    <div class="border rounded bg-light p-4 shadow-sm">
        <!-- SEO Title -->
        <div class="form-group mb-4">
            <label for="seo_title" class="font-weight-bold">SEO Title <small class="text-muted">(Meta Title)</small></label>
            <input id="seo_title" name="form[seo_title]" type="text" class="form-control"
                   value="<?= $list -> seo_title ?? '' ?>" maxlength="70"
                   placeholder="Пример: Купи <?= htmlentities($list -> product_name ?? '') ?> на добра цена | Онлайн магазин">
            <div class="seo-meter mt-1"><div class="seo-meter-bar" id="seo_title_meter"></div></div>
            <small id="seo_title_feedback" class="form-text text-muted">Оптимална дължина: 50–60 символа.</small>
        </div>

        <!-- SEO Description -->
        <div class="form-group mb-4">
            <label for="seo_description" class="font-weight-bold">SEO Description</label>
            <textarea id="seo_description" name="form[seo_description]" class="form-control"
                      rows="3" maxlength="170"
                      placeholder="Кратко описание (до 160 символа), което се показва под заглавието в Google..."><?= $list -> seo_description ?? '' ?></textarea>
            <div class="seo-meter mt-1"><div class="seo-meter-bar" id="seo_description_meter"></div></div>
            <small id="seo_description_feedback" class="form-text text-muted">Оптимална дължина: 140–160 символа.</small>
        </div>

        <!-- Keywords -->
        <div class="form-group mb-4">
            <label for="focus_keyword" class="font-weight-bold">Ключови думи</label>
            <input id="focus_keyword" name="form[focus_keyword]" type="text" class="form-control"
                   value="<?= $list -> focus_keyword ?? '' ?>"
                   placeholder="Пример: брава, VW Bora, KU718, авто части">
            <small class="form-text text-muted">Въведи няколко ключови думи, разделени със запетая.</small>
        </div>

        <!-- Canonical URL -->
        <div class="form-group mb-4">
            <label for="canonical_url" class="font-weight-bold">Canonical URL</label>
            <input
                id="canonical_url"
                name="form[canonical_url]"
                type="text"
                class="form-control"
                value="<?= $list -> canonical_url ?? '' ?>"
                placeholder="https://example.com/products/<?= $list -> seo_slug ?? ($list -> product_id ?? '') ?>"
                >
            <small class="form-text text-muted">Указва оригиналния адрес на продукта при дублирано съдържание.</small>
        </div>

        <!-- Robots -->
        <div class="form-group mb-4">
            <label for="noindex" class="font-weight-bold">Robots / Индексация</label>
            <div class="custom-control custom-switch mt-2">
                <input type="checkbox" class="custom-control-input" id="noindex"
                       name="form[noindex]" value="1" <?= !empty($list -> noindex) ? 'checked' : '' ?>>
                <label class="custom-control-label" for="noindex">Не индексирай този продукт (noindex)</label>
            </div>
            <small class="form-text text-muted">Активирай, ако искаш Google да не индексира тази страница.</small>
        </div>

        <!-- Slug -->
        <div class="form-group mb-4">
            <label for="seo_slug" class="font-weight-bold">SEO Slug (URL адрес)</label>
            <input id="seo_slug" name="form[seo_slug]" type="text" class="form-control"
                   value="<?= $list -> seo_slug ?? '' ?>"
                   placeholder="пример: <?= strtolower(str_replace(' ', '-', $list -> product_name ?? '')) ?>">
            <small class="form-text text-muted">Персонализиран URL на страницата (само латиница, без интервали).</small>
        </div>

        <hr class="my-4">

        <h5 class="mt-3 mb-4 font-weight-bold">SEO настройки за изображения</h5>

        <?php
        $mainImage        = trim($list -> image ?? '');
        $additionalImages = !empty($list -> image_aditional) ? array_filter(array_map('trim', explode(',', $list -> image_aditional))) : [];

// 1) Събираме всички снимки
        $images   = [];
        if ($mainImage)
            $images[] = ['label' => 'Основна снимка', 'path' => $mainImage];
        foreach ($additionalImages as $i => $img) {
            $images[] = ['label' => 'Допълнителна снимка ' . ($i + 1), 'path' => $img];
        }

// 2) Подготвяме дефолтен ALT/TITLE
        $productName        = trim($list -> product_name ?? '');
        $list -> seo_images = $list -> seo_images ?? []; // ако липсва запис в DB → празен масив

        foreach ($images as $i => $img) {
            if (empty($list -> seo_images[$i]['alt'])) {
                $list -> seo_images[$i]['alt'] = $productName;
            }
            if (empty($list -> seo_images[$i]['title'])) {
                $list -> seo_images[$i]['title'] = $productName;
            }
        }


        foreach ($images as $i => $img):
            $thumb = $_ENV['app.imageCasheDir'] . $img['path'] . '/' .
                    pathinfo($img['path'], PATHINFO_FILENAME) . '__150x150.' .
                    pathinfo($img['path'], PATHINFO_EXTENSION);
            ?>
            <div class="border rounded p-3 mb-4 bg-white shadow-sm image-seo-block">
                <div class="d-flex align-items-center mb-3">
                    <img src="<?= $thumb ?>" alt="" width="75" height="75" class="border rounded mr-3">
                    <strong><?= $img['label'] ?></strong>
                    <span class="status-dot ml-2"></span>
                </div>
                <div class="form-group mb-3">
                    <label class="font-weight-bold mb-1">ALT текст на изображението</label>
                    <input type="text" class="form-control seo-image-alt"
                           name="form[seo_images][<?= $i ?>][alt]"
                           value="<?= $list -> seo_images[$i]['alt'] ?>"
                           placeholder="Описание на изображението (пример: Брава за VW Bora)">
                </div>
                <div class="form-group mb-0">
                    <label class="font-weight-bold mb-1">Title на изображението</label>
                    <input type="text" class="form-control seo-image-title"
                           name="form[seo_images][<?= $i ?>][title]"
                           value="<?= $list -> seo_images[$i]['title'] ?>"
                           placeholder="Заглавие на изображението (пример: VW Bora брава KU718)">
                </div>
            </div>
        <?php endforeach; ?>

        <?php if (empty($images)): ?>
            <div class="alert alert-warning p-3">Няма качени снимки за този продукт.</div>
        <?php endif; ?>

        <!-- Recommendations -->
        <hr class="my-4">
        <div id="seoRecommendations" class="mt-4">
            <h5 class="font-weight-bold mb-3">Препоръки за подобрение</h5>
            <div id="seoChecklist" class="seo-checklist"></div>
        </div>
    </div>
</div> 
