<!-- доставчик  modal -->
<div class="modal fade" id="modal_language" tabindex="-1"  data-backdrop="static" data-keyboard="false" role="dialog">
    <div class="modal-dialog mx-auto m-0" role="document" style="max-width: 40vw;">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><?= lang('popup/LANGpop__language.title') ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body overflow-auto" style="max-height: 75vh">

                <table id="tbl_language" class="table-striped table-bordered table-sm" cellspacing="0" width="100%" >
                    <thead class="bg-black">
                        <tr>
                            <th></th>
                            <th><?= lang('popup/LANGpop__language.label.name') ?></th>
                            <th><?= lang('popup/LANGpop__language.label.code') ?></th>
                            <th><?= lang('popup/LANGpop__valuta.label.default') ?></th>
                            <th></th>
                        </tr>
                        <tr>
                            <th></th>
                            <th><input name="language_name" type="text"></th>
                            <th><input name="language_code" type="text"></th>
                            <th></th>
                            <th class="action"> 
                                <button type="button" class="save btn py-0" data-route="<?= route_to('POPup_language-save') ?>">
                                    <i class="bg-white p-1 border-0 fa fa-plus"></i>
                                </button>
                            </th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php foreach ($list as $row) { ?>
                            <tr data-id="<?= $row['language_id'] ?>">

                                <td></td>

                                <td>
                                    <input class="id"
                                           name="language_id"
                                           type="hidden" 
                                           value="<?= $row['language_id'] ?>">

                                    <input name="language_name"
                                           type="hidden" 
                                           value="<?= $row['language_name'] ?>">

                                    <span> <?= $row['language_name'] ?></span> 
                                </td>

                                <td>
                                    <input name="language_code"
                                           type="hidden" 
                                           value="<?= $row['language_code'] ?>">

                                    <span> <?= $row['language_code'] ?></span>
                                </td>

                                <td>
                                    <input class="isDefault" name="language_default" data-route="<?= route_to('POPup_language-set_defaulLanguage', $row['language_code']) ?>" type="radio" value="Y" <?= service('settings') -> get('App.defaultLocale') == $row['language_code'] ? 'checked' : '' ?>>
                                </td>

                                <td class="action text-center">

                                    <div class="btnGroup1 btn-group btn-group-sm">
                                        <button type="button" class="edit btn">
                                            <i class="btn-outline-primary p-1 border-0 fa fa-edit"></i>
                                        </button>

                                        <button class="delete btn" data-route=" <?= route_to('POPup_language-delete', $row['language_id'], $row['language_name']) ?>" data-name="<?= $row['language_name'] ?>" type="button">
                                            <i class="btn-outline-danger p-1 border-0 fa fa-trash"></i>
                                        </button>
                                    </div>

                                    <div class="btnGroup2 btn-group btn-group-sm hide">
                                        <button type="button" class="save btn" data-route="<?= route_to('POPup_language-save') ?>">
                                            <i class="btn-outline-primary p-1 border-0 fa fa-save"></i>
                                        </button>

                                        <button type="button" class="cansel btn">
                                            <i class="btn-outline-secondary p-1 border-0 fa fa-reply-all"></i>
                                        </button>
                                    </div>

                                </td>
                            </tr>
                        <?php } ?>
                    </tbody> 
                </table>   

            </div>

            <div class="modal-footer">
                <b class="col text-red"><?= lang('LANG__global.requiredFields') ?></b>
                <div class="btn-group  btn-group"> 
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('LANG__global.btn.cansel') ?></button> 
                </div>
            </div>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>    

    <script>
        var LANGpop__language = <?php print_r(json_encode(lang('popup/LANGpop__language.js'))) ?>
    </script> 
</div><!-- /.modal -->
