<?php
/**
 * View: VIEWpop__editCategorySEO.php
 * Purpose: SEO settings modal for category editing with live SEO score and recommendations
 */
?>

<script>
    /* --- AJAX form submission for SEO modal --- */
    $(document).on('submit', '#form-category-seo', function (e) {
        e.preventDefault();
        const $form = $(this);
        $.post($form.attr('action'), $form.serialize(), function (response) {
            if (response.status === 'success') {
                $('#modal_categorySEO').modal('hide');
                showSuccessModal(response.message || 'SEO настройките са запазени успешно.');
                setTimeout(() => location.reload(), 1500);
            }
            else {
                alert('Грешка при запазване на настройките.');
            }
        }).fail(xhr => {
            alert('Заявката се провали: ' + xhr.status);
            console.error(xhr.responseText);
        });
    });

    /* --- Simple Bootstrap success popup --- */
    function showSuccessModal (message) {
        $('#modal_success').remove();
        $('body').append(`
    <div class="modal fade" id="modal_success" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content border-success">
          <div class="modal-header bg-success text-white py-2">
            <h6 class="modal-title"><i class="fa fa-check-circle mr-1"></i> Успешно</h6>
            <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
          </div>
          <div class="modal-body text-center"><p class="mb-0">${message}</p></div>
        </div>
      </div>
    </div>`);
        const $m = $('#modal_success');
        $m.modal('show');
        setTimeout(() => $m.modal('hide'), 1500);
    }
</script>

<div class="modal fade" id="modal_categorySEO"  tabindex="-1"  data-backdrop="static" data-keyboard="false" role="dialog" style="z-index:50001">
    <!-- --- ЗАРЕЖДАНЕ НА CSS ОТ CONTROLLER --- -->
    <?php if (isset($addCSS) && is_array($addCSS)) { ?>
        <?php foreach ($addCSS as $css) { ?>
            <link rel="stylesheet" type="text/css" href="<?= auto('assets/' . $css . '.css'); ?>">
        <?php } ?>
    <?php } ?>

    <div class="modal-dialog modal-lg modal-dialog-centered my-1" role="document">
        <div class="modal-content css-background">

            <!-- === Modal Header === -->
            <div class="modal-header p-2 text-white">
                <h4 class="modal-title">
                    <i class="fa fa-search mr-2"></i> SEO настройки за категория:
                    <span class="text-light ml-2"><?= esc($category['category_name'] ?? 'Непозната категория') ?>
                    </span>
                </h4>

                <button type="button" class="close css-icon-hover mr-1" data-dismiss="modal" aria-label="Close"><span>&times;</span></button>
            </div>

            <!-- === Modal Body === -->
            <div class="modal-body">
                <!-- Top SEO score display -->
                <div class="d-flex justify-content-between align-items-center mt-2 mb-4">
                    <label class="font-weight-bold h5 mb-0">SEO информация</label>
                    <div id="seoScoreWrap" class="d-flex align-items-center">
                        <div id="seoScoreCircle" class="seo-score-circle mr-3"><span id="seoScoreValue">0%</span></div>
                        <div>
                            <div id="seoScoreLabel" class="font-weight-bold">Няма данни</div>
                            <small id="seoScoreTips" class="text-muted">Попълни SEO полетата, за да получиш оценка.</small>
                        </div>
                    </div>
                </div>

                <div class="overflow-auto" style=" max-height: calc(100vh - 350px);">
                    <!-- Main SEO form -->
                    <form id="form-category-seo" action="<?= route_to('POPup_category-seoSave', $category['category_id'] ?? 0) ?>" method="post">
                        <input type="hidden" name="category_id" value="<?= esc($category['category_id'] ?? 0) ?>">

                        <!-- SEO Title -->
                        <div class="form-group">
                            <label for="seo_title">SEO Заглавие</label>
                            <input type="text" class="form-control" id="seo_title" name="form[seo_title]" maxlength="70"
                                   placeholder="Въведи SEO заглавие"
                                   value="<?= esc($category['seo_title'] ?? '') ?>">
                            <div class="seo-meter mt-1"><div class="seo-meter-bar" id="seo_title_meter"></div></div>
                            <small id="seo_title_feedback" class="form-text text-muted">Оптимална дължина: 50–60 символа.</small>
                        </div>

                        <!-- SEO Description -->
                        <div class="form-group">
                            <label for="seo_description">SEO Описание</label>
                            <textarea class="form-control" id="seo_description" name="form[seo_description]" rows="3" maxlength="170"
                                      placeholder="Въведи кратко SEO описание (до 160 символа)"><?= esc($category['seo_description'] ?? '') ?></textarea>
                            <div class="seo-meter mt-1"><div class="seo-meter-bar" id="seo_description_meter"></div></div>
                            <small id="seo_description_feedback" class="form-text text-muted">Оптимална дължина: 140–160 символа.</small>
                        </div>

                        <!-- Focus Keyword -->
                        <div class="form-group">
                            <label for="focus_keyword">Ключови думи</label>
                            <input type="text" class="form-control" id="focus_keyword" name="form[focus_keyword]"
                                   placeholder="Пример: авто части, VW, брава"
                                   value="<?= esc($category['focus_keyword'] ?? '') ?>">
                            <small class="form-text text-muted">Въведи няколко ключови думи, разделени със запетая.</small>
                        </div>

                        <!-- Canonical URL -->
                        <div class="form-group">
                            <label for="canonical_url">Каноничен URL</label>
                            <input type="url" class="form-control" id="canonical_url" name="form[canonical_url]"
                                   placeholder="https://example.com/category-slug"
                                   value="<?= esc($category['canonical_url'] ?? '') ?>">
                            <small class="form-text text-muted">Посочи оригиналния адрес на категорията при дублирано съдържание.</small>
                        </div>

                        <!-- Robots / Indexing -->
                        <div class="form-group form-check mt-4">
                            <input type="checkbox" class="form-check-input" id="noindex" name="form[noindex]" value="1"
                                   <?= !empty($category['noindex']) ? 'checked' : '' ?>>
                            <label for="noindex" class="form-check-label text-muted">
                                <i class="fa fa-robot mr-1"></i> Не индексирай тази категория (noindex)
                            </label>
                        </div>

                        <!-- SEO Slug -->
                        <div class="form-group">
                            <label for="seo_slug">SEO Slug (адрес)</label>
                            <input type="text" class="form-control" id="seo_slug" name="form[seo_slug]"
                                   placeholder="пример: <?= strtolower(str_replace(' ', '-', $category['category_name'] ?? '')) ?>"
                                   value="<?= esc($category['seo_slug'] ?? '') ?>">
                            <small class="form-text text-muted">Използвай само латиница, цифри и тирета.</small>
                        </div>
                    </form>
                </div>

                <div>
                    <!-- SEO recommendation checklist -->
                    <hr class="my-2">
                    <label class="font-weight-bold w-100">Препоръки за оптимизация</label>
                    <div id="seoChecklist" class="seo-checklist d-flex"></div>
                </div>
            </div>

            <!-- === Modal Footer === -->
            <div class="modal-footer">
                <button type="submit" form="form-category-seo" class="btn btn-primary round-10"><i class="fa fa-save"></i> Запази</button>
                <button type="button" class="btn round-10" data-dismiss="modal"><i class="fa fa-times"></i> Затвори</button>
            </div>
        </div>
    </div>

    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>        
</div>


