<?php
$request = \Config\Services::request();
$_isAjax = $request -> isAJAX();

$general = service('settings') -> get('App.general') ?? [];
helper('utils'); // helper 

/** --- Основни настройки ------------------------------------ */
$preval    = $general['preval'] ?? [];
$priceType = $general['zenoobr']['price_type'] ?? 'discount';
$currency  = $preval['base_currency'] ?? 'BGN';

/* --- Точност ------------------------------------------------- */
$_isRoundedToFirst = $ofer -> isRoundedToFirst ?? false;
$_priceAccuracy    = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

/* --- Цени -------------------------------------------------- */
$_pricesWithDds     = !empty($general['prices_with_dds']);
$_dealerPricesLabel = 'ДИЛЪРСКИ ЦЕНИ ' . ($_pricesWithDds ? '(С ДДС)' : '(БЕЗ ДДС)');

/* --- Валута ---------------------------------------------- */
$_default_valutaCode   = $currency;
$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

$show = [
    'kkc_no_dds'    => true,
    'dost'          => true,
    'dealer_no_dds' => true,
    'raised_no_dds' => true,
];

// RULES
switch ($priceType) {
    case 'gensoft':
        // Gensoft → скриваме KKC и доставна
        foreach (['kkc_no_dds', 'dost'] as $k) {
            $show[$k] = false;
        }
        break;

    case 'discount':
        // Discount → няма клиентска цена
        $show['cenaKl'] = false;
        break;

    default:
        // всички други → имат клиентска цена
        $_priceLevels['cenaKl'] = 'Кл.клиент';
        break;
}

/* --- Ценови нива --------------------------------------------- */
$_promoTip = $_GET['promoTip'] ?? $arg ?? '';

$_priceLevels = match ($_promoTip) {
    'D' =>
    [
        'cenaB'    => 'B',
        'cenaA'    => 'А',
        'cenaSpec' => 'Спец.',
    ],
    default => ['cenaKKC' => 'ККЦ']
};

// само когато НЕ е discount / gensoft
if (!in_array($priceType, ['discount', 'gensoft'], true)) {
    $_priceLevels['cenaKl'] = 'Кл.клиент';
}

$_labelValuta = "<div class='w-50 m-auto' style='background-color:#C61111;color:#fff!important;padding:1px 6px;border-radius:4px;font-size:0.85em;'> $_default_valutaCode </div>";

/* --- Мярка -------------------------------------------------- */
$_mqrka = isset($mqrka) ? array_column($mqrka, null, 'sp_mqrka_id') : []
?>
<style>
    #tbl_products {
        table-layout: fixed;
        width: 100%;
    }
    #tbl_products th:last-child,
    #tbl_products td:last-child {
        width: auto !important;
    }
</style>

<table id="tbl_products" class="table table-striped table-sm mt-5" cellspacing="0" width="100%">
    <?php
    /* ===== COLGROUP – ДИНАМИЧНО РАВНО РАЗПРЕДЕЛЕНИЕ ===== */

// фиксирани колони (винаги ги има)
    $fixedCols  = [3, 7, 2, 15, 10, 15, 5, 5, 10]; // последната е снимка
    $fixedWidth = array_sum($fixedCols);

// динамични ценови колони
    $dynamicKeys   = ['dealer_no_dds', 'raised_no_dds', 'dost'];
    $activeDynamic = array_filter($dynamicKeys, fn($k) => !empty($show[$k]));
    $dynamicCount  = count($activeDynamic);

// изчисляване
    $remainingWidth = 100 - $fixedWidth;
    $dynamicWidth   = $dynamicCount > 0 ? round($remainingWidth / $dynamicCount, 2) : 0;
    ?>

    <colgroup>
        <!-- фиксирани -->
        <col style="width:3%">
        <col style="width:7%">
        <col style="width:4%">
        <col style="width:15%">
        <col style="width:10%">
        <col style="width:15%">
        <col style="width:5%">
        <col style="width:5%">

        <!-- динамични – РАВНО -->
        <?php if ($show['dealer_no_dds']): ?><col style="width:<?= $dynamicWidth ?>%"><?php endif; ?>
        <?php if ($show['raised_no_dds']): ?><col style="width:<?= $dynamicWidth ?>%"><?php endif; ?>
        <?php if ($show['dost']): ?><col style="width:<?= $dynamicWidth ?>%"><?php endif; ?>

        <!-- снимка -->
        <col style="width:10%">
    </colgroup>

    <thead class="css-background">
        <tr style="background: #C61111;color: white;">
            <th class="p-1 fw-600" colspan="13">
                <span style="background: #C61111;"><?= $_dealerPricesLabel ?></span>
            </th>
        </tr>

        <tr class="css-bg-purple">
            <th colspan="2"></th> 

            <th></th> 

            <th>
                <input id="filter" class="pr-4 css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__global.placeholder.filter') ?>">
            </th> 

            <th colspan="4"></th>   

            <th>
                <?php
                $_route     = route_to('Promo-getPriceLevel');
                $_priceNivo = "<div id='priceLevelAll' class='text-center' data-all='1'>
                                    <span>Ценово ниво за всички продукти</span>
                                    <br><br>";

                foreach ($_priceLevels as $level => $label) {
                    $_priceNivo .= "<button class='css-btn-wp' type='button'
                                        data-level='{$level}'
                                        data-route='{$_route}'>
                                        {$label}
                                    </button>";
                }
                $_priceNivo .= "</div>";

                if ($priceType != 'gensoft') {
                    ?>
                    <button class="css-btn-purple border-w-1 round-10 text-white btn btn-sm" type="button" data-toggle="tooltip" title="<?= $_priceNivo ?>">Ц. ниво</button>
                <?php } ?>
            </th>  

            <?php if ($_promoTip == 'D'): ?>
                <th></th>  
            <?php endif ?>

            <th colspan="2"> 
                <div class="input-group">
                    <input id="total_percent_zavishenaZena" class="notClear css-input-p css-focus-strong css-max-input-width pr-1 w-40 " type="text">

                    <div class="input-group-append">
                        <button id="btn-total_percent_ок" class="css-btn-purple border-w-1 round-10 btn btn-sm text-white" type="button">%&nbsp;OK</button>
                    </div>
                </div>
            </th>  

            <th></th>   
        </tr>

        <tr>
            <th class="w-3"></th> 
            <th class="w-7"> </th>
            <th class="w-2">
                <i class="showHidePromoPrice_all_inSite btn-outline-success px-1 fa fa-check" data-route="<?= route_to('Promo-showHidePromoPrice_all_onSite', urldecode(http_build_query(['action' => 'show', 'promoTip' => $_promoTip]))) ?>" data-action="show" title="показване на промо цена за всички продукти от промоцията в сайт"></i>

                <i class="showHidePromoPrice_all_inSite btn-outline-danger px-1 fa fa-trash" data-route="<?= route_to('Promo-showHidePromoPrice_all_onSite', urldecode(http_build_query(['action' => 'hide', 'promoTip' => $_promoTip]))) ?>" data-action="hide" title="скриване на промо цена за всички продукти от промоцията в сайт"></i>
            </th>

            <th class="w-15"><?= lang('LANG__special.tbl.th.product') ?></th>
            <th class="w-10"><?= lang('LANG__special.tbl.th.model') ?></th>
            <th class="w-15"><?= lang('LANG__special.tbl.th.description') ?></th>
            <th class="w-5">Налич.</th>
            <th class="w-5">Надц. %</th>

            <?php if ($show['dealer_no_dds']): ?>
                <th class="w-7">Цена дълър
                    <?= $_labelValuta ?>
                </th>
            <?php endif ?>

            <?php if ($show['raised_no_dds']): ?>
                <th class="w-5">
                    Завишена цена 
                    <?= $_labelValuta ?>
                </th>
            <?php endif; ?>

            <th class="w-5">
                Дост. цена   
                <?= $_labelValuta ?>
            </th>

            <th class="w-10">Снимка</th>
        </tr>
    </thead>

    <tbody> 
        <?php
        if (!isset($list)) {
            return;
        }

        $_colorRows = json_decode((string) $ofer?->colorRows, true) ?? [];
        $_clRow     = [];

        foreach ($list as $key => $row) {
            $_gensoftJson   = json_decode((string) $row['gensoft_json']);
            $_qtyPrice_json = (isset($row['qtyPrice_json']) ? json_decode($row['qtyPrice_json']) : (object) []) -> {$row['product_id']} ?? (object) [];
            $_mqrka_unit    = $_mqrka[$row['sp_mqrka_id']]['mqrka_unit'] ?? '';

            $_zavishenaZena = $_promoTip == 'D' ? $row['zavishena_zena'] : $row['zavishenaKl_zena'];

            // if (!$request -> isAJAX()) {
            helper('colorRows'); // Load the helper
            $_clRow    = generate_colorRows(['list' => $list, 'key' => $key, 'colspan' => 12, 'colorRows' => $_colorRows]);
            // }
            ?> 

            <tr data-id="<?= $row['product_id'] ?>"> 
                <td class="align-middle text-center fw-400">
                    <input type="hidden" name="promo[productsID][]" value="<?= $row['product_id'] ?>">           
                    <input type="hidden" name="zProduct[][product_id]" value="<?= $row['product_id'] ?>">
                    <input type="hidden" name="zProduct[][promoLista_id]" value="<?= $row['id'] ?? '' ?>"> 
                </td> 

                <!-- бутони -->
                <td class="action text-center align-middle"> 
                    <div class="d-flex justify-content-center align-items-center">
                        <i class="delete_product btn-outline-danger p-1 border-0 fa fa-trash" title="<?= lang('LANG__global.tbl.btn.title.delete') ?>"></i>

                        <?php
                        $urlParams = array(
                            'ctrl'       => 'promo',
                            'product_id' => $row['product_id'],
                            'arg'        => '',
                        );
                        ?>

                        <i class="edit_product btn-outline-primary p-1 border-0 fa fa-edit" data-route="<?= route_to('Popup_editProduct-open', urldecode(http_build_query($urlParams))) ?>" title="<?= lang('LANG__global.tbl.btn.title.edit') ?>"></i> 
                    </div>

                    <div>
                        <i class="btn-outline-dark p-1 border-0 fa fa-arrows" title="<?= lang('LANG__global.tbl.btn.title.move') ?>"></i>
                        <i class="rowPosition btn-outline-dark p-1 border-0 fa fa-list"></i>
                    </div> 
                </td> 

                <!-- show/hide промоция като цена -->
                <td class="chk_promoPrice align-middle text-center" title="Видимост на промоционалната цена в сайт">
                    <label class="switch switch-green round-10">
                        <input class="isShowPromoPrice_inSite switch-input" name="promo[qtyPrice_json][<?= $row['product_id'] ?>][isShowPriceInSite]" type="checkbox"  data-route="<?= route_to('Promo-showPromoPrice_onSite', $row['product_id'], $_promoTip) ?>"  <?= $row[$_promoTip == 'D' ? 'is_promo' : 'is_promoKl'] == 1 ? 'checked' : '' ?> value="1">
                        <span class="switch-label" data-on="Да" data-off="Не"></span>
                        <span class="switch-handle"></span>
                    </label>
                </td> 

                <!-- продукт име -->
                <td class="productName align-middle text-left text-break fw-400" data-name="<?= $row['product_name'] ?? '' ?>">
                    <?= empty($row['product_name']) ? '<b class="bg-danger">Липсва продуктово име</b><br>' . $row['gensoft_productName'] : $row['product_name'] ?>
                </td> 

                <!-- модел -->
                <td class="productModel align-middle text-break text-center fw-400"><?= $row['model'] ?></td> 

                <!-- описание -->
                <td class="productDesk align-middle fw-400">
                    <div class="maxHeight">
                        <?= $row['description'] ?>
                    </div>

                    <?php if (!empty($row['description'])) { ?>
                        <i class="fa fa-info-circle text-primary text-center d-block cursor-pointer css-icon-active" data-toggle="tooltip" title="<?= htmlentities($row['description']) ?>"></i> 
                    <?php } ?>
                </td> 

                <!-- наличност -->
                <td class="productNalichnost position-relative align-middle text-center fw-400">
                    <div class="position-absolute w-100" style="top: 50%; left: 50%; transform: translate(-50%, -50%);"><?= ($row['nalichnost'] ?? 0 ) . ' ' . $_mqrka_unit ?>
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">
                        <?php
                        if ($_gensoftJson -> kol_lock ?? null) {
                            echo '<small>запаз. - ' . $_gensoftJson -> kol_lock . $_mqrka_unit . '</small>';
                        }
                        ?>
                    </div>
                </td> 

                <!-- надценка -->
                <td class="nadz text-center align-middle fw-400"></td> 

                <!-- цена дилър без ддс -->
                <?php if ($show['dealer_no_dds']): ?>
                    <td class="zenaProdava position-relative align-middle text-center fw-400">
                        <?php
                        $_zenaProdava = null;
                        $_promoPrice  = null;
                        $_gsKKC       = h_toFixed($_gensoftJson -> KKC ?? null, $_isRoundedToFirst); // gensoft KKC 

                        if (isset($row['nivo'])) {
                            $_zenaProdava = h_toFixed($row['nivo'], $_isRoundedToFirst);
                        } elseif (isset($_qtyPrice_json -> {$row['product_id']} -> price)) {
                            $_zenaProdava = h_toFixed($_qtyPrice_json -> {$row['product_id']} -> price, $_isRoundedToFirst);
                        }

                        $_gPromoPercent = is_numeric($_gensoftJson -> promoPercent ?? null) ? (float) $_gensoftJson -> promoPercent : null; // gensoft промо % 

                        if ($_gPromoPercent && is_numeric($_gsKKC)) {
                            $_promoPrice = h_toFixed($_gsKKC * (1 + ($_gPromoPercent / 100)), $_isRoundedToFirst);
                        }
                        ?>
                        <div class="position-absolute w-90 mb-2" style="top: 50%; left: 50%; transform: translate(-50%, -50%);" >
                            <input class="zenaProdava <?= $priceType === 'gensoft' && !empty($row['gensoft_item_id']) ? 'css-pointer-events-none2' : '' ?> css-input-p css-focus-strong css-border-none css-max-input-width text-center" 
                                   name="promo[qtyPrice_json][<?= $row['product_id'] ?>][price]" 
                                   data-isNumeric
                                   type="text" 
                                   value="<?= $priceType === 'gensoft' ? $_gsKKC : ($_zenaProdava ?? '') ?>">
                        </div>

                        <div class="position-relative mt-5 pt-4" style="left: 50%; transform: translateX(-50%);">
                            <?php if ($_promoPrice !== null && !empty($_gsKKC)): ?>
                                <small class="<?= $_gPromoPercent < 0 ? 'text-danger' : 'text-success' ?>">
                                    <?= ($_gPromoPercent > 0 ? '+' : '') . $_promoPrice . '&nbsp;&nbsp;(' . $_gPromoPercent . '%)' ?>
                                </small>
                            <?php endif; ?>

                            <?php
                            $_route           = route_to('Promo-getPriceLevel');
                            $_btnPriceLvl     = '';
                            $_isEmptyPriceLvl = true; // Предполагаме, че всички нива са празни;
                            $_btn             = '';
                            foreach ($_priceLevels as $level => $label) {
                                if (!empty($row[$level])) {
                                    $_btn .= "<button class='css-btn-wp' data-level='$level'
                                          data-product-id='{$row['product_id']}'
                                          data-route='$_route' type='button'>$label</button>";
                                }
                            }


                            if ($priceType !== 'gensoft' && $_btn) {
                                echo "<button class='css-btn-purple round-10 w-100'
                                  type='button' data-toggle='tooltip'
                                  title=\"<div id='priceLevel' class='d-flex gap-3'><span>Ценово ниво</span>$_btn</div>\">
                                  Ц. ниво
                                </button>";
                            }
                            ?>
                        </div>
                    </td> 
                <?php endif ?>

                <!-- цена завишена -->
                <?php if ($show['raised_no_dds']): ?>
                    <td class="position-relative  align-middle text-center fw-500"> 
                        <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);" >
                            <input class="cenaZavishena css-input-p css-focus-strong css-border-none css-max-input-width text-center" 
                                   name="promo[zavishena_zena][<?= $row['product_id'] ?>]" 
                                   data-isNumeric
                                   type="text" 
                                   value="<?= $_isAjax ? '' : $_zavishenaZena ?>">
                        </div>

                        <div class="position-relative text-left mt-5 pt-1" style="left: 50%; transform: translateX(-50%);margin-top:80px !important;" >
                            <input class="percent_zavishenaZena w-50 css-input-p css-focus-strong css-border-none text-center" type="text" data-isPercent> %
                        </div>
                    </td>
                <?php endif ?>

                <!-- цена доставна -->
                <td class="zenaDostavna css-background text-center align-middle fw-500" data-base-price="<?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) ?>">
                    <?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) . ' ' . ($_default_valuta['valuta_symbol'] ?? '') ?>
                </td> 

                <!-- картинка -->
                <td class="productImage align-middle fw-500">
                    <?php
                    echo match ($row['badge_index']) {
                        '1' => '<div class="mb-1 text-center"><img class="w-50" src="' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></div>',
                        '2' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                        '3' => '<div class="mb-1 text-center"><img class="w-50" src="' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></div>',
                        '4' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></div>',
                        default => ''
                    };
                    ?>
                    <div class="d-flex">
                        <span class="<?= $row['image'] != '' ? 'fa fa-search-plus' : '' ?> position-absolute"></span>
                        <?php $_imgSrc = empty($row['image']) ? '' : $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION) ?>
                        <img class="zoomImg mw-100 m-auto" src="<?= $_imgSrc ?>" data-full-image="<?= $_ENV['app.imageDir'] . $row['image'] ?>" onerror="this.onerror=null;this.src='';" alt=" ">  
                    </div>
                </td>         
            </tr> 
            <?php
            echo implode("", $_clRow);
        }
        ?> 
    </tbody> 
</table>
