<?php

namespace App\Modules\special\Controllers;

use \App\Models\common\MODEL__global;
use \App\Models\common\MODEL__all_oferta;

class Special extends \App\Controllers\BaseController {

    protected MODEL__all_oferta $MODEL__all_oferta;
    protected MODEL__global $MODEL__global;
    protected $viewPath = 'Modules\special\Views\\';
    protected $tip      = 'special';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global     = new MODEL__global();
        $this -> MODEL__all_oferta = new MODEL__all_oferta();
        helper('url');
    }

    public function index($id = null) {
        $settings = service('settings');
        $general  = $settings -> get('App.general') ?? [];
        $preval   = $settings -> get('App.general')['preval'] ?? [];

        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add('Поръчки', '/');

        $zenovaLista = $this -> MODEL__global -> get__zenovaLista();

        $data = [
            'page_title'             => 'Оферти',
            'breadcrumbs'            => $this -> breadcrumb -> render(),
            'addCSS'                 => $this -> addCSS(),
            'addJS'                  => $this -> addJS(),
            'ofer'                   => $this -> MODEL__all_oferta -> get__ofer_by_id($id, $this -> tip),
            'status'                 => $this -> MODEL__global -> get__status(),
            'shablon'                => $this -> MODEL__global -> get__shablons(),
            'list'                   => $this -> MODEL__all_oferta -> get__products_forOfer($id, $this -> tip),
            //'zenovaLista'    => $this -> MODEL__global -> get__zenovaLista(),
            'mqrka'                  => $this -> MODEL__global -> get__mqrka(),
            'valuta'                 => $this -> MODEL__global -> get__valuta(),
            'languages'              => $this -> MODEL__global -> get__languages(),
            // ако има снимки прикачени се извличат
            'uploads'                => glob('uploads/special/' . $id . '/*.*'),
            'modulTip'               => $this -> tip,
            'general'                => $general,
            'preval'                 => $preval,
            // VIEWS -----------------------------------------------------
            'view_global_klientData' => 'common/VIEW__glob-klientData',
            'view_leftAside'         => $this -> viewPath . 'VIEW__special-leftAside',
            'view_htmlTable'         => $this -> viewPath . 'VIEW__special-table',
            'view_files'             => $this -> viewPath . 'VIEW__special-files',
            'view_actionBtn'         => $this -> viewPath . 'VIEW__special-actionBtn'
        ];

        return $this -> render_template($this -> viewPath . 'VIEW__special', $data);
    }

    public function set_badge_toAllProduct() {
        $productIds = $this -> request -> getVar('productIds');
        $index      = $this -> request -> getVar('index');

        if (empty($productIds)) {
            return;
        }

        $productIds = explode(',', $productIds);

        $this -> MODEL__global -> save__badge($productIds, $index);
        return json_encode('');
    }

    public function save_valuta() {
        $valuta_id  = $this -> request -> getVar('valuta_id');
        $valuta_val = $this -> request -> getVar('valuta_val');

        $this -> MODEL__global -> save__valuta($valuta_id, $valuta_val);

        return json_encode('');
    }

    // превръщане  на оферта в поръчка
    public function clone() {
        $id       = $this -> request -> getVar('id');
        $tab      = $this -> request -> getVar('tab');
        $oferName = $this -> request -> getVar('oferName');

        $data = [
            'id'         => $id,
            'tab'        => $tab,
            'oferName'   => $oferName,
            'userCreate' => $this -> user -> username,
        ];

        $response = $this -> MODEL__all_oferta -> clone_ofer($data);

        return json_encode($response);
    }

    public function submit($id = null) {
        $form = json_decode($this -> request -> getVar('form'), true);

        $form['special'] = $this -> changeArr($form['special'] + ($form['colorRows'] ?? []), [
            'all'    => [
                'json' => [
                    'colorRows',
                    'qtyPrice_json'
                ],
                'imp'  => ['productsID'],
                'null' => ['valuta_id'],
            ],
            'update' => [
                'user' => 'userName_modify',
                'date' => 'date_update'
            ],
            'create' => [
                'user' => 'userName_create',
                'date' => 'date_create' // име на sql колоната 
            ]
                ], $id, true);

        $response = $this -> MODEL__all_oferta -> save_order($id, $form, $this -> tip);

        if (isset($response['err'])) {
            return json_encode($response, JSON_UNESCAPED_UNICODE);
        }

        return json_encode(['url' => route_to('Special-edit', $response)]); // last id на оферта ако е нова оферта
    }

    // изтриване на оферта
    public function delete($id = null) {

        if ($id) {
            $this -> MODEL__all_oferta -> delete_oferta(['id' => $id, 'tab' => $this -> tip]);
            return redirect() -> to(html_entity_decode(route_to('tabSpecial')));
        }
    }
    

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'plugins/currency-flags/currency-flags',
            'css/layouts/autocomplete',
            'css/layouts/global',
            'css/layouts/tables',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/choose-color/choose-color',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/timepicker/datepicker',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/klient_modify_inOfer',
            'js/_Global/inOfer/leftAsideActions',
            'js/_Global/inOfer/tableActions',
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/img/jquery.elevatezoom',
            'plugins/tableSearchRow/tableSearchRow',
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/timepicker/datepicker',
            'plugins/choose-color/choose-color',
        ];

        $default = ['js/modul/special/special'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
