<?php

namespace App\Modules\zenova\Controllers;

use \App\Controllers\BaseController as BaseController;
use \App\Models\common\MODEL__global;
use \App\Models\MODEL__offer_isOpen;
use \App\Modules\zenova\Models\MODEL__zenova_oferta;
use \App\Libraries\Pagination;

class Zenova extends BaseController {

    protected MODEL__zenova_oferta $MODEL__zenova_oferta;
    protected MODEL__global $MODEL__global;
    protected $viewPath = 'Modules\zenova\Views\\';
    protected $tip      = 'zenova';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global        = new MODEL__global();
        $this -> MODEL__zenova_oferta = new MODEL__zenova_oferta();
        $this -> Pagination_lib       = new Pagination();
        helper('url');
    }

    public function index($id = null, $previewView = null) {
        // Breadcrumbs
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add('Ценова листа', '/');

        $settings = service('settings');
        $general  = $settings -> get('App.general') ?? [];
        $preval   = $settings -> get('App.general')['preval'] ?? [];

        $search = trim((string) $this -> request -> getGet('search'));

        $perPage = $this -> request -> getVar('perPage') ?? 100;
        $page    = max(1, (int) ($this -> request -> getGet('page') ?? 1));
        $offset  = ($page > 1) ? ($perPage * ($page - 1)) : 0;

        $product       = [];
        $totalProducts = 0;
        $totalPages    = 1;

        if (is_numeric($id)) {
            $this -> session -> set('oferId', $id);
            $this -> session -> set('openedTab', $this -> tip);
            $this -> session -> set('zenova_perPage', $perPage);
        }

        $ofer = $this -> MODEL__zenova_oferta -> get_zenova_by_id($id);

        if (!empty($ofer -> productsID)) {
            $productIds = explode(',', $ofer -> productsID);

            $product = $this -> MODEL__zenova_oferta -> get__products_fromZenova([
                'productIds'     => $productIds,
                'zenovaLista_id' => $id,
                'search'         => $search,
                    ], $perPage, $offset);

            $this -> MODEL__zenova_oferta -> setCurrentZenovaId($id);

            $totalProducts = $this -> MODEL__zenova_oferta -> count__products_fromZenova(
                    $productIds, $id, $search
            );

            $totalPages = ceil($totalProducts / ($perPage ?: 1)); // ako $perPage ==0  
        }

        $pagination = $this -> Pagination_lib -> generate(['page' => $page, 'total_pages' => $totalPages]);

        $data = [
            'page_title'    => 'ЦЕНОВА ЛИСТА',
            'breadcrumbs'   => $this -> breadcrumb -> render(),
            'addCSS'        => $this -> addCSS(),
            'addJS'         => $this -> addJS(),
            'ofer'          => $ofer,
            'shablon'       => $this -> MODEL__global -> get__shablons(),
            'list'          => $product ?? [],
            'mqrka'         => $this -> MODEL__global -> get__mqrka(),
            'general'       => $general,
            'preval'        => $preval,
            'pagination'    => $pagination,
            "totalProducts" => $totalProducts,
            "perPage"       => $perPage,
        ];

        if ($previewView === 'preview') {
            $this -> viewPath = $this -> viewPath . 'preview/';

            $views = [
                'view_leftAside' => $this -> viewPath . 'VIEW__zenovaPrev-leftAside',
                'view_htmlTable' => $this -> viewPath . 'VIEW__zenovaPrev-table',
                'view_actionBtn' => $this -> viewPath . 'VIEW__zenovaPrev-actionBtn'
            ];

            return $this -> render_template($this -> viewPath . 'VIEW__zenovaPrev', $data + $views);
        }
        // режим редакция
        $views = [
            'view_leftAside' => $this -> viewPath . 'VIEW__zenova-leftAside',
            'view_htmlTable' => $this -> viewPath . 'VIEW__zenova-table',
            'view_actionBtn' => $this -> viewPath . 'VIEW__zenova-actionBtn'
        ];

        return $this -> render_template($this -> viewPath . 'VIEW__zenova', $data + $views);
    }

    // извличане на х-ките на продукт
    public function productAttrInfo($productId = null) {
        // Load product attributes
        $productAttr = $this -> MODEL__zenova_oferta -> get__prodAttr($productId);
        $productAttr = is_array($productAttr) ? $productAttr : [];

        $category = $this -> MODEL__zenova_oferta -> get__productCategoryWithParent($productId);

        if ($category) {

            if (!empty($category['parent'])) {
                array_unshift($productAttr, [
                    'value'                       => $category['parent'],
                    'product_characteristic_text' => 'Категория (родител)',
                ]);
            }

            array_unshift($productAttr, [
                'value'                       => $category['category'],
                'product_characteristic_text' => 'Категория',
            ]);
        }

        return json_encode($productAttr ?: 'Няма х-ки', JSON_UNESCAPED_UNICODE);
    }

    // добавяне/премахване на продукт/и към сайтове
    public function productToSites($productId = null) {
        $is_toSite  = (bool) $this -> request -> getVar('is_toSite');
        // ако отметнем всички продукти за сайт
        $productIds = $this -> request -> getVar('productIds');
        // Определяме дали е групова операция (bulk)
        $isBulk     = !empty($productIds);

        // Ако не е групова – използваме подадения $productId
        $targetIds = $isBulk ? $productIds : $productId;

        $response = $this -> MODEL__zenova_oferta -> product_toSites($targetIds, $is_toSite, $isBulk);

        return json_encode($response);
    }

    public function submit($id = null) {
        $form             = json_decode($this -> request -> getVar('form'), true);
        $currentPageOrder = explode(',', (string) ($form['currentPageOrder'] ?? ''));
        $currentPage      = (int) ($form['currentPage'] ?? 1);
        $perPage          = (int) ($form['perPage'] ?? 20);

        if (!empty($currentPageOrder[0]) && is_numeric($id)) {

            $ofer = $this -> MODEL__zenova_oferta -> get_zenova_by_id($id);

            if (!empty($ofer -> productsID)) {

                $fullOrder = explode(',', $ofer -> productsID);

                $fullOrder = array_values(array_diff($fullOrder, $currentPageOrder));

                $offset = ($currentPage - 1) * $perPage;

                $before = array_slice($fullOrder, 0, $offset);
                $after  = array_slice($fullOrder, $offset);

                $newFullOrder = array_merge($before, $currentPageOrder, $after);

                $form['zenova']['productsID'] = $newFullOrder;
            }
        }

        $deletedProductArrId = array_filter($this -> request -> getVar('deletedProductArrId') ?? []);

        $form['zenova'] = $this -> changeArr($form['zenova'] + ($form['colorRows'] ?? []), [
            'all'    => [
                'imp'  => ['productsID'],
                'json' => ['colorRows'],
                'null' => ['shablon_id'],
            ],
            'update' => [
                'user' => 'userName_modify',
                'date' => 'date_update'
            ],
            'create' => [
                'user' => 'userName_create',
                'date' => 'date_create' // име на sql колоната 
            ]
                ], $id, true);

        $response = $this -> MODEL__zenova_oferta -> save_oferta($id, $form, $deletedProductArrId); //id ако е нова оферта

        if (isset($response['err'])) {
            return json_encode($response, JSON_UNESCAPED_UNICODE);
        }

        // ако е нова оферта се заклучва към потребителя който я е създал
        if (!is_numeric($id) && !empty($response)) {
            $MODEL__offer_isOpen = new MODEL__offer_isOpen();
            $MODEL__offer_isOpen -> checkAndLockOffer($response, $this -> tip, $this -> user -> id);
        }

        return json_encode(['url' => route_to('Zenova-edit', $response)]);
    }

    public function deleteProductFromZenova() {
        return $this -> deleteProducts();
    }

    //изтриване на оферта
    public function delete($id = null, $arg = 'zenova') {

        if ($id) {
            $this -> MODEL__zenova_oferta -> delete_oferta($id);
            return redirect() -> to(html_entity_decode(route_to('tabZenova')));
        }
    }

    public function deleteProducts() {
        $productIds = $this -> request -> getVar('productIds');
        $zenovaId   = $this -> request -> getVar('zenovaId');

        if (empty($productIds)) {
            return $this -> response -> setJSON(['err' => 'Няма избрани продукти']);
        }

        $this -> MODEL__zenova_oferta -> delete_products_from_zenova($productIds, $zenovaId);
        return $this -> response -> setJSON(['success' => true]);
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'css/layouts/autocomplete',
            'css/layouts/global',
            'css/layouts/tables',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/choose-color/choose-color',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/inOfer/leftAsideActions',
            'js/_Global/inOfer/tableActions',
        ];

        $plugins = [
            'plugins/sessionOferTimeout/jquery.idleCat.min',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/img/jquery.elevatezoom',
            'plugins/tableSearchRow/tableSearchRow',
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/choose-color/choose-color',
        ];
        $default = ['js/modul/zenova/zenova'];
        $modals  = [];

        return array_merge($global, $plugins, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
